/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rEb!B#G\u0001!S\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011A,\t\u0011y\u0003!\u0011!Q\u0001\naC\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005C\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0001\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003b\u0011!Q\u0007A!A!\u0002\u0013\t\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\n\u0003'\u0001!\u0011!Q\u0001\nADq!!\u0006\u0001\t\u0003\t9\u0002C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u00111\t\u0001!\u0002\u0013\ty\u0003C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u0002H!A\u0011q\n\u0001!\u0002\u0013\tI\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u00111\u000e\u0001!\u0002\u0013\t)\u0006C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011Q\u0011\u0001!\u0002\u0013\t\t\bC\u0005\u0002\b\u0002\u0011\r\u0011\"\u0003\u0002\n\"A\u0011\u0011\u0015\u0001!\u0002\u0013\tY\t\u0003\u0005\u0002$\u0002\u0001\r\u0011\"\u0003a\u0011%\t)\u000b\u0001a\u0001\n\u0013\t9\u000bC\u0004\u00024\u0002\u0001\u000b\u0015B1\t\u0015\u0005U\u0006A1A\u0005\u0002\u0019\u000b9\f\u0003\u0005\u0003z\u0001\u0001\u000b\u0011BA]\r\u001d\t\u0019\r\u0001!G\u0003\u000bD!\"a;\u001d\u0005+\u0007I\u0011AAw\u0011)\t)\u0010\bB\tB\u0003%\u0011q\u001e\u0005\u000b\u0003od\"Q3A\u0005\u0002\u0005e\bB\u0003B\u00019\tE\t\u0015!\u0003\u0002|\"9\u0011Q\u0003\u000f\u0005\u0002\t\r\u0001b\u0002B\u00059\u0011\u0005#1\u0002\u0005\n\u0005#a\u0012\u0011!C\u0001\u0005'A\u0011B!\u0007\u001d#\u0003%\tAa\u0007\t\u0013\tEB$%A\u0005\u0002\tM\u0002\"\u0003B\u001c9\u0005\u0005I\u0011\tB\u001d\u0011!\u0011)\u0005HA\u0001\n\u0003\u0001\u0007\"\u0003B$9\u0005\u0005I\u0011\u0001B%\u0011%\u0011\u0019\u0006HA\u0001\n\u0003\u0012)\u0006C\u0005\u0003`q\t\t\u0011\"\u0001\u0003b!I!1\u000e\u000f\u0002\u0002\u0013\u0005#Q\u000e\u0005\n\u0005_b\u0012\u0011!C!\u0005cB\u0011Ba\u001d\u001d\u0003\u0003%\tE!\u001e\b\u0015\tm\u0004!!A\t\u0002\u0019\u0013iH\u0002\u0006\u0002D\u0002\t\t\u0011#\u0001G\u0005\u007fBq!!\u00060\t\u0003\u0011i\tC\u0005\u0003p=\n\t\u0011\"\u0012\u0003r!I!qR\u0018\u0002\u0002\u0013\u0005%\u0011\u0013\u0005\n\u0005/{\u0013\u0011!CA\u00053C\u0001Ba+\u0001\t\u00031%Q\u0016\u0005\t\u0005{\u0003A\u0011\u0001$\u0003@\"9!Q\u0018\u0001\u0005\n\t\r\u0007\u0002\u0003Bh\u0001\u0011\u0005aI!5\t\u000f\t\u0005\b\u0001\"\u0011\u0003d\"9!Q\u001d\u0001\u0005B\t\r\bb\u0002Bt\u0001\u0011\u0005!1\u001d\u0005\b\u0005S\u0004A\u0011\u0002Bv\u0011\u001d\u0011)\u0010\u0001C\u0005\u0005GDqAa>\u0001\t\u0013\u0011I\u0010C\u0004\u0004\b\u0001!IAa9\t\u000f\r%\u0001\u0001\"\u0003\u0004\f!91\u0011\u0004\u0001\u0005\u0002\t\rxACB\u0012\r\u0006\u0005\t\u0012\u0001%\u0004&\u0019IQIRA\u0001\u0012\u0003A5q\u0005\u0005\b\u0003+\u0011E\u0011AB\u0015\u0011%\u0019YCQI\u0001\n\u0003\u0019iC\u0001\u0005BG\u000e,\u0007\u000f^8s\u0015\t9\u0005*A\u0004oKR<xN]6\u000b\u0003%\u000bQa[1gW\u0006\u001c2\u0001A&P!\taU*D\u0001G\u0013\tqeI\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003!Nk\u0011!\u0015\u0006\u0003%\"\u000bq!\\3ue&\u001c7/\u0003\u0002U#\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u0011\u0015tG\rU8j]R\u001c\u0001!F\u0001Y!\tIF,D\u0001[\u0015\tY\u0006*A\u0004dYV\u001cH/\u001a:\n\u0005uS&\u0001C#oIB{\u0017N\u001c;\u0002\u0013\u0015tG\rU8j]R\u0004\u0013AD:f]\u0012\u0014UO\u001a4feNK'0Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n\u0019\u0011J\u001c;\u0002\u001fM,g\u000e\u001a\"vM\u001a,'oU5{K\u0002\naB]3dm\n+hMZ3s'&TX-A\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3!\u0003\u0019qw\u000eZ3JI\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u00196L!A\u001c$\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018\u0001D7fiJL7\r\u0015:fM&D\bCA9y\u001d\t\u0011h\u000f\u0005\u0002tG6\tAO\u0003\u0002v-\u00061AH]8pizJ!a^2\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003o\u000e\fA\u0001^5nKB\u0019Q0a\u0004\u000e\u0003yT1a`A\u0001\u0003\u0015)H/\u001b7t\u0015\u0011\t\u0019!!\u0002\u0002\r\r|W.\\8o\u0015\rI\u0015q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\t1a\u001c:h\u0013\r\t\tB \u0002\u0005)&lW-A\u0005m_\u001e\u0004&/\u001a4jq\u00061A(\u001b8jiz\"\"#!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\t)#a\n\u0002*A\u0011A\n\u0001\u0005\u0006+2\u0001\r\u0001\u0017\u0005\u0006?2\u0001\r!\u0019\u0005\u0006Q2\u0001\r!\u0019\u0005\u0006U2\u0001\r!\u0019\u0005\u0006W2\u0001\r\u0001\u001c\u0005\u0006_2\u0001\r\u0001\u001d\u0005\u0006w2\u0001\r\u0001 \u0005\t\u0003'a\u0001\u0013!a\u0001a\u0006Ya.[8TK2,7\r^8s+\t\ty\u0003\u0005\u0003\u00022\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0011\rD\u0017M\u001c8fYNTA!!\u000f\u0002<\u0005\u0019a.[8\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u00024\tA1+\u001a7fGR|'/\u0001\u0007oS>\u001cV\r\\3di>\u0014\b%A\u0007tKJ4XM]\"iC:tW\r\\\u000b\u0003\u0003\u0013\u0002B!!\r\u0002L%!\u0011QJA\u001a\u0005M\u0019VM\u001d<feN{7m[3u\u0007\"\fgN\\3m\u00039\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY\u0002\n!\u0002\u001d:pG\u0016\u001c8o\u001c:t+\t\t)\u0006\u0005\u0004\u0002X\u0005\u0005\u0014QM\u0007\u0003\u00033RA!a\u0017\u0002^\u00059Q.\u001e;bE2,'bAA0G\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002M\u0003OJ1!!\u001bG\u0005%\u0001&o\\2fgN|'/A\u0006qe>\u001cWm]:peN\u0004\u0013!\u00059s_\u000e,7o]8sgN#\u0018M\u001d;fIV\u0011\u0011\u0011\u000f\t\u0005\u0003g\n\t)\u0004\u0002\u0002v)!\u0011qOA=\u0003\u0019\tGo\\7jG*!\u00111PA?\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u007f\nY$\u0001\u0003vi&d\u0017\u0002BAB\u0003k\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017A\u00059s_\u000e,7o]8sgN#\u0018M\u001d;fI\u0002\n1C\u00197pG.,G\rU3sG\u0016tG/T3uKJ,\"!a#\u0011\t\u00055\u0015QT\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006!1m\u001c:f\u0015\r\u0011\u0016Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0004zC6lWM\u001d\u0006\u0003\u00037\u000b1aY8n\u0013\u0011\ty*a$\u0003\u000b5+G/\u001a:\u0002)\tdwnY6fIB+'oY3oi6+G/\u001a:!\u0003U\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb\f\u0011dY;se\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:J]\u0012,\u0007p\u0018\u0013fcR!\u0011\u0011VAX!\r\u0011\u00171V\u0005\u0004\u0003[\u001b'\u0001B+oSRD\u0001\"!-\u0019\u0003\u0003\u0005\r!Y\u0001\u0004q\u0012\n\u0014AF2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r\u001f\u0011\u0002!QD'o\u001c;uY\u0016$7k\\2lKR\u001cXCAA]!\u0019\t9&a/\u0002@&!\u0011QXA-\u00055\u0001&/[8sSRL\u0018+^3vKB\u0019\u0011\u0011\u0019\u000f\u000e\u0003\u0001\u0011!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiNIA$a2\u0002N\u0006}\u0017Q\u001d\t\u0004E\u0006%\u0017bAAfG\n1\u0011I\\=SK\u001a\u0004b!a4\u0002Z\u0006}f\u0002BAi\u0003+t1a]Aj\u0013\u0005!\u0017bAAlG\u00069\u0001/Y2lC\u001e,\u0017\u0002BAn\u0003;\u0014qa\u0014:eKJ,GMC\u0002\u0002X\u000e\u00042AYAq\u0013\r\t\u0019o\u0019\u0002\b!J|G-^2u!\r\u0011\u0017q]\u0005\u0004\u0003S\u001c'\u0001D*fe&\fG.\u001b>bE2,\u0017AB:pG.,G/\u0006\u0002\u0002pB!\u0011\u0011GAy\u0013\u0011\t\u00190a\r\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003\u001d\u0019xnY6fi\u0002\n\u0011#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\tY\u0010E\u0002c\u0003{L1!a@d\u0005\u0011auN\\4\u0002%\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u000b\u0007\u0003\u007f\u0013)Aa\u0002\t\u000f\u0005-\u0018\u00051\u0001\u0002p\"9\u0011q_\u0011A\u0002\u0005m\u0018aB2p[B\f'/\u001a\u000b\u0004C\n5\u0001b\u0002B\bE\u0001\u0007\u0011qX\u0001\u0005i\"\fG/\u0001\u0003d_BLHCBA`\u0005+\u00119\u0002C\u0005\u0002l\u000e\u0002\n\u00111\u0001\u0002p\"I\u0011q_\u0012\u0011\u0002\u0003\u0007\u00111`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iB\u000b\u0003\u0002p\n}1F\u0001B\u0011!\u0011\u0011\u0019C!\f\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-2-\u0001\u0006b]:|G/\u0019;j_:LAAa\f\u0003&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0007\u0016\u0005\u0003w\u0014y\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005w\u0001BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0005\u0003\nY$\u0001\u0003mC:<\u0017bA=\u0003@\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B&\u0005#\u00022A\u0019B'\u0013\r\u0011ye\u0019\u0002\u0004\u0003:L\b\u0002CAYQ\u0005\u0005\t\u0019A1\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0016\u0011\r\te#1\fB&\u001b\t\ti&\u0003\u0003\u0003^\u0005u#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0019\u0003jA\u0019!M!\u001a\n\u0007\t\u001d4MA\u0004C_>dW-\u00198\t\u0013\u0005E&&!AA\u0002\t-\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0005\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005w\ta!Z9vC2\u001cH\u0003\u0002B2\u0005oB\u0011\"!-.\u0003\u0003\u0005\rAa\u0013\u0002#QD'o\u001c;uY\u0016$7k\\2lKR\u001c\b%\u0001\nEK2\f\u00170\u001a3DY>\u001cXmU8dW\u0016$\bcAAa_M)qF!!\u0002fBQ!1\u0011BE\u0003_\fY0a0\u000e\u0005\t\u0015%b\u0001BDG\u00069!/\u001e8uS6,\u0017\u0002\u0002BF\u0005\u000b\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011i(A\u0003baBd\u0017\u0010\u0006\u0004\u0002@\nM%Q\u0013\u0005\b\u0003W\u0014\u0004\u0019AAx\u0011\u001d\t9P\ra\u0001\u0003w\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001c\n\u001d\u0006#\u00022\u0003\u001e\n\u0005\u0016b\u0001BPG\n1q\n\u001d;j_:\u0004rA\u0019BR\u0003_\fY0C\u0002\u0003&\u000e\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003BUg\u0005\u0005\t\u0019AA`\u0003\rAH\u0005M\u0001\u000eC\u0012$\u0007K]8dKN\u001cxN]:\u0015\r\u0005%&q\u0016B]\u0011\u001d\u0011\t\f\u000ea\u0001\u0005g\u000bQB\\3x!J|7-Z:t_J\u001c\bCBA,\u0005k\u000b)'\u0003\u0003\u00038\u0006e#A\u0002\"vM\u001a,'\u000f\u0003\u0004\u0003<R\u0002\r\u0001]\u0001\u0016aJ|7-Z:t_J$\u0006N]3bIB\u0013XMZ5y\u0003=\u0019H/\u0019:u!J|7-Z:t_J\u001cH\u0003BAU\u0005\u0003DaAa/6\u0001\u0004\u0001HCBAU\u0005\u000b\u0014i\rC\u0004\u0002RY\u0002\rAa2\u0011\r\te#\u0011ZA3\u0013\u0011\u0011Y-!\u0018\u0003\u0007M+\u0017\u000f\u0003\u0004\u0003<Z\u0002\r\u0001]\u0001\u0011e\u0016lwN^3Qe>\u001cWm]:peN$b!!+\u0003T\n]\u0007B\u0002Bko\u0001\u0007\u0011-A\u0006sK6|g/Z\"pk:$\bb\u0002Bmo\u0001\u0007!1\\\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\ra%Q\\\u0005\u0004\u0005?4%A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!!+\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0003\r\u0011XO\\\u0001\u0011_B,gnU3sm\u0016\u00148k\\2lKR$b!!\u0013\u0003n\nE\bB\u0002Bxw\u0001\u0007\u0001/\u0001\u0003i_N$\bB\u0002Bzw\u0001\u0007\u0011-\u0001\u0003q_J$\u0018\u0001F1dG\u0016\u0004HOT3x\u0007>tg.Z2uS>t7/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0005w\u0014i\u0010E\u0003c\u0005;\u000by\u000fC\u0004\u0003\u0000v\u0002\ra!\u0001\u0002\u0007-,\u0017\u0010\u0005\u0003\u00022\r\r\u0011\u0002BB\u0003\u0003g\u0011AbU3mK\u000e$\u0018n\u001c8LKf\f\u0011d\u00197pg\u0016$\u0006N]8ui2,GmQ8o]\u0016\u001cG/[8og\u0006\u0019\u0012m]:jO:tUm^\"p]:,7\r^5p]RA!1MB\u0007\u0007#\u0019)\u0002C\u0004\u0004\u0010}\u0002\r!a<\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u001d\u0019\u0019b\u0010a\u0001\u0003K\n\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\t\u000f\r]q\b1\u0001\u0003d\u0005AQ.Y=CY>\u001c7.\u0001\u0004xC.,W\u000f\u001d\u0015\u0004\u0001\u000eu\u0001\u0003\u0002B\u001f\u0007?IAa!\t\u0003@\tAqJ^3se&$W-\u0001\u0005BG\u000e,\u0007\u000f^8s!\ta%iE\u0002C\u0003\u000f$\"a!\n\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019yCK\u0002q\u0005?\u0001")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;

    public static String $lessinit$greater$default$8() {
        return Acceptor$.MODULE$.$lessinit$greater$default$8();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                x$15.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                x$16.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$17)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$17) {
        return x$17.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int nodeId, ConnectionQuotas connectionQuotas, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

