/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) ^ (- 12)) => ivec3(40, -44, 92)
 * (ivec3(-36, 32, -88) ^ (- -6)) => ivec3(-38, 38, -82)
 * (ivec3(-36, 32, -88) ^ (- 76)) => ivec3(104, -108, 28)
 * (ivec3(-36, 32, -88) ^ (- -32)) => ivec3(-4, 0, -120)
 * (ivec3(-36, 32, -88) ^ (- 0)) => ivec3(-36, 32, -88)
 * (ivec3(36, 32, 88) ^ (- 12)) => ivec3(-48, -44, -84)
 * (ivec3(36, 32, 88) ^ (- -6)) => ivec3(34, 38, 94)
 * (ivec3(36, 32, 88) ^ (- 76)) => ivec3(-112, -108, -20)
 * (ivec3(36, 32, 88) ^ (- -32)) => ivec3(4, 0, 120)
 * (ivec3(36, 32, 88) ^ (- 0)) => ivec3(36, 32, 88)
 * (ivec3(59, 77, 68) ^ (- 12)) => ivec3(-49, -71, -80)
 * (ivec3(59, 77, 68) ^ (- -6)) => ivec3(61, 75, 66)
 * (ivec3(59, 77, 68) ^ (- 76)) => ivec3(-113, -7, -16)
 * (ivec3(59, 77, 68) ^ (- -32)) => ivec3(27, 109, 100)
 * (ivec3(59, 77, 68) ^ (- 0)) => ivec3(59, 77, 68)
 */
#version 130

void main()
{
  float[all(equal((ivec3(-36, 32, -88) ^ (- 12)), ivec3(40, -44, 92))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) ^ (- -6)), ivec3(-38, 38, -82))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) ^ (- 76)), ivec3(104, -108, 28))) ? 1 : -1] array2;
  float[all(equal((ivec3(-36, 32, -88) ^ (- -32)), ivec3(-4, 0, -120))) ? 1 : -1] array3;
  float[all(equal((ivec3(-36, 32, -88) ^ (- 0)), ivec3(-36, 32, -88))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) ^ (- 12)), ivec3(-48, -44, -84))) ? 1 : -1] array5;
  float[all(equal((ivec3(36, 32, 88) ^ (- -6)), ivec3(34, 38, 94))) ? 1 : -1] array6;
  float[all(equal((ivec3(36, 32, 88) ^ (- 76)), ivec3(-112, -108, -20))) ? 1 : -1] array7;
  float[all(equal((ivec3(36, 32, 88) ^ (- -32)), ivec3(4, 0, 120))) ? 1 : -1] array8;
  float[all(equal((ivec3(36, 32, 88) ^ (- 0)), ivec3(36, 32, 88))) ? 1 : -1] array9;
  float[all(equal((ivec3(59, 77, 68) ^ (- 12)), ivec3(-49, -71, -80))) ? 1 : -1] array10;
  float[all(equal((ivec3(59, 77, 68) ^ (- -6)), ivec3(61, 75, 66))) ? 1 : -1] array11;
  float[all(equal((ivec3(59, 77, 68) ^ (- 76)), ivec3(-113, -7, -16))) ? 1 : -1] array12;
  float[all(equal((ivec3(59, 77, 68) ^ (- -32)), ivec3(27, 109, 100))) ? 1 : -1] array13;
  float[all(equal((ivec3(59, 77, 68) ^ (- 0)), ivec3(59, 77, 68))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
