/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WraparoundApplicator;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;

public final class WraparoundAxesFinder {
    public final CoordinateReferenceSystem preferredCRS;
    public final MathTransform preferredToSpecified;

    public WraparoundAxesFinder(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
            coordinateReferenceSystem = projectedCRS.getBaseCRS();
            this.preferredToSpecified = projectedCRS.getConversionFromBase().getMathTransform();
        } else {
            this.preferredToSpecified = MathTransforms.identity(ReferencingUtilities.getDimension(coordinateReferenceSystem));
        }
        this.preferredCRS = coordinateReferenceSystem;
    }

    public double[] periods() {
        double[] dArray = null;
        CoordinateSystem coordinateSystem = this.preferredCRS.getCoordinateSystem();
        int n = coordinateSystem.getDimension();
        while (--n >= 0) {
            double d = WraparoundApplicator.range(coordinateSystem, n);
            if (!(d > 0.0)) continue;
            if (dArray == null) {
                dArray = new double[n + 1];
            }
            dArray[n] = d;
        }
        return dArray;
    }
}

