/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.solr.cluster.api.ApiType;
import org.apache.solr.cluster.api.CollectionConfig;
import org.apache.solr.cluster.api.HashRange;
import org.apache.solr.cluster.api.Resource;
import org.apache.solr.cluster.api.Router;
import org.apache.solr.cluster.api.Shard;
import org.apache.solr.cluster.api.ShardReplica;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.cluster.api.SolrCluster;
import org.apache.solr.cluster.api.SolrCollection;
import org.apache.solr.cluster.api.SolrNode;
import org.apache.solr.common.SimpleZkMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.WrappedSimpleMap;
import org.apache.zookeeper.KeeperException;

public class LazySolrCluster
implements SolrCluster {
    final ZkStateReader zkStateReader;
    private final Map<String, SolrCollectionImpl> cached = new ConcurrentHashMap<String, SolrCollectionImpl>();
    private final SimpleMap<SolrCollection> collections;
    private final SimpleMap<SolrCollection> collectionsAndAliases;
    private final SimpleMap<SolrNode> nodes;
    private SimpleMap<CollectionConfig> configs;

    public LazySolrCluster(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.collections = this.lazyCollectionsMap(zkStateReader);
        this.collectionsAndAliases = this.lazyCollectionsWithAlias(zkStateReader);
        this.nodes = this.lazyNodeMap();
    }

    private SimpleMap<CollectionConfig> lazyConfigMap() {
        final HashSet configNames = new HashSet();
        new SimpleZkMap(this.zkStateReader, "/configs").abortableForEach((name, resource) -> {
            if (!name.contains("/")) {
                configNames.add(name);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return new SimpleMap<CollectionConfig>(){

            public CollectionConfig get(String key) {
                if (configNames.contains(key)) {
                    return new ConfigImpl(key);
                }
                return null;
            }

            public void forEachEntry(BiConsumer<String, ? super CollectionConfig> fun) {
                for (String name : configNames) {
                    fun.accept(name, new ConfigImpl(name));
                }
            }

            public int size() {
                return configNames.size();
            }
        };
    }

    private SimpleMap<SolrNode> lazyNodeMap() {
        return new SimpleMap<SolrNode>(){

            public SolrNode get(String key) {
                if (!LazySolrCluster.this.zkStateReader.getClusterState().liveNodesContain(key)) {
                    return null;
                }
                return new Node(key);
            }

            public void forEachEntry(BiConsumer<String, ? super SolrNode> fun) {
                for (String s : LazySolrCluster.this.zkStateReader.getClusterState().getLiveNodes()) {
                    fun.accept(s, new Node(s));
                }
            }

            public int size() {
                return LazySolrCluster.this.zkStateReader.getClusterState().getLiveNodes().size();
            }
        };
    }

    private SimpleMap<SolrCollection> lazyCollectionsWithAlias(final ZkStateReader zkStateReader) {
        return new SimpleMap<SolrCollection>(){

            public SolrCollection get(String key) {
                SolrCollection result = (SolrCollection)LazySolrCluster.this.collections.get(key);
                if (result != null) {
                    return result;
                }
                Aliases aliases = zkStateReader.getAliases();
                List aliasNames = aliases.resolveAliases(key);
                if (aliasNames == null || aliasNames.isEmpty()) {
                    return null;
                }
                return LazySolrCluster.this._collection((String)aliasNames.get(0), null);
            }

            public void forEachEntry(BiConsumer<String, ? super SolrCollection> fun) {
                LazySolrCluster.this.collections.forEachEntry(fun);
                Aliases aliases = zkStateReader.getAliases();
                aliases.forEachAlias((s, colls) -> {
                    if (colls == null || colls.isEmpty()) {
                        return;
                    }
                    fun.accept((String)s, (SolrCollection)LazySolrCluster.this._collection((String)colls.get(0), null));
                });
            }

            public int size() {
                return LazySolrCluster.this.collections.size() + zkStateReader.getAliases().size();
            }
        };
    }

    private SimpleMap<SolrCollection> lazyCollectionsMap(final ZkStateReader zkStateReader) {
        return new SimpleMap<SolrCollection>(){

            public SolrCollection get(String key) {
                return LazySolrCluster.this._collection(key, null);
            }

            public void forEachEntry(BiConsumer<String, ? super SolrCollection> fun) {
                zkStateReader.getClusterState().forEachCollection(coll -> fun.accept(coll.getName(), LazySolrCluster.this._collection(coll.getName(), (DocCollection)coll)));
            }

            public int size() {
                return zkStateReader.getClusterState().size();
            }
        };
    }

    private SolrCollection _collection(String key, DocCollection c) {
        if (c == null) {
            c = this.zkStateReader.getCollection(key);
        }
        if (c == null) {
            this.cached.remove(key);
            return null;
        }
        SolrCollectionImpl existing = this.cached.get(key);
        if (existing == null || existing.coll != c) {
            existing = new SolrCollectionImpl(c, this.zkStateReader);
            this.cached.put(key, existing);
        }
        return existing;
    }

    public SimpleMap<SolrCollection> collections() throws SolrException {
        return this.collections;
    }

    public SimpleMap<SolrCollection> collections(boolean includeAlias) throws SolrException {
        return includeAlias ? this.collectionsAndAliases : this.collections;
    }

    public SimpleMap<SolrNode> nodes() throws SolrException {
        return this.nodes;
    }

    public SimpleMap<CollectionConfig> configs() throws SolrException {
        if (this.configs == null) {
            this.configs = this.lazyConfigMap();
        }
        return this.configs;
    }

    public String overseerNode() throws SolrException {
        return null;
    }

    public String thisNode() {
        return null;
    }

    private class ConfigImpl
    implements CollectionConfig {
        final String name;
        final SimpleMap<Resource> resources;
        final String path;

        private ConfigImpl(String name) {
            this.name = name;
            this.path = "/configs/" + name;
            this.resources = new SimpleZkMap(LazySolrCluster.this.zkStateReader, this.path);
        }

        public SimpleMap<Resource> resources() {
            return this.resources;
        }

        public String name() {
            return this.name;
        }
    }

    private class Node
    implements SolrNode {
        private final String name;

        private Node(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String baseUrl(ApiType apiType) {
            return Utils.getBaseUrlForNodeName((String)this.name, (String)LazySolrCluster.this.zkStateReader.getClusterProperty("urlScheme", "http"), (apiType == ApiType.V2 ? 1 : 0) != 0);
        }

        public SimpleMap<ShardReplica> cores() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private class ShardReplicaImpl
    implements ShardReplica {
        private final ShardImpl shard;
        private final Replica replica;

        private ShardReplicaImpl(ShardImpl shard, Replica replica) {
            this.shard = shard;
            this.replica = replica;
        }

        public String name() {
            return this.replica.getName();
        }

        public String shard() {
            return this.shard.name();
        }

        public String collection() {
            return this.shard.collection.name();
        }

        public String node() {
            return this.replica.getNodeName();
        }

        public String core() {
            return this.replica.getCoreName();
        }

        public Replica.Type type() {
            return this.replica.getType();
        }

        public boolean alive() {
            return LazySolrCluster.this.zkStateReader.getClusterState().getLiveNodes().contains(this.node()) && this.replica.getState() == Replica.State.ACTIVE;
        }

        public long indexSize() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public boolean isLeader() {
            return Objects.equals(this.shard.leader(), this.name());
        }

        public String url(ApiType type) {
            String base = ((SolrNode)LazySolrCluster.this.nodes.get(this.node())).baseUrl(type);
            if (type == ApiType.V2) {
                return base + "/cores/" + this.core();
            }
            return base + "/" + this.core();
        }
    }

    private class ShardImpl
    implements Shard {
        final SolrCollectionImpl collection;
        final Slice slice;
        final HashRange range;
        final SimpleMap<ShardReplica> replicas;

        private ShardImpl(SolrCollectionImpl collection, Slice slice) {
            this.collection = collection;
            this.slice = slice;
            this.range = this._range(slice);
            this.replicas = this._replicas();
        }

        private SimpleMap<ShardReplica> _replicas() {
            HashMap replicas = new HashMap();
            this.slice.forEach(replica -> replicas.put(replica.getName(), new ShardReplicaImpl(this, (Replica)replica)));
            return new WrappedSimpleMap(replicas);
        }

        private HashRange _range(final Slice slice) {
            return slice.getRange() == null ? null : new HashRange(){

                public int min() {
                    return slice.getRange().min;
                }

                public int max() {
                    return slice.getRange().max;
                }
            };
        }

        public String name() {
            return this.slice.getName();
        }

        public String collection() {
            return this.collection.name();
        }

        public HashRange range() {
            return this.range;
        }

        public SimpleMap<ShardReplica> replicas() {
            return this.replicas;
        }

        public String leader() {
            Replica leader = this.slice.getLeader();
            return leader == null ? null : leader.getName();
        }
    }

    private class SolrCollectionImpl
    implements SolrCollection {
        final DocCollection coll;
        final SimpleMap<Shard> shards;
        final ZkStateReader zkStateReader;
        final Router router;
        String confName;

        private SolrCollectionImpl(DocCollection coll, ZkStateReader zkStateReader) {
            this.coll = coll;
            this.zkStateReader = zkStateReader;
            this.router = key -> coll.getRouter().getTargetSlice(key, null, null, null, null).getName();
            LinkedHashMap<String, ShardImpl> map = new LinkedHashMap<String, ShardImpl>();
            for (Slice slice : coll.getSlices()) {
                map.put(slice.getName(), new ShardImpl(this, slice));
            }
            this.shards = new WrappedSimpleMap(map);
        }

        public String name() {
            return this.coll.getName();
        }

        public SimpleMap<Shard> shards() {
            return this.shards;
        }

        public String config() {
            if (this.confName == null) {
                try {
                    byte[] d = this.zkStateReader.getZkClient().getData(DocCollection.getCollectionPathRoot((String)this.coll.getName()), null, null, true);
                    if (d == null || d.length == 0) {
                        return null;
                    }
                    Map m = (Map)Utils.fromJSON((byte[])d);
                    this.confName = (String)m.get("configName");
                }
                catch (InterruptedException | KeeperException e) {
                    SimpleZkMap.throwZkExp((Exception)e);
                    return null;
                }
            }
            return this.confName;
        }

        public Router router() {
            return this.router;
        }
    }
}

