/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Phaser;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginConfig;
import org.apache.solr.cluster.placement.PlacementPluginFactory;

public final class DelegatingPlacementPluginFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    private volatile PlacementPluginFactory<? extends PlacementPluginConfig> delegate;
    private volatile Phaser phaser;

    @Override
    public PlacementPlugin createPluginInstance() {
        if (this.delegate != null) {
            return this.delegate.createPluginInstance();
        }
        return null;
    }

    @VisibleForTesting
    public void setDelegationPhaser(Phaser phaser) {
        phaser.register();
        this.phaser = phaser;
    }

    public void setDelegate(PlacementPluginFactory<? extends PlacementPluginConfig> delegate) {
        this.delegate = delegate;
        Phaser localPhaser = this.phaser;
        if (localPhaser != null) {
            assert (localPhaser.getRegisteredParties() == 1);
            localPhaser.arrive();
        }
    }

    @VisibleForTesting
    public PlacementPluginFactory<? extends PlacementPluginConfig> getDelegate() {
        return this.delegate;
    }
}

