/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.exporter.MetricsQueryTemplate;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetricsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PrometheusExporterSettings settings;
    private final List<MetricsQuery> pingConfiguration;
    private final List<MetricsQuery> metricsConfiguration;
    private final List<MetricsQuery> collectionsConfiguration;
    private final List<MetricsQuery> searchConfiguration;
    static final XPathFactory xpathFactory = XPathFactory.newInstance();

    private MetricsConfiguration(PrometheusExporterSettings settings, List<MetricsQuery> pingConfiguration, List<MetricsQuery> metricsConfiguration, List<MetricsQuery> collectionsConfiguration, List<MetricsQuery> searchConfiguration) {
        this.settings = settings;
        this.pingConfiguration = pingConfiguration;
        this.metricsConfiguration = metricsConfiguration;
        this.collectionsConfiguration = collectionsConfiguration;
        this.searchConfiguration = searchConfiguration;
    }

    public PrometheusExporterSettings getSettings() {
        return this.settings;
    }

    public List<MetricsQuery> getPingConfiguration() {
        return this.pingConfiguration;
    }

    public List<MetricsQuery> getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public List<MetricsQuery> getCollectionsConfiguration() {
        return this.collectionsConfiguration;
    }

    public List<MetricsQuery> getSearchConfiguration() {
        return this.searchConfiguration;
    }

    public static MetricsConfiguration from(String resource) throws Exception {
        Document document;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setXIncludeAware(true);
            dbf.setNamespaceAware(true);
        }
        catch (UnsupportedOperationException e) {
            log.warn("{} XML parser doesn't support XInclude option", (Object)resource);
        }
        Path path = Path.of(resource, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            document = dbf.newDocumentBuilder().parse(path.toUri().toASCIIString());
        } else {
            try (InputStream configInputStream = MethodHandles.lookup().lookupClass().getClassLoader().getResourceAsStream(resource.replace(File.separatorChar, '/'));){
                document = dbf.newDocumentBuilder().parse(configInputStream);
            }
        }
        return MetricsConfiguration.from(document);
    }

    public static MetricsConfiguration from(Document config) throws Exception {
        Node settings = MetricsConfiguration.getNode(config, "/config/settings");
        NodeList jqTemplates = (NodeList)xpathFactory.newXPath().evaluate("/config/jq-templates/template", config, XPathConstants.NODESET);
        Map<String, MetricsQueryTemplate> jqTemplatesMap = jqTemplates != null && jqTemplates.getLength() > 0 ? MetricsConfiguration.loadJqTemplates(jqTemplates) : Collections.emptyMap();
        Node pingConfig = MetricsConfiguration.getNode(config, "/config/rules/ping");
        Node metricsConfig = MetricsConfiguration.getNode(config, "/config/rules/metrics");
        Node collectionsConfig = MetricsConfiguration.getNode(config, "/config/rules/collections");
        Node searchConfiguration = MetricsConfiguration.getNode(config, "/config/rules/search");
        return new MetricsConfiguration(settings == null ? PrometheusExporterSettings.builder().build() : PrometheusExporterSettings.from(settings), MetricsConfiguration.toMetricQueries(pingConfig, jqTemplatesMap), MetricsConfiguration.toMetricQueries(metricsConfig, jqTemplatesMap), MetricsConfiguration.toMetricQueries(collectionsConfig, jqTemplatesMap), MetricsConfiguration.toMetricQueries(searchConfiguration, jqTemplatesMap));
    }

    private static Node getNode(Document doc, String path) {
        XPath xpath = xpathFactory.newXPath();
        String xstr = path;
        try {
            NodeList nodes = (NodeList)xpath.evaluate(xstr, doc, XPathConstants.NODESET);
            if (nodes == null || 0 == nodes.getLength()) {
                return null;
            }
            if (1 < nodes.getLength()) {
                throw new RuntimeException("more than one value");
            }
            return nodes.item(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in xpath:" + xstr, e);
        }
    }

    private static List<MetricsQuery> toMetricQueries(Node node, Map<String, MetricsQueryTemplate> jqTemplatesMap) throws JsonQueryException {
        if (node == null) {
            return Collections.emptyList();
        }
        return MetricsQuery.from(node, jqTemplatesMap);
    }

    static Map<String, MetricsQueryTemplate> loadJqTemplates(NodeList jqTemplates) {
        HashMap<String, MetricsQueryTemplate> map = new HashMap<String, MetricsQueryTemplate>();
        for (int t = 0; t < jqTemplates.getLength(); ++t) {
            Node template = jqTemplates.item(t);
            if (template.getNodeType() != 1 || !template.hasAttributes()) continue;
            Node nameAttr = template.getAttributes().getNamedItem("name");
            String name = nameAttr != null ? nameAttr.getNodeValue() : null;
            String tmpl = template.getTextContent();
            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)tmpl)) continue;
            Node defaultTypeAttr = template.getAttributes().getNamedItem("defaultType");
            String defaultType = defaultTypeAttr != null ? defaultTypeAttr.getNodeValue() : null;
            map.put(name, new MetricsQueryTemplate(name, tmpl, defaultType));
        }
        return map;
    }
}

