/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.apache.sis.image.ComputedTiles;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.TileCache;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;

public abstract class ComputedImage
extends PlanarImage
implements Disposable {
    public static final String SOURCE_PADDING_KEY = "org.apache.sis.SourcePadding";
    private final ComputedTiles reference;
    private final RenderedImage[] sources;
    private WritableRenderedImage destination;
    protected final SampleModel sampleModel;

    protected ComputedImage(SampleModel sampleModel, RenderedImage ... renderedImageArray) {
        ArgumentChecks.ensureNonNull("sampleModel", sampleModel);
        this.sampleModel = sampleModel;
        WritableRenderedImage[] writableRenderedImageArray = null;
        if (renderedImageArray != null) {
            renderedImageArray = (RenderedImage[])renderedImageArray.clone();
            int n = 0;
            for (int i = 0; i < renderedImageArray.length; ++i) {
                RenderedImage renderedImage = renderedImageArray[i];
                ArgumentChecks.ensureNonNullElement("sources", i, renderedImage);
                if (!(renderedImage instanceof WritableRenderedImage)) continue;
                if (writableRenderedImageArray == null) {
                    writableRenderedImageArray = new WritableRenderedImage[renderedImageArray.length - i];
                }
                writableRenderedImageArray[n++] = (WritableRenderedImage)renderedImage;
            }
            if (n != 0) {
                if (n == renderedImageArray.length) {
                    renderedImageArray = writableRenderedImageArray;
                } else {
                    writableRenderedImageArray = (WritableRenderedImage[])ArraysExt.resize(writableRenderedImageArray, n);
                }
            }
        }
        this.sources = renderedImageArray;
        this.reference = new ComputedTiles(this, writableRenderedImageArray);
    }

    final Reference<ComputedImage> reference() {
        return this.reference;
    }

    final void setDestination(WritableRenderedImage writableRenderedImage) {
        if (this.destination != null) {
            throw new IllegalStateException(Errors.format((short)188, "destination"));
        }
        if (!this.sampleModel.equals(writableRenderedImage.getSampleModel())) {
            throw new IllegalArgumentException(Resources.format((short)46));
        }
        if (writableRenderedImage.getTileGridXOffset() != this.getTileGridXOffset() || writableRenderedImage.getTileGridYOffset() != this.getTileGridYOffset()) {
            throw new IllegalArgumentException(Resources.format((short)47));
        }
        this.destination = writableRenderedImage;
    }

    final WritableRenderedImage getDestination() {
        return this.destination;
    }

    final RenderedImage getSource() {
        return this.sources[0];
    }

    protected final RenderedImage getSource(int n) {
        if (this.sources != null) {
            return this.sources[n];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.sources != null ? new Vector<RenderedImage>(Arrays.asList(this.sources)) : null;
    }

    private <T> T getProperty(Class<T> clazz, String string, RenderedImage renderedImage) {
        Object object = this.getProperty(string);
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (this.sources != null && object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = Math.min(this.sources.length, objectArray.length);
            for (int i = 0; i < n; ++i) {
                if (this.sources[i] != renderedImage || !clazz.isInstance(object = objectArray[i])) continue;
                return (T)object;
            }
        }
        return null;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    @Override
    public int getTileWidth() {
        return this.sampleModel.getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.sampleModel.getHeight();
    }

    private static void checkTileIndex(String string, int n, int n2, int n3) {
        int n4 = n + n2;
        if (n3 < n || n3 >= n4) {
            throw new IndexOutOfBoundsException(Errors.format((short)166, string, n, n4 - 1, n3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Raster getTile(int n, int n2) {
        TileCache tileCache = TileCache.GLOBAL;
        TileCache.Key key = new TileCache.Key(this.reference, n, n2);
        Raster raster = (Raster)tileCache.peek(key);
        if (raster == null || this.reference.isTileDirty(key)) {
            Throwable throwable;
            block13: {
                ComputedImage.checkTileIndex("tileX", this.getMinTileX(), this.getNumXTiles(), n);
                ComputedImage.checkTileIndex("tileY", this.getMinTileY(), this.getNumYTiles(), n2);
                throwable = null;
                Cache.Handler<Raster> handler = tileCache.lock(key);
                try {
                    int n3;
                    boolean bl;
                    raster = (Raster)handler.peek();
                    boolean bl2 = this.reference.trySetComputing(key);
                    if (!bl2 && raster != null) break block13;
                    WritableRenderedImage writableRenderedImage = this.destination;
                    boolean bl3 = bl = writableRenderedImage != null && n >= (n3 = writableRenderedImage.getMinTileX()) && n < n3 + writableRenderedImage.getNumXTiles() && n2 >= (n3 = writableRenderedImage.getMinTileY()) && n2 < n3 + writableRenderedImage.getNumYTiles();
                    WritableRaster writableRaster = bl ? writableRenderedImage.getWritableTile(n, n2) : (raster instanceof WritableRaster ? (WritableRaster)raster : null);
                    try {
                        raster = this.computeTile(n, n2, writableRaster);
                    }
                    catch (Exception exception) {
                        raster = null;
                        throwable = Exceptions.unwrap(exception);
                    }
                    finally {
                        if (bl) {
                            writableRenderedImage.releaseWritableTile(n, n2);
                        }
                    }
                    if (bl2) {
                        this.reference.endWrite(key, throwable == null);
                    }
                }
                finally {
                    handler.putAndUnlock(raster);
                }
            }
            if (raster == null) {
                if (!(throwable instanceof ImagingOpException)) {
                    throwable = new ImagingOpException(key.error((short)4)).initCause(throwable);
                }
                throw (ImagingOpException)throwable;
            }
        }
        return raster;
    }

    protected abstract Raster computeTile(int var1, int var2, WritableRaster var3) throws Exception;

    protected WritableRaster createTile(int n, int n2) {
        int n3 = Math.toIntExact(((long)n - (long)this.getMinTileX()) * (long)this.getTileWidth() + (long)this.getMinX());
        int n4 = Math.toIntExact(((long)n2 - (long)this.getMinTileY()) * (long)this.getTileHeight() + (long)this.getMinY());
        return WritableRaster.createWritableRaster(this.getSampleModel(), new Point(n3, n4));
    }

    @Override
    protected Disposable prefetch(Rectangle rectangle) {
        return null;
    }

    public boolean hasTileWriters() {
        return this.reference.getWritableTileIndices(null);
    }

    public boolean isTileWritable(int n, int n2) {
        return this.reference.isTileWritable(new TileCache.Key(this.reference, n, n2));
    }

    public Point[] getWritableTileIndices() {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (this.reference.getWritableTileIndices(arrayList)) {
            return arrayList.toArray(new Point[arrayList.size()]);
        }
        return null;
    }

    protected boolean markTileWritable(int n, int n2, boolean bl) {
        TileCache.Key key = new TileCache.Key(this.reference, n, n2);
        if (bl) {
            return this.reference.startWrite(key);
        }
        return this.reference.endWrite(key, true);
    }

    protected boolean markDirtyTiles(Rectangle rectangle) {
        return this.reference.markDirtyTiles(rectangle.x, rectangle.y, Math.addExact(rectangle.x, rectangle.width - 1), Math.addExact(rectangle.y, rectangle.height - 1), false);
    }

    protected boolean clearErrorFlags(Rectangle rectangle) {
        return this.reference.markDirtyTiles(rectangle.x, rectangle.y, Math.addExact(rectangle.x, rectangle.width - 1), Math.addExact(rectangle.y, rectangle.height - 1), true);
    }

    protected void sourceTileChanged(RenderedImage renderedImage, int n, int n2) {
        long l = renderedImage.getTileWidth();
        long l2 = renderedImage.getTileHeight();
        long l3 = this.getTileWidth();
        long l4 = this.getTileHeight();
        long l5 = (long)n * l + (long)renderedImage.getTileGridXOffset() - (long)this.getTileGridXOffset();
        long l6 = (long)n2 * l2 + (long)renderedImage.getTileGridYOffset() - (long)this.getTileGridYOffset();
        Insets insets = this.getProperty(Insets.class, SOURCE_PADDING_KEY, renderedImage);
        this.reference.markDirtyTiles(Numerics.clamp(Math.floorDiv(l5 - (long)(insets == null ? 0 : insets.left), l3)), Numerics.clamp(Math.floorDiv(l6 - (long)(insets == null ? 0 : insets.top), l4)), Numerics.clamp(Math.floorDiv(l5 + (long)(insets == null ? 0 : insets.right) + l - 1L, l3)), Numerics.clamp(Math.floorDiv(l6 + (long)(insets == null ? 0 : insets.bottom) + l2 - 1L, l4)), false);
    }

    @Override
    public void dispose() {
        this.reference.dispose();
    }
}

