/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.traccar.model.BaseModel;
import org.traccar.model.Pair;
import org.traccar.model.Permission;
import org.traccar.storage.Storage;
import org.traccar.storage.query.Request;

public class MemoryStorage
extends Storage {
    private final Map<Pair<Class<?>, Class<?>>, Set<Pair<Long, Long>>> permissions = new HashMap();

    @Override
    public <T> List<T> getObjects(Class<T> clazz, Request request) {
        return null;
    }

    @Override
    public <T> long addObject(T entity, Request request) {
        return 0L;
    }

    @Override
    public <T> void updateObject(T entity, Request request) {
    }

    @Override
    public void removeObject(Class<?> clazz, Request request) {
    }

    private Set<Pair<Long, Long>> getPermissionsSet(Class<?> ownerClass, Class<?> propertyClass) {
        return this.permissions.computeIfAbsent(new Pair(ownerClass, propertyClass), k -> new HashSet());
    }

    @Override
    public List<Permission> getPermissions(Class<? extends BaseModel> ownerClass, long ownerId, Class<? extends BaseModel> propertyClass, long propertyId) {
        return this.getPermissionsSet(ownerClass, propertyClass).stream().filter(pair -> ownerId == 0L || ((Long)pair.getFirst()).equals(ownerId)).filter(pair -> propertyId == 0L || ((Long)pair.getSecond()).equals(propertyId)).map(pair -> new Permission(ownerClass, (Long)pair.getFirst(), propertyClass, (Long)pair.getSecond())).collect(Collectors.toList());
    }

    @Override
    public void addPermission(Permission permission) {
        this.getPermissionsSet(permission.getOwnerClass(), permission.getPropertyClass()).add(new Pair<Long, Long>(permission.getOwnerId(), permission.getPropertyId()));
    }

    @Override
    public void removePermission(Permission permission) {
        this.getPermissionsSet(permission.getOwnerClass(), permission.getPropertyClass()).remove(new Pair<Long, Long>(permission.getOwnerId(), permission.getPropertyId()));
    }
}

