/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.spi.v1;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.FirestoreStubSettings;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreStub;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.DatabaseRootName;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.protobuf.Empty;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class GrpcFirestoreRpc
implements FirestoreRpc {
    private final FirestoreStub firestoreStub;
    private final ScheduledExecutorService executor;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private final ClientContext clientContext;
    private boolean closed;

    public GrpcFirestoreRpc(FirestoreOptions options) throws IOException {
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)options.getTransportOptions();
        this.executorFactory = transportOptions.getExecutorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        try {
            if (options.getHost().contains("localhost") || NoCredentials.getInstance().equals((Object)options.getCredentials())) {
                ManagedChannel managedChannel = ManagedChannelBuilder.forTarget((String)options.getHost()).usePlaintext().executor((Executor)this.executor).build();
                GrpcTransportChannel transportChannel = GrpcTransportChannel.create((ManagedChannel)managedChannel);
                this.clientContext = ClientContext.newBuilder().setCredentials(null).setExecutor(this.executor).setTransportChannel((TransportChannel)transportChannel).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)managedChannel, (CallOptions)CallOptions.DEFAULT)).setBackgroundResources(Collections.singletonList(transportChannel)).build();
            } else {
                FirestoreSettingsBuilder settingsBuilder = new FirestoreSettingsBuilder(FirestoreSettings.newBuilder().build());
                DatabaseRootName databaseName = DatabaseRootName.of((String)options.getProjectId(), (String)options.getDatabaseId());
                settingsBuilder.setCredentialsProvider(options.getCredentialsProvider());
                settingsBuilder.setTransportChannelProvider(options.getTransportChannelProvider());
                ApiClientHeaderProvider internalHeaderProvider = FirestoreSettings.defaultApiClientHeaderProviderBuilder().setClientLibToken(ServiceOptions.getGoogApiClientLibName(), GaxProperties.getLibraryVersion(((Object)((Object)options)).getClass())).setResourceToken(databaseName.toString()).build();
                settingsBuilder.setInternalHeaderProvider((HeaderProvider)internalHeaderProvider);
                settingsBuilder.setHeaderProvider(options.getMergedHeaderProvider((HeaderProvider)new NoHeaderProvider()));
                this.clientContext = ClientContext.create((ClientSettings)settingsBuilder.build());
            }
            ApiFunction retrySettingsSetter = builder -> {
                builder.setRetrySettings(options.getRetrySettings());
                return null;
            };
            FirestoreStubSettings.Builder firestoreBuilder = FirestoreStubSettings.newBuilder(this.clientContext).applyToAllUnaryMethods(retrySettingsSetter);
            firestoreBuilder.runQuerySettings().setRetrySettings(options.getRetrySettings());
            firestoreBuilder.batchGetDocumentsSettings().setRetrySettings(options.getRetrySettings());
            this.firestoreStub = GrpcFirestoreStub.create(firestoreBuilder.build());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.firestoreStub.close();
            for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
                resource.close();
            }
            this.executorFactory.release((ExecutorService)this.executor);
            this.closed = true;
        }
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void shutdown() {
        if (this.closed) {
            return;
        }
        this.firestoreStub.shutdown();
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.shutdown();
        }
        this.executorFactory.release((ExecutorService)this.executor);
        this.closed = true;
    }

    @Override
    public void shutdownNow() {
        if (this.closed) {
            return;
        }
        this.firestoreStub.shutdownNow();
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.shutdownNow();
        }
        this.executorFactory.release((ExecutorService)this.executor);
        this.closed = true;
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.firestoreStub.commitCallable();
    }

    @Override
    public UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable() {
        return this.firestoreStub.batchWriteCallable();
    }

    @Override
    public ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.firestoreStub.batchGetDocumentsCallable();
    }

    @Override
    public ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.firestoreStub.runQueryCallable();
    }

    @Override
    public ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.firestoreStub.runAggregationQueryCallable();
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.firestoreStub.beginTransactionCallable();
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.firestoreStub.rollbackCallable();
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable() {
        return this.firestoreStub.listCollectionIdsPagedCallable();
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable() {
        return this.firestoreStub.partitionQueryPagedCallable();
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.firestoreStub.listDocumentsPagedCallable();
    }

    @Override
    public BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable() {
        return this.firestoreStub.listenCallable();
    }

    private static class FirestoreSettingsBuilder
    extends FirestoreSettings.Builder {
        private FirestoreSettingsBuilder(FirestoreSettings settings) {
            super(settings);
        }

        protected FirestoreSettings.Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            return (FirestoreSettings.Builder)super.setInternalHeaderProvider(internalHeaderProvider);
        }
    }
}

