/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.auth.ProviderConfig;
import java.util.HashMap;
import java.util.Map;

public final class OidcProviderConfig
extends ProviderConfig {
    @Key(value="clientId")
    private String clientId;
    @Key(value="clientSecret")
    private String clientSecret;
    @Key(value="issuer")
    private String issuer;
    @Key(value="responseType")
    private GenericJson responseType;

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public boolean isCodeResponseType() {
        return this.responseType.containsKey((Object)"code") && (Boolean)this.responseType.get((Object)"code") != false;
    }

    public boolean isIdTokenResponseType() {
        return this.responseType.containsKey((Object)"idToken") && (Boolean)this.responseType.get((Object)"idToken") != false;
    }

    public UpdateRequest updateRequest() {
        return new UpdateRequest(this.getProviderId());
    }

    static void checkOidcProviderId(String providerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"Provider ID must not be null or empty.");
        Preconditions.checkArgument((boolean)providerId.startsWith("oidc."), (Object)("Invalid OIDC provider ID (must be prefixed with 'oidc.'): " + providerId));
    }

    static Map<String, Boolean> ensureResponseType(Map<String, Object> properties) {
        if (properties.get("responseType") == null) {
            properties.put("responseType", new HashMap());
        }
        return (Map)properties.get("responseType");
    }

    public static final class UpdateRequest
    extends ProviderConfig.AbstractUpdateRequest<UpdateRequest> {
        public UpdateRequest(String providerId) {
            super(providerId);
            OidcProviderConfig.checkOidcProviderId(providerId);
        }

        public UpdateRequest setClientId(String clientId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"Client ID must not be null or empty.");
            this.properties.put("clientId", clientId);
            return this;
        }

        public UpdateRequest setClientSecret(String clientSecret) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientSecret) ? 1 : 0) != 0, (Object)"Client Secret must not be null or empty.");
            this.properties.put("clientSecret", clientSecret);
            return this;
        }

        public UpdateRequest setIssuer(String issuer) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)issuer) ? 1 : 0) != 0, (Object)"Issuer must not be null or empty.");
            ProviderConfig.assertValidUrl(issuer);
            this.properties.put("issuer", issuer);
            return this;
        }

        public UpdateRequest setCodeResponseType(boolean enabled) {
            Map<String, Boolean> map = OidcProviderConfig.ensureResponseType(this.properties);
            map.put("code", enabled);
            return this;
        }

        public UpdateRequest setIdTokenResponseType(boolean enabled) {
            Map<String, Boolean> map = OidcProviderConfig.ensureResponseType(this.properties);
            map.put("idToken", enabled);
            return this;
        }

        @Override
        UpdateRequest getThis() {
            return this;
        }
    }

    public static final class CreateRequest
    extends ProviderConfig.AbstractCreateRequest<CreateRequest> {
        @Override
        public CreateRequest setProviderId(String providerId) {
            OidcProviderConfig.checkOidcProviderId(providerId);
            return (CreateRequest)super.setProviderId(providerId);
        }

        public CreateRequest setClientId(String clientId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"Client ID must not be null or empty.");
            this.properties.put("clientId", clientId);
            return this;
        }

        public CreateRequest setClientSecret(String clientSecret) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientSecret) ? 1 : 0) != 0, (Object)"Client Secret must not be null or empty.");
            this.properties.put("clientSecret", clientSecret);
            return this;
        }

        public CreateRequest setIssuer(String issuer) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)issuer) ? 1 : 0) != 0, (Object)"Issuer must not be null or empty.");
            ProviderConfig.assertValidUrl(issuer);
            this.properties.put("issuer", issuer);
            return this;
        }

        public CreateRequest setCodeResponseType(boolean enabled) {
            Map<String, Boolean> map = OidcProviderConfig.ensureResponseType(this.properties);
            map.put("code", enabled);
            return this;
        }

        public CreateRequest setIdTokenResponseType(boolean enabled) {
            Map<String, Boolean> map = OidcProviderConfig.ensureResponseType(this.properties);
            map.put("idToken", enabled);
            return this;
        }

        @Override
        CreateRequest getThis() {
            return this;
        }
    }
}

