/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.util.StringUtils;

public class CapabilityResolver {
    private ArrayList<StringBuilder> capList = null;
    private StringBuilder capBuf;
    private ResolvedFeature feature;
    private CapabilitySpec capSpec;
    private String currentElem;

    List<String> resolve(CapabilitySpec capSpec, ResolvedFeature feature) throws ProvisioningException {
        if (capSpec.isStatic()) {
            return Collections.singletonList(capSpec.toString());
        }
        if (this.capBuf == null) {
            this.capBuf = new StringBuilder();
        }
        this.feature = feature;
        this.capSpec = capSpec;
        try {
            if (!capSpec.resolve(this)) {
                List<String> list = Collections.emptyList();
                return list;
            }
            if (this.capList == null) {
                List<String> list = this.capBuf.length() == 0 ? Collections.emptyList() : Collections.singletonList(this.capBuf.toString());
                return list;
            }
            ArrayList<String> resolved = new ArrayList<String>(this.capList.size());
            for (int i = 0; i < this.capList.size(); ++i) {
                resolved.add(this.capList.get(i).toString());
            }
            ArrayList<String> arrayList = resolved;
            return arrayList;
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToResolveCapability(feature, capSpec), e);
        }
        finally {
            this.reset();
        }
    }

    void reset() {
        this.feature = null;
        this.capList = null;
        this.capBuf.setLength(0);
        this.currentElem = null;
    }

    public CapabilitySpec getSpec() {
        return this.capSpec;
    }

    public String getElem() {
        return this.currentElem;
    }

    public boolean resolveElement(String elem, boolean isStatic) throws ProvisioningException {
        if (isStatic) {
            this.add(elem);
            return true;
        }
        this.currentElem = elem;
        return this.feature.spec.resolveCapabilityElement(this.feature, elem, this);
    }

    public CapabilityResolver add(Object elem) throws ProvisioningException {
        if (this.capList == null) {
            if (this.capBuf.length() > 0) {
                this.capBuf.append('.');
            }
            this.capBuf.append(this.toStringElem(elem));
            return this;
        }
        String str = this.toStringElem(elem);
        for (int i = 0; i < this.capList.size(); ++i) {
            this.capList.get(i).append('.').append(str);
        }
        return this;
    }

    public CapabilityResolver multiply(Collection<?> elems) throws ProvisioningException {
        if (elems.isEmpty()) {
            throw new ProvisioningException(Errors.illegalCapabilityElement(this.capSpec, elems.toString(), this.capBuf.toString()));
        }
        if (elems.size() == 1) {
            this.add(elems.iterator().next());
            return this;
        }
        if (this.capList == null) {
            if (this.capBuf.length() > 0) {
                this.capBuf.append('.');
            }
            this.capList = new ArrayList(elems.size());
            for (Object o : elems) {
                this.capList.add(this.capBuf.length() == 0 ? new StringBuilder(this.toStringElem(o)) : new StringBuilder(this.capBuf).append(this.toStringElem(o)));
            }
            return this;
        }
        this.capList.ensureCapacity(this.capList.size() * elems.size());
        int capsTotal = this.capList.size();
        for (int i = 0; i < capsTotal; ++i) {
            StringBuilder capBuf = this.capList.get(i).append('.');
            Iterator<?> elemI = elems.iterator();
            Object firstElem = elemI.next();
            while (elemI.hasNext()) {
                this.capList.add(new StringBuilder(capBuf).append(this.toStringElem(elemI.next())));
            }
            capBuf.append(this.toStringElem(firstElem));
        }
        return this;
    }

    private String toStringElem(Object elem) throws ProvisioningException {
        if (elem == null) {
            throw new ProvisioningException(Errors.illegalCapabilityElement(this.capSpec, null, this.capBuf.toString()));
        }
        String str = elem.toString().trim();
        if (str.isEmpty()) {
            throw new ProvisioningException(Errors.illegalCapabilityElement(this.capSpec, str, this.capBuf.toString()));
        }
        return StringUtils.stripSurrounding(str, '\"');
    }
}

