/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LonLat
implements Proj {
    private double a;

    @Override
    public String getName() {
        return I18n.tr("Lat/lon (Geodetic)", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "lonlat";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        CheckParameterUtil.ensureParameterNotNull(params, "params");
        CheckParameterUtil.ensureParameterNotNull(params.ellps, "params.ellps");
        this.a = params.ellps.a;
    }

    @Override
    public double[] project(double latRad, double lonRad) {
        return new double[]{Utils.toDegrees(lonRad) / this.a, Utils.toDegrees(latRad) / this.a};
    }

    @Override
    public double[] invproject(double east, double north) {
        return new double[]{Utils.toRadians(north * this.a), Utils.toRadians(east * this.a)};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-90.0, -180.0, 90.0, 180.0, false);
    }

    @Override
    public boolean isGeographic() {
        return true;
    }
}

