/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.ChangesetReviewModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagSettingsPanel
extends JPanel
implements TableModelListener {
    private final TagEditorPanel pnlTagEditor = new TagEditorPanel(null, null, 255);
    private final transient ChangesetCommentModel changesetCommentModel;
    private final transient ChangesetCommentModel changesetSourceModel;
    private final transient ChangesetReviewModel changesetReviewModel;

    public TagSettingsPanel(ChangesetCommentModel changesetCommentModel, ChangesetCommentModel changesetSourceModel, ChangesetReviewModel changesetReviewModel) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        CheckParameterUtil.ensureParameterNotNull(changesetSourceModel, "changesetSourceModel");
        CheckParameterUtil.ensureParameterNotNull(changesetReviewModel, "changesetReviewModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetSourceModel = changesetSourceModel;
        this.changesetReviewModel = changesetReviewModel;
        changesetCommentModel.addChangeListener(new ChangesetCommentChangeListener("comment", "hashtags"));
        changesetSourceModel.addChangeListener(new ChangesetCommentChangeListener("source"));
        changesetReviewModel.addChangeListener(new ChangesetReviewChangeListener());
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlTagEditor, "Center");
    }

    protected void setProperty(String key, String value) {
        String commentInTag;
        String val = (value == null ? "" : value).trim();
        if (val.equals(commentInTag = this.getTagEditorValue(key))) {
            return;
        }
        if (val.isEmpty()) {
            this.pnlTagEditor.getModel().delete(key);
            return;
        }
        TagModel tag = this.pnlTagEditor.getModel().get(key);
        if (tag == null) {
            tag = new TagModel(key, val);
            this.pnlTagEditor.getModel().add(tag);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tag, val);
        }
    }

    protected String getTagEditorValue(String key) {
        TagModel tag = this.pnlTagEditor.getModel().get(key);
        return tag == null ? null : tag.getValue();
    }

    public void initFromTags(Map<String, String> tags) {
        this.pnlTagEditor.getModel().initFromTags(tags);
    }

    public Map<String, String> getTags(boolean keepEmpty) {
        this.forceCommentFieldReload();
        return this.pnlTagEditor.getModel().getTags(keepEmpty);
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(MainApplication.getLayerManager().getEditLayer());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.changesetCommentModel.setComment(this.getTagEditorValue("comment"));
        this.changesetSourceModel.setComment(this.getTagEditorValue("source"));
        this.changesetReviewModel.setReviewRequested("yes".equals(this.getTagEditorValue("review_requested")));
    }

    private void forceCommentFieldReload() {
        this.setProperty("comment", this.changesetCommentModel.getComment());
        this.setProperty("source", this.changesetSourceModel.getComment());
        this.setProperty("review_requested", this.changesetReviewModel.isReviewRequested() ? "yes" : null);
    }

    class ChangesetReviewChangeListener
    implements ChangeListener {
        private static final String KEY = "review_requested";

        ChangesetReviewChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof ChangesetReviewModel) {
                boolean newState = ((ChangesetReviewModel)e.getSource()).isReviewRequested();
                boolean oldState = "yes".equals(Optional.ofNullable(TagSettingsPanel.this.getTagEditorValue(KEY)).orElse(""));
                if (oldState != newState) {
                    TagSettingsPanel.this.setProperty(KEY, newState ? "yes" : null);
                }
            }
        }
    }

    class ChangesetCommentChangeListener
    implements ChangeListener {
        private final String key;
        private final String hashtagsKey;

        ChangesetCommentChangeListener(String key) {
            this(key, null);
        }

        ChangesetCommentChangeListener(String key, String hashtagsKey) {
            this.key = key;
            this.hashtagsKey = hashtagsKey;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof ChangesetCommentModel) {
                ChangesetCommentModel model = (ChangesetCommentModel)e.getSource();
                String newValue = model.getComment();
                String oldValue = Optional.ofNullable(TagSettingsPanel.this.getTagEditorValue(this.key)).orElse("");
                if (!oldValue.equals(newValue)) {
                    TagSettingsPanel.this.setProperty(this.key, newValue);
                    if (this.hashtagsKey != null && Config.getPref().getBoolean("upload.changeset.hashtags", true)) {
                        String newHashTags = String.join((CharSequence)";", model.findHashTags());
                        String oldHashTags = Optional.ofNullable(TagSettingsPanel.this.getTagEditorValue(this.hashtagsKey)).orElse("");
                        if (!oldHashTags.equals(newHashTags)) {
                            TagSettingsPanel.this.setProperty(this.hashtagsKey, newHashTags);
                        }
                    }
                }
            }
        }
    }
}

