/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.NameUtility;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeType;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class AttributeTableModel
extends AbstractTableModel {
    protected boolean dataChanged = false;
    int noRows = 0;
    DXEntry oldEntry;
    Vector attributeTypes = new Vector();
    Vector attributeValues = new Vector();
    int numberNamingValues;
    String[] namingTypes;
    String[] namingRawValues;

    public int getRDNSize() {
        return this.numberNamingValues;
    }

    public Class getColumnClass(int c) {
        Class clazz = c == 1 ? AttributeValue.class : AttributeType.class;
        return clazz;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.noRows;
    }

    public void setValueAt(Object aValue, int row, int col) {
        this.dataChanged = true;
        if (col == 1) {
            if (aValue instanceof AttributeValue) {
                this.attributeValues.set(row, aValue);
            } else {
                ((AttributeValue)this.attributeValues.elementAt(row)).update(aValue);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public String getStringValueAt(int row, int col) {
        String s = this.getValueAt(row, col).toString();
        if (s == null || s.length() == 0) {
            s = " ";
        }
        return s;
    }

    public Object getValueAt(int row, int col) {
        return col == 0 ? this.attributeTypes.elementAt(row) : this.attributeValues.elementAt(row);
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (col > 1) {
            return false;
        }
        return !this.attributeTypes.elementAt(row).toString().equalsIgnoreCase("objectclass");
    }

    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "attribute type" : "value";
    }

    public void reset() {
        this.dataChanged = false;
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            ((AttributeValue)this.attributeValues.elementAt(i)).reset();
        }
        RDN rdn = this.oldEntry.getRDN();
        if (!rdn.equals(this.getRDN())) {
            this.setRDN(rdn);
        }
        this.fireChange();
    }

    public void clear() {
        this.dataChanged = false;
        this.noRows = 0;
        this.attributeTypes.clear();
        this.attributeValues.clear();
        this.fireChange();
    }

    public void insertAttributes(DXEntry entry) {
        if (entry == null) {
            return;
        }
        this.oldEntry = entry;
        this.noRows = 0;
        this.attributeTypes.clear();
        this.attributeValues.clear();
        try {
            RDN rdn = entry.getRDN();
            this.setRDN(rdn);
            DXNamingEnumeration mandatory = (DXNamingEnumeration)entry.getMandatory();
            while (mandatory.hasMore()) {
                this.insertAttribute((DXAttribute)mandatory.next(), 1);
            }
            DXNamingEnumeration active = (DXNamingEnumeration)entry.getAllNonNull();
            active.sort();
            while (active.hasMore()) {
                DXAttribute temp = (DXAttribute)active.next();
                if (mandatory.contains(temp) || temp.size() <= 0 || temp.get() == null) continue;
                temp.sort();
                this.insertAttribute(temp, 0);
            }
            DXNamingEnumeration possible = (DXNamingEnumeration)entry.getAll();
            possible.sort();
            while (possible.hasMore()) {
                DXAttribute temp = (DXAttribute)possible.next();
                if (mandatory.contains(temp) || temp.size() != 0 && temp.get() != null) continue;
                this.insertAttribute(temp, 0);
            }
            this.fireChange();
            this.dataChanged = false;
        }
        catch (NamingException e) {
            System.err.println("Naming Exception in AttributeTableModel: " + e);
        }
        catch (Exception e2) {
            System.err.println("Unexpected Exception in AttributeTableModel: " + e2);
            e2.printStackTrace();
        }
    }

    protected void setRDN(RDN rdn) {
        this.numberNamingValues = rdn.size();
        this.namingTypes = new String[this.numberNamingValues];
        this.namingRawValues = new String[this.numberNamingValues];
        for (int i = 0; i < this.numberNamingValues; ++i) {
            this.namingTypes[i] = rdn.getAtt(i);
            this.namingRawValues[i] = rdn.getRawVal(i);
        }
    }

    public void insertAttribute(DXAttribute att, int type) throws NamingException {
        String namingValue = null;
        String ID2 = att.getID();
        NamingEnumeration<?> values = att.getAll();
        AttributeValue newAV = new AttributeValue(ID2, "");
        if (att.size() == 0) {
            newAV = new AttributeValue(ID2, "");
            if (!att.isString()) {
                newAV.setBinary(true);
            }
            this.addAttribute(ID2, newAV, type);
        } else {
            namingValue = this.getAnyNamingValue(ID2);
            if (namingValue != null && !att.isString()) {
                throw new NamingException("Binary naming attributes not supported in JXplorer: can't use attribute " + ID2 + " to name an entry");
            }
            while (values.hasMore()) {
                newAV = new AttributeValue(ID2, values.next());
                if (!att.isString()) {
                    newAV.setBinary(true);
                }
                if (namingValue != null && newAV.getStringValue().equalsIgnoreCase(namingValue)) {
                    newAV.setNamingStatus(true);
                }
                this.addAttribute(ID2, newAV, type);
            }
        }
        if (att instanceof DXAttribute) {
            if (att.hasOptions()) {
                newAV.setOptions(att.getOptions());
            }
            newAV.setBinary(!att.isString());
        }
    }

    private String getAnyNamingValue(String ID2) {
        for (int i = 0; i < this.numberNamingValues; ++i) {
            if (!ID2.equalsIgnoreCase(this.namingTypes[i])) continue;
            return this.namingRawValues[i];
        }
        return null;
    }

    public void addAttribute(String ID2, AttributeValue val, int type) {
        this.attributeTypes.add(new AttributeType(ID2, type == 1));
        this.attributeValues.add(val);
        ++this.noRows;
    }

    public void addAttribute(String ID2, AttributeValue val, int type, int indexPos) {
        this.attributeTypes.add(indexPos, new AttributeType(ID2, type == 1));
        this.attributeValues.add(indexPos, val);
        ++this.noRows;
    }

    public void deleteAttribute(String ID2, int indexPos) {
        if (this.attributeTypes.elementAt(indexPos).toString().equals(ID2)) {
            ((AttributeValue)this.attributeValues.elementAt(indexPos)).update(new String(""));
        } else {
            System.err.println("Internal error: attempt to delete attribute with invalid ID in AttributeTableModel\n att name = " + this.attributeTypes.elementAt(indexPos).toString() + " ID = " + ID2);
        }
    }

    public void fireChange() {
        this.dataChanged = true;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public DXEntry getOldEntry() {
        return this.oldEntry;
    }

    public RDN getRDN() {
        String rdn = "";
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            AttributeValue entryValue = (AttributeValue)this.attributeValues.get(i);
            if (!entryValue.isNaming()) continue;
            if (rdn.length() > 0) {
                rdn = rdn + "+";
            }
            rdn = rdn + this.attributeTypes.get(i).toString() + "=" + NameUtility.escape(entryValue.getStringValue());
        }
        if ("".equals(rdn)) {
            rdn = this.oldEntry.getRDN().toString();
        }
        return new RDN(rdn);
    }

    public DXEntry getNewEntry() {
        DN newDN = new DN(this.oldEntry.getDN());
        RDN newRDN = this.getRDN();
        newDN.setRDN(newRDN, newDN.size() - 1);
        DXEntry newEntry = new DXEntry(newDN);
        for (int i = 0; i < this.attributeTypes.size(); ++i) {
            AttributeValue test = (AttributeValue)this.attributeValues.elementAt(i);
            if (test.isEmpty()) continue;
            String id = this.attributeTypes.elementAt(i).toString();
            BasicAttribute exists = (BasicAttribute)newEntry.get(id);
            if (exists == null) {
                newEntry.put(new BasicAttribute(id, test.value()));
                continue;
            }
            exists.add(test.value());
        }
        if (this.oldEntry.getStatus() == 1) {
            newEntry.setStatus(1);
        }
        return newEntry;
    }

    public Attribute getAttribute(String ID2) {
        BasicAttribute returnAtt = new BasicAttribute(ID2);
        for (int i = 0; i < this.attributeTypes.size(); ++i) {
            if (!ID2.equals(this.attributeTypes.elementAt(i).toString())) continue;
            Object o = ((AttributeValue)this.attributeValues.elementAt(i)).value();
            if (o != null && o instanceof String && ((String)o).length() == 0) {
                o = null;
            }
            if (o == null) continue;
            returnAtt.add(o);
        }
        return returnAtt;
    }

    public boolean isMandatory(String attributeTypeName) {
        for (int i = 0; i < this.attributeTypes.size(); ++i) {
            if (!((AttributeType)this.attributeTypes.elementAt(i)).toString().equals(attributeTypeName)) continue;
            return ((AttributeType)this.attributeTypes.elementAt(i)).isMandatory();
        }
        System.err.println("unable to find type name " + attributeTypeName);
        return false;
    }

    public boolean checkMandatoryAttributesSet() {
        String ID2 = "";
        boolean inDoubt = false;
        int i = 0;
        while (i < this.noRows) {
            AttributeType type = (AttributeType)this.attributeTypes.elementAt(i);
            if (type.isMandatory()) {
                ID2 = type.toString();
                inDoubt = true;
                AttributeType testType = type;
                while (ID2.equals(testType.toString()) && i < this.noRows) {
                    AttributeValue value;
                    if (inDoubt && !(value = (AttributeValue)this.attributeValues.elementAt(i)).isEmpty()) {
                        inDoubt = false;
                    }
                    if (++i >= this.noRows) continue;
                    testType = (AttributeType)this.attributeTypes.elementAt(i);
                }
                if (!inDoubt) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeNamingComponent(AttributeType currentType, AttributeValue currentValue) {
        try {
            int i;
            String type = currentType.getValue();
            String value = currentValue.getStringValue();
            if ("".equals(type) || "".equals(value)) {
                return;
            }
            if (this.numberNamingValues == 1) {
                return;
            }
            this.dataChanged = true;
            for (i = 0; i < this.numberNamingValues; ++i) {
                if (!type.equals(this.namingTypes[i]) || !value.equals(this.namingRawValues[i])) continue;
                int removeRow = i;
                this.namingTypes = AttributeTableModel.removeRowFromArray(this.namingTypes, removeRow);
                this.namingRawValues = AttributeTableModel.removeRowFromArray(this.namingRawValues, removeRow);
                --this.numberNamingValues;
                break;
            }
            for (i = 0; i < this.attributeValues.size(); ++i) {
                AttributeValue attval = (AttributeValue)this.attributeValues.get(i);
                if (!attval.getID().equals(type) || !attval.getStringValue().equals(value)) continue;
                attval.setNamingStatus(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected static String[] removeRowFromArray(String[] array, int removeRow) {
        int originalLength = array.length;
        if (removeRow < 0 || removeRow >= originalLength) {
            return array;
        }
        String[] temp = new String[array.length - 1];
        if (removeRow > 0) {
            System.arraycopy(array, 0, temp, 0, removeRow);
        }
        if (removeRow < originalLength - 1) {
            System.arraycopy(array, removeRow + 1, temp, removeRow, originalLength - removeRow - 1);
        }
        return temp;
    }

    public void dumpNamingArrays() {
        System.out.println("dump naming array");
        for (int i = 0; i < this.numberNamingValues; ++i) {
            System.out.println(i + " type        " + this.namingTypes[i]);
            System.out.println(i + " value       " + this.namingRawValues[i]);
        }
    }

    public void addNamingComponent(AttributeType currentType, AttributeValue currentValue) {
        String type = currentType.getValue();
        String value = currentValue.getStringValue();
        if ("".equals(type) || "".equals(value)) {
            return;
        }
        this.dataChanged = true;
        String[] tempTypes = new String[this.numberNamingValues + 1];
        String[] tempRawValues = new String[this.numberNamingValues + 1];
        System.arraycopy(this.namingTypes, 0, tempTypes, 0, this.numberNamingValues);
        System.arraycopy(this.namingRawValues, 0, tempRawValues, 0, this.numberNamingValues);
        tempTypes[this.numberNamingValues] = type;
        tempRawValues[this.numberNamingValues] = value;
        ++this.numberNamingValues;
        this.namingTypes = tempTypes;
        this.namingRawValues = tempRawValues;
        currentValue.setNamingStatus(true);
    }

    public boolean changedByUser() {
        return this.dataChanged;
    }
}

