/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.docker.DockerEndpoint;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.utils.ProfileHelper;

public class DockerV2LoginProtocolService {
    private final EventBuilder event;
    private final KeycloakSession session;

    public DockerV2LoginProtocolService(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
    }

    public static UriBuilder authProtocolBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return DockerV2LoginProtocolService.authProtocolBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authProtocolBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/docker-v2");
    }

    public static UriBuilder authUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return DockerV2LoginProtocolService.authUrl(baseUriBuilder);
    }

    public static UriBuilder authUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = DockerV2LoginProtocolService.authProtocolBaseUrl(baseUriBuilder);
        return uriBuilder.path(DockerV2LoginProtocolService.class, "auth");
    }

    @Path(value="auth")
    public Object auth() {
        ProfileHelper.requireFeature(Profile.Feature.DOCKER);
        return new DockerEndpoint(this.session, this.event, EventType.LOGIN);
    }
}

