/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter.cfg;

import org.jboss.byteman.agent.adapter.cfg.BBlock;

public class CodeLocation
implements Comparable<CodeLocation> {
    private BBlock block;
    private int instructionIdx;

    public CodeLocation(BBlock block, int instructionIdx) {
        this.block = block;
        this.instructionIdx = instructionIdx;
    }

    public BBlock getBlock() {
        return this.block;
    }

    public int getBlockIdx() {
        return this.block.getBlockIdx();
    }

    public int getInstructionIdx() {
        return this.instructionIdx;
    }

    public String toString() {
        return "BB" + this.getBlockIdx() + "." + this.getInstructionIdx();
    }

    @Override
    public int compareTo(CodeLocation loc) {
        int otherBlockIdx;
        int blockIdx = this.getBlockIdx();
        if (blockIdx < (otherBlockIdx = loc.getBlockIdx())) {
            return -1;
        }
        if (blockIdx > otherBlockIdx) {
            return 1;
        }
        if (this.instructionIdx < loc.instructionIdx) {
            return -1;
        }
        if (this.instructionIdx > loc.instructionIdx) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof CodeLocation) {
            return this.compareTo((CodeLocation)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.block.getBlockIdx() << 16 ^ this.instructionIdx;
    }
}

