/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.CuratorConnectionLossException;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetACLBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetConfigBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.ReconfigBuilder;
import org.apache.curator.framework.api.RemoveWatchesBuilder;
import org.apache.curator.framework.api.SetACLBuilder;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.SyncBuilder;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.imps.BackgroundSyncImpl;
import org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.imps.CuratorMultiTransactionImpl;
import org.apache.curator.framework.imps.CuratorTransactionImpl;
import org.apache.curator.framework.imps.DeleteBuilderImpl;
import org.apache.curator.framework.imps.EnsembleTracker;
import org.apache.curator.framework.imps.ExistsBuilderImpl;
import org.apache.curator.framework.imps.FailedDeleteManager;
import org.apache.curator.framework.imps.FailedRemoveWatchManager;
import org.apache.curator.framework.imps.GetACLBuilderImpl;
import org.apache.curator.framework.imps.GetChildrenBuilderImpl;
import org.apache.curator.framework.imps.GetConfigBuilderImpl;
import org.apache.curator.framework.imps.GetDataBuilderImpl;
import org.apache.curator.framework.imps.InternalConnectionHandler;
import org.apache.curator.framework.imps.NamespaceFacadeCache;
import org.apache.curator.framework.imps.NamespaceImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.ReconfigBuilderImpl;
import org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import org.apache.curator.framework.imps.SetACLBuilderImpl;
import org.apache.curator.framework.imps.SetDataBuilderImpl;
import org.apache.curator.framework.imps.StandardInternalConnectionHandler;
import org.apache.curator.framework.imps.SyncBuilderImpl;
import org.apache.curator.framework.imps.TransactionOpImpl;
import org.apache.curator.framework.imps.WatcherRemovalFacade;
import org.apache.curator.framework.imps.WatcherRemovalManager;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.schema.SchemaSet;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.framework.state.ConnectionStateManager;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorFrameworkImpl
implements CuratorFramework {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorZookeeperClient client;
    private final ListenerContainer<CuratorListener> listeners;
    private final ListenerContainer<UnhandledErrorListener> unhandledErrorListeners;
    private final ThreadFactory threadFactory;
    private final int maxCloseWaitMs;
    private final BlockingQueue<OperationAndData<?>> backgroundOperations;
    private final BlockingQueue<OperationAndData<?>> forcedSleepOperations;
    private final NamespaceImpl namespace;
    private final ConnectionStateManager connectionStateManager;
    private final List<AuthInfo> authInfos;
    private final byte[] defaultData;
    private final FailedDeleteManager failedDeleteManager;
    private final FailedRemoveWatchManager failedRemoveWatcherManager;
    private final CompressionProvider compressionProvider;
    private final ACLProvider aclProvider;
    private final NamespaceFacadeCache namespaceFacadeCache;
    private final boolean useContainerParentsIfAvailable;
    private final ConnectionStateErrorPolicy connectionStateErrorPolicy;
    private final AtomicLong currentInstanceIndex = new AtomicLong(-1L);
    private final InternalConnectionHandler internalConnectionHandler;
    private final EnsembleTracker ensembleTracker;
    private final SchemaSet schemaSet;
    private final boolean zk34CompatibilityMode;
    private final Executor runSafeService;
    private volatile ExecutorService executorService;
    private final AtomicBoolean logAsErrorConnectionErrors = new AtomicBoolean(false);
    private static final boolean LOG_ALL_CONNECTION_ISSUES_AS_ERROR_LEVEL = !Boolean.getBoolean("curator-log-only-first-connection-issue-as-error-level");
    volatile DebugBackgroundListener debugListener = null;
    @VisibleForTesting
    public volatile UnhandledErrorListener debugUnhandledErrorListener = null;
    private final AtomicReference<CuratorFrameworkState> state;
    @VisibleForTesting
    volatile long sleepAndQueueOperationSeconds = 1L;

    public CuratorFrameworkImpl(CuratorFrameworkFactory.Builder builder) {
        ZookeeperFactory localZookeeperFactory = this.makeZookeeperFactory(builder.getZookeeperFactory());
        this.client = new CuratorZookeeperClient(localZookeeperFactory, builder.getEnsembleProvider(), builder.getSessionTimeoutMs(), builder.getConnectionTimeoutMs(), builder.getWaitForShutdownTimeoutMs(), new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                CuratorEventImpl event = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.WATCHED, watchedEvent.getState().getIntValue(), CuratorFrameworkImpl.this.unfixForNamespace(watchedEvent.getPath()), null, null, null, null, null, watchedEvent, null, null);
                CuratorFrameworkImpl.this.processEvent(event);
            }
        }, builder.getRetryPolicy(), builder.canBeReadOnly(), builder.getConnectionHandlingPolicy());
        this.internalConnectionHandler = new StandardInternalConnectionHandler();
        this.listeners = new ListenerContainer();
        this.unhandledErrorListeners = new ListenerContainer();
        this.backgroundOperations = new DelayQueue();
        this.forcedSleepOperations = new LinkedBlockingQueue();
        this.namespace = new NamespaceImpl(this, builder.getNamespace());
        this.threadFactory = this.getThreadFactory(builder);
        this.maxCloseWaitMs = builder.getMaxCloseWaitMs();
        this.connectionStateManager = new ConnectionStateManager(this, builder.getThreadFactory(), builder.getSessionTimeoutMs(), builder.getConnectionHandlingPolicy().getSimulatedSessionExpirationPercent(), builder.getConnectionStateListenerManagerFactory());
        this.compressionProvider = builder.getCompressionProvider();
        this.aclProvider = builder.getAclProvider();
        this.state = new AtomicReference<CuratorFrameworkState>(CuratorFrameworkState.LATENT);
        this.useContainerParentsIfAvailable = builder.useContainerParentsIfAvailable();
        this.connectionStateErrorPolicy = (ConnectionStateErrorPolicy)Preconditions.checkNotNull((Object)builder.getConnectionStateErrorPolicy(), (Object)"errorPolicy cannot be null");
        this.schemaSet = (SchemaSet)Preconditions.checkNotNull((Object)builder.getSchemaSet(), (Object)"schemaSet cannot be null");
        this.zk34CompatibilityMode = builder.isZk34CompatibilityMode();
        byte[] builderDefaultData = builder.getDefaultData();
        this.defaultData = builderDefaultData != null ? Arrays.copyOf(builderDefaultData, builderDefaultData.length) : new byte[]{};
        this.authInfos = this.buildAuths(builder);
        this.failedDeleteManager = new FailedDeleteManager(this);
        this.failedRemoveWatcherManager = new FailedRemoveWatchManager(this);
        this.namespaceFacadeCache = new NamespaceFacadeCache(this);
        this.ensembleTracker = this.zk34CompatibilityMode ? null : new EnsembleTracker(this, builder.getEnsembleProvider());
        this.runSafeService = this.makeRunSafeService(builder);
    }

    private Executor makeRunSafeService(CuratorFrameworkFactory.Builder builder) {
        if (builder.getRunSafeService() != null) {
            return builder.getRunSafeService();
        }
        ThreadFactory threadFactory = builder.getThreadFactory();
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory((String)"SafeNotifyService");
        }
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    private List<AuthInfo> buildAuths(CuratorFrameworkFactory.Builder builder) {
        ImmutableList.Builder builder1 = ImmutableList.builder();
        if (builder.getAuthInfos() != null) {
            builder1.addAll(builder.getAuthInfos());
        }
        return builder1.build();
    }

    @Override
    public CompletableFuture<Void> runSafe(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.runSafeService);
    }

    @Override
    public WatcherRemoveCuratorFramework newWatcherRemoveCuratorFramework() {
        return new WatcherRemovalFacade(this);
    }

    @Override
    public QuorumVerifier getCurrentConfig() {
        return this.ensembleTracker != null ? this.ensembleTracker.getCurrentConfig() : null;
    }

    private ZookeeperFactory makeZookeeperFactory(final ZookeeperFactory actualZookeeperFactory) {
        return new ZookeeperFactory(){

            public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
                ZooKeeper zooKeeper = actualZookeeperFactory.newZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly);
                for (AuthInfo auth : CuratorFrameworkImpl.this.authInfos) {
                    zooKeeper.addAuthInfo(auth.getScheme(), auth.getAuth());
                }
                return zooKeeper;
            }
        };
    }

    private ThreadFactory getThreadFactory(CuratorFrameworkFactory.Builder builder) {
        ThreadFactory threadFactory = builder.getThreadFactory();
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory((String)"Framework");
        }
        return threadFactory;
    }

    protected CuratorFrameworkImpl(CuratorFrameworkImpl parent) {
        this.client = parent.client;
        this.listeners = parent.listeners;
        this.unhandledErrorListeners = parent.unhandledErrorListeners;
        this.threadFactory = parent.threadFactory;
        this.maxCloseWaitMs = parent.maxCloseWaitMs;
        this.backgroundOperations = parent.backgroundOperations;
        this.forcedSleepOperations = parent.forcedSleepOperations;
        this.connectionStateManager = parent.connectionStateManager;
        this.defaultData = parent.defaultData;
        this.failedDeleteManager = parent.failedDeleteManager;
        this.failedRemoveWatcherManager = parent.failedRemoveWatcherManager;
        this.compressionProvider = parent.compressionProvider;
        this.aclProvider = parent.aclProvider;
        this.namespaceFacadeCache = parent.namespaceFacadeCache;
        this.namespace = new NamespaceImpl(this, null);
        this.state = parent.state;
        this.authInfos = parent.authInfos;
        this.useContainerParentsIfAvailable = parent.useContainerParentsIfAvailable;
        this.connectionStateErrorPolicy = parent.connectionStateErrorPolicy;
        this.internalConnectionHandler = parent.internalConnectionHandler;
        this.schemaSet = parent.schemaSet;
        this.zk34CompatibilityMode = parent.zk34CompatibilityMode;
        this.ensembleTracker = null;
        this.runSafeService = parent.runSafeService;
    }

    @Override
    public void createContainers(String path) throws Exception {
        this.checkExists().creatingParentContainersIfNeeded().forPath(ZKPaths.makePath((String)path, (String)"foo"));
    }

    @Override
    public void clearWatcherReferences(Watcher watcher) {
    }

    @Override
    public CuratorFrameworkState getState() {
        return this.state.get();
    }

    @Override
    @Deprecated
    public boolean isStarted() {
        return this.state.get() == CuratorFrameworkState.STARTED;
    }

    @Override
    public boolean blockUntilConnected(int maxWaitTime, TimeUnit units) throws InterruptedException {
        return this.connectionStateManager.blockUntilConnected(maxWaitTime, units);
    }

    @Override
    public void blockUntilConnected() throws InterruptedException {
        this.blockUntilConnected(0, null);
    }

    @Override
    public ConnectionStateErrorPolicy getConnectionStateErrorPolicy() {
        return this.connectionStateErrorPolicy;
    }

    @Override
    public void start() {
        this.log.info("Starting");
        if (!this.state.compareAndSet(CuratorFrameworkState.LATENT, CuratorFrameworkState.STARTED)) {
            throw new IllegalStateException("Cannot be started more than once");
        }
        try {
            this.connectionStateManager.start();
            ConnectionStateListener listener = new ConnectionStateListener(){

                @Override
                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                    if (ConnectionState.CONNECTED == newState || ConnectionState.RECONNECTED == newState) {
                        CuratorFrameworkImpl.this.logAsErrorConnectionErrors.set(true);
                    }
                }

                @Override
                public boolean doNotProxy() {
                    return true;
                }
            };
            this.getConnectionStateListenable().addListener(listener);
            this.client.start();
            this.executorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CuratorFrameworkImpl.this.backgroundOperationsLoop();
                    return null;
                }
            });
            if (this.ensembleTracker != null) {
                this.ensembleTracker.start();
            }
            this.log.info(this.schemaSet.toDocumentation());
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            this.handleBackgroundOperationException(null, e);
        }
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        if (this.state.compareAndSet(CuratorFrameworkState.STARTED, CuratorFrameworkState.STOPPED)) {
            this.listeners.forEach(new Function<CuratorListener, Void>(){

                public Void apply(CuratorListener listener) {
                    CuratorEventImpl event = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.CLOSING, 0, null, null, null, null, null, null, null, null, null);
                    try {
                        listener.eventReceived(CuratorFrameworkImpl.this, event);
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted((Throwable)e);
                        CuratorFrameworkImpl.this.log.error("Exception while sending Closing event", (Throwable)e);
                    }
                    return null;
                }
            });
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(this.maxCloseWaitMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.ensembleTracker != null) {
                this.ensembleTracker.close();
            }
            this.listeners.clear();
            this.unhandledErrorListeners.clear();
            this.connectionStateManager.close();
            this.client.close();
        }
    }

    @Override
    @Deprecated
    public CuratorFramework nonNamespaceView() {
        return this.usingNamespace(null);
    }

    @Override
    public String getNamespace() {
        String str = this.namespace.getNamespace();
        return str != null ? str : "";
    }

    private void checkState() {
        CuratorFrameworkState state = this.getState();
        Preconditions.checkState((state == CuratorFrameworkState.STARTED ? 1 : 0) != 0, (String)"Expected state [%s] was [%s]", (Object)((Object)CuratorFrameworkState.STARTED), (Object)((Object)state));
    }

    @Override
    public CuratorFramework usingNamespace(String newNamespace) {
        this.checkState();
        return this.namespaceFacadeCache.get(newNamespace);
    }

    @Override
    public CreateBuilder create() {
        this.checkState();
        return new CreateBuilderImpl(this);
    }

    @Override
    public DeleteBuilder delete() {
        this.checkState();
        return new DeleteBuilderImpl(this);
    }

    @Override
    public ExistsBuilder checkExists() {
        this.checkState();
        return new ExistsBuilderImpl(this);
    }

    @Override
    public GetDataBuilder getData() {
        this.checkState();
        return new GetDataBuilderImpl(this);
    }

    @Override
    public SetDataBuilder setData() {
        this.checkState();
        return new SetDataBuilderImpl(this);
    }

    @Override
    public GetChildrenBuilder getChildren() {
        this.checkState();
        return new GetChildrenBuilderImpl(this);
    }

    @Override
    public GetACLBuilder getACL() {
        this.checkState();
        return new GetACLBuilderImpl(this);
    }

    @Override
    public SetACLBuilder setACL() {
        this.checkState();
        return new SetACLBuilderImpl(this);
    }

    @Override
    public ReconfigBuilder reconfig() {
        Preconditions.checkState((!this.isZk34CompatibilityMode() ? 1 : 0) != 0, (Object)"reconfig/config APIs are not support when running in ZooKeeper 3.4 compatibility mode");
        return new ReconfigBuilderImpl(this);
    }

    @Override
    public GetConfigBuilder getConfig() {
        Preconditions.checkState((!this.isZk34CompatibilityMode() ? 1 : 0) != 0, (Object)"reconfig/config APIs are not support when running in ZooKeeper 3.4 compatibility mode");
        return new GetConfigBuilderImpl(this);
    }

    @Override
    public CuratorTransaction inTransaction() {
        this.checkState();
        return new CuratorTransactionImpl(this);
    }

    @Override
    public CuratorMultiTransaction transaction() {
        this.checkState();
        return new CuratorMultiTransactionImpl(this);
    }

    @Override
    public TransactionOp transactionOp() {
        this.checkState();
        return new TransactionOpImpl(this);
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.connectionStateManager.getListenable();
    }

    @Override
    public Listenable<CuratorListener> getCuratorListenable() {
        return this.listeners;
    }

    @Override
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.unhandledErrorListeners;
    }

    @Override
    public void sync(String path, Object context) {
        this.checkState();
        path = this.fixForNamespace(path);
        this.internalSync(this, path, context);
    }

    @Override
    public SyncBuilder sync() {
        return new SyncBuilderImpl(this);
    }

    @Override
    public RemoveWatchesBuilder watches() {
        Preconditions.checkState((!this.isZk34CompatibilityMode() ? 1 : 0) != 0, (Object)"Remove watches APIs are not support when running in ZooKeeper 3.4 compatibility mode");
        return new RemoveWatchesBuilderImpl(this);
    }

    protected void internalSync(CuratorFrameworkImpl impl, String path, Object context) {
        BackgroundSyncImpl operation = new BackgroundSyncImpl(impl, context);
        this.performBackgroundOperation(new OperationAndData<String>(operation, path, null, null, context, null));
    }

    @Override
    public CuratorZookeeperClient getZookeeperClient() {
        return this.client;
    }

    @Override
    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        return this.namespace.newNamespaceAwareEnsurePath(path);
    }

    @Override
    public SchemaSet getSchemaSet() {
        return this.schemaSet;
    }

    ACLProvider getAclProvider() {
        return this.aclProvider;
    }

    FailedDeleteManager getFailedDeleteManager() {
        return this.failedDeleteManager;
    }

    FailedRemoveWatchManager getFailedRemoveWatcherManager() {
        return this.failedRemoveWatcherManager;
    }

    RetryLoop newRetryLoop() {
        return this.client.newRetryLoop();
    }

    ZooKeeper getZooKeeper() throws Exception {
        return this.client.getZooKeeper();
    }

    CompressionProvider getCompressionProvider() {
        return this.compressionProvider;
    }

    boolean useContainerParentsIfAvailable() {
        return this.useContainerParentsIfAvailable;
    }

    <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        boolean isInitialExecution;
        boolean bl = isInitialExecution = event == null;
        if (isInitialExecution) {
            this.performBackgroundOperation(operationAndData);
            return;
        }
        boolean doQueueOperation = false;
        if (RetryLoop.shouldRetry((int)event.getResultCode())) {
            doQueueOperation = this.checkBackgroundRetry(operationAndData, event);
        } else if (operationAndData.getCallback() != null) {
            this.sendToBackgroundCallback(operationAndData, event);
        } else {
            this.processEvent(event);
        }
        if (doQueueOperation) {
            this.queueOperation(operationAndData);
        }
    }

    <DATA_TYPE> boolean queueOperation(OperationAndData<DATA_TYPE> operationAndData) {
        if (this.getState() == CuratorFrameworkState.STARTED) {
            this.backgroundOperations.offer(operationAndData);
            return true;
        }
        return false;
    }

    void logError(String reason, final Throwable e) {
        if (reason == null || reason.length() == 0) {
            reason = "n/a";
        }
        if (!Boolean.getBoolean("curator-dont-log-connection-problems") || !(e instanceof KeeperException)) {
            if (e instanceof KeeperException.ConnectionLossException) {
                if (LOG_ALL_CONNECTION_ISSUES_AS_ERROR_LEVEL || this.logAsErrorConnectionErrors.compareAndSet(true, false)) {
                    this.log.error(reason, e);
                } else {
                    this.log.debug(reason, e);
                }
            } else {
                this.log.error(reason, e);
            }
        }
        final String localReason = reason;
        this.unhandledErrorListeners.forEach(new Function<UnhandledErrorListener, Void>(){

            public Void apply(UnhandledErrorListener listener) {
                listener.unhandledError(localReason, e);
                return null;
            }
        });
        if (this.debugUnhandledErrorListener != null) {
            this.debugUnhandledErrorListener.unhandledError(reason, e);
        }
    }

    String unfixForNamespace(String path) {
        return this.namespace.unfixForNamespace(path);
    }

    String fixForNamespace(String path) {
        return this.namespace.fixForNamespace(path, false);
    }

    String fixForNamespace(String path, boolean isSequential) {
        return this.namespace.fixForNamespace(path, isSequential);
    }

    byte[] getDefaultData() {
        return this.defaultData;
    }

    NamespaceFacadeCache getNamespaceFacadeCache() {
        return this.namespaceFacadeCache;
    }

    void validateConnection(Watcher.Event.KeeperState state) {
        if (state == Watcher.Event.KeeperState.Disconnected) {
            this.internalConnectionHandler.suspendConnection(this);
        } else if (state == Watcher.Event.KeeperState.Expired) {
            this.connectionStateManager.addStateChange(ConnectionState.LOST);
        } else if (state == Watcher.Event.KeeperState.SyncConnected) {
            this.internalConnectionHandler.checkNewConnection(this);
            this.connectionStateManager.addStateChange(ConnectionState.RECONNECTED);
            this.unSleepBackgroundOperations();
        } else if (state == Watcher.Event.KeeperState.ConnectedReadOnly) {
            this.internalConnectionHandler.checkNewConnection(this);
            this.connectionStateManager.addStateChange(ConnectionState.READ_ONLY);
        }
    }

    void checkInstanceIndex() {
        long instanceIndex = this.client.getInstanceIndex();
        long newInstanceIndex = this.currentInstanceIndex.getAndSet(instanceIndex);
        if (newInstanceIndex >= 0L && instanceIndex != newInstanceIndex) {
            this.connectionStateManager.addStateChange(ConnectionState.LOST);
        }
    }

    Watcher.Event.KeeperState codeToState(KeeperException.Code code) {
        switch (code) {
            case AUTHFAILED: 
            case NOAUTH: {
                return Watcher.Event.KeeperState.AuthFailed;
            }
            case CONNECTIONLOSS: 
            case OPERATIONTIMEOUT: {
                return Watcher.Event.KeeperState.Disconnected;
            }
            case SESSIONEXPIRED: {
                return Watcher.Event.KeeperState.Expired;
            }
            case OK: 
            case SESSIONMOVED: {
                return Watcher.Event.KeeperState.SyncConnected;
            }
        }
        return Watcher.Event.KeeperState.fromInt((int)-1);
    }

    WatcherRemovalManager getWatcherRemovalManager() {
        return null;
    }

    boolean setToSuspended() {
        return this.connectionStateManager.setToSuspended();
    }

    void addStateChange(ConnectionState newConnectionState) {
        this.connectionStateManager.addStateChange(newConnectionState);
    }

    @Override
    public boolean isZk34CompatibilityMode() {
        return this.zk34CompatibilityMode;
    }

    EnsembleTracker getEnsembleTracker() {
        return this.ensembleTracker;
    }

    private <DATA_TYPE> boolean checkBackgroundRetry(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        boolean doRetry = false;
        if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs(), operationAndData)) {
            doRetry = true;
        } else {
            if (operationAndData.getErrorCallback() != null) {
                operationAndData.getErrorCallback().retriesExhausted(operationAndData);
            }
            if (operationAndData.getCallback() != null) {
                this.sendToBackgroundCallback(operationAndData, event);
            }
            KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
            Throwable e = null;
            try {
                e = code != null ? KeeperException.create((KeeperException.Code)code) : null;
            }
            catch (Throwable t) {
                ThreadUtils.checkInterrupted((Throwable)t);
            }
            if (e == null) {
                e = new Exception("Unknown result codegetResultCode()");
            }
            this.validateConnection(this.codeToState(code));
            this.logError("Background operation retry gave up", e);
        }
        return doRetry;
    }

    private <DATA_TYPE> void sendToBackgroundCallback(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        try {
            operationAndData.getCallback().processResult(this, event);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            this.handleBackgroundOperationException(operationAndData, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <DATA_TYPE> void handleBackgroundOperationException(OperationAndData<DATA_TYPE> operationAndData, Throwable e) {
        if (operationAndData != null && RetryLoop.isRetryException((Throwable)e)) {
            if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                this.log.debug("Retry-able exception received", e);
            }
            if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs(), operationAndData)) {
                if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                    this.log.debug("Retrying operation");
                }
                this.backgroundOperations.offer(operationAndData);
                return;
            }
            if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                this.log.debug("Retry policy did not allow retry");
            }
            if (operationAndData.getErrorCallback() != null) {
                operationAndData.getErrorCallback().retriesExhausted(operationAndData);
            }
        }
        this.logError("Background exception was not retry-able or retry gave up", e);
    }

    private void backgroundOperationsLoop() {
        try {
            while (this.state.get() == CuratorFrameworkState.STARTED) {
                try {
                    OperationAndData<?> operationAndData = this.backgroundOperations.take();
                    if (this.debugListener != null) {
                        this.debugListener.listen(operationAndData);
                    }
                    this.performBackgroundOperation(operationAndData);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.log.info("backgroundOperationsLoop exiting");
        }
    }

    void performBackgroundOperation(OperationAndData<?> operationAndData) {
        try {
            if (!operationAndData.isConnectionRequired() || this.client.isConnected()) {
                operationAndData.callPerformBackgroundOperation();
            } else {
                this.client.getZooKeeper();
                if (operationAndData.getElapsedTimeMs() >= (long)this.client.getConnectionTimeoutMs()) {
                    throw new CuratorConnectionLossException();
                }
                this.sleepAndQueueOperation(operationAndData);
            }
        }
        catch (Throwable e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            if (e instanceof CuratorConnectionLossException) {
                WatchedEvent watchedEvent = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null);
                CuratorEventImpl event = new CuratorEventImpl(this, CuratorEventType.WATCHED, KeeperException.Code.CONNECTIONLOSS.intValue(), null, null, operationAndData.getContext(), null, null, null, watchedEvent, null, null);
                if (this.checkBackgroundRetry(operationAndData, event)) {
                    this.queueOperation(operationAndData);
                } else {
                    this.logError("Background retry gave up", e);
                }
            }
            this.handleBackgroundOperationException(operationAndData, e);
        }
    }

    private void sleepAndQueueOperation(OperationAndData<?> operationAndData) throws InterruptedException {
        operationAndData.sleepFor(this.sleepAndQueueOperationSeconds, TimeUnit.SECONDS);
        if (this.queueOperation(operationAndData)) {
            this.forcedSleepOperations.add(operationAndData);
        }
    }

    private void unSleepBackgroundOperations() {
        ArrayList drain = new ArrayList(this.forcedSleepOperations.size());
        this.forcedSleepOperations.drainTo(drain);
        this.log.debug("Clearing sleep for {} operations", (Object)drain.size());
        for (OperationAndData operation : drain) {
            operation.clearSleep();
            if (!this.backgroundOperations.remove(operation)) continue;
            this.backgroundOperations.offer(operation);
        }
    }

    private void processEvent(final CuratorEvent curatorEvent) {
        if (curatorEvent.getType() == CuratorEventType.WATCHED) {
            this.validateConnection(curatorEvent.getWatchedEvent().getState());
        }
        this.listeners.forEach(new Function<CuratorListener, Void>(){

            public Void apply(CuratorListener listener) {
                try {
                    OperationTrace trace = CuratorFrameworkImpl.this.client.startAdvancedTracer("EventListener");
                    listener.eventReceived(CuratorFrameworkImpl.this, curatorEvent);
                    trace.commit();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted((Throwable)e);
                    CuratorFrameworkImpl.this.logError("Event listener threw exception", e);
                }
                return null;
            }
        });
    }

    static interface DebugBackgroundListener {
        public void listen(OperationAndData<?> var1);
    }
}

