/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.servlet.QueryRateLimiter;
import org.apache.solr.servlet.RequestRateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitManager
implements ClusterPropertiesListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_CONCURRENT_REQUESTS = Runtime.getRuntime().availableProcessors() * 3;
    public static final long DEFAULT_SLOT_ACQUISITION_TIMEOUT_MS = -1L;
    private final Map<String, RequestRateLimiter> requestRateLimiterMap = new HashMap<String, RequestRateLimiter>();
    private final Map<HttpServletRequest, RequestRateLimiter.SlotMetadata> activeRequestsMap = new ConcurrentHashMap<HttpServletRequest, RequestRateLimiter.SlotMetadata>();

    public boolean onChange(Map<String, Object> properties) {
        QueryRateLimiter queryRateLimiter = (QueryRateLimiter)this.getRequestRateLimiter(SolrRequest.SolrRequestType.QUERY);
        if (queryRateLimiter != null) {
            try {
                queryRateLimiter.processConfigChange(properties);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return false;
    }

    public boolean handleRequest(HttpServletRequest request) throws InterruptedException {
        String requestContext = request.getHeader("Solr-Request-Context");
        String typeOfRequest = request.getHeader("Solr-Request-Type");
        if (typeOfRequest == null) {
            return true;
        }
        if (requestContext != null && requestContext.equals(SolrRequest.SolrClientContext.SERVER.toString())) {
            return true;
        }
        RequestRateLimiter requestRateLimiter = this.requestRateLimiterMap.get(typeOfRequest);
        if (requestRateLimiter == null) {
            return true;
        }
        RequestRateLimiter.SlotMetadata result = requestRateLimiter.handleRequest();
        if (result != null) {
            if (result.isReleasable()) {
                this.activeRequestsMap.put(request, result);
            }
            return true;
        }
        RequestRateLimiter.SlotMetadata slotMetadata = this.trySlotBorrowing(typeOfRequest);
        if (slotMetadata != null) {
            this.activeRequestsMap.put(request, slotMetadata);
            return true;
        }
        return false;
    }

    private RequestRateLimiter.SlotMetadata trySlotBorrowing(String requestType) {
        for (Map.Entry<String, RequestRateLimiter> currentEntry : this.requestRateLimiterMap.entrySet()) {
            RequestRateLimiter.SlotMetadata result = null;
            RequestRateLimiter requestRateLimiter = currentEntry.getValue();
            if (requestRateLimiter.getRateLimiterConfig().requestType.toString().equals(requestType) || !requestRateLimiter.getRateLimiterConfig().isSlotBorrowingEnabled) continue;
            if (log.isWarnEnabled()) {
                String msg = "WARN: Experimental feature slots borrowing is enabled for request rate limiter type " + requestRateLimiter.getRateLimiterConfig().requestType.toString();
                log.warn(msg);
            }
            try {
                result = requestRateLimiter.allowSlotBorrowing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (result == null) {
                throw new IllegalStateException("Returned metadata object is null");
            }
            if (!result.isReleasable()) continue;
            return result;
        }
        return null;
    }

    public void decrementActiveRequests(HttpServletRequest request) {
        RequestRateLimiter.SlotMetadata slotMetadata = this.activeRequestsMap.get(request);
        if (slotMetadata != null) {
            this.activeRequestsMap.remove(request);
            slotMetadata.decrementRequest();
        }
    }

    public void registerRequestRateLimiter(RequestRateLimiter requestRateLimiter, SolrRequest.SolrRequestType requestType) {
        this.requestRateLimiterMap.put(requestType.toString(), requestRateLimiter);
    }

    public RequestRateLimiter getRequestRateLimiter(SolrRequest.SolrRequestType requestType) {
        return this.requestRateLimiterMap.get(requestType.toString());
    }

    public static class Builder {
        protected SolrZkClient solrZkClient;

        public Builder(SolrZkClient solrZkClient) {
            this.solrZkClient = solrZkClient;
        }

        public RateLimitManager build() {
            RateLimitManager rateLimitManager = new RateLimitManager();
            rateLimitManager.registerRequestRateLimiter(new QueryRateLimiter(this.solrZkClient), SolrRequest.SolrRequestType.QUERY);
            return rateLimitManager;
        }
    }
}

