/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of the world by country focused on the European Union area
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://commons.wikimedia.org/wiki/File:BlankMap-World6-Equirectangular.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				european_union : {
					width : 755.125,
					height : 530.81061,
					getCoords : function (lat, lon) {
								var xfactor = 10.2159;
								var xoffset = 258.4616;
								var yfactor = -13.5189;
								var yoffset = 976.7300;
								var x = (lon * xfactor) + xoffset;
								var y = (lat * yfactor) + yoffset;
								
						return {x : x, y : y};
					},
					elems : {
						"AZ" : "m 734.03,410.78 c -0.12,-0.01 -0.26,0.01 -0.38,0.03 -0.27,0.05 -0.56,0.14 -0.81,0.34 -0.15,0.12 -2.44,2.31 -2.44,2.31 -0.15,0.84 1.25,2.32 1.63,3 0.6,1.08 5.88,3.4 2.44,4.94 -1.84,0.82 -2.22,-0.26 -3.66,-0.72 -1.84,-0.58 -3.36,0.41 -4.84,-1.22 -2.34,-2.57 -4.4,-3.05 -7.56,-0.38 -0.03,0.84 3.22,3.08 0.53,2.47 1.7,1.59 4.71,1.59 5.25,4.41 -4.22,1.36 0.04,5.4 1.63,6.34 0.96,0.56 2.86,1.09 2.03,2.84 -0.83,1.75 -2.46,1 -3.78,1.56 2.68,1.17 4.24,5.14 7.28,5.31 0.68,0.05 1.42,0.39 1.91,0.88 0.59,0.63 -0.46,0.93 -0.69,1.41 -0.55,1.1 1.62,2.17 2.03,2.81 -1.86,0.24 -1.36,3.89 -0.81,4.78 0.63,-0.91 2.17,-3.08 3.13,-3.53 0.52,-0.26 1.69,-0.21 2,-0.88 1.09,-2.33 3.91,-3.54 5.81,-4.94 4.21,-3.13 5.41,-1.12 7.69,2.47 -4.14,1.59 -0.31,2.53 -0.38,4.75 -0.01,0.82 -2.21,1.3 -2.72,1.75 -1.41,1.26 2.95,3.57 3.5,4.06 0.9,0.77 1.32,1.9 2.19,2.66 0.03,0.03 0.09,-0.02 0.13,0 l 0,-46.38 c -0.04,-0.02 -0.08,0.02 -0.13,0 0.36,0.14 -5.22,5.24 -5.69,5.66 -0.92,0.84 -1.51,2.78 -2.69,2.81 -1.3,0.02 -2.63,-0.28 -3.78,-0.72 -1.3,-0.49 -1.91,-1.98 -2.31,-3.34 -0.29,-0.98 -1.43,-0.65 -2.03,-1.59 -0.6,-0.92 -2.64,-3.82 -4.47,-3.91 z m -16.16,29.56 c -0.74,0.05 -1.54,0.29 -2.19,0.44 0.86,3.24 3.41,5.47 5.56,7.63 2.59,2.57 5.63,2.74 8.88,4.03 -0.72,-1.05 -1.42,-5.51 -2.28,-6 -2.08,-1.21 -0.57,-1.55 -1.47,-3.28 -0.43,-0.82 -2.5,-0.29 -3.22,-0.06 -1.43,0.47 -2.07,-1.41 -3.41,-0.63 0.35,-1.86 -0.65,-2.21 -1.88,-2.13 z",
						"SY" : "m 690.18,473.58 c -1.13,-0.14 -3.02,1.6 -4.46,2.12 -4.45,1.61 -8.66,-0.92 -12.83,1.06 -4.21,2.01 -7.95,3.97 -12.42,4.94 -1.75,0.38 -4.94,0.29 -6.48,-0.53 -1.34,-0.73 -2,-1.85 -3.65,-2.12 -2.24,-0.35 -4.5,0.64 -6.62,1.59 -2.05,0.94 -3.18,1.06 -5.27,1.41 -1.71,0.3 -1.55,-0.11 -3.11,-1.06 -0.58,-0.35 -1.64,-1.27 -2.43,-1.06 -1.04,0.28 -0.95,2.55 -1.08,3.35 -0.38,2.19 0.42,2.59 1.08,4.41 -1,0.05 -2.11,0.44 -3.11,0.18 -0.31,1.21 0.59,2.76 -0.54,3.7 -0.52,0.42 -1.87,1.94 -2.16,1.76 -0.4,-0.23 -3.17,-1.84 -3.24,-0.53 -0.11,1.75 -0.53,4.45 0.68,5.64 1.51,1.49 -0.05,5.23 0.14,7.23 0.23,2.34 1.08,5.38 3.92,3.7 2.06,-1.21 0.13,1.66 1.62,1.94 1.25,0.24 2.06,2.9 1.76,4.23 -0.52,2.36 -3.75,2.56 -2.16,4.94 -1.97,-0.66 -5.6,0.87 -3.38,3.35 -1.53,0.38 -2.9,3.3 -4.46,4.23 0.31,0.17 0.51,0.59 0.54,1.23 l 29.03,0 c 10.39,-6.41 26.15,-16.13 27,-20.1 0.54,-2.5 0.65,-6.95 1.08,-9.52 0.29,-1.71 1.34,-3.8 1.35,-5.47 0.01,-2.83 -3.25,-7.86 0.68,-10.23 1.82,-1.1 3.43,-0.98 5.13,-2.64 0.92,-0.91 4.23,-3.62 4.32,-4.94 0.16,-1.99 -0.27,-2.73 -0.95,-2.82 z",
						"TN" : "m 356.41,472.88 c -0.92,0.06 -1.92,0.65 -2.7,0.88 -2.26,0.72 -3.81,1.5 -5.4,3.35 -0.74,0.86 -1.37,0.58 -2.3,0.88 -0.84,0.26 -0.61,1.45 -0.95,2.12 -0.94,1.84 -2.98,2.69 -4.19,4.23 3.38,0.8 1.08,5.08 0.81,7.4 -0.24,2.03 1.37,3.81 0.95,5.82 -0.47,2.2 0.07,2.14 0.54,3.53 0.44,1.36 -1.1,4.44 -1.35,5.82 -0.33,1.78 -0.93,3.64 -2.57,4.41 -1.74,0.8 -1.62,2.39 -2.97,3.53 -0.87,0.73 -1.93,1.14 -2.16,2.47 -0.15,2.59 0.29,4.97 1.49,7.23 0.6,1.12 0.18,2.42 0.81,3.53 0.3,0.53 0.74,0.96 1.22,1.23 l 37.27,0 c -0.84,-1.24 -2.87,-0.15 -3.78,-1.23 1.74,-0.19 0.08,-1.26 -0.41,-2.47 -0.33,-0.87 0.48,-1.82 -0.68,-2.29 -0.84,-0.33 -2.42,2.64 -2.97,1.59 -0.23,-0.42 -0.44,-2.42 -0.81,-2.47 -1.13,-0.18 -1.6,0.61 -2.84,0 -1.1,-0.56 -1.92,-1.54 -2.57,-2.64 -2.93,-5.04 1.62,-6.4 4.59,-8.99 2.99,-2.61 5.65,-7.16 4.86,-11.46 -0.63,-3.41 -0.55,-3.5 -3.24,-5.11 -1.78,-1.05 -2.94,-3.63 -2.84,-5.82 0.16,-2.9 4.51,-5.38 5.81,-7.93 0.67,-1.33 0.93,-2.97 -0.54,-3.7 -0.62,-0.31 -1.91,1.24 -2.3,1.59 -0.98,0.91 -2.05,2.1 -3.24,2.64 -0.88,0.4 -1.69,-0.78 -1.76,-0.71 0.78,-0.73 0.56,-1.84 -0.27,-2.47 -1.09,-0.84 0.09,-0.87 -0.27,-1.76 -0.82,-1.99 -1.49,-1.8 -3.51,-2.29 0.64,1 0.42,1.59 -0.68,1.59 -0.15,-1.08 1.19,-1.7 -0.14,-2.29 -0.28,-0.12 -0.64,-0.2 -0.95,-0.18 z",
						"KZ" : "m 754.85,292.34 c 0.12,0.04 0.17,0.11 0.27,0.18 l 0,-0.18 c -0.1,-0.02 -0.17,0.03 -0.27,0 z m -10.4,2.47 c -0.47,0.03 -1,0.28 -1.49,0.71 -1.73,1.49 -0.9,4.1 -2.3,5.82 -2.04,2.59 -3.23,2.57 -3.78,5.99 -0.48,3.04 1.14,2.59 2.03,4.76 0.39,0.94 -0.59,2.26 -1.49,2.82 -1.77,1.07 -1.87,2.46 -2.7,4.23 -0.05,0.19 -0.08,0.37 -0.14,0.53 -0.05,0.17 -0.11,0.37 -0.14,0.53 -0.04,0.16 0.01,0.39 0,0.53 -0.03,0.14 -0.14,0.23 -0.14,0.35 -0.01,0.12 0,0.25 0,0.35 0.01,0.12 0.11,0.27 0.14,0.35 0.01,0.1 -0.04,0.09 0,0.18 0.04,0.09 0.08,0.28 0.14,0.35 0.04,0.09 0.08,0.11 0.14,0.18 0.07,0.07 0.19,0.11 0.27,0.18 0.08,0.07 0.18,0.11 0.27,0.18 0.08,0.05 0.16,0.11 0.27,0.18 0.11,0.05 0.16,0.13 0.27,0.18 0.12,0.05 0.27,0.13 0.41,0.18 0.12,0.05 0.26,0.14 0.41,0.18 0.13,0.05 0.26,-0.03 0.41,0 0.05,0.02 0.1,0.16 0.14,0.18 0.05,0 0.2,-0.02 0.27,0 0.05,0 0.08,-0.02 0.14,0 0.07,0.02 0.07,-0.02 0.14,0 0.07,0.02 0.2,0.16 0.27,0.18 0.07,0.02 0.2,-0.02 0.27,0 0.07,0 0.05,-0.02 0.14,0 l 0.27,0 c 0.08,0.02 0.07,0.16 0.14,0.18 0.07,0.04 0.2,-0.02 0.27,0 0.05,0.04 0.07,-0.02 0.14,0 0.05,0.04 0.07,0.16 0.14,0.18 0.05,0.04 0.08,-0.03 0.14,0 0.05,0.04 0.1,0.14 0.14,0.18 0.04,0.04 0.11,0.13 0.14,0.18 0.03,0.04 0.11,0.13 0.14,0.18 0.01,0.05 0.12,0.11 0.14,0.18 0.01,0.05 -0.03,0.13 0,0.18 0.01,0.07 -0.01,0.13 0,0.18 0.01,0.05 0.12,0.13 0.14,0.18 0.01,0.05 -0.01,0.11 0,0.18 0.01,0.05 -0.01,0.13 0,0.18 0.01,0.07 0.12,0.13 0.14,0.18 0.01,0.05 -0.01,0.13 0,0.18 0.01,0.05 -0.01,0.13 0,0.18 0.01,0.05 0.11,0.11 0.14,0.18 0.01,0.05 -0.03,0.13 0,0.18 0.01,0.05 0.11,0.13 0.14,0.18 0.03,0.04 -0.03,0.13 0,0.18 0.03,0.05 0.11,-0.03 0.14,0 l 0.14,0.18 c -0.01,0.02 -0.11,0.16 -0.14,0.18 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 0.03,0.16 0,0.18 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 0.03,0.16 0,0.18 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 -0.12,-0.02 -0.14,0 -0.03,0.02 0.03,0.16 0,0.18 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 -0.11,-0.02 -0.14,0 -0.03,0.02 0.03,0.16 0,0.18 l 0.14,0.18 c 0.04,0.07 -0.03,0.11 0,0.18 0.04,0.05 0.1,0.11 0.14,0.18 0.03,0.07 0.11,0.09 0.14,0.18 0.03,0.07 -0.01,0.11 0,0.18 0.03,0.07 0.12,0.28 0.14,0.35 0.03,0.07 -0.03,0.11 0,0.18 0.01,0.07 0.12,0.11 0.14,0.18 0.03,0.07 -0.03,0.28 0,0.35 0.01,0.07 0.11,0.11 0.14,0.18 0.01,0.07 -0.03,0.11 0,0.18 0.03,0.07 0.11,0.11 0.14,0.18 0.03,0.07 -0.03,0.28 0,0.35 0.04,0.07 0.1,0.13 0.14,0.18 0.04,0.07 0.08,0.13 0.14,0.18 0.04,0.07 0.08,0.13 0.14,0.18 0.08,0.09 0.19,0.13 0.27,0.18 0.07,0.07 0.22,0.14 0.27,0.18 0.07,0.05 0.08,-0.02 0.14,0 0.04,0.04 0.1,0.16 0.14,0.18 0.04,0 0.1,0 0.14,0 0.03,-0.02 0.11,-0.16 0.14,-0.18 0.03,-0.02 0.11,0.03 0.14,0 0.03,-0.02 -0.03,-0.14 0,-0.18 0.03,-0.04 0.1,0.03 0.14,0 0.03,-0.05 0.11,-0.14 0.14,-0.18 0.04,-0.05 0.1,-0.13 0.14,-0.18 0.04,-0.04 0.08,0.05 0.14,0 0.04,-0.04 0.07,-0.13 0.14,-0.18 0.05,-0.04 0.07,-0.14 0.14,-0.18 0.08,-0.04 0.18,0.03 0.27,0 1.82,-0.61 3.83,0 5.4,0.53 3.17,1.08 4.87,3.98 6.48,6.88 l 0,-35.61 c -0.88,0.3 -1.75,0.43 -2.3,0.35 -2.37,-0.34 -5.1,-8.5 -8.37,-8.29 z m 10.67,50.42 c -0.72,0.06 -1.26,0.39 -1.35,1.06 -0.08,0.59 0.49,1.22 1.35,1.76 l 0,-2.82 z",
						"IQ" : "m 695.04,472.52 c -0.21,0.07 -0.32,0.23 -0.41,0.35 -0.67,1.05 -0.75,2.42 -2.03,2.82 -0.78,0.24 -1.46,-0.1 -1.62,0.71 -0.38,1.99 -3.1,4.01 -4.46,5.29 -1.71,1.63 -4.01,1.07 -5.54,2.64 -2.2,2.24 -0.98,6.65 -0.14,8.82 0.91,2.36 -1.39,6.69 -1.62,9.34 -0.25,3.15 0.43,5.86 -1.62,8.64 -1.43,1.91 -3.63,2.96 -5.4,4.41 -5.43,4.48 -11.22,7.82 -17.69,11.11 0.19,0.91 0.46,1.75 0.68,2.64 l 74.67,0 c 0.43,-2.08 -3.29,-6.15 -4.19,-6.88 -1.11,-0.89 -1.88,-2.11 -2.84,-3.17 -1.13,-1.24 0.22,-1.74 0.81,-3.35 0.58,-1.52 -0.06,-1.91 -0.81,-3 -0.75,-1.07 0.11,-1.86 0.41,-3 0.6,0.45 1.38,0.71 2.16,0.71 -0.09,-1.24 -1.02,-2.18 -0.54,-3.53 0.43,-1.19 2.07,-1.03 2.16,-2.29 0.25,-2.82 2.88,0.3 2.97,-2.47 0.07,-2.1 -2.91,-3.86 -1.49,-6.17 0.83,-1.38 2.65,-0.88 3.24,-2.64 -1.06,0.33 -5.38,0.21 -6.21,-0.35 -1.61,-1.07 -1.69,-2.68 -4.05,-2.12 1.47,-2.85 -1.51,-4.79 -2.57,-6.52 -0.55,-0.89 -0.22,-2.04 -0.54,-3 -0.27,-0.8 -0.99,-0.59 -1.35,-1.23 -0.75,-1.33 0.04,-5.2 -2.03,-5.29 -1.63,-0.07 -2.55,2.31 -4.05,2.47 -2.14,0.23 0.69,-4.88 -2.7,-4.23 -1.46,0.3 -2.05,1.44 -3.65,1.06 -0.98,-0.23 -1.9,-0.76 -2.84,-1.06 -0.95,-0.31 -5.26,-1.17 -6.75,-0.71 z",
						"IR" : "m 713.54,440.08 c -0.52,-0.04 -0.83,0.39 -0.95,1.41 -0.46,4.13 -1.64,2.55 -4.59,3.7 0.68,1.03 2.28,3.4 1.62,4.76 -0.59,1.21 1.01,1.7 1.22,2.64 0.43,2.17 -0.49,5.95 1.89,6.88 -1.26,1.15 -2.1,3.5 -2.43,5.11 -0.23,1.07 1.99,1.78 2.57,2.12 1.86,1.08 0.44,3.27 1.22,4.94 0.76,1.64 2.17,0.58 1.89,3 -0.09,0.68 1.03,5.66 1.35,5.82 1.27,0.63 1.4,1.26 1.08,2.82 -0.55,2.68 5.16,3.77 3.11,7.76 2.36,-0.58 2.44,1.07 4.05,2.12 1.06,0.7 2.45,-0.04 3.65,-0.18 0.98,-0.1 1.53,0.84 2.57,0.53 -0.62,1.84 -2.91,1.34 -3.51,3 -0.71,1.94 1.03,3.31 1.62,4.76 0.35,0.87 0.29,2.31 -1.08,2.29 -1.45,0 -1.48,-0.5 -1.89,1.41 -0.25,1.31 -1.88,0.88 -1.89,2.64 0,1.01 0.34,2 0.41,3 -0.78,0 -1.56,-0.27 -2.16,-0.71 -0.28,1.07 -1.21,2.46 -0.27,3.35 0.95,0.89 1.14,1.6 0.54,3 -0.66,1.52 -1.79,1.77 -0.68,3 0.74,0.84 1.38,1.66 2.16,2.47 0.87,0.9 5.47,5.4 4.86,7.58 l 25.25,0 0,-71.4 c -1.11,-0.67 -1.94,-1.88 -2.97,-2.64 -1.54,-1.15 -5.31,-3.6 -1.22,-4.58 2.2,-0.52 -2.56,-4.07 1.49,-5.64 -1.46,-2.27 -3.6,-5.5 -6.75,-3.35 -1.22,0.82 -2.25,1.89 -3.38,2.82 -0.98,0.82 -2.52,1.23 -3.11,2.47 -0.5,1.08 -4.56,4.41 -5.67,4.76 -2,0.61 -4.69,0.33 -6.62,0 -3.11,-0.52 -4,-1.69 -5.94,-3.88 -0.95,-1.07 -2.02,-1.93 -2.97,-3 -0.99,-1.12 -1.44,-2.76 -2.57,-3.7 -0.61,-0.5 -1.37,-1.01 -1.89,-1.06 z",
						"RU" : "m 584.66,30.53 c -0.25,0.03 -0.51,0.1 -0.75,0.19 0.38,0.4 0.84,0.82 1.22,1.22 -0.79,0.09 -2.79,-0.45 -3.25,0.72 -0.28,0.73 -2.51,1.84 -2.97,1.56 -1.53,-0.96 -4.08,-1.21 -5.94,-1.56 1.19,0.96 1.69,2.63 -0.53,3.16 -2.26,0.56 -4.14,-0.58 -5.94,-1.41 1.04,3.76 -4.69,3.95 -7.03,4.41 -2.71,0.52 -0.97,1.86 -2.69,3.19 -2.29,1.78 -5.9,1.94 -8.5,2.81 1.42,0.17 5.4,0.37 2.56,2.63 -2.44,1.99 -2.43,3.99 -0.16,5.66 2.18,1.59 5.17,1.54 7.31,3.19 1.69,1.29 4.91,2.85 6.06,4.56 2.56,3.8 -11.46,6.68 -8.09,12 3.23,5.16 8.61,8.49 9.72,15.16 -1.37,0.07 -2.7,0.47 -4.06,0.72 1.65,0.51 0.35,3.2 -0.66,4.56 -0.95,1.28 1.62,1.73 1.88,2.66 -2.85,0.61 -2.81,3.64 -0.53,4.41 1.5,0.51 3.42,-0.24 4.06,1.59 -5.2,2.17 1.31,4.66 3.09,5.63 3.94,2.13 -3.14,6.07 -5.28,7.06 4.73,2.89 9.55,5.6 14.06,8.63 1.88,1.26 2.6,1.75 1.22,4.06 -1.59,2.68 -2.6,4.51 -5.28,6.34 -5.71,3.92 -10.56,8.88 -16.06,13.06 -5.29,4.02 -11.51,6.66 -16.34,11.28 2.38,0.04 3.7,0.15 5.94,-1.25 0.83,-0.52 2.89,-1.85 3.66,-0.88 -1.33,0.73 -0.71,2.38 -0.53,3.34 -0.8,-0.44 -1.66,-0.92 -2.44,-1.41 1.23,1.66 4.43,4.37 6.34,5.13 2.75,1.07 5.42,-0.95 7.97,1.06 0.12,0.1 5.54,3.34 2.97,3.34 -2.81,0 -5.23,-1.85 -8.09,-1.94 -2.49,-0.07 -3.44,2.84 -5.69,3 -1.27,0.09 -2.57,-1.71 -3.63,0 -0.32,0.51 -0.51,1.2 -1.22,1.22 -1.18,0 -3.26,-2.34 -3.13,0 0.05,1.12 0.99,1.66 0,2.81 0.79,0.33 1.69,0.87 1.91,1.78 -2.87,-0.04 -2.93,1.83 -4.19,3.88 -0.9,1.47 -3.19,2.28 -3.38,4.06 -0.17,1.8 1.24,3.27 0.69,5.09 -0.31,1.03 -0.83,2.04 0,2.84 1.02,0.98 1.64,3.68 2.97,3.88 -3.86,2.85 -5.91,4.5 -0.97,6.88 2.13,1.03 0.88,5.11 -0.66,6.88 2.64,-0.31 4.33,3.35 5.25,5.47 0.35,0.8 0.18,6.13 1.75,5.47 2.73,-1.14 3.61,1.47 6.34,0.88 1.27,-0.28 2.83,-0.22 3.94,0.34 1.18,0.61 0.37,1.37 0.41,2.47 0.09,2.69 7.15,-1.4 8.78,-0.88 1,0.35 7.05,3.31 7,4.22 -0.12,1.89 -0.92,2.94 0,4.78 0.46,0.91 1.05,2.5 -0.25,3.34 -2.24,1.4 2.37,5.1 3.09,6.69 0.74,1.64 1.63,3.39 3.25,4.25 1.19,0.63 3.33,0.33 3.5,2.09 0.11,1.07 -1.83,3.37 0.69,2.84 1.78,-0.38 2.26,-0.28 3.91,0.16 2.83,0.75 0.22,1.16 1.63,2.31 0.88,0.75 2.79,1.45 2.97,2.81 0.13,0.91 -5.16,3.79 -6.22,3.88 -2.95,0.26 -4.92,-2.79 -8.09,-0.34 -1.53,1.19 0.48,2.83 1.22,3.53 1.49,1.4 0.97,1.35 1.06,3.34 0.16,3.01 0.6,6.32 3.53,7.41 2.37,0.87 4.54,-0.58 4.72,-3.38 2.84,0.21 4.22,1.15 7.16,0 2.67,-1.05 4.31,0.96 6.63,0 2.45,-1.01 3.55,2.47 4.03,4.06 0.51,1.71 2.88,2 3.38,3.72 -1.1,0.65 -2.56,0.16 -3.38,1.41 -0.39,0.63 2.83,4.21 0.94,5.28 1.41,0.52 5.03,1.83 6.63,1.06 2.49,-1.22 2.9,2.06 5.13,1.94 -0.84,1.29 0.52,5.18 0.81,6.53 0.48,2.25 1.92,3.3 4.19,2.09 2.05,-1.12 3.02,0.17 4.47,1.06 0.2,0.12 2.87,1.59 2.97,1.59 2.69,-0.14 5.53,-3.31 8.5,-3 1.71,0.19 2.15,3.06 2.97,4.25 0.9,1.31 2.79,1.41 3.25,3.16 2.83,-1.57 1.85,-2.81 4.72,-1.06 1.5,0.87 5.58,2.89 7.16,1.25 0.82,2.41 2.83,1 3.91,2.63 0.76,1.15 2.22,1.68 3.66,1.59 0.99,-0.07 1.24,-1.09 2.28,-0.53 -1.96,1.7 1.75,5.61 -2.41,7.25 -1.07,0.44 -2.09,0.54 -1.5,1.94 0.74,1.82 2.7,-0.72 2.56,1.75 -1.25,-0.42 -3.75,0.92 -3.25,2.66 0.16,0.59 4.18,2.03 1.78,3.69 0.4,0.38 0.88,0.5 1.47,0.34 0.07,1.47 -1.77,6.24 -3.38,6.38 -1.69,0.16 -3.44,-0.54 -5.13,-0.19 -1.49,0.3 -2.97,-0.93 -4.19,0.88 -0.6,0.89 -1.12,1.45 -2.16,1.75 -2.02,0.59 -4.81,4.41 -2.44,4.94 -1.78,1.45 -0.51,2.74 1.22,1.97 0.41,-0.18 0.73,-0.31 1.09,-0.53 -0.23,0.21 -0.52,0.4 -0.69,0.69 2.04,0.24 4.18,-1.23 6.22,-1.59 2.57,-0.45 1.02,2.43 3.09,1.78 -1.73,1.43 -4.7,3.2 -7.03,3.53 -4.66,0.65 -1.16,0.54 -2,2.81 -1.41,0.1 -2.31,-0.64 -3.78,-0.19 -1.34,0.4 -2.52,0.76 -3.78,0.19 0.54,3.34 2.37,2.77 4.44,4.22 0.82,0.58 3.92,2.78 3.38,4.25 -1.11,0.07 -2.09,-1.9 -3.22,-1.41 -0.95,0.4 -1.11,2.57 -1.78,3.34 -0.05,-0.77 -0.1,-1.54 -0.13,-2.31 -1.47,0.91 -2.3,7.14 -4.31,5.66 -0.21,0.77 -0.13,3.9 0.94,1.06 0,1.19 0.75,2.29 0,3.53 -0.75,-0.26 -5.57,-0.82 -5.25,0.16 -1.33,-1.31 -4.2,-3.32 -5.28,-0.53 0.38,-0.3 0.8,-0.46 1.22,-0.69 -0.05,0.96 0.43,1.59 1.34,1.59 -1.06,0.63 -2.31,0.64 -2.97,1.94 2.87,1.43 6.04,1.03 7.56,4.41 0.75,1.68 5.49,2.96 4.19,0.88 2.14,0.66 2.91,3.25 4.72,4.41 1.96,1.24 4.5,1.72 6.5,3 4.57,2.9 7.07,8.24 11.75,10.94 0.46,-5.47 11.23,-0.54 13.34,0.53 1.69,0.86 3.63,1.44 5.53,1.75 1.78,0.3 3.3,-0.41 5,-0.34 1.22,0.05 1.98,1.01 3.25,1.06 1.15,0.04 2.33,-0.25 3.25,0.5 1.11,0.91 9.25,4.94 7.81,6.38 2.89,2.61 9.33,-4.54 10.81,0.34 0.54,-2.54 3.8,-1.66 4.59,-0.34 1.35,2.22 2.58,0.6 4.44,1.75 1.19,0.75 -0.07,2.46 -0.13,3.69 -0.07,1.21 2.42,2.27 3.25,2.66 3.12,1.43 7.08,1.68 9.19,4.41 0.91,1.19 1.67,1.75 2.81,2.47 1.23,0.77 0.8,2.81 2.16,3.53 1.13,0.59 3.58,1.73 5,1.06 0.79,-0.35 1.62,-2.3 2.31,-3 1.43,-1.43 3.12,-2.37 4.31,-4.06 1.26,-1.8 -0.25,-2.38 -1.22,-3.69 -1.13,-1.52 -1.67,-3.36 -2.97,-4.78 -1.13,-1.24 -2.68,-2.4 -3.38,-4.03 -0.75,-1.77 -1,-3.46 -2.56,-4.59 -1.11,-0.82 -0.33,-3.55 0.81,-4.41 -2.64,-0.52 -0.02,-6.07 1.06,-7.59 -1.8,-1.35 -2.27,3.23 -2.28,4.41 -1.89,-0.3 -0.27,-1.43 -0.13,-2.81 0.16,-1.43 -0.66,-2.57 -1.22,-3.69 -0.95,-1.87 -1.8,-2.84 -3.53,-3.91 -1.3,-0.8 -3.63,-1.26 -3.09,-3.5 0.38,-1.56 3.77,-2.76 2.84,-4.41 0.2,0.4 0.4,0.68 0.66,1.03 1.93,-4.39 6.2,-8.37 3.53,-12.5 1.38,0.02 1.85,1.38 2.28,2.47 -0.11,-0.98 0.04,-2.1 -0.66,-2.81 1.18,0.38 2.06,1.29 3.09,1.94 -0.01,-2.57 1.93,-0.98 3.5,-1.78 0.78,-0.4 1.25,-1.17 2.16,-1.06 -1.06,-1.87 0.91,-1.09 2.31,-0.53 l 0,-2.81 0,-7.22 c -0.8,-0.48 -1.33,-0.9 -1.09,-1.25 0.24,-0.36 0.63,-0.5 1.09,-0.53 l 0,-6.69 c -1.93,-3.33 -3.54,-6.74 -7.69,-7.59 -1.23,-0.26 -3.96,-0.82 -5.16,0.53 -1.42,1.59 -2.12,-2.8 -2.69,-3.5 0.42,-0.26 0.8,-0.46 1.22,-0.72 -1.33,-1.52 -0.86,-2.7 -3.09,-3.34 -1.25,-0.35 -2.87,-0.8 -3.38,-2.13 -0.95,-2.5 1.63,-6.14 3.75,-7.59 2.95,-2.01 -1.46,-3.64 -1.47,-5.44 -0.01,-3.92 1.11,-5.36 4.19,-7.41 1.94,-1.26 -0.33,-6.24 3.78,-6.19 3.56,0.04 4.69,6.26 7.44,7.75 0.82,0.44 1.99,0.26 3.09,-0.16 l 0,-10.41 c -0.08,-0.05 -0.2,-0.16 -0.28,-0.19 0.08,0.02 0.2,-0.02 0.28,0 l 0,-231.47 c -1.38,0.01 -2.67,0.19 -3.5,0.69 -1.94,1.17 -3,-0.13 -4.59,1.06 2.05,1.19 -0.01,2.88 -1.09,4.75 -1,1.75 1.49,3.01 -1.47,4.41 -1.15,0.56 -3.74,0.17 -5,0.38 -2,0.31 -4.81,0.11 -6.75,1.41 0.54,-0.42 1.12,-0.8 1.63,-1.25 -2.46,-0.18 -6.04,0.83 -7.84,-0.69 -1.29,-1.08 -1.44,-3 -2.97,-3.88 -1.62,-0.91 -4.53,-0.39 -5.53,-2.13 -1.23,-2.12 1.82,-3.11 3.63,-3.53 -0.04,-0.47 -0.09,-1.12 -0.13,-1.59 4.92,-1.56 9.3,-0.09 14.19,-1.41 -0.4,-3.46 -3.87,-4.49 -6.22,-6.34 -2.59,-2.05 -4.2,-3.16 -8.09,-3.53 -4.07,-0.37 -9.24,1.05 -12.97,0 -1.81,-0.51 -5.13,-2.47 -7.44,-0.53 2.89,0.98 6.55,2 8.91,3.72 1.41,1.03 -1.19,3.61 0.97,3.88 -2.06,0.33 -1.43,1.03 -0.56,1.75 -2.28,0.1 -0.95,1 -1.47,2.31 -0.42,1.08 -1.22,2 -1.91,3 -0.86,1.28 -2.39,3.65 -0.81,4.41 2.25,1.05 4.62,0.49 6.09,2.81 0.83,1.31 -0.57,4.03 1.34,4.59 -5.05,1.49 -5.21,8.13 -3.91,10.75 -1.3,-1.36 -1.42,-3.64 -3.66,-4.06 -1.19,-0.21 -3.53,-0.09 -3.91,1.75 -0.47,-0.21 -0.8,-0.47 -1.09,-0.88 0.96,-0.75 2.03,-1.2 3.13,-1.41 0.16,-2.27 -3.62,-2.91 -5.41,-3 -2.81,-0.12 -3.98,-0.24 -6.5,-1.06 -2.49,-0.8 -4.63,1.18 -6.75,3 -2.6,2.24 -5.13,2.88 -8.09,3.53 -3.01,0.66 -5.07,2.52 -7.81,4.06 -1.5,0.86 -5.54,1.89 -5.81,4.06 -0.27,2.08 3.87,4.11 5,5.44 1.69,1.91 2.88,4.1 3.38,6.72 -1.53,-0.51 -4.9,-1.63 -6.63,-1.25 -2.61,0.58 -3.84,0.86 -6.06,-0.16 -2.34,-1.07 -4.95,-2.03 -7.84,-1.78 -1.82,0.16 -4.57,2.43 -4.59,0 1.04,0.09 2.22,-0.45 3.09,-1.22 -4.47,1.22 -6.23,-2.93 -9.84,-3.72 -1.38,-0.3 -3.86,-1.81 -5.25,0.19 -1.51,2.13 -1.84,2.81 -4.75,2.66 1.61,2.96 4.8,4.64 7.16,6.88 1.11,1.05 2.99,0.8 4.59,0.34 2.06,-0.58 2.96,0.69 4.59,1.22 -1.8,1.82 2.76,5.94 -3.25,5.31 -1.65,-0.16 -2.48,1.61 -4.72,0.88 -2.37,-0.75 -4.95,-0.99 -7.28,-1.78 -1.92,-0.66 -2.85,-2.47 -4.47,-3.5 -0.86,-0.54 -0.97,1.26 -1.75,-0.19 -0.33,-0.59 -0.93,-1.06 -1.63,-1.25 -1.89,-1.01 -3.44,0.81 -5.25,-0.16 -1.46,-0.77 -2.87,-1.91 -4.47,-2.47 0.46,-0.4 0.89,-0.83 1.34,-1.25 -0.4,-0.31 -0.82,-0.58 -1.22,-0.88 0.55,-0.31 1.06,-0.6 1.63,-0.88 -1.78,-0.12 -1.27,-2.57 -3.09,-2.81 2.26,-2.12 -1.88,-3.82 -2.69,-4.94 -0.83,-1.14 4.67,-2.69 3.38,-5.31 3.46,0.89 -1,-4.17 -1.78,-4.75 -3.36,-2.47 -8.69,-3.29 -13.09,-3.53 1.39,-0.45 3.69,0.11 3.53,-2.09 -1.7,0.33 -5.45,-0.15 -7.03,-0.53 1.69,-0.8 3.47,-0.83 5,-0.38 -1.33,-1.73 -4.04,-0.18 -5.94,-0.69 1.47,0.26 2.91,-1.18 4.31,-0.53 -1.12,-1.1 -2.92,-1.1 -4.47,-1.41 1.13,-0.24 -3.23,-2.34 -4.44,-2.13 0.54,-0.47 0.96,-0.92 1.47,-1.41 -1.98,-1.63 -4.72,-1.23 -7,-2.28 1.71,0.28 3.78,-0.7 5.38,0 1.69,0.74 3.73,0.94 5.69,0.88 -3.92,0.14 3.25,4.21 4.19,4.56 1.11,0.42 3.49,-0.68 4.19,0 1.04,1 2.51,1.37 3.78,-0.16 -0.95,2.36 2.61,0.87 3.38,3 0.08,0.23 4.61,-0.49 5.53,0 4.31,2.26 8.81,3.12 14.03,3.34 6.16,0.28 11.17,2.51 17.16,3.16 5.39,0.58 10.3,-0.27 15.94,-1.56 5.17,-1.19 8.82,-2.95 13.38,-6.34 3.01,-2.27 6.74,-6.78 2.56,-7.94 -0.86,-0.24 -1.15,-3.34 -1.22,-4.25 -0.19,-2.31 -1.11,-1.7 -2.72,-2.63 -1.8,-1.05 -4.16,-0.67 -5.53,-2.31 -1.22,-1.45 -2.95,-2.82 -4.84,-3.5 0.25,0.47 0.46,0.92 0.66,1.41 -4.69,0.56 -8.96,-2.1 -12.28,-4.25 0.4,0.38 0.72,0.64 1.09,1.06 -4.7,-0.87 -7.62,-4.4 -12.03,-5.81 -5.14,-1.64 -10.35,-3.37 -15.25,-5.47 -4.39,-1.87 -9.03,-0.29 -13.63,-1.06 -1.97,-0.33 -3.75,-1.36 -5.81,-1.41 -1.86,-0.05 -4.11,0.65 -5.81,0 -0.83,3.45 -4.46,2.37 -6.22,4.94 -0.67,-2.17 3.22,-2.06 4.47,-2.81 -0.94,-0.3 -2.57,-0.9 0,-1.25 -1.81,-0.37 -1.17,-0.54 0.25,-1.22 -1.18,-1.8 -3.95,-0.91 -5.78,0.16 0.43,-0.47 0.84,-0.9 1.22,-1.41 -1.55,-0.04 -3.07,-0.39 -4.59,-0.53 -1.35,-0.12 -2.57,0.82 -3.94,0.91 0.98,-0.35 1.96,-0.8 2.97,-1.06 -1.53,-0.87 -3.33,-1.24 -4.97,-1.94 0.27,-0.51 0.63,-0.87 1.06,-1.25 1.19,1.82 9.2,3.79 10.41,0.19 -2.12,-0.96 -4.65,-0.23 -6.75,-1.41 -1.06,-0.59 -2.66,-1.49 -4.19,-1.59 -0.25,-0.02 -0.5,-0.03 -0.75,0 z m -109.69,198.31 c -1.86,0.09 -2.92,2.91 -4.34,3.88 -1.77,1.19 -3.82,0.97 -5.75,1.22 -1.45,0.17 -1.33,0.71 -1.53,2 -0.34,2.25 -1.77,3.82 -3.59,5.09 1.87,-0.34 2.63,-3.38 4.06,-3.53 1.38,-0.16 2.82,0.05 4.19,0.16 -1.15,1.4 -2.57,0.99 -4,1.69 -0.98,0.49 -0.24,1.22 -1.28,1.66 1.76,0.17 3.55,0.75 5.41,0.81 7.14,0.24 14.96,0.68 23.91,-0.03 -0.74,-0.28 -2.19,0.1 -2.34,-0.31 -0.18,-0.51 -0.44,-1.38 -0.13,-2.19 0.16,-0.93 0.12,-0.79 0.5,-1.72 0.51,-1.25 0.89,-1.86 0.41,-2.5 -0.91,-1.37 -1.63,-2.11 -2.44,-2.44 -1.21,-0.49 -3.34,-0.07 -5.56,-0.19 -1.63,-0.54 -6.58,-3.65 -5.5,-1.25 -0.15,5 -3,2.72 -7.06,2.72 1.25,-2.01 3.35,-3.49 5.06,-5.06 z M 459.75,241.03 c -0.02,0 -0.04,-0 -0.06,0 l 0,0.03 c 0.02,-0.01 0.04,-0.02 0.06,-0.03 z m 194.03,97.28 c 0.15,0.01 0.29,0.02 0.47,0.03 -0.48,-0.03 -0.99,0.19 -1.47,0.38 0.17,-0.07 0.35,-0.33 0.53,-0.38 0.15,-0.04 0.31,-0.04 0.47,-0.03 z",
						"DZ" : "m 332.24,476.4 c -0.65,0.14 -0.5,0.94 -1.22,1.59 -1.75,1.54 -4.35,0.91 -6.08,-0.35 -0.83,-0.61 -4.29,-2.43 -3.78,0.35 0.28,1.56 -4.5,1.83 -5.27,1.94 -2.38,0.31 -3.29,3.68 -6.08,1.41 -2.18,-1.78 -2.84,-2.38 -5.67,-2.29 -3.39,0.1 -6.65,-0.52 -9.86,0.88 -0.55,0.24 -4.39,0.21 -4.46,0.35 -0.35,0.65 -0.12,0.95 -1.08,0.35 -2.18,-1.33 -3.72,2.11 -6.21,1.94 -3.34,-0.26 -6.7,0.83 -9.99,1.23 -4.63,0.59 -12.45,2.92 -14.58,8.11 -1.58,3.88 -4.05,-0.46 -5.67,1.23 -0.62,0.65 -1.83,2.09 -2.84,1.23 -0.76,-0.65 -2,0.66 -2.7,1.06 -1.22,0.75 -1.8,1.88 -2.43,3.17 -0.7,1.47 -1.47,1.4 -2.7,2.12 -2.83,1.64 -3.75,2.64 -7.16,2.64 0.78,2.08 3.91,2.75 4.32,4.76 0.32,1.52 -0.78,2.53 1.08,3.35 -1.71,1.52 0.1,3.51 0.14,5.47 0.04,1.47 -0.45,2.94 -0.54,4.41 -0.11,1.57 1.44,1.72 1.22,3.35 -0.23,1.68 -1.08,2.92 -0.14,4.58 l 96.94,0 c -1.68,-1.44 -1.35,-3.93 -2.57,-6.17 -0.9,-1.63 -1.77,-5.41 -0.27,-6.88 2.57,-2.54 6.42,-5.51 7.16,-9.34 0.87,-4.69 1.51,-8.29 0.14,-13.05 -0.79,-2.73 2.78,-8.59 -1.08,-9.52 1.41,-1.78 4.74,-3.34 4.59,-6.17 -1.81,0.67 -3.92,0.18 -5.81,0.71 -0.94,0.28 -3.88,1.13 -2.7,-1.06 -1.42,0.07 -2.47,-1.04 -3.78,-1.41 -0.47,-0.12 -0.73,-0.05 -0.95,0 z",
						"MA" : "m 201.67,492.62 c -0.23,-0.09 -0.61,-0.03 -0.95,0.18 -1.07,0.65 -2.33,1.2 -3.65,1.06 -1.06,-0.12 -1.68,3.66 -1.89,4.41 -2.2,7.78 -5.08,18.41 -11.75,22.74 -3.36,2.19 -7.13,3.65 -10.67,5.47 -1.39,0.72 -2.58,1.68 -3.65,2.82 l 71.56,0 c -0.48,-1.21 -0.59,-2.09 -0.27,-3.88 0.29,-1.68 -0.6,-2.67 -0.81,-4.23 -0.27,-1.92 0.25,-3.82 -0.14,-5.82 -0.24,-1.26 -0.65,-2.95 0.41,-3.88 -2.04,-0.91 -0.64,-2.29 -1.35,-3.88 -0.62,-1.4 -2.38,-2.02 -3.38,-3 -0.94,-0.93 -1.82,-2.57 -3.24,-1.76 -1.09,0.62 -2.44,0.45 -3.38,-0.35 0.18,0.57 -0.9,-0.02 -1.08,-0.88 -0.23,-1.07 -0.64,-1.4 -0.68,-2.82 -1.85,4.34 -6.13,2.21 -9.45,2.64 -4.01,0.54 -7,1.19 -10.67,-1.59 -1.75,-1.31 -2.75,-2.64 -3.65,-4.76 -0.35,-0.83 -0.66,-2.19 -1.35,-2.47 z",
						"FR" : "m 281.41,286.25 c -2.56,0.12 -6.36,1.74 -7.25,2.75 -1.22,1.35 -1.77,8.61 -0.19,9.66 -1.8,-0.96 -3.53,2.45 -4.91,3.03 -2.38,1.01 -5.09,0.9 -7.44,2 -0.74,0.37 -5.1,3.23 -3.09,4.41 1,0.58 2.68,0.39 3.66,-0.03 -1.21,0.94 -3.08,0.9 -4.44,1.72 -1.49,0.91 -2.96,0.96 -4.69,0.63 -1.77,-0.35 -3.5,-0.95 -5.31,-0.94 -0.62,0 -1.67,0.63 -2.28,0.28 -2.13,-1.24 -0.4,-3.59 -1.94,-4.38 -0.99,-0.51 -2.28,0.59 -3.38,0.34 -1.02,-0.21 -1.98,-0.71 -3,-0.91 1.39,1.07 0.66,3.06 1.66,4.38 0.58,0.75 2.21,1.85 2.16,2.94 -0.11,2.22 -0.9,6.48 2.03,7.38 -1.34,0.23 -3.06,0.62 -4.44,0.25 -0.58,-0.16 -1,-1.55 -1.59,-0.63 -0.59,0.91 0.58,1.57 -0.16,2.13 -0.2,-2.01 -1.04,-1.02 -2.25,-1.25 -1.21,-0.24 -1.18,-1.34 -2.56,-0.5 -0.63,0.47 -1.27,0.88 -1.97,1.25 -1.02,0.45 -5.03,-3.31 -4.75,-4.38 -3.17,-0.4 -4.82,2.52 -7.66,2.44 -2.01,-0.05 -3.87,0.08 -5.81,0.5 -1.45,0.3 -4.44,1.6 -3.78,3.72 0.47,1.57 3.37,-0.21 4.25,-0.16 -0.53,1.12 0.18,1.15 1.06,1.19 -1.21,-0.07 -2.49,-0.09 -3.59,0.31 0.76,1.66 3.69,-0.03 3.34,2.41 -1.53,-0.28 -3.12,0.16 -4.44,0.84 2.16,0.45 3.27,1.54 4.63,3.34 2.84,-3.43 7.35,2.87 10.19,0.09 -1.13,1.48 0.28,1.79 1.06,1.06 -0.36,0.94 0.62,1.92 0.72,3 0.24,-1.98 2.75,-2.34 4.19,-1.38 -0.67,0.38 -1.38,0.56 -2.16,0.56 1.5,1.61 3.87,0.14 5.63,0.59 -1.13,0.19 -1.36,0.6 -0.69,1.25 -2.22,0.3 0.25,2.21 1.47,2.03 0.76,-0.1 1.36,-0.21 1.91,-0.28 -0.08,0.04 -0.17,0.09 -0.25,0.16 -0.54,0.4 -0.55,1.38 -0.94,1.91 3.64,0.17 0.85,2.01 1.25,3.69 0.44,1.84 2.17,2.68 3,4.25 0.94,1.77 5.3,4.41 7.03,3.06 -0.69,1.13 -0.39,6.65 0.81,7.91 -0.92,-0.49 -3.15,-0.82 -2.09,0.22 0.71,0.7 1.66,1.32 2.5,1.81 2.01,1.14 2.85,2.73 3.19,5.09 0.21,1.52 1.8,2.78 1.44,4.38 -0.03,-1.24 -0.97,-1.37 -1.38,-2.41 -0.19,-0.8 -0.37,-1.62 -0.56,-2.44 -0.74,-1.82 -2.31,-2.9 -3.88,-3.81 -1.38,3.55 -1.85,8.35 -1.41,12.22 0.08,-1.89 2.54,-1.68 0.78,0 -1.19,1.14 -1.37,3.67 -1.59,5.28 -0.58,4.08 -0.63,10.35 -4.78,12.03 0.75,0.94 4.07,0.4 4.03,1.63 -0.04,1.05 -0.97,2.11 0.44,2.72 0.66,-2.08 8.24,3.06 9.75,3.09 1.51,0.02 1.37,-0.58 2.94,0.88 0.88,0.8 1.52,0.5 2.5,0.31 1.77,-0.35 3.78,0.13 5.56,0.41 -0.63,-3.22 2.65,-2.35 4.28,-1 1.18,0.96 3.25,0.11 3.63,2.16 0.63,-0.93 2.05,-0.68 2.84,-0.13 1.38,0.98 -0.54,0.9 0.31,1.56 0.33,0.26 3.38,1.73 3.53,1.63 2.09,-1.68 3.54,0.8 5.75,0.16 0.92,-0.28 1.42,-1.18 2.47,-1.25 1,-0.05 1.9,0.5 2.91,0.19 -1.14,-1.91 -0.79,-2.91 -1.44,-4.91 -0.8,-0.49 -0.86,-1.03 -0.22,-1.66 0.28,-0.49 0.42,-1.02 0.44,-1.59 -0.31,-1.71 3.8,-3.39 4.97,-3.97 1.5,-0.75 3.32,-2.81 5.03,-2.72 1.41,0.07 2.6,1.03 4.03,1.03 2.48,0 3.51,2.62 2.84,-1.47 0.48,2.05 0.67,2.15 2.28,2.06 0.98,-0.05 1.58,-0.22 0.84,-1.38 0.84,-0.04 1.35,0.45 1.41,1.34 -0.58,-0.23 -1,-0.08 -1.25,0.41 0.08,1.61 4.28,-0.53 3.34,2.22 2.46,-0.24 3.78,1.61 5.84,1.44 1.37,-0.12 2.29,0.73 3.72,0.19 1.33,-0.51 2.54,-1.29 3.97,-1.5 -0.27,-0.38 -0.53,-0.75 -0.78,-1.16 3.82,-2.76 8.1,-4.91 10.31,-9.16 0.92,-1.77 1.29,-3.32 -1.19,-2.25 -1.97,0.84 -5.75,-1.53 -6.38,-3.63 -0.51,-1.71 2.85,-4.02 1.41,-5.31 -0.99,-0.91 -3.89,-2.25 -4,-3.84 -0.01,-0.23 4.67,-2.07 5.28,-3.44 0.91,-2.01 -2.54,-4.56 -3.47,-5.94 1.69,-1.5 2.88,-2.35 0.94,-4.59 -1.11,-1.28 -0.14,-3.92 -1.66,-4.38 -1.26,-0.38 -4.37,-0.52 -4.81,1.28 -0.44,1.82 -1.09,2.47 -2.88,2.72 0.39,-1 1.38,-1.43 1.59,-2.56 -0.09,-0.65 -0.27,-1.25 -0.5,-1.84 0.25,-1.77 2.08,-2.35 3,-3.59 0.54,-0.73 0.45,-1.93 1.09,-2.56 0.79,-0.63 1.59,-1.24 2.41,-1.81 1.35,-1.15 2.38,-2.73 3.56,-4.06 -1.58,0.28 -1.53,-1.53 -0.59,-2.09 1.31,-0.77 1.43,0.96 2.53,1.06 1.31,0.12 1.96,-0.69 2.81,-1.53 1.02,-1.01 -0.14,-2.37 0.31,-4 0.39,-1.33 0.04,-1.75 0.19,-2.78 0.21,-1.61 1.09,-3.08 1.44,-4.66 0.72,-3.27 2.91,-5.66 5.25,-7.84 -1.94,-0.35 -5.15,-0.59 -6.72,-1.81 -1.46,-1.17 -2.34,-0.14 -3.91,-0.28 -0.24,-0.02 -1.64,0.32 -1.56,-0.31 0.12,-0.28 0.03,-0.49 -0.25,-0.59 -0.51,-0.09 -0.75,-0.77 -1.22,-0.25 -0.19,0.31 -0.44,0.53 -0.75,0.69 -1.49,-0.4 -2.2,-2.06 -3.19,-3.13 -1.26,-1.35 -2.4,-0.99 -3.97,-1.13 -0.32,-0.04 -6.75,-1.13 -6.59,-0.66 -0.55,-1.64 -3.95,-3.92 -5.59,-3.97 -1.13,-0.05 -0.88,-3.94 -1.03,-4.81 -1.3,0.56 -1.54,2.16 -2.84,2.72 -1.31,0.54 -2.85,0.12 -4.19,-0.13 0.35,-1.5 1.13,-4.13 -0.91,-4.84 -1.07,-0.4 -2.83,-0.57 -3.81,0.13 0.12,-2.76 -1.57,-1.74 -3.28,-2.59 -1.33,-0.66 -0.83,-2.04 -2.53,-2.56 -1.81,-0.58 -1.18,0.04 -3.75,-0.63 -2.48,-0.65 -0.96,-3.53 -1.84,-4.28 -0.43,-0.37 -1.15,-0.48 -2,-0.44 z m -44.47,51.63 c 0.69,0.1 1.44,0.39 2.44,1.06 -0.79,-0.11 -1.62,-0.77 -2.44,-1.06 z m 116.66,58.19 c -1.43,0.18 -0.66,2.68 -1.94,3.59 -1.54,1.08 -3.38,1.31 -5,2.19 -0.8,0.44 -0.92,1.79 -1.53,2.44 0.21,0.61 0.51,1.19 0.88,1.72 -1.73,0.38 -0.92,2.15 0.34,2.5 -0.84,0.87 -0.63,2.67 0.84,2.28 0.09,0.96 -0.43,1.77 -1.16,2.28 0.66,0.4 1.37,0.75 2.13,0.94 -2.76,1.24 2.42,3.24 2.97,4.19 1.42,-3.31 3.04,-6.7 3.84,-10.25 0.76,-3.38 -0.82,-8.39 -1.06,-11.88 -0.12,-0.01 -0.22,-0.01 -0.31,0 z",
						"BY" : "m 494.38,269.98 c 1.45,-1.73 2.65,-3.88 4.97,-4.32 2.29,-0.42 3.11,-2.22 3.04,-4.39 -0.16,-5.11 -4.15,-8.68 -4.55,-13.71 2.55,0.68 5.95,0.19 8.63,0.51 0.82,0.1 2.1,-0.54 2.92,-0.75 1.63,-0.42 1.3,-1.17 2.53,-2.17 0.78,-0.63 1.61,-0.03 2.4,-0.4 0.63,-0.3 0.98,-0.98 1.62,-1.28 1.26,-0.58 3.75,-0.73 2.79,1.38 0.64,0.23 1.73,0.14 2.21,-0.54 1.07,-1.47 -1.46,-1.98 -2.18,-2.29 2.89,-2.92 1.14,-6.03 5.01,-8.03 1.81,-0.93 2.2,-2.87 4.45,-2.66 2.45,0.24 1.39,-1.1 3.35,-2.06 -2.51,-0.72 -4.53,-1.75 -1.49,-4.97 1.94,-2.08 5.28,-2.83 7.58,-2.08 2.79,0.89 3.34,-3.15 6.11,-4.16 1.46,-0.54 3.31,1.14 4.09,0.54 1.57,-1.17 2.83,0.03 3.28,1.26 0.31,0.8 5.59,-1 7.1,0.63 0.54,0.59 -0.54,1.8 0.07,2.5 0.8,0.94 2.97,0.28 4.02,-0.21 3.68,-1.73 5.75,-1.07 8.53,1.22 0.75,0.63 3.17,1.03 3.03,2.38 -0.27,2.24 -0.48,2.71 0.29,4.72 0.51,1.33 -0.28,2.17 -1.07,3.24 -1.35,1.84 1.23,2.54 2.04,3.62 1.88,2.54 2.18,5.72 5.49,6.86 0.95,0.33 2.4,0.68 2.67,1.84 0.35,1.43 -1.53,2.59 0.31,3.15 0.6,-0.09 1.21,-0.24 1.8,-0.47 0.8,-0.16 1.73,0.51 2.5,0.59 2.44,0.3 0.92,1.17 1.86,2.64 0.5,0.79 1.77,0.86 2.44,1.49 1.78,1.71 -1.22,1.64 -1.98,2.12 -1.38,0.87 -1.69,2.22 -3.7,2.71 -2.5,0.61 -3.34,-1.63 -5.52,-1.59 -4.65,0.07 -2.33,3.59 -0.71,5.11 1.02,0.96 0.35,2.83 0.5,4.16 0.24,2.19 1.09,4.02 1.98,5.89 -5.25,0.17 -10.1,-0.45 -12.81,6 -0.63,1.52 0.7,2.83 0.91,4.25 0.4,2.54 -2.42,0.47 -2.96,-0.33 -1.55,-2.34 -3.97,-0.84 -6.36,-1.49 -0.99,-0.26 -2.83,0.61 -3.62,1.36 -0.78,0.75 -1.49,-2.78 -2.02,-3.1 -1.34,-0.79 -4.25,1 -4.22,2.75 -0.82,-0.4 -0.7,-1.78 -1.46,-2.12 -0.78,-0.37 -1.93,0.65 -2.59,0.1 -0.91,-0.77 -1.93,-0.7 -3.09,-0.58 -1.58,0.19 -2.18,-0.91 -2.6,1.05 -0.94,-0.26 -1.58,-1.08 -2.55,-1.29 -1.15,-0.26 -2.22,0.75 -3.07,-0.42 -1.63,-2.27 -4.77,-2.01 -7.42,-2.59 -2.71,-0.59 -5.85,-1.19 -8.67,-1.14 -1.8,0.03 -3.56,-0.58 -5.34,-0.4 -1.55,0.16 -3.07,0.77 -4.63,0.77 -3.39,0 -3.59,1.38 -6.07,3.34 -1.3,1.03 -2.14,0.33 -3.44,0.07 -1.66,-0.31 -1.02,0.68 -1.9,1.49 -1.3,1.21 0.51,-5.58 0.55,-5.74 0.72,-3.15 -3.94,-2.52 -5.02,-4.46",
						"CH" : "m 318.25,353.4 c 0.32,-0.7 0.68,-1.38 1.06,-2.03 0.5,-1.05 -0.2,-1.91 0.13,-2.89 0.5,-1.43 2.08,-1.94 2.91,-3.06 2.22,-3.01 4.55,-5.6 7.06,-8.45 -2.29,0.38 -0.75,-3.27 0.95,-1.82 2.29,1.96 3.12,-1.33 5.22,-1.64 -1.09,1.35 4.45,0.31 5.47,0.37 1.97,0.1 3.75,0.16 4.17,-1.17 -1.5,0.59 -1.88,-0.94 -0.48,-1.33 0.63,-0.19 1.67,-0.24 1.71,0.51 0.05,1.31 3.09,0.66 3.59,0.7 1.81,0.07 3.86,0.8 5.24,2.06 1.81,1.68 -0.87,4.41 -1.18,6.26 3.48,-0.45 3.76,2.2 6.6,2.8 1.23,0.24 1.71,-2.2 3.05,-1.8 1.57,0.47 0.23,2.33 0.09,3.18 -0.11,0.66 1.26,2.75 -0.13,2.78 -1,0.03 -1.78,-1.89 -2.73,-1 -0.35,0.33 -1.53,2.22 -0.71,2.62 1.46,0.7 0.59,1.24 0.38,2.75 -1.42,-0.61 -1.47,-2.22 -3.27,-1.85 -1.74,0.37 -1.93,0.77 -3.36,-0.68 -0.13,-0.16 -1.7,-2.97 -1.9,-0.66 -0.19,2.12 -0.15,2.62 -1.57,4.22 -1.82,2.03 -0.16,6.8 -3.09,2.26 -0.66,-1.01 -1.42,-1.52 -2.32,-2.22 -1.38,-1.1 -0.86,-3.18 -2.21,-4.18 -0.76,1.03 -1.66,2.08 -2.91,2.43 1.38,1.68 -1.57,4.65 -3.24,4.48 -3.16,-0.31 -5.75,1.82 -8.2,-0.89 -0.87,-0.94 -2.06,-1.96 -1.8,-3.46 0.39,-2.1 -1.06,-2.68 -2.75,-2.48 -2.84,0.3 -3.01,3.85 -5.79,4.22",
						"MK" : "m 466.73,415.58 c 1.33,-0.21 0.5,-1.36 0.52,-2.22 0.03,-1.17 2,-1.77 2.32,-3.22 0.29,-1.28 1.31,-1.89 2.32,-2.4 2.24,-1.14 1.77,0.35 3.74,0.42 -0.33,-1.71 0.76,-1.08 1.58,-1.94 0.47,-0.24 0.92,-0.23 1.37,0.03 1.06,0.33 1.22,-0.77 2.17,-0.94 1.07,-0.19 3.24,0.26 4.14,-0.44 1.11,-0.87 2.13,1.71 2.77,2.38 2.37,2.5 4.68,3.24 4.27,7.63 -0.09,0.93 0.67,2.8 -0.11,3.48 -0.96,0.84 -1.85,0.65 -1.71,2.36 -1.1,-0.3 -2.08,0.79 -3.38,0.51 -1.67,-0.35 -3.38,-0.16 -4.85,0.96 -2.92,2.22 -5.14,2.22 -8.61,2.83 -1.86,0.31 -1,-1.07 -2.59,-0.63 -1.94,0.52 -0.92,-1.28 -1.89,-2.13 -1.96,-1.71 -1.37,-4.23 -2.06,-6.68",
						"UA" : "m 483.97,322.63 c -0.21,-2.43 1.88,-4.11 2.95,-6.14 0.6,-1.14 0.21,-2.33 0.83,-2.76 0.62,-0.42 2.24,-0.09 3.59,0.96 0.17,-0.91 -0.12,-1.43 -0.75,-1.91 -0.9,-0.68 -0.4,-2.22 -0.74,-3.24 -1.1,-3.32 1.69,-5.54 3.95,-7.84 1.88,-1.94 3.84,-4.22 6.14,-5.61 2.53,-1.57 5.55,-2.66 2.53,-5.72 0.66,-0.28 1.31,-0.59 1.97,-0.94 -2.69,-0.65 -6.05,-6.87 -5.64,-9.73 0.36,-2.45 3.35,0.09 4.72,-0.65 1.25,-0.66 2.41,-1.63 3.27,-2.8 1.07,-1.49 3.42,-1.1 4.84,-1.1 3.2,-0.02 6.43,-0.3 9.63,-0.44 2.85,-0.1 5.04,0.96 7.6,1.66 1.27,0.33 5.43,-0.1 6.24,0.98 0.86,1.12 1.66,2.31 3.34,1.75 1.45,-0.47 2.33,0.91 3.52,1.24 0.42,-1.98 1.02,-0.86 2.6,-1.05 1.17,-0.14 2.18,-0.19 3.11,0.56 0.64,0.54 1.8,-0.45 2.57,-0.1 0.76,0.35 0.64,1.71 1.46,2.13 -0.03,-2.4 2.8,-3.18 4.37,-2.24 1.66,0.98 1.26,3.73 4.09,1.75 0.8,-0.56 1.42,-0.59 2.22,-0.14 1.03,0.58 2.64,-0.65 3.84,-0.37 0.75,0.19 3.62,4.37 4.35,2.19 0.91,-2.71 -1.22,-3.59 0.62,-6.58 1.3,-2.12 3.48,-4.65 5.79,-3.39 0.38,0.21 2.01,-0.61 2.38,-0.7 1.19,-0.3 2.79,-0.17 3.92,0.02 2.57,0.45 5.28,1.1 5.53,-3.04 2.02,0.14 3.75,1.54 5.89,0.63 1.06,-0.45 2.2,-1 3.31,-1.12 1.35,-0.14 1.75,0.94 2.84,0.96 0.84,0 1.42,-0.82 2.24,-0.79 1.29,0.03 2.67,1.71 3.09,2.8 0.8,2.15 3.24,3.29 3.8,5.3 -0.91,0.54 -2.67,0.47 -3.4,1.19 -0.44,0.44 2.83,4.5 1,5.53 1.34,0.49 5.63,1.52 7.09,1.08 2.36,-0.72 2.49,1.99 4.61,1.87 -1,1.56 0.7,2.66 0.92,3.94 0.31,1.75 -0.63,3.22 0.76,4.67 1.39,1.49 3.01,-0.16 4.72,-0.31 1.98,-0.19 2.71,2.08 4.73,1.89 1.61,-0.16 0.92,1.43 3.08,0.17 1.77,-1.03 3.66,-0.72 5.52,-1.71 1.85,-0.98 2.73,1.28 3.34,2.48 0.95,1.92 3.56,2.4 4.11,4.55 2.81,-1.57 1.81,-2.66 4.68,-0.91 1.5,0.87 5.6,2.78 7.18,1.14 0.82,2.41 2.87,0.98 3.95,2.61 0.54,0.8 1.51,1.42 2.48,1.61 1.19,0.24 2.44,-0.94 3.44,-0.4 -1.77,1.54 0.95,4.71 -2.01,6.93 -0.86,0.63 -2.52,0.33 -2.04,1.87 0.62,2.01 2.79,-0.28 2.67,2.08 -1.25,-0.42 -3.71,0.89 -3.23,2.62 0.17,0.58 4.15,2.08 1.75,3.73 0.39,0.4 0.9,0.51 1.49,0.35 0.04,0.75 -1.61,4.46 -2.08,5.21 -1.43,2.26 -4.31,0.51 -6.39,0.93 -1.21,0.24 -2.09,-0.52 -3.34,0.07 -1.23,0.61 -1.49,2.12 -2.97,2.66 -0.86,0.31 -2.29,0.51 -2.68,1.63 -0.54,1.56 -1.17,2.87 0.19,3.15 -0.95,0.79 -0.27,2.06 -1.37,2.69 -1.34,0.75 -4.38,-0.02 -5.89,0.26 -1.5,0.28 -1.93,1.96 -3.46,2.08 -1.81,0.14 -4.06,1.14 -4.77,3.18 -0.63,-1.47 -2.55,-1.35 -3.86,-0.61 -2.22,1.26 -3.59,0.63 -5.85,1.33 -3.79,1.17 -5.04,6.61 -8.81,7.61 0.23,-0.68 5.87,-4.86 1.86,-5.44 1.15,2.2 -1.63,2.61 -2.97,3.5 -1.94,1.28 0.46,5.53 1.13,6.72 1.22,2.13 6.08,9.45 8.28,3.66 0.98,1.45 1.78,1.01 3.2,0.28 1.92,-1 3.97,-0.05 5.24,1.22 -1.74,0.24 -1.84,1.14 -2,2.66 -0.2,1.87 -1.78,1.8 -3.13,1.96 -1.47,0.17 -2.26,0.1 -3.48,-0.68 -0.75,-0.47 -1.75,-1.21 -2.77,-0.8 -1.02,0.4 -0.63,1.49 -1.25,1.73 -1.5,0.61 -2.49,2.13 -4.03,2.36 -2.1,0.31 -3.9,0.09 -5.69,1.8 -3.05,2.96 -8.52,6.49 -10.98,1.21 2.1,0.51 3.46,-7.22 0.19,-7.77 -1.82,-0.28 -2.71,-1 -4.15,-1.99 -1.35,-0.93 -2.77,-0.28 -4.29,-0.47 -2.3,-0.31 3.31,-4.04 4.15,-4.39 1.67,-0.68 7.3,-1.63 8.04,-3.69 -1.38,0.03 -1.43,-1.42 -1.34,-2.55 -1.7,0.96 -1.33,1.19 -3.24,0.12 -1.57,-0.87 -3.92,0.05 -5.76,0.09 -2,0.03 -3.26,0.28 -4.97,-0.8 -1.47,-0.93 -3.08,-2.43 -5.06,-1.84 5.92,-2.38 -1.29,-1.47 -2.45,-3.59 3.36,1.85 8.16,1.33 11.41,-1.03 -2.09,0.61 -4.94,1.66 -6.55,-0.23 -1.19,-1.43 0.09,-3.87 -1.23,-5.34 0.98,1.61 0.46,3.15 0.29,4.93 -0.12,1.36 -2.99,0.49 -3.74,0.98 -0.31,-0.8 -0.2,-1.57 0.33,-2.33 -0.9,0.21 -1.19,1.47 -1.7,2.12 -0.71,0.93 -2.41,0.05 -3.35,0.23 -4.01,0.72 -3.79,4.71 -6.34,7.26 -0.09,-1.21 -1.9,-4.88 -3.55,-3.71 0.4,1.71 2.87,1.85 3.16,3.57 0.36,2.01 -5.29,5.74 -6.72,6.51 1.31,-0.87 2.93,-1.8 3.47,-3.48 -1.43,0.12 -4.54,5.2 -4.49,1.63 -0.75,0.8 -1.94,3.38 0.32,2.31 -0.31,0.38 -0.59,0.77 -0.86,1.15 1.5,0.24 2.05,3.36 0.27,3.94 1.45,-4.36 -3.99,-2.62 -6.12,-1.98 -2.71,0.8 -4.18,2.4 -6.82,0.8 -0.44,-0.26 -3.15,-2.87 -0.91,-2.89 2.69,-0.02 1.84,-1.96 3.26,-3.66 1.57,-1.87 4.27,-3.29 4.17,-6.05 -0.11,-2.43 -1.07,-3.29 1.85,-4.39 0.17,0.7 0.36,1.4 0.56,2.08 1.96,-3.55 6.26,2.4 8.95,-0.35 -1.03,-0.33 -1.37,-1.12 -2.33,-1.56 2.36,-1.67 -0.04,-4.41 -0.62,-5.03 -2.1,-2.65 -2.52,-1.28 -2.87,-2.71 0.07,-0.96 0.88,-4.1 -1.33,-2.98 -0.63,0.31 -1.07,-3.2 -1.31,-3.66 -0.63,-1.19 -1.1,-2.4 -1.46,-3.85 -0.68,-2.61 -2.09,-0.44 -3.2,-2.38 -0.68,-1.21 -3.08,-2.97 -3.78,-0.63 -0.15,-2.08 -1.65,0.75 -1.84,-1.24 -2.34,1.1 -4.42,-2.68 -6.23,-3.48 -2.34,-1.05 -5.06,1.03 -7.65,0.79 -0.9,-0.09 -1.93,0.02 -1.73,1.29 -0.86,-0.16 -2.09,0.44 -2.89,0.73 -0.79,0.3 -1.88,0.58 -2.26,1.5 -0.87,2.1 -1.9,1.92 -3.98,2.12 -2.56,0.24 -5.28,-0.26 -7.31,1.94 -2.97,3.27 -4.18,-0.73 -6.72,-1.63 -1.22,-0.42 -2.67,0.03 -3.92,0.19 -1.58,0.21 -2.34,-0.35 -3.79,-0.61 -1.46,-0.26 -2.96,0.26 -4.23,-0.72 -2.12,-1.63 -2.55,0.44 -4.61,0.98 0.09,-2.48 -2.21,-1.5 -3.31,-2.87 -0.76,-0.98 -1.27,-0.54 -2.04,-1.17 -0.88,-0.72 -1.02,-1.78 -2.32,-2.1",
						"IT" : "m 381.56,340.59 c -1.88,0.01 -3.78,1.34 -5.72,1.22 -1.38,-0.07 -3.14,-0.37 -4.28,0.72 -0.84,0.8 -1.85,2.97 -3.28,2.19 -1.1,-0.59 -4.11,-2.42 -4.28,-0.13 -0.03,0.52 1.05,3.84 -0.41,3.41 -0.67,-0.19 -1.46,-1.34 -2.19,-1.19 -0.72,0.16 -2.22,2.15 -1.09,2.69 1.27,0.61 0.47,1.68 0.31,2.75 -1.65,-0.7 -1.76,-2.08 -3.78,-1.75 -1.53,0.24 -1.58,0.45 -2.81,-0.81 -0.71,-0.72 -2.18,-2.46 -1.88,0.22 0.21,1.77 -0.61,2.36 -1.72,3.53 -0.98,1.01 0.07,3.85 -0.94,4.34 -0.92,0.47 -1.87,-2.13 -2.28,-2.66 -0.87,-1.08 -1.96,-1.74 -2.94,-2.69 -1.11,-1.08 -0.08,-2.37 -1.34,-3.31 -0.76,1.03 -2.05,1.18 -2.91,2.41 -0.5,0.71 0.57,1.39 0.16,2.13 -0.51,0.94 -1.97,2.59 -3.13,2.5 -1.74,-0.14 -2.62,-0.68 -4.44,0 -1.45,0.54 -2.02,0.67 -3.38,0.28 -0.72,-0.21 -2.11,1.52 -2.56,1.94 0.42,0.56 0.84,1.12 1.31,1.63 0.87,1 2.03,2.2 2.13,3.66 0.24,3.59 -3.76,2.11 -5.25,3.84 1.45,1.28 1.39,2.59 3.19,3.47 1.54,0.77 1.7,1.7 0.47,2.88 -3.27,3.11 1.59,6.91 4.59,6.56 5.55,-0.65 0.52,2.16 0.84,4.59 0.2,1.5 4.69,-0.57 5.28,-0.91 1.65,-0.96 2.56,-2.74 3.66,-4.28 3.12,-4.32 7.89,-2.86 11.63,-0.19 3.62,2.61 7.04,1.97 8.06,7.34 0.12,0.58 3.09,9.68 2.88,9.72 1.88,-0.28 6.92,5.47 5.66,7.69 2.17,-1.43 5,0.87 6.09,2.81 1.04,1.85 1.65,1.56 3.22,2.75 1.81,1.36 2.76,3.78 4.41,5.41 1.49,1.45 3.37,1.83 4.88,3.16 1.49,1.35 0.07,1.64 2.28,1.06 1.04,-0.26 1.97,0.25 2.94,0.56 1.82,0.58 3.18,-0.8 4.25,1.53 0.62,1.29 1.54,4.1 3.28,3.91 2.34,-0.26 2.67,1.52 1.5,3.38 2.24,-1.52 5.26,-1.45 6.38,1.47 0.51,1.35 -0.16,1.68 0,2.78 0.21,1.33 1.44,1.15 2.19,1.81 0.66,0.58 1.69,2.46 2.72,1.53 0.88,-0.77 1.49,-1.04 2.38,0.03 1.47,1.77 1.59,4.9 2.69,7 0.92,1.75 1.04,3.44 1.47,5.34 0.28,1.22 1.8,2.75 1.38,4.09 -0.48,1.56 -2.13,0.64 -3,1.84 -0.54,0.72 -0.2,1.7 -0.28,2.5 -0.23,2.36 -3.7,3.58 -2.63,6.19 0.71,1.71 1.91,2.36 3.41,1.19 1.58,-1.26 2.66,-3.1 4,-4.63 1.59,-1.8 2.24,-2 1.97,-4.66 -0.55,-5.4 6.51,-2.21 6.22,-6.69 -0.17,-2.66 -0.55,-4.51 -2.94,-5.72 -1.5,-0.75 -4.29,-1.33 -3.78,-3.69 0.44,-2.08 1.32,-4.3 2.47,-6.06 1.85,-2.83 2.45,-2.79 5.28,-3.31 0.33,1.08 0.8,2.97 3.47,2.69 3.32,-0.37 3.15,2.4 4.41,4.78 0.58,1.08 2,1.84 3.16,1.72 0.86,-0.1 1.04,-2.86 1.16,-3.47 0.51,-2.71 -1.62,-4.4 -3.22,-6.03 -2.38,-2.41 -5.49,-3.09 -7.94,-5.28 -2.42,-2.13 -5.07,-3.28 -8,-4.44 -1.85,-0.72 -5.46,-1.71 -6.78,-3.44 -1.23,-1.61 2.27,-2.81 2.59,-4.13 0.68,-2.76 -4.26,-2 -5.38,-1.84 -3,0.44 -4.41,0.02 -7.06,-1.31 -3.6,-1.8 -8.64,-6.07 -9.97,-10.25 -1.04,-3.27 -1.98,-6.99 -3.81,-9.84 -1.25,-1.98 -4.18,-2.85 -6,-4.09 -3.72,-2.55 -10.66,-8.13 -7.5,-13.97 1.58,1.91 3.36,-2.32 0.63,-3.13 -0.17,-0.05 -1.98,-2.8 -1.97,-3.34 0.92,0.23 0.74,-1.61 1.22,-2.06 0.7,-0.63 1.78,-0.53 2.59,-0.72 -3.07,1.7 1.88,0 2.47,-0.31 0.88,-0.47 1.79,-0.99 2.63,-1.56 0.78,-0.51 3.39,-2.59 3.69,-0.28 0.78,-0.3 4.92,-2.22 3.34,1.13 2.1,0.54 1.8,-1.37 0.44,-2.16 -1.03,-0.59 -2.46,-0.9 -1.31,-2.44 -2.4,-0.59 -0.54,-2.17 0.34,-3.25 -1.02,-0.24 -1.9,-0.86 -2.78,-1.41 0.71,-1.35 1.16,-1.8 1.34,-3.41 -3.99,-1.24 -5.74,-0.18 -9.75,-1.53 -1.33,-0.45 -5.92,-4.4 -3.53,-5.91 -0.27,-0.06 -0.51,-0.09 -0.78,-0.09 z m -29.91,79.5 c -0.83,0.06 -1.59,0.92 -2.19,1.47 -2.18,2.03 -5.71,6.1 -8.5,2.69 0.21,1.59 -0.5,2.97 0.44,4.44 0.51,0.8 1.2,1.4 1.56,2.31 -0.25,1.17 1.01,2.16 1.03,3.41 0.01,0.96 -0.9,2.08 -0.75,2.91 0.15,0.93 1.19,0.64 1.41,1.41 0.21,0.7 -0.06,1.44 -0.03,2.16 -0.35,-0.3 -0.71,-0.61 -1.06,-0.91 -0.12,2.06 -0.39,4.14 -0.31,6.22 0.08,1.68 1.26,2.91 -0.56,3.31 0.21,0.44 0.51,0.79 0.84,1.13 0.28,-0.38 0.56,-0.74 0.84,-1.13 1.02,2.2 1.04,1.6 3.09,1.97 2.16,0.4 1.9,-2.92 2.63,-4.13 1.39,-0.14 3.47,1.58 4.72,0.72 1.35,-0.94 1.25,-4 1.31,-5.47 0.09,-1.98 1.19,-6.14 0,-7.78 -1.22,-1.64 0.74,-2.4 1.13,-3.81 0.46,-1.63 -0.47,-7.06 -2.63,-6.97 0.35,-0.3 0.68,-0.61 1.03,-0.91 -0.9,-0.05 -1.22,-0.61 -0.84,-1.5 -1.06,0.58 -1.56,-0.77 -2.31,-1.28 -0.28,-0.2 -0.57,-0.27 -0.84,-0.25 z m 64.66,39.84 c -1.17,0.1 -2.73,0.96 -3.41,1.47 -1.39,1.05 -1.65,-0.11 -3.09,-0.13 -1.62,-0.02 -3.2,1.84 -4.88,2.16 -1.81,0.37 -3.6,0.05 -5.41,0.47 -3.16,0.72 -5.05,-3.86 -7.81,-2.22 -1.78,1.08 -2.82,2.48 -4.34,0.03 -0.79,1.66 -4.22,3.63 -2.56,6.25 0.76,1.21 2.57,1.65 3.84,1.69 2.79,0.07 4.83,2.96 7.09,4.34 2.21,1.36 4.63,1.47 6.91,2.5 2.16,0.98 2,3.87 4.22,4.63 1.58,0.54 3.55,0.7 5.19,0.28 -0.79,-1.71 0.85,-2.7 1.47,-4.03 0.74,-1.59 -1.52,-3.69 -1.84,-5.09 -0.36,-1.61 1.43,-4.61 2.03,-6.09 0.88,-2.12 2.24,-4.26 3.59,-6.06 -0.26,-0.17 -0.61,-0.22 -1,-0.19 z",
						"AT" : "m 354.76,338.02 c 1.06,-1.99 0.84,-1.43 0.32,-3.22 -0.19,-0.63 8.2,-0.37 6.23,3.22 2.37,-0.07 2.44,-2.43 2.96,-4.29 1,0.96 3.32,1.05 4.59,0.93 -1.1,0.58 1.45,1.66 2.08,1.47 0.5,0.07 1,0.1 1.51,0.16 0.56,-0.4 1.07,-0.86 1.54,-1.4 2.08,-1.31 5.65,-2.2 8,-1.38 -0.03,-0.44 -0.09,-0.86 -0.2,-1.28 1.18,0.16 3.05,1.28 4.22,0.66 1.98,-1.03 2.06,1.49 3.58,2.12 1.63,0.7 1.84,-2.26 0.71,-2.85 -0.87,-0.47 -0.27,-1.75 -0.44,-2.48 -0.23,-1 -1.26,-1.4 -1.63,-2.29 -0.96,-2.29 4.62,-3.06 5.75,-3.87 0.98,-0.68 0.36,-3.85 2.14,-3.15 2.41,0.98 2.09,-0.4 2.71,-2.71 1.54,0.72 2.64,2.61 4.46,2.66 0.84,0.03 1.27,-0.91 2.01,-0.93 0.8,-0.02 1.58,0.63 2.29,0.93 0.03,-1.12 0.64,-2.22 1.71,-2.57 1.41,-0.45 1.55,-1.47 1.39,-3.32 0.94,-0.07 1.45,0.65 2.3,0.8 1.78,0.33 3.26,0.28 5.04,0.91 2.1,0.73 4.46,2.48 6.7,1.43 1.57,-0.73 5.75,0.3 6,2.17 0.13,1.12 0.25,1.63 0.2,2.61 -0.04,1.12 0.07,2.69 0.64,3.57 1.58,2.36 1.15,2.38 -0.04,5.39 -1.11,2.83 -4.69,-1.36 -5.41,0.65 -0.4,1.17 3.74,2.19 0.71,3.8 -2.13,1.12 -1.38,4.08 -0.76,5.96 -1.92,-0.45 -6.5,2.15 -4.72,4.64 -2.32,-1.59 -3.47,0.23 -5.72,0.44 -1.61,0.17 -3.62,-1.07 -5.06,0.24 -1.23,-0.73 -3.26,2.05 -4.18,2.55 -1.71,0.94 -4.65,-1.19 -6.34,-1.45 -4.39,-0.68 -9.31,0.07 -13.81,-1.43 -1.37,-0.45 -6.52,-4.34 -3.87,-6.02 -1.51,-0.33 -2.75,0.82 -4.17,1.03 -2.09,0.31 -3.84,0.02 -5.93,0.65 -1.26,0.37 -2.26,2.76 -3.55,2.36 -1.29,-0.4 -2.48,-0.72 -3.78,-1.07 -1.09,-0.28 -0.03,-1.54 -0.72,-1.64 -0.84,-0.16 -2.14,0.84 -2.73,1.4 -1.11,1.07 -3.11,-0.61 -3.2,-1.71 -0.05,-0.77 -2.41,-0.77 -2.87,-0.79 0.43,-1.05 -0.09,-2.05 -0.66,-2.89",
						"SE" : "m 467.38,42.5 c -1.16,-0.02 -2.32,0.15 -3.5,0.66 3.8,1.59 0.38,4.68 -2,6.06 0.94,0.21 1.83,0.54 2.69,0.94 -4.07,2.92 -10.56,-0.02 -14.88,-0.44 -1.11,-0.1 -5.83,-1.46 -6.56,-0.09 -0.64,1.17 0.35,2.9 0.38,4.09 0.05,1.8 -3.02,2.92 -4.34,2.63 -2.63,-0.61 -4.2,-1.1 -6.88,0.13 -4.18,1.91 -5.59,5.93 -9.88,7.88 0.88,0.8 5.1,3.09 2.91,4.84 -2.68,2.12 -5.4,4.02 -7.81,6.5 -0.54,0.54 -2.18,1.01 -2.06,1.94 0.09,0.87 0.9,1.98 -0.19,2.63 -2.57,1.5 -6.26,1.84 -9.06,1.72 0.33,1.43 1.21,10.61 -0.66,11.63 -1.46,0.8 -3.21,4.13 -4.5,5.38 -1.41,1.35 -2.8,2.7 -4.06,4.19 2.46,0.82 5.06,1.21 5.06,4.34 0.01,3.15 -3.39,2.78 -5.63,2.66 -3.39,-0.17 -6.66,-0.4 -9.59,1.75 -1.11,0.84 -5.54,3.58 -4.63,5.16 0.82,1.38 -1.67,2.05 -1.5,3.66 0.16,1.33 1.11,2.04 1.5,3.25 0.31,0.96 -1.05,1.37 -0.88,2.47 0.2,1.19 -0.03,2.34 0.34,3.53 0.98,3.08 1.91,4.79 0.97,8.09 -0.79,2.75 -0.42,4.97 2.47,6.09 1.57,0.59 4.56,1.21 3.88,3.63 -0.99,3.57 -2.22,2.65 -4.78,3.75 -2.56,1.1 0.24,3.86 1.13,5.16 1.61,2.33 0.4,4.19 -0.22,6.78 -0.82,3.48 -6.29,2.09 -6.13,4.59 0.16,2.31 -2.43,2.89 -1.25,5.56 0.66,1.5 0.07,6.15 -1.94,6.69 -1.26,0.35 -1.76,-3.03 -3.53,-2.72 -2.05,1.42 1.35,7.79 0.38,10.06 0.9,-0.66 1.71,-0.39 1.91,0.75 2.05,-0.66 0.3,-2.16 2.5,-1.94 -0.6,0.87 -1.24,1.73 -1.91,2.53 1.51,0.21 2.3,-1.55 3.81,-1.22 -0.12,0.89 -2.5,8.1 -0.22,7.28 -2.36,0.84 0.21,1.03 0.53,2.63 0.19,0.93 0.11,1.92 0,2.84 1.85,-0.63 2.4,1.16 2.91,2.56 0.79,2.17 2.63,3.68 3.88,5.53 1.3,1.92 6.6,3.81 1.13,4.75 0.24,2.31 2.54,3.76 -1.44,2.31 -0.16,1.92 2.84,5.6 4.06,6.97 1.1,1.24 0.16,5.11 -1.03,5.16 3.71,0.21 6.73,0.07 10.44,-0.28 1.17,-0.1 5.12,1.89 4.91,-1.16 -0.11,-1.61 -1.81,-2.9 -1.03,-4.59 1.35,-2.96 3.23,-1.56 5.44,-2.47 -1.65,-2.2 1.6,-1.93 2.84,-1.84 2.26,0.16 4.66,-0.95 6.88,-0.25 3.7,1.17 4.8,-5.02 6.53,-7.16 2.69,-3.32 0.62,-6.66 3.13,-9.84 1.1,-1.4 -2.21,-2.48 -0.38,-3.22 2.06,-0.84 -0.81,-2.55 -1.34,-3.28 0.92,-0.23 1.79,-0.1 2.59,0.38 0.31,-1.03 -0.05,-1.59 -1.13,-1.34 4.45,-1.66 0.29,-5.76 -2.19,-6.66 1.66,0.09 3.24,0.89 4.88,0 -0.98,-2.1 -3.85,-2.32 -5.88,-1.81 2.55,-1.87 5.78,0.68 8.5,-0.75 -0.36,-0.33 -0.74,-0.67 -1.13,-0.97 1.69,0.17 3.31,0.28 4.91,-0.59 -0.16,-0.4 -0.33,-0.82 -0.53,-1.22 1.54,0.72 1.57,-0.1 1.25,-1.22 0.39,0.28 0.78,0.56 1.16,0.84 0.2,-1 -0.08,-1.79 -0.81,-2.41 1.3,-0.07 1.68,3.15 2.5,2.66 1.22,-0.75 1.48,-2.21 2.97,-2.75 1.06,-0.38 2.16,-0.46 3.19,-1 -0.98,-0.19 -1.63,-0.94 -1.78,-1.94 0.5,0.16 3.68,1.01 2.78,0.59 0.96,0.09 -0.23,-1.92 -0.91,-2.31 0.4,2.26 -4.13,1.36 -3.84,-0.13 0.66,0.65 1.45,0.87 2.38,0.63 -2.3,-0.82 1.37,-1.35 2.69,-2.31 1.49,-1.07 2.96,-2.12 4.81,-2.19 -0.44,-0.96 -1.12,-1.83 -1.91,-2.53 2.81,2.36 -0.58,-2.58 -1.28,-2.72 -0.96,-0.21 -5,-1.4 -1.91,-2.03 -1.18,-1.94 -7.03,-1.43 -5.91,-4.88 -1.69,0.33 -3.29,2.08 -4.19,-0.28 -0.2,-0.54 -3.15,-0.76 -3.75,-1.13 0.46,-0.21 0.92,-0.4 1.38,-0.63 -0.83,-1.61 -1.96,-2.7 -2.03,-4.66 -0.04,-1.33 1.07,-3.76 -0.66,-4.38 3.46,-0.37 -2.1,-2.57 1.44,-1.91 -0.92,-0.33 -3.26,-1.08 0.16,-0.75 -3.94,-0.82 3.34,-0.43 -1.25,-1.5 1.46,-0.4 2.79,0.34 3.72,1.38 0.71,-1.66 -1.64,-2.62 -1.09,-4.53 0.36,-1.24 1.3,-3.67 2.81,-3.88 -2.3,-0.14 -3.46,-1.79 -2.38,-4.03 1.73,2.26 5.66,0.33 5.38,-2.5 -0.19,-1.85 -2.41,-3.02 -1.84,-5.03 0.04,1.35 1.83,1.97 1.44,3.41 0.54,-0.14 4.41,0.19 1.22,0.5 1.27,0.66 1.77,-1.34 2.47,-0.97 1.26,0.66 2.49,-0.27 2.53,-1.69 -0.87,0.04 -1.77,-0 -2.63,-0.13 2.88,-2.08 6.24,-1.85 9,-3.69 0.78,-0.51 1.59,-2.42 2.41,-2.44 1.45,-0.05 1.82,1.09 1.56,-1.03 1.29,2.89 2.04,-0.39 3.66,-0.69 1.54,-0.26 3.82,-0.81 4.59,-2.44 0.28,0.44 0.55,0.89 0.78,1.38 -0.23,-1.43 4.37,-3.33 5.06,-4.94 1.22,-2.82 4.82,-4.2 7.41,-5.38 -0.6,-1.15 -6.97,-3.37 -3.31,-4.13 -1.04,-0.21 -1.89,-0.71 -2.53,-1.5 1.02,0.51 4.63,-1.9 5.31,-2.72 2.01,-2.41 -0.01,-2.98 -0.72,-4.47 0.82,-0.1 8.14,-0.71 4.13,-1.97 1.02,0.38 2.02,0.27 3,-0.38 -0.46,-0.24 -0.92,-0.52 -1.34,-0.81 1.13,0.54 2.29,1.03 3.59,1.06 -0.07,-1.14 -1.36,-2.36 -0.91,-3.56 0.98,-2.55 3.59,2.7 4.31,-0.91 1.63,1.12 3.28,1.56 5.34,1.56 -0.31,-0.45 -0.64,-0.89 -1,-1.31 2.21,2.31 7.14,0.81 10.06,0.41 -0.55,-3.17 -7.11,-6.52 -3.81,-9.81 1.61,-1.61 2.32,-4.27 0.78,-5.66 -0.68,-0.61 -3.58,-2.94 -2.44,-4.22 1.04,-1.15 3.17,-1.66 0.63,-2.38 -0.66,-0.17 -1.89,0 -2.06,-0.75 -0.35,-1.38 -0.26,-3.06 -0.06,-4.53 0.11,-0.77 1.76,-1.69 1.75,-1.78 -0.09,-0.91 -6.55,-4.87 -7.63,-5.38 -3.31,-1.56 -7.28,-1.71 -10.63,-3.25 C 477.21,46.85 472.4,42.6 467.38,42.5 z m -16.22,151.13 c -0.44,-0.05 -1.07,0.02 -2,0.22 -2.09,0.44 -4.12,2.19 -5.56,3.78 -1.27,1.42 -1.05,6.68 1.03,7.03 -0.71,0.77 -1.28,1.59 -1.75,2.53 1.02,0.21 1.88,-0.43 2.41,-1.34 -0.42,-1.36 4.36,-5.17 5.41,-5.91 -3.91,-0.4 3.52,-5.97 0.47,-6.31 z",
						"TR" : "m 536,408.34 c -0.71,0.04 -1.53,0.38 -2.53,0.72 -0.6,0.21 -4.34,1.35 -4.31,1.75 0.08,1.45 -4.11,2.03 -0.81,3.22 0.91,0.33 1.18,1.29 1.31,2.22 0.24,1.59 0.76,1.6 -0.69,2.28 -2.65,1.26 -1.33,2.76 -1.97,4.75 -0.42,1.29 -2.06,2.92 -3.19,3.5 0.71,4.5 5.73,-0.48 7.66,1.38 1.19,1.14 -2.76,2.42 -3.13,2.56 -2.06,0.77 -3.09,3.06 -2.72,5.28 1.75,-0.72 3.51,-4.21 5.19,-5.47 1.97,-1.49 4.18,-2.03 5.94,-3.94 1.09,-1.19 1.83,-2.87 3.31,-3.34 1.22,-0.39 2.25,0.61 3.34,0.03 0.88,-0.47 1.56,-1.24 2.59,-1.19 2.06,0.14 4.87,2.29 6.97,1.47 1.11,-0.44 2.75,-3.16 1.06,-3.72 -4.37,-1.45 -7.5,-3.19 -10.03,-7.13 -0.67,-1.05 0.94,-1.38 -0.06,-2.34 -0.59,-0.56 -1.5,-0.65 -2.28,-0.56 -1.69,0.17 -2.48,1.23 -3.69,-0.38 -0.64,-0.87 -1.26,-1.14 -1.97,-1.09 z m 79.66,0.31 c -0.19,-0.01 -0.38,0.03 -0.59,0.09 -0.83,0.24 -1.24,1.33 -2.09,1.59 -1.86,0.58 -3.71,-0.25 -5.53,-0.25 -4.51,0 -7.87,-0.69 -12.44,0.63 -4.38,1.24 -7.58,3.32 -11.56,5.72 -1.38,0.82 -4,1.51 -4.81,3.06 -0.75,1.42 -1.09,2.36 -2.78,2.53 -3.66,0.38 -6.34,-1.71 -9.97,-0.88 -2.71,0.63 -5.21,-0.71 -7.81,-0.97 -2.37,-0.24 -4.77,1.8 -2.75,4.28 1.8,2.2 5.24,1.15 7.5,2.41 -2.79,0.7 -8.74,-0.69 -10.34,2.97 0.96,0.89 2.29,-7.4e-4 3.19,1.03 -2.2,1.94 -5.6,0.38 -8.06,0.63 -0.79,0.07 -3.95,0.63 -4.5,-0.31 0.03,-0.52 0.33,-0.88 0.88,-1.09 -1.06,-0.3 -2.16,-0.36 -3.25,0.09 3.13,2.15 -2.1,2.61 -3.63,1.56 -1.06,-0.73 -1.55,-1.49 -2.91,-0.53 -1.07,0.79 -2.39,-0.25 -3.53,0.34 -2.14,1.12 -3.01,4.24 -5.06,5.06 -0.82,0.33 -1.25,6.14 -1.47,7.31 2.93,1.05 5.93,-2.3 8.81,-0.66 -0.91,1.22 -2.05,2.22 -3.03,3.38 1.3,1.31 2.31,1.57 2.03,3.66 -0.28,2.06 1.56,0.16 2.03,2 -1.3,0.31 -1.94,1.73 -3.06,2.38 1.15,1.7 1.94,2.78 4,3.06 -1.15,2.55 -4.55,-0.56 -4.47,1.94 -0.96,-0.91 -0.63,-2.86 -1.22,-4.03 -0.29,-0.58 -1.92,-1.4 -2.06,-0.25 -0.2,1.4 2.26,4.96 -0.78,4.16 0,0.82 2.94,3.35 3.44,2.41 1.1,-2.12 1.67,-0.39 2.25,0.81 0.56,1.19 3.21,0.36 4.03,1.94 1.14,2.19 -0.6,3.01 -2.13,3.91 2.13,-0.1 1.55,6.48 4.03,3.28 -0.58,2.27 0.45,0.27 1.16,1.72 0.3,0.61 0.28,1.54 -0.03,2.19 -0.39,0.79 -4.81,-0.82 -2.63,2.22 1.66,-1.73 8.21,-1.61 10.06,-0.69 -0.66,0.77 -1.65,1.17 -2.16,2.09 -0.72,1.33 -0.53,0.88 -2.09,0.84 -1.54,-0.05 -3.54,0.03 -4.69,1.47 1.33,0.42 6.29,-0.73 7.41,-1.69 -0.07,0.91 -0.62,1.62 -1.44,1.81 0.8,0.19 1.01,0.68 0.63,1.47 1,-0.8 4.06,-2.98 4.41,-4.31 0.21,1.82 2.99,2.21 4.03,3.28 0.48,-2.33 3,-0.37 1.75,1.38 1.46,0.09 1.36,2.53 2.38,3.28 1.34,1 3.83,2.19 5.56,1.88 1.49,-0.28 3.15,-2.23 4.63,-2 0.58,0.09 1.3,1.45 1.97,0.72 1.23,-1.36 1.16,-4.46 1.28,-6.16 0.21,-2.97 3.64,-2.19 5.31,-1.88 3.19,0.63 6.03,2.43 8.84,4 2.56,1.43 3.31,4.87 6,6.22 1.75,0.89 3.92,1.03 5.88,0 1.07,-0.56 4.22,-1.39 5.28,-0.94 1.21,0.52 1.84,-1.08 2.69,-1.97 0.28,0.37 0.56,0.76 0.84,1.13 2.25,-2.83 5.04,-9.77 9.16,-7.41 1.73,1 3.41,2.32 5.41,2.72 1.59,0.33 4.07,-2.12 1.84,-1.88 1.42,-1.08 2.46,-0.84 3.66,-2.34 0.87,-1.08 1.91,-0.12 2.38,0.69 1.17,1.98 0.19,2.92 -1.31,4.25 -1.45,1.28 -2.95,2.33 -1.81,4.09 0.62,0.94 1.71,2.57 0.72,3.84 0.9,0.26 1.62,0.89 2.34,1.47 0.43,-1.24 1.81,-1.46 2.28,-2.59 0.4,-0.94 -0.12,-1.98 0.13,-2.94 0.99,0.26 2.09,-0.04 3.09,-0.09 -0.75,-2.1 -1.36,-3.83 -0.78,-6.28 0.58,-2.48 2.98,-1.94 4,-0.34 2.02,3.15 8.2,-0.25 11.03,-1.69 2.65,-1.33 3.84,-0.35 5.72,1.34 1.71,1.56 5.78,0.94 8.03,0.78 5.63,-0.44 11,-6.52 16.44,-5.72 3.03,0.44 5.58,0.47 8.72,-0.59 1.23,-0.42 4.24,-3.23 4.56,-0.91 0.38,2.69 2.48,1.07 3.66,-0.72 0.98,-1.49 1.91,-1.05 3.47,-1.06 2.17,-0.04 3.67,0.74 5.66,1.44 1.21,0.44 2.75,0.67 3.94,-0.38 0.66,-0.59 1.75,-0.63 2.34,-0.16 1.21,0.96 -0.56,3.54 1.16,4.19 1.31,0.51 2.85,-4.14 5.03,-2.28 -0.21,-0.7 0.43,-1.96 -0.06,-2.5 -0.44,-0.51 -1.72,-0.85 -1.81,-1.66 -0.2,-1.59 0.26,-3.21 -0.81,-4.44 -1.07,-1.21 -3.51,-0.86 -2.66,-3.38 0.42,-1.26 1.16,-3.07 2.16,-4 -2.49,-0.96 -1.38,-4.22 -1.91,-6.44 -0.36,-1.52 -0.92,-2.39 -1.13,-4.03 -0.12,-0.98 -1.1,-2.99 -1.63,-3.78 0.87,-0.35 3.43,0.24 3.88,-0.84 0.33,-0.82 0.25,-1.69 0.5,-2.53 0.84,-2.71 2.53,-1.12 3.63,0 -0.59,-2.13 -3.39,-5.44 -5.66,-5.53 -2.65,-0.1 -3.99,0.21 -6.34,-1.19 1.75,-1.17 -0.9,-3.76 0.47,-5.53 1.39,-1.78 0.01,-3.53 -1.75,-5.28 -0.54,-0.54 -0.55,-2.57 -0.88,-3.25 -0.51,-1.05 -2.25,0.18 -2.47,-1.09 0.56,-0.73 0.42,-1.13 -0.41,-1.25 -0.47,-0.42 -0.93,-0.87 -1.34,-1.34 -0.59,-0.61 -1.3,-1.29 -2.28,-1.09 1.23,-2.24 -1.93,-0.99 -2.75,0.5 -0.68,1.22 -2.9,0.22 -3.72,0.03 -0.55,-0.12 -1.11,-0.28 -1.66,-0.41 -0.87,-0.19 -0.96,0.92 -1.72,0.91 -1.23,-0.04 -2.13,-1.82 -3.5,-0.75 -3.4,2.66 -6.95,4.74 -10.75,6.56 -3.16,1.5 -5.21,0.71 -7.97,-0.41 -1.97,-0.8 -3.19,-0.48 -5.38,-0.25 -2.56,0.26 -5.35,2.15 -7.84,1.88 -1.78,-0.19 -4.34,-0.18 -5.47,-1.75 -1.42,-1.94 -1.95,0.76 -3.06,0.09 -2,-1.14 -4.32,-1.43 -6.03,-3.09 -1.42,-1.35 -2.93,-1.74 -4.56,-0.06 -1.25,1.28 -3.63,-2.47 -3.84,-3.59 -0.16,-0.84 -1.51,-4.41 -2.13,-1.47 0.21,-1.98 -1.06,-0.42 -2.38,-0.25 -1.19,0.18 -2.3,-0.12 -3.38,-0.47 -1.42,-0.49 -3.48,-2.91 -1.94,-4.66 -0.59,-0.05 -1.11,-0.37 -1.69,-0.41 z",
						"PT" : "m 161.44,446.33 c -0.13,-0.38 -0.25,-0.75 -0.39,-1.14 3.35,-0.28 4.11,-6.19 4.89,-8.9 0.67,-2.38 0.94,-5 1.38,-7.49 0.12,-0.66 0.7,-0.79 1.03,-1.24 0.28,-0.38 0.11,-2.92 -0.54,-0.23 0.15,-2.92 0.68,-4.65 -0.13,-7.61 -0.27,-0.96 -2.04,-6.03 -0.21,-6.09 -2.57,0.87 -0.79,-3.34 0.56,-3.99 1.55,-0.73 3.79,-0.84 5,-2.17 -0.08,0.94 0.35,1.5 1.26,1.36 -0.54,0.45 -2.33,3.34 -0.44,3.29 1.54,-0.05 3.03,-1.35 4.58,-1.07 2.05,0.35 2.87,1.22 4.81,0.07 0.5,-2.34 3.67,-0.56 5.45,-0.75 2.1,-0.23 1.03,1.42 1.25,2.64 0.15,0.79 2.68,1.28 3.27,1.82 1.31,1.21 -5.89,7.75 -6.86,8.01 0.83,-0.23 0.88,5.88 0.94,6.33 0.08,0.84 0.54,2.4 0.21,3.17 -0.42,1.05 -1.88,0.63 -2.09,1.96 -0.13,0.79 2.68,4.01 0.39,4.83 -0.86,0.3 -0.27,1.54 -0.98,2.01 -1.03,0.68 -3.75,0.42 -4.9,0.07 0.44,0.93 1.27,1.45 1.97,2.12 0.88,0.84 0.16,1.77 0.79,2.85 0.64,1.12 3.03,2.89 2.71,4.2 -0.52,2.27 -2.75,3.41 -3.2,5.7 -0.39,2.03 1.58,5.77 3.82,4.95 -0.84,2.61 -2.51,1.96 -3.54,4.58 -0.52,1.28 -1.61,2.15 -2.08,3.48 -0.63,1.78 1.11,3.55 0.38,5.34 -1.11,2.69 -4.77,3.03 -6.99,2.05 -2.67,-1.15 -6.14,-1.28 -8.31,0.86 -0.4,-1.15 0.27,-2.73 0.63,-3.73 0.59,-1.61 0.36,-3.67 0.94,-5.09 0.7,-1.68 -0.46,-2.85 -0.47,-4.53 -0.03,-2.45 1.23,-4.11 -0.32,-6.58 0.92,2.59 1.63,-0.24 1.38,-1.24 -0.38,1.19 -3.8,1.57 -4.97,2.03 0.52,-1.08 0.08,-2.34 0.29,-3.5 0.43,0.17 0.86,0.37 1.27,0.56 0.04,-0.87 0.64,-1.03 1.18,-1.43 0.78,-0.58 -0.25,-2.1 -0.31,-2.87 -0.67,1.07 -2.89,4.9 -4.51,3.64 -2.08,-1.61 1,-6.24 0.87,-8.27",
						"DE" : "m 343.05,233.35 c -1.07,0.47 -1.17,2.05 -0.94,2.99 -0.01,-0.65 0.56,-1.21 1.27,-1.49 -0.51,-0.17 -0.79,-0.68 -0.33,-1.5 z m 1.46,1.33 c -0.33,0 -0.64,0.07 -0.96,0.17 0.6,0.14 1.46,0.05 1.94,0 -0.32,-0.14 -0.63,-0.16 -0.98,-0.17 z m 4.21,0 c -1,-0.1 -2.05,0.07 -3.07,0.17 0.67,0.35 1.42,2.48 1.8,3.13 0.35,0.59 1.93,1.71 1.47,2.48 -0.74,1.26 -2.85,0.56 -3.68,2.15 1.13,0.49 2.24,0.26 3.38,0 -2.55,1.21 0.21,2.03 0.67,3.46 -1.09,-0.05 -1.49,0.65 -0.64,1.49 0.92,0.93 2.25,0.63 3.38,1 1.19,0.37 1.81,1.36 2.57,2.31 0.92,1.14 2.14,1.28 3.2,2.15 -2.75,-0.31 -3.48,-2.68 -5.61,-3.97 -1.39,-0.84 -3,0.16 -4.49,0 -1.73,-0.17 -3.42,-0.75 -3.67,1.64 -0.09,0.96 0.67,1.73 0.67,2.64 -0.25,0.7 -0.35,1.43 -0.47,2.15 -0.12,-1.19 0.16,-2.33 -1.14,-2.97 -1.53,-0.73 -2.05,0.73 -1.1,1.82 -0.83,0.23 -1.55,0.03 -2.25,-0.49 3.74,-2.62 -6.46,-3.04 -7.56,-2.82 -1.26,0.26 -3.35,2.34 -3.3,3.8 0.04,1.22 2.97,1.12 3.7,1.49 -1.78,-0.89 -2.29,6.17 -3.21,7.61 -1.1,1.7 -2.36,0.19 -3.47,1.49 -1.55,1.8 1.81,2.29 2.75,2.8 2.93,1.64 -3.08,3.99 -2.26,5.61 1.15,2.33 -5.45,1.85 -6.46,1.33 0.7,1.89 -0.76,0.12 -2.02,1 0.58,0.52 -0.01,0.61 0.03,1.15 1.45,0.51 3.55,3.53 2.8,5.11 -0.68,1.43 -3.63,4.36 -1.92,5.95 1,0.93 -1.23,2.05 0.24,3.31 0.92,0.8 2.79,0.82 1.61,2.48 1.53,-0.28 1.46,1.64 1.93,2.64 -3.88,0.75 -2.91,5.25 -0.01,6.73 2.32,1.19 -0.28,1.85 -0.25,3.39 0.04,1.78 1.9,2.36 2.71,3.73 1.51,2.59 1.92,0.72 3.58,1.29 1,0.35 0,1.52 1.41,1.14 0.54,-0.1 1,-0.1 1.55,-0.16 1.96,-0.72 2.36,0.37 4.18,0.96 1.65,0.54 3.88,1 5.59,1.29 -1.37,1.28 -2.72,2.52 -3.82,4.06 -1.27,1.75 -1.11,4.04 -1.94,5.98 -0.55,1.31 -1.8,9.48 0.09,8.26 -1.09,1.35 4.35,0.44 5.37,0.49 1.97,0.1 3.71,0.03 4.13,-1.29 -2.37,0.93 -1.59,-2.45 1.22,-0.98 1.98,1.03 4.73,0.38 6.75,1.63 1.23,0.75 9.83,1.57 8.12,4.69 2.37,-0.07 2.55,-2.34 3.07,-4.2 1,0.94 3.32,0.93 4.59,0.8 -1.11,0.58 1.73,1.43 2.29,1.45 1.3,0.03 2.14,-1.15 3.38,-1.29 2.38,-0.24 4.72,-2.2 7.35,-1.29 -0.03,-0.44 -0.03,-0.87 -0.13,-1.29 1.23,0.16 2.41,0.8 3.67,0.8 0.6,-0.21 1.21,-0.35 1.85,-0.47 0.67,0.07 0.94,1.47 1.5,1.94 1.69,1.38 1.67,0.68 2.16,-0.98 0.48,-1.64 -1.47,-1.01 -1.34,-2.43 0.15,-1.73 0.21,-1.64 -1.03,-3.08 -0.94,-1.07 -0.28,-1.91 0.8,-2.41 1.23,-0.61 5.25,-1.33 5.28,-3.25 0.05,-3.38 2.21,-0.44 3.43,-1.94 2.2,-2.73 -1.51,-4.62 -3.15,-5.67 -1.9,-1.21 -3.52,-2.89 -5.51,-4.04 -2.51,-1.47 -2.96,-4.79 -5.36,-6.16 1.92,-1.57 1.06,-2.85 -0.72,-3.9 -1.38,-0.8 -1.67,-2.27 -2.29,-3.46 1,-0.16 1.78,0.26 2.16,1.82 0.44,-4.36 5.71,-2.66 7.86,-4.46 3.46,-2.89 9.18,-4.48 13.28,-6.12 -0.36,-0.35 -0.7,-0.65 -1.07,-0.98 1.59,-0.38 2.44,-1.03 3.11,0.82 0.8,2.2 3.26,0.7 3.26,-1 0,-1.94 1.09,-3.24 0.84,-5.11 -0.17,-1.35 -2.37,-1.08 -2.46,-2.15 -0.11,-1.45 0.15,-1.94 -0.86,-3.15 -0.67,-0.79 0.52,-1.84 0.71,-2.64 0.75,-3.31 -2.09,-3.81 -1.26,-6.44 1.03,-3.22 -4.29,-3.17 -4.46,-5.77 -0.09,-1.64 1.65,-1.52 2.14,-2.82 0.54,-1.4 0.6,-2.87 0.27,-4.3 -0.42,-1.8 -0.9,-3.73 -2.76,-4.44 -1.15,-0.45 -3.03,-0.77 -3.16,-2.33 -0.07,-0.8 -0.36,-3.31 -1.53,-3.31 -0.71,0 -2.16,0.02 -1.78,0.84 -1.27,-0.77 -4.01,-4.18 -5.22,-4.3 -2.57,-0.23 -4.35,-0.02 -6.31,1.98 -0.28,-2.2 3.35,-2.36 4.7,-2.13 -2.63,-1.01 -3.03,-0.23 -5.01,1.31 -0.94,0.73 -2.99,1.56 -2.45,3.15 0.29,-2.68 -4.9,-0.3 -6.11,0.49 2.36,-1.17 -0.25,0.79 -0.66,1.98 -0.95,-0.91 -6.52,-2.19 -5.29,0 -0.23,-0.84 -0.79,-1.29 -1.59,-1.49 1.55,-1.63 2.96,-2.73 3.4,-5.11 -2.13,0.42 -3.39,1.29 -5.48,0.31 -1.3,-0.59 -3.38,-1.42 -4.02,0.51 -0.17,-0.86 -0.21,-0.91 0.32,-1.66 -1.07,-0.49 -2.33,-0.44 -3.39,0 0.8,-0.38 2.64,-2.85 0.64,-2.8 3.2,-1.49 -7.54,-2.4 -7.1,-2.15 -0.98,-0.54 -2.02,-0.87 -3.08,-1 z",
						"HR" : "m 396.27,362.42 c 0.74,0.17 1.46,0.45 2.21,0.56 0.95,0.14 1.8,-1.15 2.32,-1.05 2.2,0.4 4.41,0.77 5.56,-2.06 1.92,2.03 3.48,1.36 5.64,2.55 2.75,1.5 1.21,-1.99 2.68,-2.31 -0.52,-0.14 -0.96,-0.63 -1.49,-0.82 1.25,-1.14 3.11,-1.78 4.7,-1.96 -0.09,-0.28 -0.78,-4.08 -0.76,-4.09 0.32,-0.91 2.71,-1.59 3.43,-1.78 1.29,-0.35 1.1,-0.94 2.1,-1.64 0,0 1.15,0.35 1.41,0.35 -2.77,-3.59 4.9,-0.16 5.41,0.12 0.79,0.42 2.68,2.45 3.26,3.18 1.53,1.92 2.41,1.84 4.46,2.71 1.65,0.7 2.17,1.87 4.35,2.08 2.5,0.24 4.73,0.87 6.82,-1.21 0.98,-0.96 2.29,0.37 2.59,1.43 0.4,1.54 -0.66,3.15 1.59,3.24 -3.55,2.57 3.92,4.04 3.35,4.76 -0.35,0.44 -2.93,0.4 -3.59,0.68 1,1.91 -0.38,5.13 -2.56,3.27 -0.44,-0.37 -0.54,-0.84 -0.31,-1.42 -0.64,-0.3 -1.29,-0.58 -1.94,-0.86 -1.38,-0.54 -2.51,-0.59 -3.97,-0.49 -1.54,0.1 -1.65,-0.79 -3.19,0.1 -1.13,0.66 -1.75,-0.1 -2.79,-0.38 -1.26,-0.31 -2.64,-0.21 -3.86,-0.59 -1.07,-0.33 -2.13,-1.19 -3.28,-1.21 -1.69,-0.03 0.59,1 -2.18,0.45 -2.02,-0.38 -1.42,-0.1 -2.52,0.89 -2.64,2.38 -2.3,1.64 -4.74,-0.37 -3.42,-2.8 -3.66,2.9 -2.25,4.37 0.71,0.75 -0.11,1.43 1,1.66 1.22,0.26 3.19,2.29 3.21,3.5 0.04,1.89 -1.17,4.25 1.78,5.21 3.09,1.03 4.06,5.18 6.6,7.26 2.05,1.68 3.42,4.51 5.6,5.7 2.32,1.26 0.88,3.71 -1.5,1.01 -2.65,-3.01 -8.71,-7.89 -12.89,-6.23 -1.09,0.42 -1.65,-0.02 -2.32,-0.98 -0.83,-1.21 -0.29,-1.52 -1.9,-2.4 -2.36,-1.26 -5.57,-4.13 -6.46,-6.86 1.5,-0.26 2.84,-0.03 4.3,0.23 -1.9,-1.5 -4.26,-2.64 -5.56,-4.85 -1.09,-1.85 -0.28,-4.22 -1.34,-6.07 -0.94,-1.64 -3.05,-3.2 -4.78,-3.71 -1.27,-0.37 -2.52,3.57 -2.3,4.58 -0.54,-0.24 -0.75,-0.07 -1.17,-0.58 -0.19,1.31 -0.51,2.71 -1.47,3.66 -0.75,-0.63 -3.16,-3.88 -1.96,-4.93 -1.37,0.33 -1.97,-3.67 -2.29,-4.86 0.33,0.03 0.66,0.09 0.98,0.12",
						"DK" : "m 365.56,195.91 c -2.22,0.75 -6.54,1.97 -8,3.75 -1.3,1.59 -2.47,4.07 -4.75,4.31 -2.57,0.26 -6.21,-0.6 -8.41,1.06 -1.55,1.19 -3.55,3.9 -1.16,5.44 0.44,0.44 0.9,0.85 1.41,1.22 0.13,-0.92 -0.28,-1.49 -1.06,-1.5 0.96,-0.36 1.43,-2.33 1.97,-3 0.95,-1.15 2.85,-1.56 4.22,-1.84 1.54,-0.31 2.86,0.37 4.47,-0.06 1.45,-0.4 2.77,-0.74 4.22,-0.28 3.01,0.94 4.65,0.83 6.19,-2.25 1.39,-2.76 -1.76,-4.41 0.91,-6.84 z m -8.16,9.34 c -1.15,0 -1.92,0.59 -3.25,0.5 -0.84,-0.09 -1.58,0.11 -2.28,0.56 -1.06,0.94 -0.74,2.79 -0.66,4.03 1.55,-0.16 1.55,0.52 1.19,2.06 0.08,-1.66 -1.54,-1.33 -2.59,-1.44 2.56,-1.29 -2.3,-2.89 -3.06,0.66 -0.31,1.47 -1.62,2.23 -2.09,0.19 -1.04,0.7 -3.05,-0.57 -3.75,-1.34 -0.15,0.4 -0.32,0.82 -0.47,1.22 -0.59,2.06 -1.02,5.76 0,7.75 -0.54,-3.2 2.84,0.68 2.56,1.59 -0.58,1.91 -2.54,-0.12 -2.69,-1.22 0.29,1.47 -10e-6,3 0.19,4.5 0.15,1.17 1.5,3.72 1.72,1.06 0.35,0.89 7.01,5.61 1.59,5.59 0.32,0.93 1.04,1.46 1.97,1.09 -0.94,3.13 3.42,2.75 5.19,3.31 1.29,0.4 2.57,0.68 3.75,-0.25 1.11,-0.89 0.99,0.34 2.16,0.41 0.4,-1.92 -1.5,-2.92 -3.09,-2.75 -0.07,-1.92 3.3,-1.88 2.47,-3.84 -1.38,-3.25 -0.45,-1.99 1.56,-4.16 -0.86,-0.33 -1.74,-0.64 -2.59,-0.97 1.23,-0.23 3.3,0.77 4.28,-0.41 0.79,-0.93 -0.54,-1.73 -1.22,-1.78 1.82,-0.49 3.75,0.03 3.91,-2.63 0.11,-1.63 0.01,-3.58 2.25,-2.81 -0.87,0.91 -0.61,1.75 0.59,2.03 0.4,-1.26 0.81,-1.16 1.81,-1.16 0.99,0 2.95,-3.13 1.97,-3.94 -1.14,-0.96 -7,-2.15 -7.41,0.13 0.05,-0.68 1.92,-2.49 1,-2.91 -1.57,-0.68 -2.64,0.52 -4.16,0.5 1.5,-0.61 3.05,-1.16 4.69,-1 -0.8,-1.26 -0.32,-3.32 -1.94,-3.97 -1.31,-0.54 -2.17,-0.63 -3.59,-0.63 z m 26.25,12.84 c -1.49,0.06 -3.06,0.98 -4.53,1.59 1.71,0.72 2.63,4.6 0.06,4.72 0.67,-1 1.35,-2.13 0.75,-3.38 -0.5,0.33 -1.84,3.5 -2.5,3.06 -1.06,-0.72 -0.71,-3.21 -0.09,-3.31 -0.83,-0.71 -2.2,-0.64 -3.28,-0.53 0.37,0.01 0.61,0.19 0.75,0.56 -0.54,2.17 -4.44,2.59 -5.97,2.5 0.74,0.87 5.11,4.99 1.84,5.22 1.06,0.38 1.18,1.59 2,2.03 0.74,0.4 2.01,0.05 2.81,0 2.15,-0.2 2.72,2.14 1.16,1.84 0.67,0.2 1.82,0.63 1.88,1.22 -0.29,0.35 -0.68,0.43 -1.19,0.22 -0.01,0.35 0.18,1.06 0.44,1.81 -0.78,-0.25 -1.84,-0.22 -2.38,-0.16 -2.16,0.31 -3.18,-2.6 -5.38,-0.94 0.27,0.4 0.54,0.8 0.81,1.19 -0.43,0.12 -0.85,0.25 -1.28,0.38 1.54,1.1 7.09,3.51 8.66,1.53 0.09,-0.12 0.15,-0.24 0.22,-0.34 0.32,0.75 0.6,1.46 0.78,1.75 0.33,-0.89 1.98,-2.63 1.97,-3.47 -0.01,-1.01 -1.78,-1.31 -2.13,-2.22 0.88,0.37 1.77,0.37 2.66,0 -1.34,-2.01 0.26,-2.75 1.91,-3.38 2.01,-0.77 -0.2,-1.87 -0.91,-2.63 -1.57,-1.66 1.49,-2.42 2.38,-3.06 2.05,-1.45 -0.71,-3.74 1.16,-5.13 -0.83,-0.87 -1.7,-1.13 -2.59,-1.09 z m -17.97,6.81 c 0.09,1.21 -0.71,2.36 -1.97,2.19 2.29,-2.66 -6.24,-0.8 -7.19,-0.75 0.04,2.05 2.61,3.33 3,5.34 0,-1.77 1.11,-0.88 1.41,0.19 0.24,0.87 3.74,0.98 4.31,0.88 3.03,-0.56 3.5,-5.06 0.31,-5.78 0.4,-0.24 0.77,-0.49 1.16,-0.75 -0.27,-0.51 -0.6,-0.93 -1.03,-1.31 z",
						"LV" : "m 472.29,212.66 c 0.12,0.4 0.25,0.8 0.38,1.21 0,-2.1 -0.32,-4.32 1.25,-6.1 0.67,-0.77 1.81,-1.31 2.14,-2.34 0.42,-1.31 0.15,-2.43 0.91,-3.71 1.49,-2.48 3.16,-3.62 5.81,-4.29 1.29,-0.31 4.84,-2.38 5.72,-1.14 1.39,1.94 3.03,2.8 4.65,4.48 1.85,1.89 2.45,4.41 5.18,5.35 2.14,0.72 4.39,-0.23 6.34,-1.56 2.81,-1.92 2.65,-4.22 1.8,-6.96 -0.33,-1.08 -0.68,-2.29 -0.32,-3.5 0.98,0.3 2.08,-0.45 2.92,-0.93 1.67,-0.94 4.9,-2.31 6.47,-1.22 1.03,0.72 3.2,0.51 4.57,1.35 2.04,1.22 3.83,1.56 5.55,3.34 1.41,1.45 2.77,2.33 4.89,1.28 2.34,-1.15 4.66,0.45 6.97,0.66 1.39,0.14 3.62,2.13 4.66,3.06 0.58,0.51 -1.34,5.56 -1.85,6.16 3.55,-0.44 1.66,1.59 3.12,2.19 1.73,0.72 2.44,3.87 2.55,5.61 0.11,1.84 -1.46,1.85 -2.79,2.5 -1,0.51 -1.92,1.56 -2.63,2.43 -0.39,0.49 -0.19,1.61 -0.8,1.94 -1.98,1.07 -3.82,-1.43 -6.01,-0.35 -2.55,1.26 -4.02,2.73 -6.63,1.12 -2.16,-1.33 -4.06,-3.04 -6.05,-4.58 -1.92,-1.49 -4.63,-0.73 -6.55,-2.08 -1.69,-1.17 -1.8,-3.69 -4.39,-2.2 -2.25,1.29 -2.97,1.26 -5.34,1.49 -2.1,0.21 -4.47,-1.21 -6.76,-1.17 -2.38,0.03 -3.99,0.45 -6.1,-0.38 -1.34,-0.52 -4.03,-0.21 -5.55,-0.21 -2.36,0 -4.47,0.4 -6.81,0.98 -1.49,0.35 -4.19,0.8 -4.94,2.5 -0.5,1.1 -1.21,1.38 -1.86,0.45 -1.17,-1.63 -0.75,-3.45 -0.47,-5.37",
						"RO" : "m 464.6,353.75 c 1.22,-0.86 2.12,-0.79 3.3,-0.45 1.14,0.31 1.29,-1.28 2.24,-1.63 1.04,-0.38 2.14,-0.1 3.19,-0.45 1.51,-0.49 1.33,-2.41 2.09,-3.6 0.74,-1.12 1.69,-2.08 2.49,-3.15 1.04,-1.36 0.99,-2.59 1.93,-3.83 0.83,-1.08 1.8,-2.38 2.29,-3.67 0.58,-1.52 0.04,-2.24 1.1,-2.8 1.04,-0.58 1.37,-0.96 2.12,-1.91 1.19,-1.47 3.12,-0.42 4.51,-1.57 1.14,-0.96 1.97,-2.31 3.21,-3.13 1.73,-1.15 3.51,0.3 5.18,0.52 1.59,0.23 3.17,0.58 4.77,0.75 1.92,0.21 4.42,-0.68 6.07,0.49 3.13,2.24 3.34,3.6 6.62,0.51 2.06,-1.92 5.99,-0.94 8.44,-1.36 1.62,-0.28 1.59,-1.35 2.59,-2.4 1.09,-1.15 2.99,-1.28 4.33,-1.12 3,0.37 4.27,3.6 5.33,6.12 1.17,2.82 2.93,5.27 4.89,7.43 2.85,3.18 4.09,5.53 4.96,9.88 0.32,1.61 -0.71,3.22 -1.18,4.74 -0.54,1.73 0.01,3.57 -0.01,5.32 -0.05,2.92 0.52,4.11 2.52,5.72 0.76,0.63 4.13,3.34 4.29,0.58 2.56,1.14 7.97,-4.74 8.99,0.17 1.14,5.4 -2.21,7.57 -6.97,7.54 0.63,-0.51 1.38,-3.52 0.13,-3.46 -1.49,0.05 -0.99,3.67 -2.14,4.6 0.71,-0.17 1.45,-0.3 2.17,-0.35 -1.13,0.51 -3.07,0.66 -1.89,2.17 0.42,-0.35 0.8,-0.73 1.17,-1.14 -0.6,1.8 -2.5,2.8 -2.95,4.67 -0.48,2.01 0.79,4.83 -0.59,6.7 -0.8,1.1 -3.7,-0.12 -4.45,-0.49 -1.04,-0.51 -1.65,-1.28 -2.17,-2.36 -0.32,-0.68 -0.78,0.31 -1.25,0.16 -3.6,-1.22 -6.48,-2.78 -10.42,-1.96 -2.34,0.51 -4.96,0.7 -7.02,2.24 -2.02,1.49 -3.46,3.6 -6,3.99 -2.49,0.37 -4.85,-0.63 -7.27,-0.84 -1,-0.09 -1.97,-0.59 -3,-0.47 -1.41,0.17 -2.2,1 -3.68,0.63 -2.6,-0.65 -5.09,-1.92 -7.82,-2.05 -1.38,-0.05 -4.61,1.57 -5.48,-0.05 -1.29,-2.43 3.52,-2.36 -0.71,-4.44 -1.3,-0.65 -2.67,-1.78 -3.08,-3.32 -0.39,-1.43 2.06,-1.33 2.8,-1.71 -0.75,-1.05 -2.55,-2.08 -3.87,-1.59 -0.91,0.33 -1.65,2.69 -2.71,2.45 -1.06,-0.26 -2.12,-2.13 -3.47,-2.55 -1.46,-0.45 -3.19,-0.72 -4.26,-1.96 1.26,-0.38 1.63,-2.08 0.11,-2.27 1.51,-1.45 1.17,-2.47 -0.5,-3.1 -2.24,-0.86 -4.27,-2.31 -6.18,-3.73 1.97,-3.76 -2.83,-6.03 -4.74,-8.45",
						"CZ" : "m 380.95,296.76 c 1.15,0 2.04,1.01 2.3,2.12 0.44,-4.22 5.25,-2.22 7.26,-3.9 3.74,-3.1 9.42,-4.83 13.82,-6.59 -0.36,-0.37 -0.72,-0.72 -1.1,-1.07 0.99,-0.24 2.13,-0.61 2.88,0.3 0.64,0.82 1.21,2.33 2.45,1.89 0.84,-0.3 2.13,0.12 2.09,-1.17 -0.04,-1.26 0.99,-0.16 1.77,0.05 1.29,0.35 1.38,-0.28 1.71,1.03 0.36,1.42 0.58,0.38 1.41,0.73 1.29,0.56 5.65,0.61 5.64,2.71 0.6,-0.65 2.1,-1.03 2.89,-0.7 2.13,0.91 -0.16,2.38 -1.07,3.18 1.9,0.72 2.53,1.8 3.58,3.43 1.29,2.01 3.56,-0.33 4.81,-1.19 -0.71,-0.65 -1.09,-1.47 -1.13,-2.48 2.84,0.8 5.43,3.13 8.59,2.13 -0.32,1.45 -0.6,3.88 1.42,3.81 1.77,-0.05 1.58,-0.38 3.39,0.54 1.96,0.98 2.93,0.28 3.87,2.54 0.21,0.52 3.98,2.97 2.21,3.66 -2.05,0.79 -3.67,1.15 -5.52,2.55 -1.31,1.01 -1.33,3.76 -2.83,3.92 -2.28,0.24 -3.15,3.24 -6.03,2.64 -2.65,-0.54 -3.55,0.1 -4.65,2.85 -0.88,-3.85 -6.07,-1.08 -8.35,-1.92 -1.88,-0.68 -3.71,-1.47 -5.6,-2.12 -1.54,-0.52 -4.47,-1.4 -6.1,-1.28 0.09,1.1 -0.38,2.15 -0.29,3.24 -1.55,-0.23 -2.77,1.08 -2.81,2.66 -2.3,-0.96 -2.37,0.09 -4.63,-0.14 -1.5,-0.14 -2.73,-1.85 -3.9,-2.69 -1.51,-1.07 -3.12,-1.98 -4.7,-2.94 -1.47,-0.91 -2.88,-3.5 -4.65,-3.95 -2.75,-0.72 -3.26,-4.76 -5.61,-6.1 3.28,-2.69 -2.87,-4.9 -3.13,-7.73",
						"AL" : "m 454.84,428.02 c 0.6,-1.05 1.15,-2.29 0.78,-3.53 1.53,0.28 0.9,-3.57 1.26,-4.81 0.29,-0.96 -1.09,-1 -0.54,-2.22 0.4,-0.93 0.75,-1.89 0.98,-2.87 0.38,-1.68 0.2,-3.53 -1.84,-2.99 -0.66,-2.54 -0.33,-5.61 1.25,-7.75 1.29,-1.71 1.82,-4.2 3.04,-1.43 0.9,2.08 2.71,-0.98 4.13,0.73 0.47,0.56 0.15,1.5 0.64,2.05 0.96,1.07 2.25,0.3 2.99,2.22 0.63,1.63 0.43,7.68 -0.79,8.17 0.04,0.7 0.59,1.42 0.84,2.01 0.03,0.49 -0.11,0.96 -0.4,1.38 -0.25,1.1 0.95,2.2 1.45,2.96 0.67,1.05 0.46,2.45 1.96,2.24 1.45,-0.21 1.47,0.7 1.71,1.85 0.75,3.46 -1.62,3.15 -2.72,5.88 -0.38,0.93 -0.64,3.48 -1.65,3.88 -2.61,1.07 -2.81,0.59 -1.8,3.64 -1.89,-0.21 -0.31,1.49 -2.28,2.08 -1.63,0.49 -2.1,-0.86 -2.26,-2.29 -0.4,-3.78 -4.97,-5.14 -6.87,-8.1 0.7,0.1 1.18,0.52 1.42,1.24 1.1,-1.31 -0.9,-2.15 0.2,-2.62 -0.62,-0.44 -1.13,-1.01 -1.5,-1.71",
						"FI" : "m 468.42,42.64 c 1.69,-1.66 3.64,0.21 5.52,-0.79 -0.42,-0.38 -0.82,-0.77 -1.22,-1.19 5.21,-2.9 9.51,0.66 12.77,4.2 2.28,2.48 7.03,4.11 10.77,3.04 2.04,-0.56 3.34,-0.84 5.06,-2.01 1.59,-1.08 5.44,0.59 6.95,1.03 2.14,0.63 2.93,1.59 5.25,1.17 2.01,-0.35 1.81,-2.99 4.5,-3.17 1.35,-0.09 2.88,-0.66 2.79,-2.29 -0.13,-2.83 1.33,-5.44 2.4,-8.15 2.65,-1.42 5.95,-4.25 8.87,-3.71 2.93,0.52 4.84,-0.24 7.73,-1.42 3.19,-1.29 4.63,1.21 7.1,2.15 2.57,0.98 5.29,1.35 7.86,2.22 7.31,2.52 -6.1,7.31 -0.48,9.31 -1.98,0.65 -3.99,1.05 -5.96,1.71 0.99,0.12 5.01,0.4 2.69,2.38 -2.29,1.96 -2.88,3.52 -0.72,5.54 2.04,1.94 5.01,1.89 7.37,3.29 2.08,1.22 4.13,3.01 6.01,4.48 3.87,2.99 -10.27,8.15 -8.16,11.98 3.03,5.56 9,8.62 10.17,15.59 -1.37,0.09 -2.72,0.56 -4.09,0.8 1.65,0.49 0.35,3.17 -0.66,4.51 -0.95,1.29 1.67,1.64 1.93,2.59 -2.49,0.52 -2.73,2.52 -1.34,3.94 1.35,1.4 4.07,-0.14 4.84,2.06 -5.2,2.17 1.29,4.64 3.07,5.61 3.94,2.13 -3.03,6.07 -5.17,7.07 3.46,2.1 7.18,3.8 10.56,5.98 1.66,1.08 3.23,2.27 4.59,3.67 1.47,1.52 0.67,2.19 -0.47,4.16 -1.82,3.15 -4.26,4.72 -7.11,6.89 -4.01,3.04 -7.45,6.77 -11.45,9.74 -3.74,2.78 -7.72,5.09 -11.56,7.64 -1.71,1.15 -3.39,2.38 -5.01,3.67 -0.78,0.52 -1.45,1.15 -2.01,1.92 -0.99,1.24 -2.69,0.26 -3.84,0.37 -1.65,0.16 -1.55,-1.35 -3.47,-0.45 -1.47,0.66 -2.83,1.22 -4.39,1.22 -0.66,0.05 -1.23,-0.12 -1.73,-0.49 -0.23,0.58 -0.62,0.96 -1.19,1.15 -1.39,0.42 -3.03,-0.3 -4.06,-1.03 0.91,1.24 0.27,1.66 -0.92,1.77 0.11,0.42 0.21,0.84 0.33,1.26 -1.29,0.33 -2.67,-0.21 -2.45,-1.77 -1.45,2.1 -4.92,2.1 -6.99,2.54 -1.17,0.24 -2.22,0.7 -3.36,1.08 -0.86,0.28 -1.06,1.33 -1.92,1.57 -1.59,0.42 -1.89,-1 -3.56,-0.56 -2.53,0.65 -5.4,1.98 -7.94,1.5 0.54,-0.3 1.06,-0.63 1.55,-0.98 -2.08,0.75 -3.67,2.36 -5.92,2.55 0.82,-0.45 1.88,-0.91 2.41,-1.75 1.21,-1.91 -2.04,-0.16 0.92,-1.43 -1.15,0.16 -2,-0.37 -2.81,-1.01 -1.39,-1.14 0.19,-2.2 1.41,-3.27 -1.06,0.33 -8.32,2.73 -5.67,-0.37 -2.21,-0.49 -4.53,-0.47 -6.35,-1.87 -0.76,-0.59 -2.96,-2.45 -2.71,-0.02 -0.66,-0.56 -2.49,-1.21 -2.17,-1.92 0.59,-1.29 -0.64,-4.58 -1.21,-5.74 4.14,0.05 -0.09,-8.52 3.86,-6.28 -1.69,-1.24 -3.63,-4.51 -4.06,-6.63 -0.33,-1.73 1.02,-2.85 0.04,-4.72 -0.7,-1.38 -1.39,-3.29 -2.25,-3.46 1.04,-1.19 3.82,-6.51 5.83,-5.53 -0.92,-0.77 -1.65,-2.13 -0.83,-3.39 1.67,2.13 6.27,0.8 8.41,-0.38 -0.51,-0.45 -2.36,-3.43 0.13,-1.5 -0.38,-0.42 -0.75,-0.84 -1.13,-1.26 1.38,1.64 2.79,-2.9 5.65,-1.5 -0.33,-2.61 3.87,-3.43 5.65,-3.88 -0.07,-0.47 -0.16,-0.93 -0.24,-1.38 1.7,-0.07 2.6,-1 3.7,-2.22 1.8,-1.99 4.31,-2.78 6.23,-4.57 1.26,-1.17 1.93,-2.73 3.39,-3.87 2.24,-1.73 4.53,-0.47 6.68,-0.03 -0.28,-0.4 -0.52,-0.82 -0.74,-1.26 0.71,-0.23 1.35,-0.61 1.92,-1.14 -0.58,-0.87 -2.55,-1.5 -2.2,-2.38 0.56,-1.42 1.51,-3.13 0.4,-4.25 -1.73,-1.71 -7.39,-1.36 -7.45,-4.29 -2.04,1.21 -3.66,0.12 -4.69,-1.49 -1.25,-1.91 -2.52,-2.94 -3.99,-4.6 -2.36,-2.66 4.63,-6.66 1.17,-10.01 -0.63,-0.59 -2.83,-2.34 -2.22,-3.36 0.39,-0.68 2.63,-2.48 1.25,-3.04 -1.89,-0.75 -2.73,0.03 -2.6,-2.71 0.04,-0.84 0.2,-1.73 0.15,-2.57 -0.05,-0.84 1.66,-0.72 1.63,-1.17 -0.08,-1.68 -3.59,-2.52 -4.69,-3.2 -1.07,-0.66 -1.03,-2.03 -2.42,-2.59 -1.39,-0.58 -2.99,-0.59 -4.47,-0.91 -2.64,-0.54 -5.4,-1.87 -7.85,-2.89 -3.75,-1.54 -7.42,-5.06 -11.6,-5.54",
						"GB" : "m 203.28,301.11 c 1.39,0.33 3.09,-2.48 4.06,-3.36 1.8,-1.64 5.68,-0.28 6.78,-2.76 0.12,1.52 3.11,2.99 4.3,3.1 2.22,0.17 3.3,-4.44 3.16,-6.17 0.79,1.38 3.12,-0.02 3.99,-0.35 2.29,-0.87 4.78,0.26 6.63,2.01 0.03,-1.54 1.54,-1.07 2.52,-0.89 1.07,0.21 4.01,-0.77 1.13,-1.36 1.29,0 9.42,-0.03 6.98,-2.34 1.46,1.45 3.12,0.31 4.76,0.7 0.43,0.09 0.63,0.33 0.62,0.73 0.09,0.7 2.69,-0.05 2.67,-0.05 2.37,-0.31 4.63,-0.44 6.99,0.3 2,0.59 4.66,-0.98 6.55,-1.52 1.67,-0.47 2.02,-1.05 3.09,-2.15 1.17,-1.19 3.56,-0.93 4.21,-2.71 0.72,-1.98 -8.08,-2.26 -9.02,-2.38 0.62,-0.17 1.21,-0.42 1.77,-0.72 -1.14,-0.28 -2.37,-0.56 -3.35,0.24 0.95,-1.14 2.34,-0.68 3.62,-0.94 2.12,-0.44 1.93,-2.71 -0.24,-2.96 0.84,0.19 1.33,-0.54 1.97,-0.87 1.27,-0.66 2.33,0.7 3.7,-0.65 -0.4,-0.82 -1.03,-1.29 -1.88,-1.42 0.9,-0.17 3.05,-0.03 0.63,-0.94 3.34,1.03 3.7,-1.19 4.98,-3.66 1.67,-3.17 1.21,-6.24 -2.44,-8.06 -2.1,-1.05 -6.89,-2.54 -8.83,-0.72 -0.66,0.61 -0.83,1.96 -1.74,2.29 -1.38,0.49 -2.38,-1.89 -3.84,-1.54 1.67,-2.9 5.48,-3.08 2.05,-7.29 -2.87,-3.5 -5.77,-3.31 -9.55,-3.8 2.42,-1.12 6.9,-0.16 9,1.52 -0.56,-1.64 -5.93,-6.16 -2.36,-7.19 -2.4,-0.63 -3,-3.06 -4.66,-4.6 -1.55,-1.45 -3.8,-1.4 -5.68,-1.7 -3.12,-0.49 -4.5,-8.1 -4.88,-10.62 -0.64,-4.18 -5.96,-7.8 -9.87,-8.54 -1.03,-0.19 -2.01,-1.66 -3.01,-0.63 -0.66,0.66 -1.29,0.98 -2.24,0.96 -2.52,-0.03 -5.99,0.12 -8.05,-1.98 4.18,3.03 6.46,-1.21 10.4,-1.21 2.24,0 1.29,-1.8 0.03,-2.76 -1.78,-1.36 -3.3,0.8 -5.13,0.58 4.54,-0.93 8.12,-3.15 10.78,-6.94 1.19,-1.71 1.43,-3.73 2.44,-5.47 0.7,-1.21 2.81,-1.99 2.05,-3.8 -1.37,-3.24 -7.51,-2.01 -10.09,-1.71 -2.67,0.31 -5.36,-0.77 -7.92,0.03 -2.14,0.68 -4.53,2.08 -6.67,2.5 0.21,-1.15 1.5,-1.26 1.77,-2.43 -1.31,-0.12 -2.41,0.51 -3.58,0.86 1.27,-1.5 4.97,-0.47 5.41,-2.8 -1.74,-0.4 -3.75,0 -5.33,-1.21 2.92,1.1 2.3,0.38 4.03,-0.89 1.42,-1.03 3.21,-1.47 4.66,-2.48 0.59,-0.4 8.2,-5.79 3.9,-6.65 -2.61,-0.52 -5.71,0.73 -8.16,1.22 -1.38,0.28 -2.84,0.63 -4.27,0.51 -0.36,-0.02 -0.84,-0.09 -1.13,-0.4 -0.44,-0.51 -1.98,0.77 -2.53,1.05 1.06,-2.1 0.09,-0.65 -0.88,-1.21 -0.38,-0.23 -1.1,-1.05 -1.59,-0.93 -1.02,0.24 -0.31,3.34 -1.73,4.08 0.48,0.26 1.49,0.59 1.54,1.1 -3.78,-1.7 -2.28,2.31 -3.98,2.9 0.95,0.38 1.77,1.12 2.22,2.06 -1.11,0.45 -5.4,-1.12 -4.82,1.33 -0.6,-2.24 -2.87,1.56 0.24,3.39 -0.8,-0.1 -1.59,-0.14 -2.37,-0.12 0.05,2.36 1.96,2.36 3.66,2.19 -0.84,0.28 -1.59,0.73 -2.22,1.33 1,-0.4 2.2,-0.17 2.92,0.86 -1.73,-1.84 -3.43,1.7 0.03,1.45 -0.36,0.14 -5.96,0.38 -1.93,1.82 -1.85,-1.56 -3.43,1.35 -1.1,1.82 -0.95,-0.14 -1.46,0.35 -1.38,1.33 -1.34,-0.61 -2.97,-0.45 -3.95,0.49 1.92,0.45 4.35,-0.84 6.14,0.37 -1.39,-0.63 -2.09,0.98 -3.48,0.37 1.63,4.99 6.99,-1.07 8.83,-2.19 -0.68,0.87 -0.99,2.26 0.84,1.45 -0.92,0.19 -5.61,2.52 -2.46,2.19 -0.36,0.4 -0.71,0.8 -1.06,1.21 0.83,0.05 1.65,-0.03 2.44,-0.24 -0.46,0.28 -2.65,0.37 -2.77,0.56 -0.35,0.51 -0.91,0.94 -1.41,1.29 -0.58,0.42 -0.01,1.59 -0.03,2.26 0,0.7 -2.71,5.33 -0.31,1.96 -1.27,1 -0.64,4.78 1.11,3.03 -2,1.26 -1.81,3.67 -3.01,5.51 -0.83,1.29 2.3,2.24 2.36,-0.33 0.03,-1.84 2.16,-3.97 1.38,-5.72 -1.1,-2.48 2.34,-4.01 3.75,-4.92 -0.91,0.91 -3.39,2.27 -2.95,4.01 0.28,0.8 0.76,1.01 1.43,0.61 0.46,0.77 1.03,1.47 1.7,2.06 0.19,-1.03 -0.51,-2.06 -1.41,-2.55 0.78,-1.29 1.37,-0.44 1.69,0.61 1.47,-1.52 0.07,-4.41 2.05,-4.01 -0.75,0.7 -0.78,1.5 -0.11,2.43 -0.47,-2.31 1.11,0.12 2.52,0.72 -0.92,-0.05 -3.08,-0.86 -3.34,0.54 -0.47,2.66 1.23,2.61 2.21,4.5 1.67,3.2 -5.04,5.07 -3.32,8.89 -0.16,-0.26 -1.84,-1.71 -1.96,-0.87 -0.25,1.56 2.4,3.67 3.34,4.65 -1.14,-2.71 -0.12,-3.25 2.45,-2.1 2.13,0.94 2.53,0.87 2.4,-1.68 2.6,2.43 4.02,1.45 6.64,0.65 0.8,-0.24 2.09,-0.51 1.81,-1.71 1.86,0.24 3.71,0.1 5.57,0.24 -1.97,1.4 -4.43,1.59 -5.44,4.13 -0.63,1.61 1.22,6.98 3.44,5.67 -0.27,0.87 -0.05,1.66 0.64,2.36 0.43,-0.68 0.79,-1.38 1.1,-2.13 0.44,1.45 1.58,0.73 2.3,0.24 -0.66,1.05 -0.55,2.4 -1.34,3.53 -0.44,0.66 -2.26,3.38 0.47,2.96 -2.67,1.43 -1.42,6.33 1.86,5.2 -1.45,1.15 -6.46,-3.29 -3.74,1.52 -3.38,-2.78 -7.64,0.09 -11.06,0 1.13,-1.61 -2.97,-3.11 -3.91,-2.22 -1.89,1.78 1.65,4.29 3.47,2.47 -1.67,2.15 -4.19,3.41 -5.77,5.67 2.32,0.17 4.19,-2.52 6.6,-1.31 -0.5,1 0.09,1.96 1,2.48 -1.31,0.65 -0.8,2.47 0.75,2.24 -1.27,0.19 -1.26,1.47 -1.66,2.45 -0.54,1.28 -2.09,2.05 -3.28,2.52 -2.64,1.05 -6.51,1.78 -8.09,4.13 1.02,0.4 1.43,1.24 0.75,2.12 1.25,0.26 2.45,0.12 3.19,-0.94 -0.48,1.14 -1.63,1.5 -2.8,1.42 1.7,2.03 6.18,-0.28 7.66,-1.42 0.05,1.71 1.94,1.77 3.04,1.42 -0.42,0.72 -1.04,0.93 -1.88,0.59 0.48,2.05 1.85,1.05 2.96,0.47 1.71,-0.86 2.92,2.01 4.53,2.73 2.93,1.29 3.19,-1.4 5.48,-1.75 2.51,-0.38 4.11,-1.77 6.03,-3.34 -1.75,2.41 -4.35,4.09 -6.28,6.37 -0.5,0.59 0.36,1.31 -0.79,1.45 -1.3,0.19 -2.63,0.26 -3.97,-0.02 -1.89,-0.4 -5.06,-1.08 -6.75,0.05 -1,0.66 -0.96,2.01 -2,2.69 -1.41,0.94 -1.9,-1.4 -2.2,1.4 -0.12,1.12 -2.38,5.37 -3.76,5.06 -0.86,-0.21 -1.06,-0.17 -1.3,0.82 -0.36,1.56 -2.4,2.27 -3.64,2.83 -1,0.45 -2.12,0.94 -2.93,1.7 -0.33,0.31 0.23,1.4 0.62,1.29 1.37,-0.31 2.95,-1.59 3.83,0.52",
						"IE" : "M 181.97 229.19 C 181.31 229.26 180.62 229.56 179.75 230.25 C 181.18 231.46 180.72 233.41 178.97 233.38 C 179.22 231.92 180.17 231.93 179.03 230.22 C 178.4 229.26 176.87 229.38 178 231.06 C 176 231.34 173.98 230.34 172 231.53 C 170.89 232.21 170.16 234.29 171.22 235.53 C 169.65 234.99 169.74 235.67 170.31 236.69 C 169.04 236.23 167.61 236.6 167.34 238 C 169.27 239.05 171.33 238.43 173.31 238.81 C 173.23 240.82 169.73 240.68 168.66 242.38 C 169.1 242.62 169.54 242.84 170 243.06 C 168.25 245.02 163.87 241.09 163.44 244.94 C 163 242.84 160.75 242.41 159.06 242.53 C 157.25 242.64 154.95 244.59 154.56 242.72 C 154.13 243.44 153.86 244.21 153.78 245.06 C 154.01 244.64 154.3 244.27 154.59 243.91 C 155.28 244.54 155.39 245.21 154.94 245.91 C 156.8 244.82 155.83 246.82 156.69 248.03 C 156.41 247.82 154.98 247.87 155.5 248.53 C 155.17 248.11 161.5 248.53 158.41 249.59 C 157.79 249.8 156.64 249.7 156.16 250.16 C 155.18 251.05 156.06 251.95 157.06 252.13 C 156.3 252.04 155.41 251.78 154.84 252.19 C 153.97 252.82 154.51 252.99 153.19 253.22 C 153.6 253.48 154 253.75 154.41 254.03 C 154.07 254.31 153.74 254.61 153.38 254.88 C 154.58 255.54 155.34 254.4 156.53 254.75 C 156.36 255.15 156.17 255.54 156 255.94 C 157.26 256.09 159.04 257.17 160 257.16 C 161.98 257.14 163.85 257.2 165.84 257.34 C 164.91 258.48 159.84 258.45 161.03 261 C 161.88 262.78 157.01 265.42 156.06 266.19 C 159.81 265.47 162.33 265.56 165.38 263.38 C 165.78 264.21 166.6 264.75 167.47 264.78 C 164.92 265.03 162.71 266.1 160.09 266.06 C 157.83 266.03 157.42 268.08 155.25 268.06 C 155.89 268.81 156.41 269.67 156.78 270.56 C 155.6 270.81 154.36 269.77 153.88 270.06 C 153.37 270.38 152.7 270.41 152.09 270.5 C 150.96 270.66 149.29 270.9 150.03 272.56 C 151.97 272.07 154.57 271.29 156.66 272.22 C 155.26 271.75 149.06 275.17 151.28 276.97 C 153.26 278.56 156.2 275.64 158.22 275.97 C 156.13 276.25 154.76 278.01 153.44 279.41 C 153.8 279.37 154.16 279.33 154.53 279.28 C 155.66 278.32 158.46 277.43 160.03 278.25 C 158.83 278.6 157.63 279.07 156.75 280 C 157.47 279.65 158.23 279.4 159.03 279.28 C 158.21 279.68 157.61 280.33 157.22 281.19 C 158.91 280.29 161.18 280.91 163.03 280.25 C 164.69 279.67 166.48 279.72 168.06 279 C 168.73 278.7 169.44 279.4 169.75 278.59 C 170.03 278.14 170.39 277.8 170.88 277.59 C 171.95 276.91 172.48 276.02 170.69 275.5 C 171.61 275.12 173.9 274.57 172.81 276.56 C 175.01 276.72 175.61 274.31 177.28 274.31 C 179.44 274.31 178.39 272.93 179.72 272.41 C 181.08 271.89 186.1 272.87 185.47 270.34 C 186.23 272.12 188.26 271.03 189.69 271.31 C 191.6 271.66 193.06 269.4 190.44 269.03 C 192.84 269.33 193.47 265.83 193.97 264.09 C 194.93 260.77 195.63 258.79 193.22 255.47 C 196.3 254.84 192.84 251.5 192.88 250.22 C 192.9 249.31 191.5 247.68 191.72 247.47 C 192.33 246.82 193.33 246.79 194.09 246.38 C 192.53 244.99 192.62 245.82 191.63 245.91 C 190.39 246.03 188.37 246.47 188.84 244.38 C 186.82 244.48 186.89 241.78 185.22 241.63 C 183.73 241.5 183.47 242.32 183.31 243.53 C 183.03 245.63 181.63 245.1 180.09 245.03 C 178.33 244.94 176.72 243.66 175.44 242.47 C 172.48 239.74 176.06 239.96 178.03 238.59 C 177.46 238.19 176.9 237.75 176.38 237.28 C 178.45 237.91 180.77 235.77 181.16 233.94 C 181.58 231.79 184.47 231.43 185.63 229.88 C 184.05 229.58 183.06 229.07 181.97 229.19 z M 190.53 231.56 C 188.74 231.6 186.92 232.92 185.19 232.09 C 185.13 234.64 182.29 232.52 181.34 233.94 C 180.86 235.39 179.75 237.69 177.09 237.66 C 177.53 238.05 177.95 238.31 178.44 238.63 C 177.32 239.44 175.39 239.66 174.47 240.69 L 174.63 241.34 C 174.35 242.23 183.11 248 183.25 242.97 C 183.66 240.38 186.12 241.63 186.47 242.13 C 187.23 243.33 188.05 244.64 188.97 243.97 C 190.19 243.86 191.39 244.76 192.75 245.19 C 194.38 245.68 194.17 243.39 195.47 243.25 C 195.96 243.18 197.38 242.3 197.19 241.63 C 196.92 241.34 196.57 241.29 196.19 241.5 C 196.62 240.9 196.63 240.05 195.84 239.59 C 197.07 239.31 197.51 240.63 197.38 241.63 C 198.84 241.2 197.83 239.3 197.31 238.34 C 196.77 237.42 194.87 238.34 194.22 238.41 C 194.43 238.17 196.09 237.23 196.16 236.81 C 196.01 236.9 194.36 235.08 194.44 235.28 C 193.95 234.29 193.26 232.77 192.31 232.09 C 191.72 231.7 191.13 231.55 190.53 231.56 z ",
						"PL" : "m 402.05,262.18 c 0,-2.82 4.06,-3.55 2.65,-6.82 -0.48,-1.14 -1.65,-2.83 -1.17,-4.2 0.23,-0.65 2.34,0.17 2.79,0.17 -0.2,-0.93 0,-1.75 0.63,-2.48 -0.12,0.19 -0.24,0.38 -0.36,0.59 -0.67,-0.61 -1.46,-0.98 -2.37,-1.07 0.46,1.26 -1.42,0.54 -1.49,-0.59 2.61,1.03 6.91,-1.33 9.34,-2.31 2.91,-1.21 9.91,-0.87 11.8,-3.34 2.33,-3.01 7.61,-4.41 11.15,-5.35 4.43,-1.17 10.5,-2.13 14.05,1.1 -0.96,-0.72 -2.12,-1.43 -3.4,-0.94 1.45,1.45 1.69,4.27 3.87,4.93 2.61,0.79 6.24,-0.4 8.83,-1.15 -1.15,0.68 -2.55,0.87 -3.68,1.63 -1.63,1.1 1.77,0.51 2.37,0.16 4.59,-2.71 7.78,-0.49 12.63,-0.49 6.46,0 13.18,0.96 19.65,0 4.84,-0.72 8.04,2.15 8.87,6.65 0.86,4.62 5.91,10.06 3.91,15.13 -0.99,2.57 -4.13,1.43 -5.59,3.41 -1.46,1.98 -2.79,3.73 0.35,4.34 5.04,1 0.35,5.27 1.63,8.15 1.34,3.03 2.32,8.87 5.93,9.76 -0.64,0.33 -1.31,0.65 -1.97,0.93 1.75,1.78 2.1,3.81 -0.71,4.88 -2.81,1.07 -5.34,3.83 -7.5,5.98 -1.94,1.92 -5.37,4.58 -4.46,7.54 0.38,1.24 0.15,2.57 0.52,3.8 0.29,0.98 1.35,0.65 1.1,1.98 -1.75,-1.36 -4.51,-1.35 -6.56,-2.12 -2.01,-0.77 -2.92,-2.41 -5,-2.99 -2.05,-0.59 -4.35,-0.93 -6.44,-0.03 -2.69,1.14 -2.95,0.09 -5.48,-0.23 -1.94,-0.26 -2.69,0.14 -4.19,1.42 -0.66,0.54 -1.49,1.24 -2.34,1.33 -1.47,0.12 -0.91,-1.5 -1.45,-2.24 -0.59,-0.8 -1.97,-1.45 -2.71,-2.45 -1.19,-1.57 -4.42,1.91 -5.8,2.1 0.42,-1.24 -4.45,-6.82 -6.14,-7.31 -1.9,-0.54 -2.8,-1.38 -4.7,-0.75 -1.98,0.65 -2.02,-2.82 -1.75,-4.04 -3.16,0.98 -5.75,-1.33 -8.59,-2.13 0.04,1.01 0.42,1.84 1.13,2.48 -1.25,0.86 -3.52,3.18 -4.81,1.19 -1.04,-1.63 -1.67,-2.73 -3.58,-3.43 0.52,-0.47 2.49,-1.56 2.1,-2.52 -0.5,-1.28 -3.21,-0.73 -3.92,0.03 0.01,-3.24 -5.65,-0.94 -6.82,-2.78 -1.11,-1.78 -0.33,-1.92 -2.45,-2.57 -1.51,-0.45 -0.6,2.55 -2.92,1.82 1.89,-4.58 3.07,-6.05 -0.2,-8.45 -1.41,-1.01 -0.24,-2.17 -1.34,-3.24 -1.45,-1.36 0.2,-2.01 0.5,-3.48 0.17,-0.89 -0.12,-2.52 -0.2,-3.45 -0.09,-0.91 -1.92,-0.68 -1.53,-2.22 0.25,-1.01 1.5,-2.01 0.2,-2.83 -1.57,-1 -3.05,-2.15 -4.38,-3.48",
						"GE" : "m 666.95,390.93 c 0.46,-5.42 11.79,-0.33 13.99,0.56 2.61,1.03 4.82,2.38 7.98,1.85 1.5,-0.24 2.72,-0.79 3.95,0.23 1.09,0.91 2.72,-0.05 3.95,0.45 0.94,0.4 1.41,1.57 2.22,2.15 0.99,0.72 2.22,1 3.38,1.4 0.96,0.31 2.01,0.68 2.76,1.36 1.03,0.96 -0.52,1.66 0.64,2.2 2.97,1.36 8.77,-4.51 10.17,0.05 0.35,-1.63 1.42,-1.68 2.5,-1.21 0.62,0.03 1.18,0.17 1.7,0.45 0.47,0.52 0.76,1.63 1.46,1.89 1.13,0.45 3.74,-0.84 4.06,1.07 0.23,1.36 -1.45,2.68 -0.35,3.88 1.7,1.84 4.17,1.54 6.2,2.57 3.26,1.66 -2.13,2.8 -0.79,5.02 0.8,1.35 5.16,3.5 4.82,5.27 -0.74,3.99 -4.81,-0.09 -5.97,0.35 -3.11,1.15 -4.41,-2.68 -7.09,-3.27 -1.07,-0.23 -2,0.3 -2.92,1.03 -0.88,0.68 -3.12,1.49 -2.83,2.01 -1.82,0.14 -3.56,-0.26 -5.37,-0.14 -1.9,0.14 -3.63,1.05 -5.57,1.05 -1.89,-0.02 -2.87,0.35 -4.25,-0.33 -0.58,-0.28 -3,-0.47 -1.84,-1.73 -1.57,-0.58 -2.34,-3.24 -4.35,-2.85 1.25,-2.26 -2.06,-1.05 -2.73,0.28 -0.48,0.94 -4.86,-0.03 -5.92,-0.28 -1,0.16 -0.64,1.29 -1.88,0.87 -1.3,-0.44 -2.68,-0.54 -1.77,-2.19 1.38,-2.47 2.42,-4.01 1.13,-6.51 -1.25,-2.38 -1.04,-5.46 -2.25,-7.87 -1,-1.98 -3.35,-1.77 -4.45,-3.67 -1.02,-1.77 -3.64,-2.01 -5.45,-2.29 -2.51,-0.4 -2.76,-3.31 -5.14,-3.67",
						"BA" : "m 418.56,367.97 c -0.01,-3.76 2.84,-1.08 4.17,0.09 1.42,1.28 2.48,0.21 3.11,-1.42 0.6,-1.56 2.79,-0.51 3.78,-0.28 0.23,-1.52 6.05,1.03 7.39,1.03 0.94,0 2.59,1.01 3.35,0.45 1.78,-1.31 1.27,0.26 2.83,-0.1 1.89,-0.45 3.51,0.05 5.24,0.8 1.43,0.65 0.46,2.15 2.33,2.26 1.18,0.07 2.83,-1.28 3.83,-0.73 1.62,0.89 0.15,3.29 -0.58,4.27 -2.4,3.24 0.07,4.34 2.21,6.14 3.7,3.1 -1.17,1.56 -1.75,2.43 -0.08,0.1 2.46,3.69 2.44,4.58 -0.01,0.77 -5.13,1.8 -5.96,1.5 -0.27,1.43 1.38,2.01 0.72,3.53 -0.72,-2.92 -4.81,0.79 -3.64,3.2 -4.18,-0.96 0.39,6.44 -1.67,6.16 -1.62,-0.23 -4.39,-2.12 -5.61,-3.2 -0.66,-0.58 -0.79,-1.35 -1.71,-1.54 -0.94,-0.17 -1.22,0.8 -1.88,-0.4 2.77,-0.03 -2.34,-4.78 -2.81,-5.42 -2.41,-3.32 -4.25,-4.44 -6.44,-7.19 -1.13,-1.4 -2.67,-2.13 -3.82,-3.46 -1.38,-1.56 -0.4,-4.06 -1.69,-5.79 -0.99,-1.33 -2.29,-1.66 -3.51,-2.61 -0.62,-0.45 -0.21,-3.27 -0.31,-4.3",
						"BE" : "m 283.12,286.25 c 2.72,-1.5 5.47,-3.04 8.48,-3.88 -0.56,2.13 2.46,1.43 3.55,1.68 1,0.23 1.5,0.7 2.59,0.38 1.35,-0.38 2.8,-2.76 3.35,-0.54 -0.19,-0.49 -0.36,-1.01 -0.5,-1.52 1.03,0.23 2.28,0.17 2.09,-1.31 0.84,0.66 2.18,1.05 2.81,-0.1 0.59,1.42 2.55,0.94 3.24,0 0.95,3.32 5.57,3.31 8.32,4.48 -1.41,1.78 -3.13,4.99 -0.25,5.32 1.34,0.14 5.4,1.17 3.82,3.41 1.53,-0.28 1.49,1.61 1.96,2.61 -1.77,0.33 -1.57,1.38 -2.65,2.34 -0.44,0.38 -1.58,-0.61 -2.55,1.07 -0.82,1.42 -1.49,2.1 -1.25,3.32 0.24,1.22 2.12,2.03 0.98,3.41 -2.02,2.45 -4.37,-0.23 -5.73,-1.47 -1.03,-0.93 -3.67,-0.94 -4.43,-1.89 -0.51,-0.61 -0.2,-3.76 -0.35,-4.67 -1.02,0.44 -1.29,1.35 -2,2.1 -1.3,1.38 -3.43,0.77 -5.05,0.49 0.32,-1.4 0.96,-3.25 -0.25,-4.48 -0.95,-0.94 -3.47,-0.93 -4.46,-0.23 0.08,-2.24 -0.87,-2.08 -2.42,-2.76 -1.85,-0.8 -1.81,-0.54 -2.88,-2.19 -0.59,-0.89 -3.54,-0.66 -4.66,-1.22 -1.69,-0.86 -0.91,-2.85 -1.74,-4.34",
						"BG" : "m 486.34,385.46 c 0.01,-1.87 1.66,-4.43 2.83,-5.82 0.38,-0.44 3.24,1.07 3.39,1.49 0.43,1.1 -1.69,2.22 -1.13,3.34 0.8,1.66 5.85,0.09 7.37,0.42 2.48,0.56 5.12,2.45 7.72,1.47 2.1,-0.79 4.65,-0.17 6.82,0.02 3.2,0.26 4.82,1.82 7.94,-0.61 2.42,-1.85 4.13,-3.38 7.13,-3.92 2.73,-0.49 5.73,-2.1 8.25,-0.63 1.61,0.93 3.97,1.7 5.87,1.31 0.66,-0.12 2.88,2.68 3.78,3.06 1.21,0.54 3.5,-0.52 3.56,1.4 0.07,2.08 0.21,3.67 -2.13,3.48 -2.33,-0.19 -3.56,1.64 -4.66,3.73 -0.95,1.8 -0.23,3.8 -1.38,5.77 -0.36,0.59 -0.76,1.17 -1.14,1.75 -0.6,0.94 -1.65,0.31 -2.29,1.43 2.84,0.72 3.23,2.96 4.92,5.04 2.09,2.55 -2.92,2.52 -4.38,2.06 -1.58,-0.49 -1.63,-2.4 -3.72,-1.77 -1.55,0.47 -2.75,1.49 -4.39,1.47 -2.21,-0.03 -0.63,0.86 -1.38,1.52 -0.71,0.65 -3.01,0.51 -2.16,2.06 -5.6,-1.35 0.36,3.17 -3.35,5.11 -1.94,1.01 -4.77,0.1 -7.02,1.05 -1.55,0.66 -2.59,-1.89 -3.99,-2.03 -2,-0.19 -2.13,0.86 -3.56,-1.21 -0.96,-1.4 -2.18,-1 -3.7,-0.73 -2.08,0.37 -3.75,2.01 -5.95,2.15 -2.56,0.14 -5.09,1.49 -7.58,0.47 1.02,-3.11 0.59,-5.6 -0.66,-8.27 -0.42,-0.89 -1.45,-1.08 -2.17,-1.56 -1.25,-0.84 -2.04,-2.17 -3,-3.31 3.26,-2.41 -0.31,-3.57 1.25,-6.87 0.59,-1.22 1.62,-0.37 2.44,-0.89 1,-0.66 2.37,-2.89 2.89,-3.99 -2.8,-0.98 -5.81,-4.95 -6.4,-7.99",
						"RS" : "m 458.84,352.91 c -0.83,0.1 -1.62,0.33 -2.16,0.8 -1.8,1.59 -4.59,2.03 -6.79,2.75 0.55,1.63 0.78,2.2 1.04,3.88 0.16,1.08 0.58,1.42 1.61,1.47 -3.05,2.19 2.4,3.55 3.27,4.53 -0.13,-0.14 -3.12,0.65 -3.51,0.8 0.8,1.54 -0.19,2.22 -0.29,3.71 1.02,-0.93 2.48,-1.01 3.82,-1.28 -0.09,0.21 -0.31,0.47 -0.33,0.63 -0.42,2.4 -2.61,4.72 -2.69,7.19 0.4,1.47 3.13,1.92 4.07,3.52 0.44,0.77 1.92,1.17 -0.08,1.92 -0.84,0.31 -1.53,-0.51 -2.24,-0.31 -0.39,0.1 3.94,5.58 0.56,6.03 -2.01,0.26 -3.67,0.14 -3.23,1.19 0.43,1.05 2.96,3.29 3.9,3.95 0.92,0.68 1.31,1.01 3.16,2.01 3.76,2.03 6,1.84 5.26,1.52 -1.31,-0.58 -0.15,0.63 -0.04,0.82 0.24,0.47 3.68,0.89 4.1,-0.84 0.46,-1.82 2.09,-0.52 1.34,-2.64 0.71,-0.1 -0.43,-0.03 0.17,-0.47 0.21,2.24 3.58,3.52 4.8,5.2 0.39,0.52 1.51,-0.26 2.8,0.47 0.52,0.3 1,0.79 0.8,1.77 -0.28,1.42 -1.82,2.96 -1.17,4.53 0.59,1.43 3.83,-0.87 4.85,-0.7 0.99,0.16 7.96,-0.89 5.93,-2.87 -0.84,-0.84 -0.99,-3.22 -0.21,-4.32 0.75,-1.08 2.01,-0.24 2.89,-1.28 0.86,-1 1.71,-2.31 2.28,-3.52 -1.43,-0.51 -3.21,-2.55 -4.27,-3.67 -3.43,-3.64 -1.23,-6.75 1,-10.39 -0.44,-0.45 -3.07,-2.99 -2.06,-3.67 0.84,-0.58 1.89,-0.21 2.75,-0.65 -0.76,-1.07 -2.83,-2.5 -4.14,-1.43 -0.4,0.33 -1.66,2.41 -2.08,2.4 -0.56,-0.02 -1.54,-1.64 -2.16,-1.91 -1.43,-0.65 -3.04,-1.15 -4.42,-1.92 -1.02,-0.58 -0.39,-0.37 -1.43,-0.79 1.39,-0.77 2.01,-2.01 0.16,-2.26 2.21,-2.12 0.54,-2.55 -1.21,-3.25 -1.78,-0.72 -4.7,-2.08 -6.23,-3.22 2.2,-4.2 -1.5,-4.69 -2.97,-7.12 -1.04,-1.75 -4.34,-2.94 -6.86,-2.59 z",
						"XK" : "m 462.89,399.1 c 0.23,-0.94 0.42,-1.47 1.01,-1.19 0.24,0.23 0.7,0.53 1.25,0.58 0.53,-0 1.73,0.18 2.39,-0.31 0.8,-0.36 0.68,-0.85 0.93,-1.27 0.22,-0.36 0.16,-0.31 0.6,-0.71 0.71,-0.1 1.03,-0.54 0.72,-1.39 0.36,0.9 2.83,2.9 2.98,2.99 0.95,0.52 1.9,1.78 2,1.79 0.97,0.02 1.39,-0.07 1.95,0.04 0.15,-0 0.99,0.18 1.38,1.05 0.36,1.87 -1.96,3.87 -1.04,5.55 -0.97,0.64 -1.6,0.27 -1.51,1.8 -1.79,-0.51 -1.75,-1.15 -4.39,-0.03 -0.52,0.5 -1.02,0.57 -1.24,1.2 -0.48,1.34 -1.17,2.49 -1.94,2.88 -0.25,-0.56 0.36,-3.48 -0.57,-5.26 -0.56,-1.05 -3.16,-1.1 -3.1,-2.3 -0.09,-1.36 -0.6,-1.99 -1.77,-1.98 -0.2,8.8e-4 0.68,-0.78 0.38,-0.88 -0.24,-0.75 -1.04,-1.95 -1.01,-2.24",
						"ME" : "m 446.2,401.88 c 2.8,-0.49 -2.53,-7.17 1.82,-6.16 -1.17,-2.41 2.92,-6.12 3.64,-3.2 0.66,-1.52 -0.99,-2.1 -0.72,-3.53 1.75,0.63 2.17,1.77 3.62,3.17 1.96,1.89 2.56,2.75 4.92,4.04 0.92,0.51 3.68,0.17 4.22,1.28 0.82,1.68 -1.47,1.56 -1.73,1.77 -0.76,0.65 1.84,2.36 0.47,3.1 -0.94,0.49 -2.06,1.12 -2.77,-0.05 -0.4,-0.63 -0.63,-1.96 -1.61,-0.82 -2.5,2.9 -3.43,6.14 -2.45,9.9 -1.69,-1.07 -3.4,-2.96 -4.49,-4.67 -0.33,-0.52 -3.17,-3.18 -3.79,-3.1 1.07,-0.49 0.84,-0.4 2,0.23 0.19,-1.92 -3.75,1.29 -3.12,-1.94",
						"EE" : "m 518.09,170.56 c 1.03,2.61 -6.08,1.52 -7.13,1.47 0.16,1.94 -2.49,0.76 -3.34,0.63 -1.69,-0.28 -2.72,2.08 -4.41,1.06 0.13,0.52 0.34,1.01 0.59,1.47 -1.85,0.05 -4.35,-0.42 -5.88,1.19 -0.63,0.66 -0.4,1.9 -0.72,2.69 0.42,-0.24 0.82,-0.49 1.25,-0.72 0.72,1.42 -2,2.42 -0.69,3.63 0.75,0.68 2.83,-0.15 3.81,0.13 -1.42,0.58 -4.51,0.19 -3.84,2.66 1.47,0.04 6.2,7.1 8.5,3.25 0.76,-1.26 2.57,-0.67 1.66,0.59 -0.7,0.98 -1.39,4.24 -1.75,5.5 2.59,0.79 5.44,-2.62 8.09,-2.66 1.13,-0.02 1.8,0.81 3.06,0.72 0.98,-0.09 2.44,1.24 3.28,1.63 2.97,1.31 5.26,4.24 8.5,4.91 1.51,0.33 2.93,-1.29 4.5,-1.06 1.38,0.21 2.43,1.11 3.91,1.06 -0.31,-2.66 2.74,-3.44 4.47,-4.72 -1.85,-0.26 -0.76,-1.68 -1.56,-2.63 -0.52,-0.61 -1.66,-1 -1.84,-1.88 -0.27,-1.19 0.69,-2.2 0.5,-3.41 -0.2,-1.35 -0.88,-2.52 -0.75,-3.97 0.19,-1.91 3.01,-2.98 3.84,-4.81 0.87,-1.91 1.35,-3.1 3.66,-3.06 -0.6,-2.64 -9.65,-0.84 -11.97,-1.16 -2.37,-0.31 -4.36,-1.36 -6.81,-1.66 -2.77,-0.33 -6.37,0.07 -8.94,-0.84 z m -28.16,13.91 c -0.32,0.01 -0.63,0 -0.97,0.03 -1.47,0.12 -2.28,-0.2 -3.56,0.91 -0.99,0.86 -2.94,0.17 -4.06,0.31 1.45,1.28 -0.39,2.53 1.56,3.88 2.28,1.56 -1.39,2.51 -0.06,4 1.88,-0.7 1.54,-2.26 2.66,-3.5 0.79,-0.87 2.13,-0.58 3.09,-0.97 0.54,0.03 1.07,0.11 1.59,0.22 0.58,-0.38 1.13,-0.78 1.66,-1.25 1.15,-0.61 2.2,-2.02 3.59,-1.53 -1.63,-1.71 -3.28,-2.15 -5.5,-2.09 z",
						"AM" : "m 702.27,421.63 c 1.65,-0.73 3.97,-0.23 5.76,-0.68 2.88,-0.73 5.89,-0.47 8.76,-0.68 -0.5,-0.51 -0.28,-0.77 0.64,-0.8 0.8,-0.63 1.18,-0.47 1.11,0.52 0.29,0.35 3.13,2.19 0.38,1.54 1.7,1.59 4.7,1.61 5.24,4.44 -3.97,1.28 -0.31,4.93 1.18,6 0.78,0.56 2.68,0.94 2.72,2.22 0.08,2.47 -2.73,2.08 -4.05,2.62 1.19,0.52 5.34,5.88 6.72,5.32 0.7,-0.28 3.67,0.77 2.4,1.54 -1.9,1.14 0.91,2.68 1.39,3.45 -1.86,0.24 -1.26,3.97 -0.71,4.88 -1.73,-0.65 -3.54,1.17 -4.46,-0.93 -0.9,-2.01 -0.76,-4.18 -2.6,-5.25 -0.86,-0.51 0.2,-2.66 -0.82,-3.1 -0.96,-0.44 -1.69,0.23 -2.6,0.66 -1.46,0.7 -1.9,-1.91 -3.58,-0.91 0.6,-3.22 -3.7,-1.47 -5.28,-2.89 -1.46,-1.31 -2.04,-3.13 -4.29,-3.06 -2.33,0.09 -4.22,-0.28 -6.14,-1.43 1.13,-0.75 0.42,-1.61 -0.04,-2.31 -0.84,-1.31 -0.24,-2.36 0.67,-3.66 2.44,-3.48 -2.75,-4.74 -2.42,-7.5",
						"ES" : "m 178.19,385.56 c -0.68,0.45 -1.38,0.92 -2.06,1.38 -0.19,-2.48 -4.6,1.34 -4.16,2.84 0.47,-0.14 0.9,-0.28 1.34,-0.47 -0.72,0.47 -2.05,1.14 0.09,1.03 -2.55,1.28 -6.74,0.25 -8.47,2.44 -0.9,1.14 -2.03,0.7 -2.5,2.38 -0.29,1.05 -0.17,2.28 1.19,2.16 -0.09,0.19 -0.17,0.4 -0.25,0.59 0.55,1.75 1.9,1.49 2.91,0.56 -0.99,0.91 -2.6,2.23 -1.41,3.88 0.43,-1.43 1.96,-1.32 2.81,-2.28 -0.09,1.17 -1.73,1.58 -1.69,2.72 0.05,1.61 1.47,1.49 2.41,1.03 -0.92,0.58 -2.02,1.09 -2.16,2.41 1.09,-0.02 2.19,-0.35 2.66,-1.47 -0.56,2.54 -3.92,2.89 -2.5,6.16 1.22,-0.66 1.99,-1.97 3.41,-2.25 1.15,-0.23 2.37,-0.26 3.22,-1.19 -0.08,0.94 0.37,1.51 1.28,1.38 -1.11,0.93 -2.19,3.71 0.25,3.19 1.55,-0.33 3.06,-1.39 4.72,-0.69 1.03,0.44 4.05,1.13 4.09,-0.81 0.03,-1 5.21,-0.41 6.19,-0.09 1.37,0.44 -0.33,2.38 0.59,2.91 0.83,0.47 3.04,0.77 3.34,1.94 0.36,1.43 -2.96,3.94 -3.81,4.5 -1.38,0.89 -1.91,2.68 -3.34,3.06 0.8,-0.21 0.95,6.55 1.03,7.22 0.11,0.89 0.55,2.35 -0.34,2.84 -0.19,0.09 -2.41,1.09 -1.47,1.69 2.13,1.33 0.35,3.73 -0.19,4.91 -0.43,0.94 0.02,1.84 -1.38,1.84 -1.35,0 -2.74,0.28 -4.09,-0.13 0.43,0.89 1.26,1.66 1.88,2.38 0.74,0.86 0.31,1.47 0.84,2.47 0.62,1.19 3.09,3 2.78,4.34 -0.59,2.48 -3.5,3.85 -3.25,6.69 0.16,1.8 1.91,4.65 3.84,3.94 -0.83,2.59 -1.55,1.31 -3,2.97 -0.63,0.72 -0.63,2.06 -1.34,2.94 -0.59,0.7 -1.28,1.45 -1.38,2.47 -0.11,1.17 0.08,4.77 1.38,5.28 0.92,0.37 2.03,-0.01 2.94,-0.03 2.05,-0.05 0.1,-1.16 2.03,-0.94 -1.13,1.21 4.27,5.12 5.19,6.03 -0.63,0.75 -0.9,1.76 -0.03,2.47 0.58,0.45 2.93,1.9 1.13,2.25 0.39,1.14 1.62,4.36 3,4.19 1.26,-0.14 2.42,2.34 3.75,2.38 1.65,0.05 1.27,-1.85 2.34,-1.75 0.86,0.09 1.61,-3.44 2.53,-3.97 1.86,-1.05 4.08,-0.37 5.66,-2.06 1.37,-1.5 1.79,-1.89 3.78,-1.94 3.75,-0.07 7.45,0.38 11.09,-0.28 1.74,-0.31 3.57,0.81 5.19,0.06 1.13,-0.52 2.1,-2.16 3.53,-0.94 2.34,2.01 3.92,-2.16 4.34,-4.47 0.5,-2.69 3.88,-5.17 6.38,-5.5 0.82,-0.11 4.3,-0.24 5.03,-1.47 -0.25,-0.15 -0.62,-0.69 -0.63,-1.16 -0.01,-1.14 0.42,-2.3 0.78,-3.31 0.59,-1.61 1.37,-3.29 2.25,-4.41 1.5,-1.87 2.95,-2.42 4.84,-3.75 3.26,-2.26 1.57,-2.97 -0.53,-5.31 -3.47,-3.85 -2.31,-11.93 1.66,-14.75 2.32,-1.66 2.63,-5.32 5,-6.84 1.62,-1.03 3.94,-1.45 1.41,-3.56 3.05,-2.36 5.36,-4.18 9.22,-5.25 1.59,-0.44 3.65,-0.42 5.13,-1.19 1.23,-0.65 1.59,-2.16 3.06,-2.84 1.97,-0.89 7.84,-3.03 7.88,-5.97 0.01,-1.05 -0.96,-3.08 -0.03,-3.91 0.62,-0.56 1.31,-0.15 1.28,-1.38 -1.09,0.17 -1.17,-1.01 -2.03,-1.38 -1.51,-0.65 -2.28,-0.52 -3.56,0.41 -1.58,1.12 -2.94,0.38 -4.53,-0.28 -0.84,-0.37 -1.55,0.44 -2.25,0.69 -0.62,0.21 -1.39,-0.73 -1.88,-1.03 -1.67,-1 -2.67,-0.12 -4.34,0.09 -0.47,-4.16 -4.78,-4.06 -7.84,-5.69 -0.46,0.72 -0.63,1.5 -0.47,2.38 -2.41,-0.37 -4.87,0.03 -7.25,-0.38 -0.87,-0.14 -1.37,-1.09 -2.16,-1.41 -0.63,-0.24 -1.28,0.21 -1.91,0.16 -2.83,-0.28 -5.4,-3.59 -8.44,-3.75 -0.96,-0.05 -0.69,1.35 -1.66,0.25 -0.4,-0.47 -0.11,-1.04 0,-1.53 0.52,-2.27 -2.9,-1.13 -3.5,-2.09 -0.56,-0.86 -3.98,0.32 -5.16,0.09 -1.94,-0.4 -3.91,-1.25 -5.88,-1.41 -2.24,-0.16 -1.74,1.98 -4.25,0.44 -1.82,-1.14 -4.24,-1.62 -6.22,-1.09 -3.13,0.8 -6.3,1.13 -9.81,0.5 -2.59,-0.45 -5.17,-1.04 -7.72,-1.69 -2.4,-0.59 -2.96,-0.45 -5.19,-0.06 -2.57,0.44 -8.24,-1.61 -9.94,1 -0.24,-2.83 -6.38,-2.07 -6.69,-3.75 z m 71.34,83.16 c 0.19,0.11 0.31,0.01 0.16,-0.53 0.01,0.19 -0.06,0.38 -0.16,0.53 z m 40.56,-31.44 c -2.52,0.93 -4.79,1.69 -6.94,3.41 -0.71,0.58 -2.72,3.89 -0.22,2.72 2.84,-1.33 1.25,1.56 3.75,2 2.36,0.42 2.2,1.6 4.09,-0.78 0.05,-0.96 2.56,-3.55 1.53,-4.41 -0.74,-0.63 -1.87,0.22 -2.66,-0.41 -1.03,-0.79 -0.62,-2.2 0.44,-2.53 z M 249.47,467.5 c 0.11,0.27 0.17,0.48 0.22,0.66 -0.01,-0.2 -0.07,-0.41 -0.22,-0.66 z m -56.88,11.25 c 0.15,-0.02 0.33,-0 0.53,0.06 -0.39,0.13 -0.82,0.42 -1.16,0.78 0.06,-0.48 0.25,-0.8 0.63,-0.84 z",
						"HU" : "m 422.09,343.46 c 1.06,-1.17 2.41,-2.12 3.98,-1.75 -0.46,-1.4 -0.75,-3.27 -0.27,-4.74 0.39,-1.26 1.89,-1.66 2.32,-2.92 0.35,-1.03 -3.19,-1.42 -1.22,-2.19 1.5,-0.59 2.99,2.03 4.15,0.1 1.65,-2.75 1.75,-5.37 5.21,-2.47 4.27,3.59 8.79,1.77 13.93,1.12 -2.73,-2.4 1.33,-2.48 3.07,-2.66 0.86,-0.09 3.08,-0.87 3.35,-1.99 0.47,-1.91 1.89,-0.4 3.19,0.16 1.74,0.73 4.58,-0.03 5.95,-1.33 0.99,-0.94 0.76,-3.62 1.96,-4.11 2.34,-0.94 5.05,0.44 7.34,0.68 1.07,-1.68 2.75,-0.3 3.59,0.66 1.26,1.45 2.17,1.57 4.07,0.98 3.35,-1.03 4.27,4.02 7.41,3.67 2.32,-0.24 0.87,3.15 -0.07,3.9 -1.45,1.15 -3.51,0.19 -4.7,1.66 -0.76,0.96 -2.76,3.18 -3.47,4.09 -1.14,1.47 -1.65,3.32 -2.41,4.44 -0.83,1.19 -1.37,2.38 -1.55,3.67 -0.21,1.59 -2.25,2.41 -2.91,3.92 -0.68,1.54 -0.72,2.76 -2.55,3.24 -1.27,0.31 -2.2,-0.23 -3.13,0.94 -0.96,1.21 -2.01,0.28 -3.16,0.72 -1.66,0.61 -3.56,0.07 -5.21,-0.1 -1.17,-0.12 -3,-0.84 -4.02,0.14 -1.18,1.14 -1.57,2.1 -3.26,2.19 -1.54,0.09 -3.21,0.24 -4.68,0.89 -1.38,0.59 -1.81,2.03 -3.42,2.24 -2.69,0.37 -6.12,-0.35 -8.27,-1.84 -1.23,-0.87 -2.44,-0.68 -3.39,-2.13 -1.19,-1.82 -2.92,-2.87 -4.62,-4.09 -1.55,-1.12 -2.77,-2.12 -3.68,-3.87 -0.74,-1.4 -1.65,-3.6 -3.54,-3.24",
						"IS" : "m 12.43,92.09 c 1.84,-0.07 4.35,-0.65 6.08,-1.05 0.96,-0.23 0.16,-1.87 1.7,-1.05 2.08,1.1 2.61,-2.22 3.71,0.79 0.84,-0.38 1.61,-0.87 2.3,-1.45 0.72,1.99 3.01,1.47 4.03,0.26 -0.63,0.68 -1.39,1.21 -2.28,1.59 1.49,1.01 1.57,-0.14 2.44,-0.56 0.59,-0.3 3.04,1.22 4.29,0.82 -3.11,0.82 -6.63,1.64 -8.61,4.08 1.33,-0.1 2.73,0.38 4.09,0.52 1.37,0.14 2.45,-0.68 3.9,-0.14 -1.62,4.46 -11.96,-1.73 -13.73,2.87 -0.94,-2.38 -1.42,-0.52 -2.67,-0.21 -1.5,0.37 -3.19,0.21 -4.8,0.21 -3.27,0 -0.6,3.17 1.57,2.31 2.32,-0.91 3.82,-1.1 6.72,-0.82 1.38,0.14 2.68,0.09 4.03,0.09 1.37,0 3.43,1.73 4.51,0.93 -0.92,0.3 -1.66,1.01 -1.77,2.01 1.02,0.16 1.75,0.79 2.08,1.77 1.45,-1.52 4.05,-2.62 6.43,-2.64 -0.35,1.01 -1.8,1.1 -2.76,1.33 -1.14,0.26 -3.42,2.96 -0.55,2.19 -0.98,0.05 -1.77,0.38 -2.4,1 2.42,0.51 3.68,-1.87 6.22,-0.87 -1.13,0.14 -6.4,1.43 -2.73,2.76 -0.94,0.21 -2.12,-0.28 -2.99,0.12 0.71,2.06 -1.07,1.56 -2.68,1.89 -0.66,0.51 -1.41,0.58 -2.25,0.19 -0.35,-0.37 -0.74,-0.65 -1.19,-0.82 -1.45,0.54 -0.82,2.2 -0.62,3.52 2.87,-0.14 6.39,-0.17 9.11,-0.75 1.31,-0.28 2.84,0.3 4.19,0.16 1.51,-0.14 1.74,-1.64 3.58,-1.28 -0.15,0.44 -0.25,0.89 -0.32,1.38 0.8,0.12 2.45,0.98 3.07,0.37 1.14,-1.14 2.26,0.84 0.07,0.63 1.61,0.98 2.87,-0.1 3.66,-1 0.44,0.45 0.82,0.96 1.11,1.5 -0.58,0.07 -1.14,0.21 -1.67,0.37 2.02,2.75 4.7,1.84 7.25,2.27 3.04,0.52 5.91,1.59 8.93,1.73 2.29,0.1 4.61,0.03 6.72,-0.47 0.96,-0.23 1.92,-0.56 2.69,-1.1 1.93,-1.31 -0.66,-1.33 1.46,-1.92 -3.3,-0.63 2.83,-1.17 3.8,-1.21 1.7,-0.1 4.81,-0.09 5.01,-2.19 0.83,3.2 5.52,-0.17 7.01,-1.01 2.83,-1.63 5.88,-2.82 8.6,-4.57 1.59,-1.01 3.84,1.33 5.61,0.59 0.99,-0.4 6.6,-3.85 3.34,-4.06 0.84,-1.22 3.6,-0.56 1.55,-2.52 2.13,2.55 3.74,-0.52 5.89,-0.24 -2.61,-1.19 1.94,-1.57 -1.45,-1.63 0.92,0.05 1.8,-0.03 2.64,-0.26 -1.34,-0.49 -2.68,-1.07 -4.06,-1.29 1.94,-1.57 4.7,2.15 6.31,-0.54 1,-1.73 -3.5,-1.7 -4.21,-1.7 1.31,-0.14 2.69,-0.1 3.62,-1.05 -1.45,-0.35 -2.88,-0.31 -4.25,-0.12 1.34,-0.3 4.17,-1.42 3.28,-3.43 -1.42,0.51 -3.36,-1.01 -4.85,-1.31 -2.05,-0.4 -3.08,0.61 -4.38,1.71 0.82,-1.15 3.12,-1.94 2.28,-3.95 -1.8,0.12 -3.43,0.7 -5.22,0.79 0.08,-1.4 2.01,-1.75 2.25,-3.1 0.23,-1.24 -4.37,-1.49 -5.22,-2.55 1.61,0.09 1.29,-0.44 1.38,-1.61 0.11,-1.35 3.07,-1.21 4.01,-1.68 -2.34,0.49 -7.78,0.07 -7.96,3.29 -1.03,-0.84 -3.66,-1.63 -3.51,-3.03 0.24,-2.2 -4.55,-2.4 -5.44,-1.87 -0.9,0.52 -3.24,-0.75 -2.41,1.26 1.04,2.57 -1.13,2.47 -0.96,4.3 -0.54,-0.49 -4.97,-1.78 -5.65,-1.71 -2.2,0.23 -2.8,2.97 -4.18,4.22 -0.95,-1.56 -6.79,-5.56 -7.88,-3.31 -0.32,0.7 0.5,2.19 1.14,2.73 1.49,1.22 1.47,2.76 1.43,4.25 -2.4,-2.4 -4.97,-8.41 -8.83,-7.49 -1.11,0.26 -0.98,1.42 -1.8,1.61 -0.98,0.24 -2.09,-0.47 -3.01,0.03 -1.27,0.72 0.51,3.15 -0.35,4.29 -1.42,1.91 -5.57,-4.01 -6.95,-4.88 -2.45,-1.52 -3.32,1.42 -2.28,3.18 0.86,1.43 0.33,5.88 -1.27,4.04 0.43,3.27 -1.78,-0.65 -2.93,-0.86 -3.12,-0.59 -1.18,5.93 -3.5,2.71 0.46,1.47 -0.52,2.57 0.13,4.08 -1.18,-1.87 -1.35,-5.33 -4.1,-4.08 3.91,-0.68 -2.33,-3.01 -2.83,-4.48 4.19,3.99 5.56,-3.39 2.01,-2.62 2.22,-0.86 0.46,-1.17 -0.7,-1.5 -1.59,-0.47 -1.42,-1.36 -2.77,-2.22 -1.41,-0.89 -2.97,-0.23 -4.11,-1.73 -0.55,-0.72 -2.37,-1.26 -3.12,-1.38 -0.58,-0.1 -6.18,0.93 -4.85,1.66 1.82,1.03 5,1.22 6.75,1.1 -1.58,0.45 -4.39,-0.7 -4.92,1.31 1.19,0.51 3.95,0.91 4.59,2.43 0.43,1.07 -1.82,1.47 -2.02,2.31 1.42,-3.2 -1.18,-2.71 -2.91,-1.71 0.39,-1.57 -0.01,-1.8 -1.19,-0.66 0.16,-0.42 0.31,-0.86 0.4,-1.31 -1.23,-0.59 -2.57,-1.24 -3.86,-1.4 -1.02,-0.12 -3.36,0.52 -0.43,1.26 -1.61,0.4 -1.46,0.93 0.44,1.59 -1.38,-0.75 -2.79,-0.93 -4.18,-1.19 0.01,2.36 3.16,2.38 4.69,3.03 -1.66,-0.17 -4.47,-1.43 -5.14,0.38 1.92,1 3.67,0.66 5.57,1.19 -0.88,0.05 -1.75,0.17 -2.57,0.4 0.78,0.35 1.55,0.52 2.32,0.52 -2,1.73 -5.88,-2.24 -8.31,-1.33 0.6,0.96 1.57,1.71 2.6,1.98 -1.62,0.3 -1.5,0.73 0.38,1.33 -2.3,-0.66 -5.51,-2.24 -6.12,0.52 1.88,0 3.76,-0.05 5.71,1.17",
						"NL" : "m 296.75,279.28 c 1.23,0.93 2.3,2.69 4.02,2.13 -0.19,-1.5 -1.85,-1.12 -2.75,-1.77 0.88,-0.63 3.35,0.35 1.19,-1.07 2.4,1.08 4.82,-1.31 7.29,-0.82 -0.67,-1.47 -2.95,0.16 -4.86,-0.47 -0.8,-0.26 -4.23,-1.43 -2.91,-2.83 3.42,-3.64 4.69,-6.54 6.19,-11.32 0.44,-1.4 1.69,-1.75 2.96,-1.96 1.93,-0.33 3.82,-1.82 5.12,-3.25 2.81,-3.13 7.58,-3.39 11.55,-3.92 2.53,-0.33 6.91,2.89 6.34,5.6 -0.39,1.75 -1.43,3.1 -1.57,4.93 -0.11,1.38 -2.93,-0.17 -3.74,1.28 -1.09,1.94 6.01,1.89 2.06,6.09 -0.38,0.26 -0.76,0.47 -1.19,0.61 -0.96,0.56 0.25,1.45 0.11,2.15 -0.32,1.56 -5.77,0.98 -6.7,0.49 0.83,2.27 -2.08,-0.77 -1.88,2.13 1.31,0.47 2.09,2.1 2.49,3.38 0.8,2.5 -1.19,4.3 -2.22,6.23 -0.33,0.61 1.96,3.32 0,3.88 -4.27,1.26 -2.99,-3.1 -1.21,-5.35 -2.75,-1.17 -7.37,-1.15 -8.32,-4.48 -0.7,0.96 -2.65,1.42 -3.24,0 -0.63,1.15 -1.97,0.77 -2.81,0.12 0.35,2.8 -3.94,0.38 -5.26,0.47 -1.61,0.09 -3.67,0.51 -4.88,-1.07 0.84,-1.66 2.73,-1.19 4.22,-1.19",
						"SK" : "m 430.73,319.74 c 1.31,-3.25 2.79,-2.68 5.65,-2.71 1.1,-0.02 5.84,-2.41 6,-3.48 0.64,-4.09 10.07,-7.22 9.07,-4.22 1.22,-0.17 4.29,-3.22 5.3,-2.24 0.63,0.59 0.9,1.5 1.7,1.98 0.54,0.05 1.02,0.23 1.46,0.52 -0.15,0.45 -0.07,0.87 0.21,1.24 1.75,1.4 2.49,0.75 4.55,-0.79 0.72,-0.52 3.9,-1.54 4.66,-0.79 2.26,2.24 4.05,-0.73 6.81,-0.42 3.12,0.35 5.04,1.49 7.58,3.15 2.36,1.56 5.32,0.63 3.2,4.06 -1.17,1.91 -2.5,3.71 -2.97,5.84 -0.94,4.29 -6.68,-1.52 -7.88,-1.35 -0.94,0.12 -0.66,0.93 -1.7,0.7 -1.26,-0.24 -2.49,-0.61 -3.78,-0.79 -3.01,-0.44 -4.31,0.09 -4.77,3.15 -0.31,2.05 -4.51,2.87 -6.16,2.08 -2.81,-1.35 -3.19,0.21 -4.9,1.61 -1.31,1.08 -8,0.35 -4.58,3.32 -2.42,0.3 -4.9,1.75 -7.33,0.86 -1.23,-0.45 -2.52,0.35 -3.78,0 -1.13,-0.3 -2.33,-1.35 -3.38,-1.91 -1.59,-0.86 -3.64,-2.33 -4.47,-4.06 -0.36,-0.73 0.04,-1.66 -0.17,-2.47 -0.4,-1.49 -0.13,-1.96 -0.33,-3.31",
						"LT" : "m 472.68,218.59 c 1.63,0.28 2.14,-1.5 3.32,-2.29 1.27,-0.87 3.44,-1.15 4.86,-1.5 3.71,-0.87 7.98,-0.91 11.68,-0.68 1.27,0.07 0.28,1.61 1.86,0.66 1.17,-0.68 3.74,-0.03 4.96,0.07 2.4,0.21 7.45,2.33 9.64,0.35 2.87,-2.59 3.34,-0.16 5.33,1.26 1.21,0.84 2.67,0.8 4.1,1.03 1.9,0.3 3.04,1.56 4.43,2.73 0.88,0.77 6.98,3.9 6.7,4.78 -1.19,3.64 -1.06,3.39 2,4.27 -2.05,1 -0.82,2.66 -3.43,2.1 -2.02,-0.42 -2.36,2.01 -4.07,2.54 -4.97,1.47 -1.98,4.76 -5.3,8.12 0.72,0.31 2.26,0.45 2.37,1.52 0.12,1.31 -1.59,1.59 -2.41,1.31 1.1,-2.43 -3.07,-1.85 -3.31,-1.36 -1.11,2.26 -3.26,0.8 -4.53,3.1 -0.44,0.79 -2.36,0.8 -3.22,1.26 -1.45,0.79 -3.92,-0.23 -5.48,-0.07 -0.76,0.07 -4.01,0.61 -4.15,-0.72 -0.2,-1.59 -0.67,-2.71 -2.1,-3.41 -1.45,-0.7 -2.77,-1.63 -4.26,-2.22 -0.62,-0.24 -1.71,0.47 -2.01,-0.4 -0.8,-2.41 2.52,-5.14 0.17,-6.96 0.21,0.16 -1.69,-1.59 -1.44,-1.49 -1.22,-0.51 -4.16,-0.24 -5.62,-0.35 -2.01,-0.14 -6.2,-3.55 -7.9,-2.34 0.2,-1.8 -0.31,-3.76 -1.06,-5.3 -0.95,-1.85 -0.63,-3.97 -1.14,-5.98",
						"GR" : "m 525.16,413.22 c -0.61,0.04 -1,0.34 -0.78,1.16 0.32,1.22 1.79,2.72 0.28,3.91 -1.21,0.96 -3,0.52 -4.31,0.47 -1.46,-0.07 -2.83,0.94 -4.28,0.63 -1.61,-0.35 -2.58,-1.81 -4.34,-1.22 -1.63,0.56 -2.21,-1.3 -3.03,-2.28 -0.94,-1.14 -2.93,-0.43 -4.13,-0.03 -1.5,0.51 -3.05,2.34 -4.59,2.56 -1.55,0.23 -3.58,-0.41 -5,0.63 -1.06,0.77 -2.36,-0.56 -3.5,-0.44 -1.63,0.17 -0.97,1.72 -2.22,2.16 -1.96,0.72 -3.26,0.02 -5.22,0.28 -2.01,0.24 -2.42,1.78 -3.84,2.94 -1.37,1.12 -2.58,0.11 -3.97,0.41 -1.43,0.31 -2.76,0.71 -4.22,0.78 -0.13,1.47 1.5,2.78 0.25,4.22 -1.29,1.49 -1.96,1.31 -2.69,3.38 -0.52,1.5 -1.42,2.55 -2.72,3.28 -2.06,1.19 -1.48,1.1 -0.72,3.38 -2.38,-0.26 0.17,0.87 -1.44,1.69 -0.64,0.33 -1.43,0.24 -2.13,0.09 1.6,0.56 1.4,3.59 2.44,4.75 1.58,1.77 3.92,2.19 4.69,4.94 -0.12,-2.03 2.91,-1.82 3.69,-1.03 2.5,2.61 -3.14,0.64 -3.59,1.13 -1.21,1.29 0.97,3.07 1.75,3.72 1.47,1.22 1.81,3.25 2.28,5.13 0.8,-0.47 1.71,-1.25 1.94,-2.28 1.39,2.87 3.24,1.93 6.09,1.25 1.11,-0.28 4.85,2.03 4.81,-0.91 0.7,0.61 1.3,1.33 1.78,2.16 0.98,-1.59 1.16,-0.24 2.25,0.53 0.96,0.66 1.9,0.49 2.97,0.63 1.97,0.28 0.75,1.14 -0.16,1.72 -1.14,0.73 -1.73,2.14 -2.75,1.44 -1.3,-0.87 -2.32,-2.19 -3.97,-2.34 -2.1,-0.21 -3.3,-2.35 -5.19,-2.75 -1.03,-0.21 -1.8,1.18 -2.47,1.81 -0.99,0.89 -1.98,-0.03 -2.88,0.84 -0.92,0.91 -1.6,2.8 -2.84,3.22 0.92,1.57 6.85,5.94 5.75,8.22 -1.35,2.8 -0.44,6.7 2.63,7.28 -0.08,-1.14 -0.25,-3.28 1.28,-3.44 1.18,-0.14 0.83,1.41 1.53,1.97 1.09,0.86 1.43,5.68 3,5.44 -0.47,-1.85 1.34,-6.92 3.03,-3.75 0.28,0.54 3.76,4.58 3.91,4 0.33,-1.29 -1.59,-1.71 -1.22,-3.09 0.44,-1.57 -0.17,-2.86 -0.59,-4.34 -0.74,-2.48 -3.03,-4.95 -2.72,-7.75 0.9,0.89 2.24,0.98 3.31,1.47 1.08,0.48 0.11,2.03 1.44,2.13 -0.05,-0.19 2.51,-1.61 2.72,-1.59 0.69,-1.09 -1.12,-1.91 -1.44,-2.69 -0.42,2.85 -1.92,-1.04 -1.94,-2.13 -0.01,-1.68 -1.38,-0.29 -1.28,-1.84 1.65,0.14 3.38,-1.35 5.09,-1 2.33,0.49 3.72,3.1 5.41,4.63 0.9,-1.66 -0.39,-3.22 -0.09,-4.97 0.27,-1.59 0.42,-3 -1.09,-3.75 -2.04,-1.01 -3.32,-2.41 -5.5,-3.09 -2.08,-0.65 -0.54,-0.77 -1.09,-1.75 -0.6,-1.03 -1.83,0.66 -2.19,-0.38 -0.44,-1.26 -3.68,-2.26 -4.84,-2.94 1.8,0.59 3.68,-0.36 4.88,-1.94 -1.8,0.77 -3.52,-3.71 -1.28,-4.41 1.71,-0.54 3.74,2.88 1.41,3.75 5.39,-0.58 -1.77,-8.03 -2.84,-9.66 -2.01,-3.06 -4.33,-10.13 1.56,-11 0.13,0.91 -0.33,1.55 -1.16,1.81 1.15,1.75 4.02,2.01 4.78,4.09 0.67,1.84 1.19,4.41 3.94,3.19 -1.06,-1.03 -2.43,-1.4 -3.06,-2.94 -0.43,-1.05 -0.21,-1.97 1.03,-1.41 1.5,0.68 3.25,4.21 5.13,3.56 -0.12,-1.22 -5.16,-5.44 -1.22,-5.09 1.71,0.16 3.57,4.04 5.28,3.06 -0.59,-0.79 -3.3,-5.21 -4.56,-3.84 -0.62,0.68 -1.46,-0.29 -1,-1.13 0.7,-1.21 -0.5,-0.58 -0.75,-1.44 -0.47,-1.57 -0.55,-2.7 1.56,-1.84 2.83,1.15 3.06,-1.59 5.03,-2.63 1.41,-0.73 2.56,2.19 4.06,1.16 2.18,-1.49 2.17,-2 4.44,-1 1.17,0.51 8.83,0.9 8.09,2.72 4.1,-2.05 1.57,-7.72 6.19,-8.56 -0.46,-1.57 -0.54,-3.33 -1.97,-4.22 -0.28,-0.17 -1.86,-0.85 -2.88,-0.78 z M 525.56,446 c -0.47,0.02 -0.98,0.1 -1.59,0.28 -1.06,0.3 -2.88,0.9 -1.34,2.13 0.83,0.66 2.08,0.1 3.03,0.19 -0.38,0.24 -0.75,0.5 -1.09,0.78 0.94,0.7 1.98,1.34 3.16,1.5 0.44,-0.87 1.2,-1.37 2,-0.81 -1.26,-2.74 -2.13,-4.14 -4.16,-4.06 z m -30.22,3.88 c -1.43,0.05 -2.45,1.66 -3.34,2.69 1.84,-1.64 7.45,2.64 6.84,4.97 0.84,1.71 3.11,0.31 4.41,1.03 1.19,0.65 1.73,3.2 2.75,4.25 0.43,0.45 3.6,2.31 2.78,0 -0.6,-1.68 -2.48,-1.22 -3.28,-2.56 -1,-1.66 0.11,-4.53 -1.84,-5.53 -1.67,-0.86 -3.83,-0.24 -5.22,-1.78 -0.92,-1.03 -1.45,-3.11 -3.09,-3.06 z m 27.91,5.84 c -0.44,0.06 -0.95,0.43 -1.5,1.16 2.52,1.08 -0.44,3.98 1.81,4.94 2.25,-1.48 1.59,-6.37 -0.31,-6.09 z m -23.19,39.75 c 0.07,0.84 -0.08,1.62 -0.5,2.38 -0.33,-0.23 -0.67,-0.46 -1,-0.69 -0.09,1.12 -1.08,3.53 0.22,4.16 1.26,0.61 4.13,0.8 5.5,0.47 1.8,0.49 3.83,0.37 5.5,1.28 0.9,0.49 0.67,1.67 1.53,2.25 0.99,0.63 2.43,0.2 3.5,-0.03 2.92,-0.63 5.77,-0.95 8.72,-0.94 0.75,0.02 1.88,0.03 2.47,-0.66 0.44,-0.51 0.34,-2.14 -0.34,-2.28 -1.41,-0.3 -3.08,1.1 -4.53,1.19 -0.96,0.07 -0.48,-0.83 -0.47,-1.53 0.05,-1.66 -1.64,-0.7 -2.5,-0.75 -3.07,-0.16 -6.15,-2.29 -9.28,-1.06 -1.5,0.58 -2.69,0.82 -3.84,-0.41 -0.78,-0.82 -2.14,-1.19 -0.19,-2.03 -1.94,0.26 -4.07,1.44 -4.78,-1.34 z",
						"SI" : "m 395.32,354.55 c 0.66,-0.44 1.25,-0.98 1.75,-1.61 -1,-0.24 -1.9,-0.86 -2.79,-1.4 2.32,-2.64 1.27,-4.25 4.09,-3.53 1.04,0.28 7.33,2.64 8.25,1.8 1.84,-1.71 3.5,-3.59 6.1,-3.41 1.38,0.09 3.03,0.8 4.34,-0.03 1.35,-0.86 2.96,-0.93 4.3,-0.02 -1.13,-1.56 0.76,-4.01 2.3,-2.66 1.21,1.05 2.6,3.8 3.47,5.2 -1.21,-0.19 -5.13,-1.4 -3.07,1.28 -1.21,-0.05 -1.85,-0.89 -2.4,0.59 -0.31,0.82 -3.32,1.57 -4.23,2.15 -0.7,0.44 0.51,2.64 0.43,3.59 -0.13,1.49 -3.36,1.59 -4.68,2.8 0.52,0.19 0.96,0.68 1.5,0.8 -0.96,0.23 -0.38,3.92 -2.2,2.66 -2.09,-1.47 -4.15,-0.79 -6.14,-2.89 -0.72,1.78 -3.13,3.29 -4.94,2.41 -0.75,-0.35 -0.72,-0.38 -1.33,0.24 -0.92,0.96 -2.8,0.14 -3.82,-0.1 1.15,-1.08 3.5,-1.49 2.65,-3.13 -0.67,-1.29 -3.8,-0.96 -2.21,-3.11 -0.78,-0.19 -1.27,-0.79 -1.39,-1.63",
						"NO" : "m 544.69,14.38 c -2.71,-0.03 -8.14,2.68 -8.94,2.81 1.46,0.33 3.22,0.12 4.09,1.5 -1.54,-0.72 -3.03,0.97 -4.63,0.84 -0.17,1.12 0.34,2.01 1.38,2.25 -0.88,-0.28 -1.82,-0.35 -2.81,-0.16 0.27,0.52 0.56,1.06 0.84,1.56 -1.13,0.03 -2.65,-0.74 -3.72,0.31 -0.72,0.72 -0.98,1.34 -2.09,1.22 1.06,-1.61 1.74,-4.82 -0.94,-4.34 2.79,-0.19 2.88,-1.58 2.66,-3.91 -3.62,0.96 -9.82,5.36 -12.5,8.25 -0.59,0.63 0.63,1.01 -0.31,1.63 -0.75,0.37 -1.38,0.91 -1.88,1.59 -0.47,0.65 -2.12,-0.42 -3.13,0.13 0.05,-1.47 2.54,-3.56 3.22,-3.63 0.12,-1.14 -0.47,-1.69 -1.59,-1.41 2.28,-2.34 6.68,-2.52 8.31,-5.56 -2.08,1.03 -3.61,-0.91 -5.59,-0.72 2.17,3.57 -2.75,-0.2 -2.84,-0.22 -1.38,-0.31 -7.54,0.38 -3.72,1.19 -1.62,1.64 -2.87,-0.45 -4.56,0.84 1.13,0.94 2.72,0.83 3.97,1.53 -1.18,0.72 -6.19,0.45 -3.75,2.81 -1.86,0.07 -3.73,-0.46 -5.56,0.59 -1.13,0.66 -2.24,2.53 -3.63,2.5 3.17,0.33 -1.14,0.71 -1.72,0.66 2.52,0.33 1.27,1.13 -0.09,1.81 0.74,0.86 2.76,0.6 2.91,1.41 -2.16,0.09 -5.71,1.51 -5.5,-2.09 -1.88,1.17 -4.09,1.2 -6.06,1.13 1.54,-0.12 4.51,0.18 5.22,-1.97 -1.77,-0.28 -3.66,-1.02 -5.56,-0.69 0.03,0.89 0.44,1.5 1.19,1.72 -1.16,-0.18 -2.5,-0.53 -1.94,-2.13 -1.82,1.43 -4.04,-2.07 -4.88,1.38 -0.88,-0.68 -1.82,-1.27 -2.78,-1.81 -0.19,0.51 -0.37,1.04 -0.56,1.56 -0.84,-0.56 -1.78,-0.65 -2.81,-0.28 1.5,1.92 5.99,2.36 8.28,1.66 -3.32,0.87 0.31,0.79 0.69,2.34 -1.93,-1.68 -2.06,0.32 -1.28,0.88 1.34,0.3 1.17,0.45 -0.47,0.44 1,0.1 1.8,0.54 2.41,1.31 -0.74,-0.1 -11.84,-5.98 -9.09,-1.31 -1.7,-1.33 -2.24,1.88 -3.75,-0.25 0.46,-0.44 0.96,-0.84 1.47,-1.19 -3.83,0.75 -6.09,4.51 -1.75,6.03 -1.23,-0.12 -3.87,-2.22 -4.81,-0.34 -0.92,1.85 -2.84,2.11 -4.41,3.13 1.49,-1.45 6.87,-7.8 3.47,-9.22 -0.31,1.82 -2.31,1.21 -3.03,2.75 -0.34,-1.74 -2.43,1.34 -0.88,2.19 -1.38,-0.03 -2.1,1.83 -3.28,2.56 1.11,-1.84 0.89,-3.42 1.28,-5.38 -2.37,0.47 -7.56,0.05 -7.53,3.66 0.88,-0.29 1.72,-0.25 2.53,0.03 -0.89,-0.21 -1.72,0.03 -2.47,0.75 0.29,0.6 0.67,0.94 1.13,1.13 -0.62,-0.17 -1.24,-0.34 -1.69,-0.59 -1.38,-0.79 -2.77,-1.29 -4.47,-0.91 0.99,1.98 3.29,2.02 5.09,2.88 -1.93,-0.82 -4.58,-1.37 -5.13,1.06 1.09,-5.98 -7.44,-1.58 -4.06,1.06 -3.08,-0.58 -7.55,3.63 -3.81,3.28 -1.07,0.51 -2.01,1.08 -0.69,1.44 -1.12,-0.26 -2.29,-0.53 -3.38,0.16 0.96,0.35 1.89,0.72 2.81,1.16 -2.45,-0.3 -5.01,-0.57 -7.5,-0.19 -2.61,0.38 -1.97,2.36 -3.88,2.69 1.53,1.17 4.63,0.95 6.47,0.72 2.93,-0.37 4.78,-0.39 7.56,0.47 -0.68,-0.15 -5.03,-0.15 -3.72,0.41 -0.82,-0.14 -1.84,-0.11 -2.13,0.5 0.03,0.29 0.16,0.53 0.34,0.69 0.09,0.08 0.21,0.11 0.34,0.16 0.13,0.04 0.27,0.08 0.44,0.09 -0.17,-0.01 -0.32,-0.06 -0.44,-0.09 -0.15,-0.04 -0.25,-0.08 -0.34,-0.16 -0.36,-0.28 -0.44,-0.73 -1.09,-0.91 -0.91,-0.02 -1.82,-0.07 -2.72,-0.16 -2.06,-0.86 -4.22,-0.28 -6.41,-0.13 1.29,1.21 3.01,2.43 4.75,2.91 -2.08,-0.38 -3.82,-1.64 -5.81,-2.25 1.9,0.73 1.85,1.17 -0.09,1.31 1.02,0.03 2.02,0.16 3,0.41 -0.74,0.21 -1.43,0.48 -2.13,0.78 1.42,0.45 2.91,0.69 4.41,0.78 -0.98,0.19 -1.91,0.14 -2.84,-0.13 0.75,1.47 0.38,1.78 -1.13,0.91 3.63,2.2 -0.7,0.52 -1.31,0 0.16,1.08 0.9,1.9 1.97,2.13 -3.09,0.21 -1.58,-3.47 -3.28,-4.59 -1.37,-0.91 -6.25,3.47 -3.84,0.5 -1.42,0.7 -3.11,0.23 -4.03,1.84 2.29,0.26 4.7,-0.77 6.81,0.41 -0.55,1.68 -3.34,0.91 -4.53,1.03 -0.78,0.07 -8.8,0.92 -4.34,1.09 -0.92,-0.03 -1.86,-0.03 -2.78,0.09 0.84,0.63 1.79,0.99 2.84,1.06 -1.14,0 -2.2,0.63 -2.81,1.59 3.72,-0.09 7.14,-3.8 10.34,-0.41 -1.23,-0.75 -6.05,-0.79 -2.72,-0.25 -0.88,0.09 -2.2,-0.67 -3.03,-0.09 -2.65,1.87 3.87,0.93 -0.59,1.91 2.26,0.86 4.51,-0.36 6.81,-0.09 -1.38,-0.05 -4.79,2.36 -1.84,2.47 -1.45,0.58 -2.26,-1.07 -3.44,-1.44 -1.31,-0.42 -2.86,-0.19 -4.19,0.13 0.54,-0.26 1.06,-0.52 1.59,-0.78 -1.41,-0.94 -3.07,0.08 -4.34,0.78 0.87,0.33 1.77,0.48 2.72,0.41 -1.07,1.5 -1.49,-0.08 -2.72,0.25 -1.09,0.3 -1.73,1.4 -2.81,1.72 2.57,1.08 4.51,-0.04 7.09,0.06 1.47,0.06 2.87,0.52 4.28,0.88 -0.51,0.03 -0.64,0.46 -0.69,1.44 -1.27,-1.08 -3.56,-1.81 -5.16,-0.81 0.05,-1.38 -5.97,-0.39 -6.56,1.47 1.02,-0.02 1.99,0.24 2.84,0.78 -2.08,-1.08 -3.64,0.85 -5.72,0.47 -1.61,-0.3 -3.55,0.36 -5,1.09 1.43,0.38 2.64,1.37 4.13,1.59 -0.55,0.03 -6.35,0.18 -2.75,0.53 -3.32,0.35 0.62,0.57 1.16,0.5 -1.8,0.66 -3.62,-0.33 -5.44,0.16 0.7,0.16 1.36,0.39 2.03,0.66 -0.95,-0.17 -1.91,-0.15 -2.84,0.13 1.43,2.55 3.61,0.03 5.69,0.66 -0.24,0.26 -3.79,1.97 -4.22,1.97 -1.27,0.02 -1.74,-1.58 -3.09,-0.66 1.25,0.59 1.42,1.64 0.22,2.5 1.38,0.42 2.84,0.02 4.25,0.25 -1.53,0.12 -3.09,0.27 -4.03,1.72 0.99,-0.24 1.97,-0.41 2.97,-0.59 -0.08,0.03 -0.15,0.03 -0.25,0.06 -1.78,0.66 -4.97,2.45 -6.75,2.5 1.73,-0.19 4.88,0.75 5.28,2.91 -3.78,-3.94 -7.98,1.26 -4.66,2.63 -1.29,-0.73 -4.64,-1.46 -3.06,1.22 0.12,0.19 3.12,1.39 3.53,1.28 -0.99,0.31 -2.33,1.11 -3.25,0.19 -0.27,-0.42 -0.58,-0.78 -0.94,-1.09 -1.69,-0.09 -2.9,2.77 -2,4.06 0.66,-0.84 1.64,-1.4 2.69,-1.19 -0.92,0.93 -1.16,1.67 0.63,1.84 -3.2,0.38 0.38,0.51 1.28,0.09 0.98,-0.44 1.85,-1.06 2.81,-1.53 -2.21,2.05 -6.27,4.31 -9.22,2.88 1.09,0.26 2.14,0.19 3.19,-0.25 -0.31,-1.73 -2.2,-1.57 -2.44,0.13 -1.17,-1.22 -4.33,0.37 -1.16,0.28 -1.1,0.63 -2.32,0.93 -3.56,1.03 4.55,-0.31 -4.06,0.08 0,0.91 -0.91,-0.09 -1.83,0.03 -2.69,0.38 1.03,0.3 2.06,0.28 3.06,-0.13 -1.29,0.73 -2.78,0.34 -4.06,1 1.81,0.16 1.87,0.49 0.13,1 1.35,0.02 2.59,-0.38 3.81,-0.88 0.66,0.14 1.32,0.23 2,0.25 -1.38,0.37 -4.18,0.41 -4.22,2.41 0.91,0.02 1.83,0.15 2.69,0.47 -1.29,0.02 -2.79,1.78 -0.31,1.53 -1.53,0.19 -3.01,0.93 -4.31,1.75 0.25,-0.44 0.5,-0.9 0.69,-1.38 -1.45,-0.33 -2.25,-1.74 -3.66,-2.16 0.7,3.06 -7.1,2.16 -5.84,5.66 -1.62,-0.56 -1.08,0.42 -2,1.16 -0.75,0.59 -3.76,2.2 -0.91,1.63 -0.37,0.26 -0.73,0.52 -1.06,0.81 -1.54,0.4 -3.08,1.38 -4.34,1.94 2.26,-0.02 1.13,0.85 0.16,1.5 1.73,-0.73 3.55,-1.19 5.38,-1.63 -0.8,0.72 -1.78,1.25 -2.88,1.25 2.28,3.31 3.11,2.56 7.03,1.16 1.21,-0.44 6.13,-1.97 4.63,-4.03 -0.8,0.49 -1.67,0.75 -2.63,0.75 2.61,-0.35 4.17,-3.27 6.81,-3.38 -2.93,1.7 0.24,0.97 1.38,1.13 -1.29,0.61 -3.15,0.54 -3.56,2.25 0.99,-0.51 1.78,-0.12 1.88,1 -2.6,0.3 -4.98,1.56 -7.03,3.16 0.84,-0.51 1.71,-0.6 2.63,-0.28 -1.43,-0.14 -1.67,0.38 -0.75,1.53 -1.51,0.35 -3.16,-0.05 -4.69,-0.06 -0.92,-0.02 -5.08,0.76 -1.69,1.56 -1.33,0.04 -2.7,-0.22 -4,0.25 2.64,-1.15 0.1,-4.29 -1.72,-3.78 -1.55,0.44 -3.44,0.87 -4.78,1.78 0.87,-0.14 1.75,-0.14 2.63,0 -0.95,0.1 -1.85,0.44 -2.63,1 0.95,0.26 1.91,0.3 2.88,0.13 -1.37,0.24 -2.73,0.55 -4,1.13 1.53,-1.56 0.04,-2.11 -1.41,-1.53 -0.92,0.37 -1.67,-0.21 -2.41,0.72 -0.38,0.56 -0.79,1.09 -1.28,1.56 1.19,0.7 2.58,0.55 3.88,0.38 -2.18,0.37 -4.68,0.45 -6.78,0.94 -1.82,0.42 1.51,1.63 2.06,1.59 -3.64,0.17 0.87,0.34 1.38,0.38 -1.11,0.21 -2.76,1.26 -0.25,1.5 -2.56,-0.09 -1.8,0.24 -3.22,-1.41 -0.59,-0.68 -2.16,-2 -3.16,-1.38 0.7,3.01 4.28,2.99 5.66,5.41 -1.13,-0.86 -3.94,-1 -4.44,-2.5 -0.59,-1.78 -1.79,-0.97 -3.19,-1.25 -1.53,-0.31 -2.82,1.23 -4.28,0.22 -1.43,-1 -2.98,-0.65 -4.28,0.28 0.78,0.79 1.68,1.27 2.75,1.5 -0.86,-0.07 -1.68,0.04 -2.47,0.38 1.67,1.89 4.64,0.1 6.59,0 -0.86,0.28 -1.74,0.52 -2.59,0.75 0.84,0.61 1.74,0.56 2.66,0.34 -0.88,0.34 -1.53,0.93 -1.63,1.91 0.92,0.09 1.83,-0.01 2.72,-0.25 -1.9,1.33 -5.28,0.25 -7.31,-0.5 -2.41,-0.89 -5.19,-0.14 -7.56,0.41 1.31,1.1 2.87,0.41 4.25,1.25 -1.49,0.19 -3,0.03 -4.44,0.5 1.84,0.51 3.82,-0.62 5.63,0.06 2.3,0.86 2.66,2.42 5.56,2.31 -0.7,0.33 -2.2,-0.35 -2.72,0.13 -1,0.89 -0.25,1.8 0.78,2.03 -0.82,0.58 -1.73,0.73 -2.72,0.47 4.49,-3.04 -7.11,-7.74 -3.63,-1.13 -1.9,-1.56 -2.34,-3.07 -4.84,-1.53 -2.06,1.28 1.42,2.71 2.44,2.94 -0.6,0 -4.07,0.14 -4.22,-0.75 -0.23,-1.45 -1.62,-0.62 -1.72,0.63 -2.09,-2.61 -3.73,0.14 -1.47,0.13 -0.35,0.37 -0.73,0.67 -1.19,0.88 -0.15,-1 -3.75,-3.88 -3.81,-2.25 -0.05,1.12 2.47,1.5 3.06,2.13 -0.68,0.73 -1.54,1.07 -2.56,1 0.62,0.49 1.41,0.67 2.25,0.75 -1.6,0.57 -4.14,1.89 -1.53,1.63 -0.74,0.63 -1.6,0.87 -2.56,0.75 0.07,2.15 3.05,1.28 4.22,1 -1.29,0.49 -2.71,0.5 -4.03,0.78 1.34,-0.12 2.68,-0.37 4.03,-0.16 -3.8,0.8 2.76,0.22 -1.16,1.41 0.91,-0.01 1.71,0.48 2.56,0.56 -1.67,0.02 -3.33,-0.12 -4.91,0.47 1.14,-0.39 1.25,0.06 0.34,1.34 1.55,-0.56 3.44,-1.17 5.13,-0.63 -1.71,-0.12 -3.58,0.14 -5.13,0.88 1,0.61 2.37,1.51 0.06,1.53 1.45,0.35 2.73,1.83 4.28,1.34 1.47,-0.45 4.08,-1.34 5.63,-1.09 1.37,0.23 3.2,1.58 4.41,0.28 0.84,-0.87 0.54,-2.21 2.03,-2.44 -2.68,2.36 3.36,2.09 4.56,1.28 -0.47,0.33 -0.93,0.72 -1.34,1.13 1.3,0.47 2.52,-0.18 3.81,-0.13 -2.06,0.59 -4.26,1.65 -2.41,3 -0.76,-0.27 -1.46,-0.25 -2.16,0.03 1.58,-1.05 -1.88,-3.6 -3.66,-2.38 -1.81,1.26 -4.44,-0.1 -6.44,-0.03 -2.77,0.1 -4.56,1.24 -7.44,0.75 -2.72,-0.45 -1.61,1.6 -0.31,1.25 -0.47,1.35 -0.67,1.34 -1.81,0.5 0.48,2.94 3.19,0.47 4.78,0.88 -1.71,-0.07 -1.31,1.77 -1.09,2.91 -0.98,-1.22 -2.76,-1.91 -4.22,-1.91 1.53,0.54 1.7,3.28 3.47,3.28 1.8,0 2.58,-2.08 4.22,-2.5 0.86,2.43 -2.32,6.8 -3.66,3.13 -0.28,0.91 -0.98,1.64 -1.88,1.91 1.35,0.28 1.01,2.35 2.13,2.88 1.37,0.63 2.52,-2.04 2.84,-2.88 -0.12,0.84 -0.3,1.68 -0.53,2.5 2.56,-0.38 1.06,5.65 4.13,-0.03 0.42,-0.79 2.75,-2.61 3.47,-2.91 2.41,-1 5.33,-1.55 7.94,-1.09 -3.42,0.3 -3.94,2.42 -5.94,4.78 0.27,-1.26 1.2,-2.52 0.63,-3.91 -1.02,0.7 -7.02,3.41 -3.75,4.41 -2.06,-0.02 -4.34,2.29 -5.47,3.81 1.16,0.73 2.75,1.2 4.06,0.75 0.19,-0.06 0.39,-0.15 0.56,-0.25 -0.1,0.09 -0.32,0.16 -0.56,0.25 -1.41,0.52 -4.57,1.08 -1.69,1.44 -1.17,0.59 -3.46,-0.66 -3.88,0.84 -0.32,1.12 -0.78,2.05 -2.09,1.25 1.53,0.04 1.72,-1.52 1.84,-2.69 -1.37,0.44 -2.66,1.84 -2.69,3.34 -0.01,0.94 1.41,3.06 1.78,1.5 -0.16,2.34 3.26,-0.97 0.31,-1.22 0.46,-0.37 0.97,-0.65 1.53,-0.84 0.03,0.94 0.07,1.85 0.09,2.78 0.75,-0.51 1.58,-0.7 2.5,-0.59 -0.08,-1.03 -0.67,-1.42 -1.59,-0.97 1.06,-0.94 2.49,-0.88 3.81,-0.84 -0.95,0.05 -1.51,0.63 -1.53,1.59 0.96,-0.44 2.64,-1.38 3.13,-2.38 0.64,-1.29 1.75,-0.14 2.94,-0.44 -2.04,0.61 -3.57,1.89 -5.31,3.03 0.83,0.21 1.67,0.3 2.53,0.25 -2.09,0.26 -1.32,0.78 0.16,0.34 0.8,-0.28 1.62,-0.38 2.47,-0.34 -1.02,0.17 -6.76,1.68 -3.66,2.31 -0.84,0.23 -1.67,0.46 -2.5,0.72 0.96,0.4 1.56,1.34 1.38,2.41 1.59,-1.24 3.61,-1.66 5.59,-1.81 -1.7,0.45 -3.57,0.65 -5.09,1.56 0.43,0.38 0.87,0.78 1.34,1.13 -2.49,0.12 -4.43,-2.24 -6.91,-2.06 0.42,0.24 0.83,0.55 1.22,0.84 -5.36,3.03 6.57,10.83 11.34,9.41 -0.68,0.37 -1.31,0.84 -1.88,1.38 1.35,1.84 4.7,1.11 6.56,1.16 1.17,0.04 2.22,0.63 3.38,0.63 1.15,0.02 2.54,-1.02 3.59,-1.41 2.52,-0.93 5.01,-1.58 7.34,-3 1.89,-1.17 2.73,-3.66 5.13,-4.03 -0.21,-0.45 -0.41,-0.91 -0.63,-1.34 1.07,0.02 2.11,-0.15 3.13,-0.5 -0.28,-0.4 -0.58,-0.79 -0.88,-1.19 1.82,0.12 5.69,-2.15 2.53,-3.53 1.14,0.45 2.14,1.16 3.25,1.69 1.84,0.91 0.86,0.15 2.09,-0.69 0.76,-0.51 1.62,-0.81 2.34,-1.41 0.84,-0.68 0.94,-2.76 0.94,-0.31 0.64,-2.29 0.32,-3.34 -1.44,-4.97 0.91,0.44 1.61,0.16 1.81,-0.88 0.32,0.42 0.62,0.85 0.94,1.25 1.57,-1.12 -0.07,-2.37 0.06,-3.75 0.24,-2.41 3.38,-1.64 2.13,0.69 -0.27,-2.87 -1.08,0.33 -1.09,1.06 -0.03,1.21 0.17,2.44 0.5,3.59 0.78,2.57 2.36,2.44 4.5,3.56 0.82,0.42 2.12,0.22 2.69,0.94 0.47,0.61 0.71,2.22 1.59,2.38 1.93,0.35 2.57,-3.93 2.69,-5.16 0.12,-1.28 -1.62,-2.99 -0.94,-4.13 0.56,-0.94 1.92,-1.68 1.84,-2.91 -0.15,-2.29 1.71,-1.34 3.66,-2.09 1.17,-0.45 2.82,-1.79 2.69,-3.28 -0.15,-1.77 1.43,-2.69 0.75,-4.53 -0.59,-1.57 -2.07,-2.55 -2.59,-4.16 -0.88,-2.69 1.36,-3.31 3.59,-3.31 0.74,0.02 2.24,-3.73 2.06,-4.38 -0.29,-1 -1.61,-1.45 -2.44,-1.78 -1.69,-0.68 -4.42,-1.46 -4.63,-3.75 -0.31,-3.62 1.73,-6 0.03,-9.66 -0.86,-1.84 -1.82,-5.26 -0.06,-6.47 0.83,-0.58 -1.28,-3.28 -1.34,-4.28 -0.08,-1.28 1.23,-2.38 1.31,-3.78 0.16,-2.71 6.77,-6.26 9.03,-6.63 2.46,-0.38 9.23,1.45 10.69,-1.03 2.09,-3.57 -2.37,-5.12 -4.81,-5.94 1.53,-1.8 3.25,-3.49 5.06,-5.03 1.37,-1.21 2.05,-3.7 3.5,-4.5 1.86,-1.01 0.99,-10.22 0.66,-11.66 2.33,0.1 7.69,0.04 9.41,-2.09 0.79,-0.98 -1.04,-2.47 0.28,-3.19 1.11,-0.61 1.71,-1.08 2.63,-2.06 1.3,-1.4 6.83,-4.51 7.19,-6 0.43,-1.75 -2.26,-3.35 -3.28,-4.28 4.54,-2.05 6.55,-6.86 11.38,-8.44 2.92,-0.96 8.54,2.68 9.84,-1.94 0.38,-1.33 -1.46,-3.82 0.22,-4.59 2.34,-1.07 3.93,0.77 6.25,0.47 4.9,-0.59 9.74,3.72 14.5,0.31 -0.86,-0.4 -1.75,-0.73 -2.69,-0.94 2.38,-1.38 5.77,-4.47 1.97,-6.06 3.01,-1.29 7.32,0.14 10.09,-1.31 -0.42,-0.38 -0.82,-0.77 -1.22,-1.19 3.59,-1.99 6.01,-1.35 8.72,1.03 1.45,1.28 4.13,4.67 5.88,5.13 3.97,1.03 8.2,1.87 12.44,0.31 1.38,-0.51 1.64,-2.01 3.31,-1.5 1.35,0.44 2.78,0.73 4.16,1.09 2.04,0.56 5,3.25 6.97,0.94 0.84,-1 1.56,-2.29 2.84,-2.78 1.26,-0.45 2.3,-0.09 3.47,-1 1.04,-0.86 0.21,-2.46 0.44,-3.44 0.38,-1.56 1.01,-3.06 1.66,-4.56 2.84,-6.54 11.18,-4.05 16.13,-6.34 3.75,-1.78 5.26,1.05 8.13,2.22 2.5,1.03 5.24,1.46 7.88,2.16 3.43,0.93 2.13,3.48 -0.09,5.31 -0.83,0.7 -3.38,1.8 -1.75,2.91 0.8,0.54 1.67,1.07 2.78,0.53 1.96,-0.96 1.17,-1.87 2.22,-3.09 0.8,-0.96 3.33,-0.97 4.38,-1.25 1.84,-0.49 4.92,-1.4 4.25,-3.81 0.87,0.4 8.2,3.46 7.53,-0.25 -0.35,-1.85 -3.56,-2.93 -4.69,-0.53 -0.24,-1.59 -1.89,-1.77 -3.31,-1.84 -0.16,0.75 -0.19,1.48 -0.13,2.22 -1.07,0.04 -1.71,0 -1.69,-1.06 -1.29,0.21 -2.56,0.41 -3.84,0.56 3.97,-1.57 0.51,-2.45 -1.03,-2.66 3.97,-1.38 -2.13,-1.55 -3.28,-1.78 -1.63,-0.31 -3.29,-0.58 -5,-0.69 2.85,-2.2 7.91,-0.09 10.63,0.31 3.39,0.52 5.54,-1.42 8.78,-2.06 0.72,-0.16 5.8,-0.69 4.59,-2.28 -1.88,-2.47 -6.35,-2.04 -9.31,-1.81 3.32,-0.72 -0.87,-3.57 -3.19,-1.56 0,-2.43 -3.38,-0.83 -4.81,-0.41 2.1,-2.76 -3.42,-3.66 -5.13,-2.72 -1.27,0.7 -6.1,5 -2.59,4.97 -1.67,-0.17 -3.71,0.95 -3.91,2.91 -0.16,-1.17 0.65,-2.2 1.72,-2.78 -1.69,-0.47 -3.65,0.28 -5.41,0.16 1.61,-0.73 3.26,-1.29 4.81,-2.25 -1.47,-1.42 -4.37,0.21 -6.25,0.28 1.54,-0.3 3.02,-1 4.56,-1.41 -0.78,-0.58 -1.66,-0.81 -2.72,-0.69 0.42,-0.23 7.53,-1.1 6.38,-2.47 -0.42,-0.49 -3.02,-0.6 -3.03,-1.16 -0.02,-0.81 -0.63,-1.12 -1.53,-1.13 z M 309.13,145.91 c -0.18,0.07 -0.38,0.13 -0.56,0.22 0.2,-0.09 0.4,-0.16 0.56,-0.22 z m 129.03,-110.38 c -0.56,0.05 0.04,1.03 0.06,1.16 -0.03,-0.02 -0.29,-0.31 -0.38,-0.41 0.88,1.25 -3.03,-0.41 -4.25,0.19 0.79,0.73 1.78,1.03 2.91,0.91 -2.06,0.73 -4.22,0.38 -6.31,0.81 1.31,-0.14 1.6,0.09 1.38,1.31 0.48,-0.05 0.97,-0.1 1.47,-0.16 -1.98,0.44 -2.02,0.88 -0.09,1.31 -0.94,0.37 -1.88,0.68 -2.84,0.94 1.61,0.94 3.6,0.53 5.25,-0.31 1.96,-1.01 4.21,0.04 6.25,-0.47 -1.66,-0.38 -1.73,-0.8 -0.19,-1.25 0.76,-0.77 1.34,-2.37 0.25,-2.28 1.28,-0.63 -1.36,-0.85 -2.28,-1.31 -0.64,-0.32 -1.01,-0.46 -1.22,-0.44 z M 453.41,38 c 0.68,0.13 1.45,0.06 2.25,0.06 1.47,0 0.47,1.86 -0.56,1.97 0.78,-1.21 -0.36,-1.66 -1.69,-2.03 z M 419.25,43.56 c -0.32,-0 -0.69,0.1 -1.16,0.31 -1.04,0.49 -1.62,2.53 -0.63,3.09 -0.66,-0.13 -1.34,-0.08 -2,0.16 0.11,0.44 0.24,0.88 0.34,1.31 -0.87,0.31 -1.75,0.47 -2.66,0.5 1.3,1.49 -1.1,2.21 -1.22,3.72 1.27,-1.08 2.86,-1.71 4.44,-2.13 -0.43,0.47 -0.85,0.95 -1.25,1.44 0.8,0.03 1.79,0.79 2.59,0.53 1,-0.31 1.56,-1.89 2.41,-2.5 -0.29,3.04 1.26,0.43 2,-0.34 0.82,-0.84 1.98,-0.47 2.97,-0.5 1.82,-0.07 3.62,-2.57 1.78,-3.78 -0.78,-0.52 -2.49,-0.81 -3.25,0.06 -1.07,1.24 -3.2,2.21 -4.78,3.78 0.08,-0.38 4.48,-5.2 0.78,-2.63 1.04,-1.24 1,-3.02 -0.38,-3.03 z m -16.94,35.66 c -1.03,1.05 -5.86,1.94 -3.69,2.5 -0.72,-0.16 -1.89,0.45 -2.53,0.03 -0.72,-0.45 -0.63,-1.07 -1.13,-1.16 2.44,-0.43 4.92,-0.79 7.34,-1.38 z M 382.63,98.25 c 0.77,0.03 1.57,0.23 2.41,0.66 -1.2,-0.49 -2.55,-0.64 -3.88,-0.53 0.48,-0.09 0.97,-0.15 1.47,-0.13 z m -21.75,13.56 c 0.46,-0.02 0.93,0.11 1.41,0.41 -0.79,-0.3 -1.61,-0.26 -2.44,-0.06 0.35,-0.21 0.68,-0.33 1.03,-0.34 z m -21.84,15.78 c 0.66,0.01 1.29,0.21 1.88,0.81 -0.96,-0.34 -2.71,-0.56 -4.22,-0.31 0.79,-0.25 1.59,-0.51 2.34,-0.5 z M 316.81,139.31 c 0.3,-0.01 0.58,0.01 0.84,0.03 -3.51,0.12 3.36,0.41 4.19,0.56 0.2,0.03 0.39,0.06 0.59,0.06 -1.71,0.25 -3.41,0.7 -4.13,1.25 1.34,-1.63 -1.31,-0.82 -2.22,-1 -0.61,-0.13 -1.08,-0.49 -1.59,-0.75 0.8,-0.05 1.6,-0.13 2.31,-0.16 z m 8.09,0.34 c 0.51,-0.04 0.99,0.03 1.47,0.22 -0.62,-0.14 -1.71,-0.14 -2.88,-0.03 0.47,-0.07 0.94,-0.15 1.41,-0.19 z M 335.13,145 c -2.01,1.91 -3.35,3.4 0.34,3.88 -0.38,0.01 -1.4,0.2 -2.47,0.5 -1.58,-1.94 0.47,-3.68 2.13,-4.38 z m -18.94,0.06 c 0.15,0.01 0.29,0.03 0.44,0.06 -0.7,0.22 -1.43,0.28 -2.16,0.31 0.15,-0.01 0.28,-0.04 0.44,-0.09 0.4,-0.2 0.84,-0.3 1.28,-0.28 z",
						"MD" : "m 529.91,324.71 c 1.11,-0.65 1.02,-0.16 1.53,-1.22 0.35,-0.72 1.45,-0.63 2,-0.59 1.67,0.12 3.71,0.26 5.28,-0.89 3.27,-2.41 4.92,5.34 8.17,3.8 0.19,1.99 1.63,-0.52 1.8,1.54 0.59,-1.98 2.44,-1.19 3.23,-0.09 0.4,0.56 1.43,2.06 2.08,1.47 1.02,-0.94 1.1,0.35 1.71,1.33 1.47,2.34 0.63,2.97 2.01,5.13 0.43,0.58 0.17,2.01 0.64,2.54 0.54,0.72 0.84,-0.87 1.37,-0.1 1,1.5 -2.09,6.45 -1.31,4.43 1.38,-3.59 8.24,4.6 4.88,5.82 0.96,0.44 1.03,1.5 2.05,1.84 -2.69,2.75 -6.6,-3.2 -8.56,0.35 -0.2,-0.68 -0.39,-1.38 -0.56,-2.08 -4.05,1.52 -1.17,4.57 -3.58,7.59 -1.39,1.75 -2.28,2.99 -3.31,4.9 -0.21,0.42 -0.21,1.33 -0.78,1.47 -0.8,0.21 -2.2,-0.51 -2.46,0.96 -1.31,-1.31 -0.12,-2.78 -0.72,-4.34 -0.6,-1.61 -0.66,-3.62 -0.42,-5.37 0.28,-2.13 1.88,-4.08 1.47,-6.24 -0.35,-1.82 -1.06,-3.95 -2.29,-5.25 -2.83,-2.97 -5.85,-6.23 -7.66,-10.08 -1.46,-3.08 -2.71,-6.66 -6.55,-6.89",
						"LB" : "m 616.64,530.48 c 2.45,-2.92 2.75,-8.15 4.88,-11.42 1.07,-1.63 0.11,-3.8 1.31,-5.37 0.94,-1.21 3.35,-2.55 2.73,-4.43 0.87,0.19 2.16,0.61 3.04,0.05 2.02,-1.26 0.48,1.15 0.71,1.87 -0.03,-0.09 1.25,0.45 1.37,0.59 0.9,1.03 0.36,0.8 0.99,2.29 1.33,3.17 -3.7,3.67 -1.9,6.35 -1.98,-0.66 -5.53,0.89 -3.31,3.39 -0.91,0.23 -4.18,3.5 -4.39,4.51 -0.2,-0.14 -0.36,-0.31 -0.46,-0.56 -0.39,0.72 -0.35,1.68 -0.88,2.33 -0.95,1.15 -2.97,0.42 -4.09,0.38",
						"CY" : "m 587.86,504.63 c -0.11,-0.42 -0.21,-0.82 -0.32,-1.24 1.27,1.52 3.56,-1.38 5.14,-1.26 2.45,0.19 0.82,-2.55 3.09,-2.48 2.44,0.07 4.58,0.54 7.1,-0.19 2.83,-0.82 5.56,-3.99 8.47,-3.99 -1.94,1.28 -3.83,4.25 -5.92,4.95 -2.29,0.77 -0.25,3.13 0.54,4.22 -0.96,0.12 -3.09,-0.09 -3.88,0.65 -0.86,0.8 -1.21,1.94 -2.34,2.36 -0.99,0.37 -4.85,0.82 -4.37,2.75 -3.09,-1.78 -6.28,-1.26 -7.5,-5.75",
						"LU" : "m 315.91,303.09 c -0.03,-0.35 0.75,-0.23 -0.12,-0.45 1.07,-0.96 0.98,-3.24 2.48,-3.76 1.73,-0.59 1.23,1.47 1.84,2.41 0.8,1.26 2.44,1.68 3.35,2.85 0.96,1.28 -1.41,2.8 -1.22,4.27 -0.99,-0.86 -4.19,-0.51 -5.68,-1.03 1.85,-1.42 -0.07,-2.75 -0.64,-4.29"
					}
				}
			}
		}
	);
})(jQuery);