/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraph;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class ForwardingGraph<N>
extends AbstractGraph<N> {
    ForwardingGraph() {
    }

    abstract BaseGraph<N> delegate();

    @Override
    public Set<N> nodes() {
        return this.delegate().nodes();
    }

    @Override
    protected long edgeCount() {
        return this.delegate().edges().size();
    }

    @Override
    public boolean isDirected() {
        return this.delegate().isDirected();
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.delegate().allowsSelfLoops();
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.delegate().nodeOrder();
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return this.delegate().incidentEdgeOrder();
    }

    @Override
    public Set<N> adjacentNodes(N node2) {
        return this.delegate().adjacentNodes(node2);
    }

    @Override
    public Set<N> predecessors(N node2) {
        return this.delegate().predecessors((Object)node2);
    }

    @Override
    public Set<N> successors(N node2) {
        return this.delegate().successors((Object)node2);
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N node2) {
        return this.delegate().incidentEdges(node2);
    }

    @Override
    public int degree(N node2) {
        return this.delegate().degree(node2);
    }

    @Override
    public int inDegree(N node2) {
        return this.delegate().inDegree(node2);
    }

    @Override
    public int outDegree(N node2) {
        return this.delegate().outDegree(node2);
    }

    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.delegate().hasEdgeConnecting(nodeU, nodeV);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        return this.delegate().hasEdgeConnecting(endpoints);
    }
}

