/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.transforms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.transforms.params.XPathFilterCHGPContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SampleTransformXPathFilterCHGP {
    public static void main(String[] stringArray) throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string = "<A xmlns:foo=\"http://foo.bar/\">\n<U>\n<U>\n<U>\n<U>\n<U>\n<B foo:attr=\"attr\">\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n<C>\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n<U>\n<U>\n<U>\n<U/>\n<U>\n<U/>\n<U/>\n</U>\n<U/>\n</U>\n<U>\n<U/>\n</U>\n</U>\n</U>\n<U>\n<U>\n<U>\n<U/>\n<U>\n<U/>\n<U/>\n</U>\n<U/>\n</U>\n<U>\n<U/>\n</U>\n</U>\n</U>\n<U>\n<U>\n<U>\n<U/>\n<U>\n<U/>\n<U/>\n</U>\n<U/>\n</U>\n<U>\n<U/>\n</U>\n</U>\n</U>\n<U>\n<U>\n<U>\n<U/>\n<U>\n<U/>\n<U/>\n</U>\n<U/>\n</U>\n<U>\n<U/>\n</U>\n</U>\n<U>\n<U>\n<U>\n<U/>\n<U>\n<U/>\n<U/>\n</U>\n<U/>\n</U>\n<U>\n<U/>\n</U>\n<U>\n<U>\n<U>\n<U/>\n<U>\n<U/>\n<U/>\n</U>\n<U/>\n</U>\n<U>\n<U/>\n</U>\n</U>\n</U>\n</U>\n</U>\n</U>\n</C>\n</B>\n<D>\n<U/>\n</D>\n<U>\n<E>\n<S>\n<S>\n<S/>\n<S>\n<S/>\n<S/>\n</S>\n<S/>\n</S>\n<S>\n<S/>\n</S>\n</S>\n</E>\n<U>\n<F>\n<G>\n<H/>\n<G>\n<H/>\n</G>\n</G>\n</F>\n</U>\n</U>\n</U>\n</U>\n</U>\n</U>\n</U>\n</A>\n";
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        SampleTransformXPathFilterCHGP.outApache(document);
        document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        SampleTransformXPathFilterCHGP.outXFilter2(document);
    }

    static void outApache(Document document) throws Exception {
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        document.getDocumentElement().appendChild(xMLSignature.getElement());
        Transforms transforms = new Transforms(document);
        String string = "//B | //E | //F | //H";
        String string2 = "//G";
        String string3 = "//C | //D | here()/ancestor::ds:Signature[1] | //@x:attr";
        boolean bl = false;
        XPathFilterCHGPContainer xPathFilterCHGPContainer = XPathFilterCHGPContainer.getInstance((Document)document, (boolean)bl, (String)string, (String)string2, (String)string3);
        xPathFilterCHGPContainer.setXPathNamespaceContext("ds", "http://www.w3.org/2000/09/xmldsig#");
        xPathFilterCHGPContainer.setXPathNamespaceContext("x", "http://foo.bar/");
        transforms.addTransform("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter", xPathFilterCHGPContainer.getElement());
        xMLSignature.addDocument("", transforms);
        String string4 = "secret";
        xMLSignature.getKeyInfo().addKeyName("The UTF-8 octets of \"" + string4 + "\" are used for signing (" + string4.length() + " octets)");
        xMLSignature.sign((Key)xMLSignature.createSecretKey(string4.getBytes()));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        byte[] byArray = canonicalizer.canonicalizeSubtree((Node)document);
        System.out.println("-------------------------------------------------------------");
        System.out.println("The signed octets (output of the transforms) are ");
        System.out.println("-------------------------------------------------------------");
        System.out.println(new String(xMLSignature.getSignedInfo().item(0).getTransformsOutput().getBytes()));
        System.out.println("-------------------------------------------------------------");
        System.out.println("The document is ");
        System.out.println("-------------------------------------------------------------");
        System.out.println(new String(byArray));
        System.out.println("-------------------------------------------------------------");
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        XMLSignature xMLSignature2 = new XMLSignature(element, null);
        boolean bl2 = xMLSignature2.checkSignatureValue((Key)xMLSignature2.createSecretKey("secret".getBytes()));
        System.out.println("verify: " + bl2);
    }

    static void outXFilter2(Document document) throws Exception {
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        document.getDocumentElement().appendChild(xMLSignature.getElement());
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceIntersect((Document)document, (String)"//E").getElement());
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceUnion((Document)document, (String)"//B").getElement());
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceSubtract((Document)document, (String)"//C").getElement());
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceUnion((Document)document, (String)"//F").getElement());
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceSubtract((Document)document, (String)"//G").getElement());
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceUnion((Document)document, (String)"//H").getElement());
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceSubtract((Document)document, (String)"//@x:attr").getElement());
        transforms.setXPathNamespaceContext("xmlns:x", "http://foo.bar/");
        transforms.setXPathNamespaceContext(Transforms.getDefaultPrefix((String)"http://www.w3.org/2002/06/xmldsig-filter2"), "http://www.w3.org/2002/06/xmldsig-filter2");
        xMLSignature.addDocument("", transforms);
        String string = "secret";
        xMLSignature.getKeyInfo().addKeyName("The UTF-8 octets of \"" + string + "\" are used for signing (" + string.length() + " octets)");
        xMLSignature.sign((Key)xMLSignature.createSecretKey(string.getBytes()));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        byte[] byArray = canonicalizer.canonicalizeSubtree((Node)document);
        System.out.println("-------------------------------------------------------------");
        System.out.println("The signed octets (output of the transforms) are ");
        System.out.println("-------------------------------------------------------------");
        System.out.println(new String(xMLSignature.getSignedInfo().item(0).getTransformsOutput().getBytes()));
        System.out.println("-------------------------------------------------------------");
        System.out.println("The document is ");
        System.out.println("-------------------------------------------------------------");
        System.out.println(new String(byArray));
        System.out.println("-------------------------------------------------------------");
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        XMLSignature xMLSignature2 = new XMLSignature(element, null);
        boolean bl = xMLSignature2.checkSignatureValue((Key)xMLSignature2.createSecretKey("secret".getBytes()));
        System.out.println("verify: " + bl);
    }

    public static void check(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(string));
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        XMLSignature xMLSignature = new XMLSignature((Element)nodeList.item(0), new File(string).toURL().toString());
        boolean bl = xMLSignature.checkSignatureValue((Key)xMLSignature.createSecretKey("secret".getBytes()));
        System.out.println("-------------------------------------------------------------");
        System.out.println("Verification of " + string + ": " + bl);
        System.out.println("-------------------------------------------------------------");
        System.out.println(new String(xMLSignature.getSignedInfo().item(0).getTransformsOutput().getBytes()));
        System.out.println("-------------------------------------------------------------");
    }
}

