/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class PioneeringMissionTest
extends FreeColTestCase {
    private static final GoodsType toolsGoodsType = PioneeringMissionTest.spec().getGoodsType("model.goods.tools");
    private static final Role pioneerRole = PioneeringMissionTest.spec().getRole("model.role.pioneer");
    private static final UnitType colonistType = PioneeringMissionTest.spec().getUnitType("model.unit.freeColonist");
    private LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testImprovementNoLongerValid() {
        ServerGame game = ServerTestHelper.startServerGame(PioneeringMissionTest.getTestMap());
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer player = this.getServerPlayer(game, "model.nation.dutch");
        EuropeanAIPlayer aiPlayer = (EuropeanAIPlayer)aiMain.getAIPlayer(player);
        Colony colony = this.getStandardColony();
        AIColony aiColony = aiMain.getAIColony(colony);
        ServerUnit colonist = new ServerUnit(game, colony.getTile(), player, colonistType);
        AIUnit aiUnit = aiMain.getAIUnit(colonist);
        PioneeringMissionTest.assertNotNull((Object)aiUnit);
        aiUnit.setMission(null);
        aiColony.updateTileImprovementPlans(this.lb);
        List<TileImprovementPlan> improvements = aiColony.getTileImprovementPlans();
        PioneeringMissionTest.assertTrue((String)"There should be valid improvements", (!improvements.isEmpty() ? 1 : 0) != 0);
        aiPlayer.buildTipMap(this.lb);
        PioneeringMissionTest.assertTrue((String)"The player should need pioneers", (aiPlayer.pioneersNeeded() > 0 ? 1 : 0) != 0);
        PioneeringMissionTest.assertFalse((String)"Colonist can improve", (boolean)colonist.hasAbility("model.ability.improveTerrain"));
        PioneeringMissionTest.assertEquals((String)"Pioneering should be valid (despite no tools)", null, (String)PioneeringMission.invalidMissionReason(aiUnit));
        PioneeringMissionTest.assertNull((String)"Pioneering should find no targets though", (Object)PioneeringMission.findMissionTarget(aiUnit, 10, false));
        colony.addGoods(toolsGoodsType, 100);
        PioneeringMissionTest.assertTrue((String)"Colony can provide tools", (boolean)colony.canProvideGoods(pioneerRole.getRequiredGoodsList()));
        PioneeringMissionTest.assertEquals((String)"Colony found", (Object)colony, (Object)PioneeringMission.findMissionTarget(aiUnit, 10, false));
        PioneeringMissionTest.assertNull((String)"Pioneer has no mission", (Object)aiUnit.getMission());
        PioneeringMissionTest.assertNull((String)"Pioneering should be valid (tools present in colony)", (Object)PioneeringMission.invalidMissionReason(aiUnit));
        colony.addGoods(toolsGoodsType, -100);
        colonist.setRole(pioneerRole);
        PioneeringMissionTest.assertEquals((String)"Should be a pioneer", (Object)pioneerRole, (Object)colonist.getRole());
        PioneeringMissionTest.assertTrue((String)"Colonist can improve", (boolean)colonist.hasAbility("model.ability.improveTerrain"));
        PioneeringMissionTest.assertNotNull((String)"TileImprovementPlan found", (Object)PioneeringMission.findMissionTarget(aiUnit, 10, false));
        PioneeringMissionTest.assertNull((String)"Pioneering should be valid (unit has tools)", (Object)PioneeringMission.invalidMissionReason(aiUnit));
        Location loc = PioneeringMission.findMissionTarget(aiUnit, 10, false);
        PioneeringMissionTest.assertTrue((String)"Pioneer should find a tile to improve", (boolean)(loc instanceof Tile));
        PioneeringMission mission = new PioneeringMission(aiMain, aiUnit, loc);
        PioneeringMissionTest.assertTrue((String)"Mission should be valid", (boolean)mission.isValid());
        TileImprovementPlan tip = mission.getTileImprovementPlan();
        PioneeringMissionTest.assertNotNull((String)"Mission should have a plan", (Object)tip);
        Tile target = tip.getTarget();
        PioneeringMissionTest.assertNotNull((String)"Plan should have a target", (Object)target);
        PioneeringMissionTest.assertEquals((String)"Mission should stick", (Object)mission, (Object)aiUnit.getMission());
    }
}

