/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.storage.jpa.PersistenceExceptionConverter;

public class JpaTransactionWrapper
implements KeycloakTransaction {
    private static final Logger logger = Logger.getLogger(JpaTransactionWrapper.class);
    private final EntityTransaction transaction;

    public JpaTransactionWrapper(EntityTransaction transaction) {
        this.transaction = transaction;
    }

    public void begin() {
        logger.tracef("tx %d: begin", this.hashCode());
        this.transaction.begin();
    }

    public void commit() {
        try {
            logger.tracef("tx %d: commit", this.hashCode());
            this.transaction.commit();
        }
        catch (PersistenceException pe) {
            throw PersistenceExceptionConverter.convert(pe.getCause() != null ? pe.getCause() : pe);
        }
    }

    public void rollback() {
        logger.tracef("tx %d: rollback", this.hashCode());
        this.transaction.rollback();
    }

    public void setRollbackOnly() {
        this.transaction.setRollbackOnly();
    }

    public boolean getRollbackOnly() {
        return this.transaction.getRollbackOnly();
    }

    public boolean isActive() {
        return this.transaction.isActive();
    }
}

