/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrmp;
import oracle.jdbc.driver.T4CTTIkpdnrnf;
import oracle.jdbc.driver.T4CTTIkpdnrpay;
import oracle.jdbc.driver.T4CTTIkpdnrreq;
import oracle.sql.CharacterSet;

final class T4CTTIoaqnfy
extends T4CTTIfun {
    byte[] jmsConnectionId = null;
    boolean isMarshalOver = false;
    boolean needToBeClosed = false;
    OracleConnection conn = null;
    T4CTTIkpdnrnf notificationHeader = null;
    T4CTTIkpdnrmp messageProperties = null;
    T4CTTIkpdnrpay payload = null;
    NTFManager ntfManager = null;
    T4CMAREngine mar;
    String databaseUniqueIdentifier;
    boolean isDCNConnection = false;
    CharacterSet charset = null;

    T4CTTIoaqnfy(T4CConnection connection, String jmsConnectionId, boolean isDCN) throws SQLException {
        this(connection, jmsConnectionId);
        this.isDCNConnection = isDCN;
        this.charset = CharacterSet.make(this.conn.getDbCsId());
    }

    T4CTTIoaqnfy(T4CConnection connection, String jmsConnectionId) throws SQLException {
        super(connection, (byte)3);
        assert (connection != null && jmsConnectionId != null) : "connection is " + connection + ", jmsConnectionId is " + jmsConnectionId;
        this.setFunCode((short)187);
        this.conn = connection;
        this.mar = connection.mare;
        this.jmsConnectionId = this.mar.conv.StringToCharBytes(jmsConnectionId);
    }

    @Override
    void marshal() throws IOException {
        T4CTTIkpdnrreq req = new T4CTTIkpdnrreq((T4CConnection)this.conn);
        req.send(this.jmsConnectionId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
        this.isMarshalOver = true;
    }

    @Override
    void readOAC() throws SQLException, IOException {
        this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
        this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
        this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
        while (true) {
            this.notificationHeader.receive();
            if (this.notificationHeader.messageType != 4) {
                this.messageProperties.receive();
                this.payload.receive();
                if (this.isDCNConnection) {
                    this.createAndGenerateDCNEvent();
                    continue;
                }
                this.createAndGenerateEvent();
                continue;
            }
            if (this.isDCNConnection) continue;
            this.throwException(this.notificationHeader.errorCode);
        }
    }

    private void throwException(int errCode) {
        try {
            int jdbcRegId = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
            NTFJMSRegistration registration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(jdbcRegId);
            switch (errCode) {
                case 24035: {
                    registration.raiseException(2);
                    break;
                }
                case 24010: {
                    registration.raiseException(3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createAndGenerateDCNEvent() throws SQLException {
        long regId = this.notificationHeader.getRegistrationId();
        NTFDCNRegistration registration = PhysicalConnection.ntfManager.getDCNRegistration(regId);
        NTFDCNEvent dcnEvent = new NTFDCNEvent(regId, this.payload.getRawPayload(), registration.getDatabaseVersion(), this.charset.getOracleId());
        registration.notify(dcnEvent);
    }

    public void createAndGenerateEvent() throws SQLException {
        try {
            int jdbcRegId = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
            NTFJMSRegistration registration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(jdbcRegId);
            NTFJMSEvent jmsEvent = new NTFJMSEvent(this);
            jmsEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
            jmsEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
            jmsEvent.setMessageId(this.messageProperties.getMessageId());
            if (this.payload.payloadType == 1) {
                jmsEvent.setPayload(this.payload.getRawPayload());
            } else if (this.payload.payloadType == 2) {
                AQMessageI aqMsg = new AQMessageI(this.messageProperties.getAqMessageProperties());
                aqMsg.setPayload(this.payload.getRawPayload(), this.payload.toid);
                aqMsg.setMessageId(this.messageProperties.getMessageId());
                jmsEvent.setAQMessage(aqMsg);
                jmsEvent.setAdt(true);
            }
            jmsEvent.setConsumerName(this.notificationHeader.getConsumerName());
            jmsEvent.setQueueName(this.notificationHeader.getNotificationQueue());
            jmsEvent.setRegistration(this.notificationHeader.getNotificationQueue());
            registration.notify(jmsEvent);
        }
        catch (NullPointerException ne) {
            return;
        }
    }

    public void stopListening() {
        while (!this.isMarshalOver) {
        }
        this.needToBeClosed = true;
    }
}

