/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;

public interface EntityFieldDelegate<E>
extends UpdatableEntity {
    public <EF extends Enum<? extends EntityField<E>>> Object get(EF var1);

    public <T, EF extends Enum<? extends EntityField<E>>> void set(EF var1, T var2);

    public <T, EF extends Enum<? extends EntityField<E>>> void collectionAdd(EF var1, T var2);

    public <T, EF extends Enum<? extends EntityField<E>>> Object collectionRemove(EF var1, T var2);

    public <K, EF extends Enum<? extends EntityField<E>>> Object mapGet(EF var1, K var2);

    public <K, T, EF extends Enum<? extends EntityField<E>>> void mapPut(EF var1, K var2, T var3);

    public <K, EF extends Enum<? extends EntityField<E>>> Object mapRemove(EF var1, K var2);

    public static abstract class WithEntity<E extends UpdatableEntity>
    implements EntityFieldDelegate<E> {
        protected final E entity;

        public WithEntity(E entity) {
            this.entity = entity;
        }

        @Override
        public <EF extends Enum<? extends EntityField<E>>> Object get(EF field) {
            return ((EntityField)((Object)field)).get(this.entity);
        }

        @Override
        public <T, EF extends Enum<? extends EntityField<E>>> void set(EF field, T value) {
            ((EntityField)((Object)field)).set(this.entity, value);
        }

        @Override
        public <K, EF extends Enum<? extends EntityField<E>>> Object mapRemove(EF field, K key) {
            return ((EntityField)((Object)field)).mapRemove(this.entity, key);
        }

        @Override
        public <K, T, EF extends Enum<? extends EntityField<E>>> void mapPut(EF field, K key, T value) {
            ((EntityField)((Object)field)).mapPut(this.entity, key, value);
        }

        @Override
        public <K, EF extends Enum<? extends EntityField<E>>> Object mapGet(EF field, K key) {
            return ((EntityField)((Object)field)).mapGet(this.entity, key);
        }

        @Override
        public <T, EF extends Enum<? extends EntityField<E>>> Object collectionRemove(EF field, T value) {
            return ((EntityField)((Object)field)).collectionRemove(this.entity, value);
        }

        @Override
        public <T, EF extends Enum<? extends EntityField<E>>> void collectionAdd(EF field, T value) {
            ((EntityField)((Object)field)).collectionAdd(this.entity, value);
        }

        @Override
        public boolean isUpdated() {
            return this.entity.isUpdated();
        }

        @Override
        public void markUpdatedFlag() {
            this.entity.markUpdatedFlag();
        }

        @Override
        public void clearUpdatedFlag() {
            this.entity.clearUpdatedFlag();
        }

        public String toString() {
            return "&" + String.valueOf(this.entity);
        }
    }
}

