/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import java.util.List;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.timeseries.TSElement;
import redis.clients.jedis.timeseries.TSKeyValue;
import redis.clients.jedis.timeseries.TSKeyedElements;

public final class TimeSeriesBuilderFactory {
    public static final Builder<TSElement> TIMESERIES_ELEMENT = new Builder<TSElement>(){

        @Override
        public TSElement build(Object data) {
            List list = (List)data;
            if (list == null || list.isEmpty()) {
                return null;
            }
            return new TSElement(BuilderFactory.LONG.build(list.get(0)), BuilderFactory.DOUBLE.build(list.get(1)));
        }
    };
    public static final Builder<List<TSElement>> TIMESERIES_ELEMENT_LIST = new Builder<List<TSElement>>(){

        @Override
        public List<TSElement> build(Object data) {
            return ((List)data).stream().map(pairObject -> (List)pairObject).map(pairList -> new TSElement(BuilderFactory.LONG.build(pairList.get(0)), BuilderFactory.DOUBLE.build(pairList.get(1)))).collect(Collectors.toList());
        }
    };
    public static final Builder<List<TSKeyedElements>> TIMESERIES_MRANGE_RESPONSE = new Builder<List<TSKeyedElements>>(){

        @Override
        public List<TSKeyedElements> build(Object data) {
            return ((List)data).stream().map(tsObject -> (List)tsObject).map(tsList -> new TSKeyedElements(BuilderFactory.STRING.build(tsList.get(0)), BuilderFactory.STRING_MAP_FROM_PAIRS.build(tsList.get(1)), TIMESERIES_ELEMENT_LIST.build(tsList.get(2)))).collect(Collectors.toList());
        }
    };
    public static final Builder<List<TSKeyValue<TSElement>>> TIMESERIES_MGET_RESPONSE = new Builder<List<TSKeyValue<TSElement>>>(){

        @Override
        public List<TSKeyValue<TSElement>> build(Object data) {
            return ((List)data).stream().map(tsObject -> (List)tsObject).map(tsList -> new TSKeyValue<TSElement>(BuilderFactory.STRING.build(tsList.get(0)), BuilderFactory.STRING_MAP_FROM_PAIRS.build(tsList.get(1)), TIMESERIES_ELEMENT.build(tsList.get(2)))).collect(Collectors.toList());
        }
    };

    private TimeSeriesBuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

