/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.auth.UserIdentifier;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.GetAccountInfoRequest;
import com.google.firebase.internal.NonNull;

public final class EmailIdentifier
extends UserIdentifier {
    private final String email;

    public EmailIdentifier(@NonNull String email) {
        UserRecord.checkEmail(email);
        this.email = email;
    }

    @Override
    public String toString() {
        return "EmailIdentifier(" + this.email + ")";
    }

    @Override
    void populate(@NonNull GetAccountInfoRequest payload) {
        payload.addEmail(this.email);
    }

    @Override
    boolean matches(@NonNull UserRecord userRecord) {
        return this.email.equals(userRecord.getEmail());
    }
}

