/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jxls.common.JxlsException;
import org.jxls.util.UtilWrapper;

public class OrderByComparator<T>
implements Comparator<T> {
    private final UtilWrapper util;
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final int ORDER_ASC = 1;
    public static final int ORDER_DESC = -1;
    private List<String> myProperties;
    private List<Integer> myOrderings;
    private int mySize;

    public OrderByComparator(List<String> expressions, UtilWrapper util) {
        this.util = util;
        this.setExpressions(expressions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setExpressions(List<String> expressions) {
        if (expressions == null || expressions.size() <= 0) {
            throw new JxlsException("No order by expressions found.");
        }
        this.mySize = expressions.size();
        this.myProperties = new ArrayList<String>(this.mySize);
        this.myOrderings = new ArrayList<Integer>(this.mySize);
        for (String expr : expressions) {
            String[] parts = expr.trim().split("\\s+");
            if (parts.length <= 0 || parts.length >= 5) throw new JxlsException("Expected \"property\" [ASC|DESC] : " + expr);
            String property = parts[0];
            int ordering = 1;
            if (parts.length == 2 || parts.length == 4) {
                if (ASC.equalsIgnoreCase(parts[1])) {
                    ordering = 1;
                } else {
                    if (!DESC.equalsIgnoreCase(parts[1])) throw new JxlsException("Expected \"ASC\" or \"DESC: " + expr);
                    ordering = -1;
                }
            }
            this.myProperties.add(property);
            this.myOrderings.add(ordering);
        }
    }

    @Override
    public int compare(T o1, T o2) throws UnsupportedOperationException {
        int comp = 0;
        for (int i = 0; i < this.mySize; ++i) {
            Comparable value2;
            Comparable value1;
            String property = this.myProperties.get(i);
            int ordering = this.myOrderings.get(i);
            try {
                value1 = (Comparable)this.util.getObjectProperty(o1, property);
                value2 = (Comparable)this.util.getObjectProperty(o2, property);
            }
            catch (ClassCastException e) {
                throw new JxlsException("Property \"" + property + "\" must implement Comparable.");
            }
            catch (Exception e) {
                throw new JxlsException("Error accessing property \"" + property + "\".", e);
            }
            if (value1 != null && value2 != null) {
                comp = value1.compareTo(value2) * ordering;
                if (comp == 0) continue;
                return comp;
            }
            if (value1 == null && value2 != null) {
                return 1 * ordering;
            }
            if (value1 == null || value2 != null) continue;
            return -1 * ordering;
        }
        return 0;
    }
}

