/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProtocolMessageParser<T extends ProtocolMessage>
extends Parser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion version;
    private final Config config;

    public ProtocolMessageParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array);
        this.version = version;
        this.config = config;
    }

    @Override
    public final T parse() {
        T msg = this.parseMessageContent();
        this.parseCompleteResultingMessage((ProtocolMessage)msg);
        return msg;
    }

    protected abstract T parseMessageContent();

    private void parseCompleteResultingMessage(ProtocolMessage msg) {
        msg.setCompleteResultingMessage(this.getAlreadyParsed());
        LOGGER.debug("CompleteResultMessage: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCompleteResultingMessage().getValue())));
    }

    protected ProtocolVersion getVersion() {
        return this.version;
    }

    protected Config getConfig() {
        return this.config;
    }
}

