/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderTextParser
extends SpiderParser {
    private static final Pattern patternURL = Pattern.compile("\\W(http(s?)://[^\\x00-\\x1f\"'\\s<>#()\\[\\]{}]+)", 2);

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        this.getLogger().debug("Parsing a non-HTML text resource.");
        String baseURL = message.getRequestHeader().getURI().toString();
        Matcher matcher = patternURL.matcher(message.getResponseBody().toString());
        while (matcher.find()) {
            String s = matcher.group(1);
            this.processURL(message, depth, s, baseURL);
        }
        return false;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyConsumed) {
        return !wasAlreadyConsumed && message.getResponseHeader().isText() && !message.getResponseHeader().isHtml();
    }
}

