/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) + 0ul) => u64vec2(10ul, 12ul)
 * (u64vec2(10ul, 12ul) + 3ul) => u64vec2(13ul, 15ul)
 * (u64vec2(10ul, 12ul) + 1192ul) => u64vec2(1202ul, 1204ul)
 * (u64vec2(10ul, 12ul) + 1048576ul) => u64vec2(1048586ul, 1048588ul)
 * (u64vec2(10ul, 12ul) + 4251475ul) => u64vec2(4251485ul, 4251487ul)
 * (u64vec2(10ul, 12ul) + 29852643761ul) => u64vec2(29852643771ul, 29852643773ul)
 * (u64vec2(10ul, 12ul) + 4398046511104ul) => u64vec2(4398046511114ul, 4398046511116ul)
 * (u64vec2(10ul, 12ul) + 3948976685146ul) => u64vec2(3948976685156ul, 3948976685158ul)
 * (u64vec2(10ul, 12ul) + 135763469567146206ul) => u64vec2(135763469567146216ul, 135763469567146218ul)
 * (u64vec2(10ul, 12ul) + 11654173250180970009ul) => u64vec2(11654173250180970019ul, 11654173250180970021ul)
 * (u64vec2(42ul, 48ul) + 0ul) => u64vec2(42ul, 48ul)
 * (u64vec2(42ul, 48ul) + 3ul) => u64vec2(45ul, 51ul)
 * (u64vec2(42ul, 48ul) + 1192ul) => u64vec2(1234ul, 1240ul)
 * (u64vec2(42ul, 48ul) + 1048576ul) => u64vec2(1048618ul, 1048624ul)
 * (u64vec2(42ul, 48ul) + 4251475ul) => u64vec2(4251517ul, 4251523ul)
 * (u64vec2(42ul, 48ul) + 29852643761ul) => u64vec2(29852643803ul, 29852643809ul)
 * (u64vec2(42ul, 48ul) + 4398046511104ul) => u64vec2(4398046511146ul, 4398046511152ul)
 * (u64vec2(42ul, 48ul) + 3948976685146ul) => u64vec2(3948976685188ul, 3948976685194ul)
 * (u64vec2(42ul, 48ul) + 135763469567146206ul) => u64vec2(135763469567146248ul, 135763469567146254ul)
 * (u64vec2(42ul, 48ul) + 11654173250180970009ul) => u64vec2(11654173250180970051ul, 11654173250180970057ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) + 0ul), u64vec2(10ul, 12ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) + 3ul), u64vec2(13ul, 15ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) + 1192ul), u64vec2(1202ul, 1204ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(10ul, 12ul) + 1048576ul), u64vec2(1048586ul, 1048588ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(10ul, 12ul) + 4251475ul), u64vec2(4251485ul, 4251487ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(10ul, 12ul) + 29852643761ul), u64vec2(29852643771ul, 29852643773ul))) ? 1 : -1] array5;
  float[all(equal((u64vec2(10ul, 12ul) + 4398046511104ul), u64vec2(4398046511114ul, 4398046511116ul))) ? 1 : -1] array6;
  float[all(equal((u64vec2(10ul, 12ul) + 3948976685146ul), u64vec2(3948976685156ul, 3948976685158ul))) ? 1 : -1] array7;
  float[all(equal((u64vec2(10ul, 12ul) + 135763469567146206ul), u64vec2(135763469567146216ul, 135763469567146218ul))) ? 1 : -1] array8;
  float[all(equal((u64vec2(10ul, 12ul) + 11654173250180970009ul), u64vec2(11654173250180970019ul, 11654173250180970021ul))) ? 1 : -1] array9;
  float[all(equal((u64vec2(42ul, 48ul) + 0ul), u64vec2(42ul, 48ul))) ? 1 : -1] array10;
  float[all(equal((u64vec2(42ul, 48ul) + 3ul), u64vec2(45ul, 51ul))) ? 1 : -1] array11;
  float[all(equal((u64vec2(42ul, 48ul) + 1192ul), u64vec2(1234ul, 1240ul))) ? 1 : -1] array12;
  float[all(equal((u64vec2(42ul, 48ul) + 1048576ul), u64vec2(1048618ul, 1048624ul))) ? 1 : -1] array13;
  float[all(equal((u64vec2(42ul, 48ul) + 4251475ul), u64vec2(4251517ul, 4251523ul))) ? 1 : -1] array14;
  float[all(equal((u64vec2(42ul, 48ul) + 29852643761ul), u64vec2(29852643803ul, 29852643809ul))) ? 1 : -1] array15;
  float[all(equal((u64vec2(42ul, 48ul) + 4398046511104ul), u64vec2(4398046511146ul, 4398046511152ul))) ? 1 : -1] array16;
  float[all(equal((u64vec2(42ul, 48ul) + 3948976685146ul), u64vec2(3948976685188ul, 3948976685194ul))) ? 1 : -1] array17;
  float[all(equal((u64vec2(42ul, 48ul) + 135763469567146206ul), u64vec2(135763469567146248ul, 135763469567146254ul))) ? 1 : -1] array18;
  float[all(equal((u64vec2(42ul, 48ul) + 11654173250180970009ul), u64vec2(11654173250180970051ul, 11654173250180970057ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
