/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorderImageSlice
extends org.w3c.css.properties.css.CssBorderImageSlice {
    public static final CssIdent fill = CssIdent.getIdent("fill");

    public static final CssIdent getMatchingIdent(CssIdent ident) {
        return fill.equals(ident) ? fill : null;
    }

    public CssBorderImageSlice() {
        this.value = initial;
    }

    public CssBorderImageSlice(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        CssValueList valueList = new CssValueList();
        if (check && expression.getCount() > 5) {
            throw new InvalidParamException("unrecognize", ac);
        }
        boolean gotFill = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    CssCheckableValue num = val.getCheckableValue();
                    num.checkPositiveness(ac, this);
                    valueList.add(val);
                    break;
                }
                case 4: {
                    CssPercentage percent = val.getPercentage();
                    percent.checkPositiveness(ac, this);
                    if (percent.floatValue() > 100.0f) {
                        ac.getFrame().addWarning("out-of-range", percent.toString());
                    }
                    valueList.add(val);
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        valueList.add(inherit);
                        break;
                    }
                    if (fill.equals(val)) {
                        if (gotFill || valueList.size() != 0 && expression.getRemainingCount() > 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        gotFill = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (gotFill) {
            valueList.add(fill);
        }
        this.value = valueList.size() == 1 ? valueList.get(0) : valueList;
    }

    public CssBorderImageSlice(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

