import collections
from _typeshed import Self
from typing import Any, Iterator

class Shelf(collections.MutableMapping[Any, Any]):
    def __init__(
        self, dict: dict[Any, Any], protocol: int | None = ..., writeback: bool = ..., keyencoding: str = ...
    ) -> None: ...
    def __iter__(self) -> Iterator[str]: ...
    def keys(self) -> list[Any]: ...
    def __len__(self) -> int: ...
    def has_key(self, key: Any) -> bool: ...
    def __contains__(self, key: Any) -> bool: ...
    def get(self, key: Any, default: Any = ...) -> Any: ...
    def __getitem__(self, key: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any) -> None: ...
    def __delitem__(self, key: Any) -> None: ...
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, type: Any, value: Any, traceback: Any) -> None: ...
    def close(self) -> None: ...
    def __del__(self) -> None: ...
    def sync(self) -> None: ...

class BsdDbShelf(Shelf):
    def __init__(
        self, dict: dict[Any, Any], protocol: int | None = ..., writeback: bool = ..., keyencoding: str = ...
    ) -> None: ...
    def set_location(self, key: Any) -> tuple[str, Any]: ...
    def next(self) -> tuple[str, Any]: ...
    def previous(self) -> tuple[str, Any]: ...
    def first(self) -> tuple[str, Any]: ...
    def last(self) -> tuple[str, Any]: ...

class DbfilenameShelf(Shelf):
    def __init__(self, filename: str, flag: str = ..., protocol: int | None = ..., writeback: bool = ...) -> None: ...

def open(filename: str, flag: str = ..., protocol: int | None = ..., writeback: bool = ...) -> DbfilenameShelf: ...
