# Copyright 2014-2016 OpenMarket Ltd
# Copyright 2019 New Vector Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging

import attr
from signedjson.types import VerifyKey

logger = logging.getLogger(__name__)


@attr.s(slots=True, frozen=True, auto_attribs=True)
class FetchKeyResult:
    verify_key: VerifyKey  # the key itself
    valid_until_ts: int  # how long we can use this key for


@attr.s(slots=True, frozen=True, auto_attribs=True)
class FetchKeyResultForRemote:
    key_json: bytes  # the full key JSON
    valid_until_ts: int  # how long we can use this key for, in milliseconds.
    added_ts: int  # When we added this key, in milliseconds.
