/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedConfigXmlParser30;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedConfigXmlWriter
extends BaseXmlWriter<ProvisionedConfig> {
    private static final ProvisionedConfigXmlWriter INSTANCE = new ProvisionedConfigXmlWriter();

    public static ProvisionedConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedConfigXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ProvisionedConfig config) throws XMLStreamException {
        return this.toElement(config, "urn:jboss:galleon:provisioned-config:3.0");
    }

    protected ElementNode toElement(ProvisionedConfig config, String ns) throws XMLStreamException {
        ElementNode propE;
        ElementNode propsE;
        ElementNode configE = ProvisionedConfigXmlWriter.addElement(null, ProvisionedConfigXmlParser30.Element.CONFIG.getLocalName(), ns);
        if (config.getName() != null) {
            ProvisionedConfigXmlWriter.addAttribute(configE, ProvisionedConfigXmlParser30.Attribute.NAME, config.getName());
        }
        if (config.getModel() != null) {
            ProvisionedConfigXmlWriter.addAttribute(configE, ProvisionedConfigXmlParser30.Attribute.MODEL, config.getModel());
        }
        if (config.hasProperties()) {
            propsE = ProvisionedConfigXmlWriter.addElement(configE, ProvisionedConfigXmlParser30.Element.PROPS.getLocalName(), ns);
            for (Map.Entry entry : config.getProperties().entrySet()) {
                propE = ProvisionedConfigXmlWriter.addElement(propsE, ProvisionedConfigXmlParser30.Element.PROP.getLocalName(), ns);
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedConfigXmlParser30.Attribute.NAME, (String)entry.getKey());
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedConfigXmlParser30.Attribute.VALUE, (String)entry.getValue());
            }
        }
        if (config.hasLayers()) {
            propsE = ProvisionedConfigXmlWriter.addElement(configE, ProvisionedConfigXmlParser30.Element.LAYERS.getLocalName(), ns);
            for (ConfigId configId : config.getLayers()) {
                propE = ProvisionedConfigXmlWriter.addElement(propsE, ProvisionedConfigXmlParser30.Element.LAYER.getLocalName(), ns);
                if (configId.getModel() != null) {
                    ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedConfigXmlParser30.Attribute.MODEL, configId.getModel());
                }
                ProvisionedConfigXmlWriter.addAttribute(propE, ProvisionedConfigXmlParser30.Attribute.NAME, configId.getName());
            }
        }
        if (config.hasFeatures()) {
            try {
                config.handle(new XmlConfigHandler(configE));
            }
            catch (ProvisioningException e) {
                throw new XMLStreamException("Failed to marshal ProvisionedConfig", e);
            }
        }
        return configE;
    }

    private static class XmlConfigHandler
    implements ProvisionedConfigHandler {
        private final ElementNode parent;
        private ElementNode fpElement;
        private ElementNode specElement;

        XmlConfigHandler(ElementNode parent) {
            this.parent = parent;
        }

        @Override
        public void nextFeaturePack(FeaturePackLocation.FPID fpid) {
            this.fpElement = BaseXmlWriter.addElement(this.parent, ProvisionedConfigXmlParser30.Element.FEATURE_PACK.getLocalName(), this.parent.getNamespace());
            BaseXmlWriter.addAttribute(this.fpElement, ProvisionedConfigXmlParser30.Attribute.LOCATION, fpid.toString());
        }

        @Override
        public void nextSpec(ResolvedFeatureSpec spec) {
            this.specElement = BaseXmlWriter.addElement(this.fpElement, ProvisionedConfigXmlParser30.Element.SPEC.getLocalName(), this.parent.getNamespace());
            BaseXmlWriter.addAttribute(this.specElement, ProvisionedConfigXmlParser30.Attribute.NAME, spec.getId().getName());
        }

        @Override
        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            ElementNode featureE = BaseXmlWriter.addElement(this.specElement, ProvisionedConfigXmlParser30.Element.FEATURE.getLocalName(), this.parent.getNamespace());
            if (feature.hasId()) {
                BaseXmlWriter.addAttribute(featureE, ProvisionedConfigXmlParser30.Attribute.ID, feature.getId().toString());
            }
            if (feature.hasParams()) {
                for (String param : feature.getParamNames()) {
                    ElementNode paramE = BaseXmlWriter.addElement(featureE, ProvisionedConfigXmlParser30.Element.PARAM.getLocalName(), this.parent.getNamespace());
                    BaseXmlWriter.addAttribute(paramE, ProvisionedConfigXmlParser30.Attribute.NAME, param);
                    BaseXmlWriter.addAttribute(paramE, ProvisionedConfigXmlParser30.Attribute.VALUE, feature.getConfigParam(param));
                }
            }
        }
    }
}

