/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;

final class NIOConnectPacket
extends NIOPacket {
    static final boolean DEBUG = false;
    private static final String TUNNEL_CONNECT_DATA_FORMAT = "(DESCRIPTION=(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))(CONNECT_DATA=(TUNNEL_ID=%s)(CONNECTION_ID=%s)(SERVICE_NAME=tunnel)(CMAN_ID=jdbc)))";
    static final int ntCharacteristics = 20376;

    NIOConnectPacket(SessionAtts session) {
        super(session);
    }

    final void writeToSocketChannel(String connectData, boolean sendAttention, boolean useVIO, boolean isUrgentSupported, int sdu, int tdu, int anoFlags) throws IOException {
        if (sdu < 512) {
            sdu = 512;
        }
        if (tdu < 255) {
            tdu = 255;
        }
        if (sdu > 0x200000) {
            sdu = 0x200000;
        }
        if (tdu > 0x200000) {
            tdu = 0x200000;
        }
        if (tdu < sdu) {
            tdu = sdu;
        }
        if (this.session.isTunnelConnection) {
            ConnOption co = this.session.cOption.getOriginalConnOption();
            connectData = String.format(TUNNEL_CONNECT_DATA_FORMAT, co.protocol, co.host, co.port, co.service_name, this.session.getNetConnectionId());
        } else if (connectData != null) {
            connectData = NIOConnectPacket.prepareConnectData(connectData, this.session);
        }
        int dataLen = connectData == null ? 0 : connectData.length();
        boolean connDataOflow = dataLen > 230;
        boolean isANOEnabled = this.session.profile.isANOEnabled();
        this.session.prepareWriteBuffer();
        this.session.payloadBufferForWrite.order(ByteOrder.BIG_ENDIAN);
        this.session.payloadBufferForWrite.putShort((short)319);
        this.session.payloadBufferForWrite.putShort((short)300);
        int connFlag2 = 0;
        int opt = 1;
        if (sendAttention && isUrgentSupported) {
            opt |= 0xC00;
            if (this.session.networkType != NTAdapter.NetworkAdapterType.MSGQ && this.session.networkType != NTAdapter.NetworkAdapterType.BEQ) {
                connFlag2 = 1;
            }
        }
        if (useVIO) {
            opt |= 0x40;
        }
        this.session.payloadBufferForWrite.putShort((short)opt);
        if (sdu < 65535) {
            this.session.payloadBufferForWrite.putShort((short)sdu);
        } else {
            this.session.payloadBufferForWrite.putShort((short)-1);
        }
        if (tdu < 65535) {
            this.session.payloadBufferForWrite.putShort((short)tdu);
        } else {
            this.session.payloadBufferForWrite.putShort((short)-1);
        }
        this.session.payloadBufferForWrite.putShort((short)20376);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)1);
        this.session.payloadBufferForWrite.putShort((short)dataLen);
        this.session.payloadBufferForWrite.putShort((short)74);
        this.session.payloadBufferForWrite.putInt(0);
        byte naFlags = isANOEnabled ? (byte)(anoFlags | 0x80) : (byte)-120;
        this.session.payloadBufferForWrite.put(naFlags);
        this.session.payloadBufferForWrite.put(naFlags);
        this.session.payloadBufferForWrite.position(42);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putInt(sdu);
        this.session.payloadBufferForWrite.putInt(tdu);
        int compressionFieldBuilder = 0;
        if (this.session.networkCompression.equals("on") || this.session.networkCompression.equals("auto")) {
            compressionFieldBuilder = Integer.MIN_VALUE;
            if (this.session.networkCompression.equals("auto")) {
                compressionFieldBuilder |= 0x40000000;
            }
            if (!this.session.cOption.protocol.equalsIgnoreCase("tcp")) {
                compressionFieldBuilder |= 2;
            }
            int schemeShiftCounter = 26;
            for (String level : this.session.networkCompressionLevelsArray) {
                if (level.equals("low")) {
                    compressionFieldBuilder |= 1 << schemeShiftCounter;
                } else if (level.equals("high")) {
                    compressionFieldBuilder |= 2 << schemeShiftCounter;
                }
                schemeShiftCounter -= 4;
            }
        }
        this.session.payloadBufferForWrite.putInt(compressionFieldBuilder);
        this.session.payloadBufferForWrite.putInt(connFlag2);
        this.session.payloadBufferForWrite.position(66);
        if (!connDataOflow && dataLen > 0) {
            this.session.payloadBufferForWrite.put(connectData.getBytes("ASCII"));
        }
        this.header.type = 1;
        this.header.flags = this.session.redirecting ? 4 : 0;
        this.session.redirecting = false;
        this.writeToSocketChannel();
        if (connDataOflow) {
            byte[] connectDataBytes = connectData.getBytes("ASCII");
            this.session.dataChannel.writeDataToSocketChannel(connectDataBytes);
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        throw new UnsupportedOperationException("Attempting to read from a one way packet sent by client");
    }

    static final String prepareConnectData(String cdata, SessionAtts sessionAttributes) {
        try {
            NVNavigator navigator = new NVNavigator();
            NVPair rootNVPair = new NVFactory().createNVPair(cdata);
            NIOConnectPacket.changeHostNameToIPAddress(navigator, rootNVPair, sessionAttributes);
            NIOConnectPacket.addConnectionId(navigator, rootNVPair, sessionAttributes);
            return rootNVPair.toString();
        }
        catch (NLException nle) {
            return cdata;
        }
    }

    private static final void changeHostNameToIPAddress(NVNavigator navigator, NVPair rootNVPair, SessionAtts sessionAttributes) throws NLException {
        NVPair nvpAddrList = navigator.findNVPair(rootNVPair, "ADDRESS_LIST");
        NVPair nvpAddr = nvpAddrList != null ? navigator.findNVPair(nvpAddrList, "ADDRESS") : navigator.findNVPair(rootNVPair, "ADDRESS");
        if (nvpAddr == null) {
            return;
        }
        NVPair nvpHost = navigator.findNVPair(nvpAddr, "HOST");
        if (nvpHost == null) {
            return;
        }
        String configuredHostName = nvpHost.getAtom();
        if (configuredHostName == null) {
            return;
        }
        boolean changeToIPAddress = !configuredHostName.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && !configuredHostName.matches("[\\[[\\w:]*\\]]");
        InetAddress connectedSocketAddr = sessionAttributes.nt.getInetAddress();
        if (changeToIPAddress && connectedSocketAddr != null) {
            nvpHost.setAtom(connectedSocketAddr.getHostAddress());
        }
    }

    private static final void addConnectionId(NVNavigator navigator, NVPair rootNVPair, SessionAtts sessionAttributes) throws NLException {
        NVPair connectDataPair = navigator.findNVPair(rootNVPair, "CONNECT_DATA");
        if (connectDataPair != null && sessionAttributes.getNetConnectionId() != null) {
            connectDataPair.addListElement(new NVPair("CONNECTION_ID", sessionAttributes.getNetConnectionId()));
        }
    }
}

