/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.server.ServerConstant;
import io.smallrye.openapi.runtime.io.servervariable.ServerVariableReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class ServerReader {
    private ServerReader() {
    }

    public static Optional<List<Server>> readServers(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue != null) {
            IoLogging.logger.annotationsArray("@Server");
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            ArrayList<Server> servers = new ArrayList<Server>();
            for (AnnotationInstance serverAnno : nestedArray) {
                servers.add(ServerReader.readServer(context, serverAnno));
            }
            return Optional.of(servers);
        }
        return Optional.empty();
    }

    public static Optional<List<Server>> readServers(JsonNode node) {
        if (node != null && node.isArray()) {
            IoLogging.logger.jsonArray("Server");
            ArrayNode nodes = (ArrayNode)node;
            ArrayList<Server> rval = new ArrayList<Server>(nodes.size());
            for (JsonNode serverNode : nodes) {
                rval.add(ServerReader.readServer(serverNode));
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static Server readServer(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue != null) {
            return ServerReader.readServer(context, annotationValue.asNested());
        }
        return null;
    }

    public static Server readServer(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            IoLogging.logger.singleAnnotation("@Server");
            ServerImpl server = new ServerImpl();
            server.setUrl((String)Annotations.value(annotationInstance, "url"));
            server.setDescription((String)Annotations.value(annotationInstance, "description"));
            server.setVariables(ServerVariableReader.readServerVariables(context, annotationInstance.value("variables")));
            server.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
            return server;
        }
        return null;
    }

    public static Server readServer(JsonNode node) {
        if (node != null && node.isObject()) {
            IoLogging.logger.singleJsonNode("Server");
            ServerImpl server = new ServerImpl();
            server.setUrl(JsonUtil.stringProperty(node, "url"));
            server.setDescription(JsonUtil.stringProperty(node, "description"));
            server.setVariables(ServerVariableReader.readServerVariables(node.get("variables")));
            ExtensionReader.readExtensions(node, server);
            return server;
        }
        return null;
    }

    public static List<AnnotationInstance> getServerAnnotations(AnnotationTarget target) {
        return Annotations.getRepeatableAnnotation(target, ServerConstant.DOTNAME_SERVER, ServerConstant.DOTNAME_SERVERS);
    }
}

