/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class XrGraphicsBindingVulkanKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int INSTANCE;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;
    public static final int QUEUEFAMILYINDEX;
    public static final int QUEUEINDEX;

    public XrGraphicsBindingVulkanKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGraphicsBindingVulkanKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingVulkanKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingVulkanKHR.nnext(this.address());
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return XrGraphicsBindingVulkanKHR.ninstance(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return XrGraphicsBindingVulkanKHR.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return XrGraphicsBindingVulkanKHR.ndevice(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return XrGraphicsBindingVulkanKHR.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueIndex() {
        return XrGraphicsBindingVulkanKHR.nqueueIndex(this.address());
    }

    public XrGraphicsBindingVulkanKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingVulkanKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR type$Default() {
        return this.type(1000025000);
    }

    public XrGraphicsBindingVulkanKHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingVulkanKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR instance(VkInstance value) {
        XrGraphicsBindingVulkanKHR.ninstance(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR physicalDevice(VkPhysicalDevice value) {
        XrGraphicsBindingVulkanKHR.nphysicalDevice(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR device(VkDevice value) {
        XrGraphicsBindingVulkanKHR.ndevice(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingVulkanKHR.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR queueIndex(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingVulkanKHR.nqueueIndex(this.address(), value);
        return this;
    }

    public XrGraphicsBindingVulkanKHR set(int type, long next, VkInstance instance, VkPhysicalDevice physicalDevice, VkDevice device, int queueFamilyIndex, int queueIndex) {
        this.type(type);
        this.next(next);
        this.instance(instance);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.queueFamilyIndex(queueFamilyIndex);
        this.queueIndex(queueIndex);
        return this;
    }

    public XrGraphicsBindingVulkanKHR set(XrGraphicsBindingVulkanKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGraphicsBindingVulkanKHR malloc() {
        return (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGraphicsBindingVulkanKHR calloc() {
        return (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGraphicsBindingVulkanKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGraphicsBindingVulkanKHR create(long address) {
        return (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)address);
    }

    @Nullable
    public static XrGraphicsBindingVulkanKHR createSafe(long address) {
        return address == 0L ? null : (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGraphicsBindingVulkanKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingVulkanKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGraphicsBindingVulkanKHR malloc(MemoryStack stack) {
        return (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsBindingVulkanKHR calloc(MemoryStack stack) {
        return (XrGraphicsBindingVulkanKHR)XrGraphicsBindingVulkanKHR.wrap(XrGraphicsBindingVulkanKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGraphicsBindingVulkanKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE));
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE));
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEVICE));
    }

    public static int nqueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEX);
    }

    public static int nqueueIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEINDEX);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ninstance(long struct, VkInstance value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INSTANCE), (long)value.address());
    }

    public static void nphysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHYSICALDEVICE), (long)value.address());
    }

    public static void ndevice(long struct, VkDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEVICE), (long)value.address());
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEX, value);
    }

    public static void nqueueIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEINDEX, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DEVICE)));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingVulkanKHR.__struct((Struct.Member[])new Struct.Member[]{XrGraphicsBindingVulkanKHR.__member((int)4), XrGraphicsBindingVulkanKHR.__member((int)POINTER_SIZE), XrGraphicsBindingVulkanKHR.__member((int)POINTER_SIZE), XrGraphicsBindingVulkanKHR.__member((int)POINTER_SIZE), XrGraphicsBindingVulkanKHR.__member((int)POINTER_SIZE), XrGraphicsBindingVulkanKHR.__member((int)4), XrGraphicsBindingVulkanKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        INSTANCE = layout.offsetof(2);
        PHYSICALDEVICE = layout.offsetof(3);
        DEVICE = layout.offsetof(4);
        QUEUEFAMILYINDEX = layout.offsetof(5);
        QUEUEINDEX = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingVulkanKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingVulkanKHR ELEMENT_FACTORY = XrGraphicsBindingVulkanKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrGraphicsBindingVulkanKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingVulkanKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingVulkanKHR.nnext(this.address());
        }

        @NativeType(value="VkInstance")
        public long instance() {
            return XrGraphicsBindingVulkanKHR.ninstance(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevice() {
            return XrGraphicsBindingVulkanKHR.nphysicalDevice(this.address());
        }

        @NativeType(value="VkDevice")
        public long device() {
            return XrGraphicsBindingVulkanKHR.ndevice(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return XrGraphicsBindingVulkanKHR.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueIndex() {
            return XrGraphicsBindingVulkanKHR.nqueueIndex(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingVulkanKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000025000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingVulkanKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer instance(VkInstance value) {
            XrGraphicsBindingVulkanKHR.ninstance(this.address(), value);
            return this;
        }

        public Buffer physicalDevice(VkPhysicalDevice value) {
            XrGraphicsBindingVulkanKHR.nphysicalDevice(this.address(), value);
            return this;
        }

        public Buffer device(VkDevice value) {
            XrGraphicsBindingVulkanKHR.ndevice(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingVulkanKHR.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer queueIndex(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingVulkanKHR.nqueueIndex(this.address(), value);
            return this;
        }
    }
}

