/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MultiReleaseMemCopy {
    private MultiReleaseMemCopy() {
    }

    static void copy(long src, long dst, long bytes) {
        if (bytes < 64L) {
            int s = (int)src;
            int d = (int)dst;
            if (Pointer.BITS64) {
                if ((s & 7) == 0 && (d & 7) == 0) {
                    MemoryUtil.memCopyAligned64(src, dst, (int)bytes & 0x3F);
                    return;
                }
            } else if ((s & 3) == 0 && (d & 3) == 0) {
                MemoryUtil.memCopyAligned32(s, d, (int)bytes & 0x3F);
                return;
            }
        }
        MemoryUtil.UNSAFE.copyMemory(null, src, null, dst, bytes);
    }

    static {
        APIUtil.apiLog("Java 10 memcpy enabled");
    }
}

