/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.extended.WhoAmIOperation;
import org.ldaptive.extended.WhoAmIRequest;

public class WhoAmIEntryResolver
extends AbstractSearchEntryResolver {
    @Override
    protected SearchResult performLdapSearch(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) throws LdapException {
        WhoAmIOperation whoami = new WhoAmIOperation(response.getConnection());
        Response res = whoami.execute(new WhoAmIRequest());
        this.logger.debug("whoami operation returned {}", res);
        String authzId = (String)res.getResult();
        if (authzId == null || !authzId.contains(":")) {
            throw new IllegalStateException("WhoAmI operation returned illegal authorization ID: '" + authzId + "'");
        }
        String dn = authzId.split(":", 2)[1].trim();
        SearchOperation search = this.createSearchOperation(response.getConnection());
        return (SearchResult)search.execute(this.createSearchRequest(criteria, dn)).getResult();
    }

    protected SearchRequest createSearchRequest(AuthenticationCriteria ac, String dn) {
        SearchRequest request = SearchRequest.newObjectScopeSearchRequest(dn, ac.getAuthenticationRequest().getReturnAttributes());
        request.setDerefAliases(this.getDerefAliases());
        request.setReferralHandler(this.getReferralHandler());
        request.setSearchEntryHandlers(this.getSearchEntryHandlers());
        return request;
    }
}

