/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.filter.parser;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.indexmanagement.controlcenter.notification.filter.OperationResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J3\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH&\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J7\u0010\u0017\u001a\u00020\u00182\b\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0010\b\u0002\u0010\u0019\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH&\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResponseParser;", "Response", "Lorg/opensearch/core/action/ActionResponse;", "", "buildNotificationMessage", "", "response", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isTimeout", "", "(Lorg/opensearch/core/action/ActionResponse;Ljava/lang/Exception;Z)Ljava/lang/String;", "buildNotificationTitle", "operationResult", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/OperationResult;", "getIndexName", "req", "Lorg/opensearch/action/ActionRequest;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getOperationResultTitleDesc", "result", "parseAndSendNotification", "", "ex", "callback", "Ljava/util/function/Consumer;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ActionRespParseResult;", "(Lorg/opensearch/core/action/ActionResponse;Ljava/lang/Exception;Ljava/util/function/Consumer;)V", "opensearch-index-management"})
public interface ResponseParser<Response extends ActionResponse> {
    public void parseAndSendNotification(@Nullable Response var1, @Nullable Exception var2, @NotNull Consumer<ActionRespParseResult> var3);

    @NotNull
    public String buildNotificationMessage(@Nullable Response var1, @Nullable Exception var2, boolean var3);

    @NotNull
    public String buildNotificationTitle(@NotNull OperationResult var1);

    @Nullable
    public String getIndexName(@NotNull ActionRequest var1, @NotNull ClusterService var2);

    @NotNull
    public String getOperationResultTitleDesc(@NotNull OperationResult var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ void parseAndSendNotification$default(ResponseParser responseParser, ActionResponse actionResponse, Exception exception, Consumer consumer, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseAndSendNotification");
            }
            if ((n & 2) != 0) {
                exception = null;
            }
            responseParser.parseAndSendNotification(actionResponse, exception, consumer);
        }

        public static /* synthetic */ String buildNotificationMessage$default(ResponseParser responseParser, ActionResponse actionResponse, Exception exception, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildNotificationMessage");
            }
            if ((n & 2) != 0) {
                exception = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return responseParser.buildNotificationMessage(actionResponse, exception, bl);
        }

        @Nullable
        public static <Response extends ActionResponse> String getIndexName(@NotNull ResponseParser<Response> $this, @NotNull ActionRequest req, @NotNull ClusterService clusterService) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String clusterName = clusterService.getClusterName().value();
            ActionRequest actionRequest = req;
            if (actionRequest instanceof IndicesRequest) {
                if (((IndicesRequest)req).indices().length == 1) {
                    String[] stringArray = ((IndicesRequest)req).indices();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"req.indices()");
                    object = "[" + clusterName + "/" + ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]";
                } else {
                    String[] stringArray = ((IndicesRequest)req).indices();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"req.indices()");
                    object = "[" + ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "] from [" + clusterName + "]";
                }
            } else if (actionRequest instanceof ReindexRequest) {
                String string = clusterName = ((ReindexRequest)req).getRemoteInfo() != null ? "remote cluster " + ((ReindexRequest)req).getRemoteInfo().getHost() : clusterName;
                if (((ReindexRequest)req).getSearchRequest().indices().length == 1) {
                    String[] stringArray = ((ReindexRequest)req).getSearchRequest().indices();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"req.searchRequest.indices()");
                    object = "[" + clusterName + "/" + ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]";
                } else {
                    String[] stringArray = ((ReindexRequest)req).getSearchRequest().indices();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"req.searchRequest.indices()");
                    object = "[" + ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "] from [" + clusterName + "]";
                }
            } else {
                object = "";
            }
            return object;
        }

        @NotNull
        public static <Response extends ActionResponse> String getOperationResultTitleDesc(@NotNull ResponseParser<Response> $this, @NotNull OperationResult result2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 1: {
                    string = "completed";
                    break;
                }
                case 2: {
                    string = "failed";
                    break;
                }
                case 3: {
                    string = "timed out";
                    break;
                }
                case 4: {
                    string = "been cancelled";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperationResult.values().length];
            try {
                nArray[OperationResult.COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationResult.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationResult.TIMEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationResult.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

