/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.internal.SearchContext;

public abstract class AggregatorFactory {
    protected final String name;
    protected final AggregatorFactory parent;
    protected final AggregatorFactories factories;
    protected final Map<String, Object> metadata;
    protected final QueryShardContext queryShardContext;

    public AggregatorFactory(String name, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        this.name = name;
        this.queryShardContext = queryShardContext;
        this.parent = parent;
        this.factories = subFactoriesBuilder.build(queryShardContext, this);
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public void doValidate() {
    }

    protected abstract Aggregator createInternal(SearchContext var1, Aggregator var2, CardinalityUpperBound var3, Map<String, Object> var4) throws IOException;

    public final Aggregator create(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality) throws IOException {
        return this.createInternal(searchContext, parent, cardinality, this.metadata);
    }

    public AggregatorFactory getParent() {
        return this.parent;
    }

    public String getStatsSubtype() {
        return "other";
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return false;
    }

    public boolean evaluateChildFactories() {
        return this.factories.allFactoriesSupportConcurrentSearch();
    }
}

