/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.conversation.ConversationMeta;

public class GetConversationsResponse
extends ActionResponse
implements ToXContentObject {
    private List<ConversationMeta> conversations;
    private int nextToken;
    private boolean hasMoreTokens;

    public GetConversationsResponse(StreamInput in) throws IOException {
        super(in);
        this.conversations = in.readList(ConversationMeta::fromStream);
        this.nextToken = in.readInt();
        this.hasMoreTokens = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.conversations);
        out.writeInt(this.nextToken);
        out.writeBoolean(this.hasMoreTokens);
    }

    public boolean hasMorePages() {
        return this.hasMoreTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("conversations");
        for (ConversationMeta conversation : this.conversations) {
            conversation.toXContent(builder, params);
        }
        builder.endArray();
        if (this.hasMoreTokens) {
            builder.field("next_token", this.nextToken);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public GetConversationsResponse(List<ConversationMeta> conversations, int nextToken, boolean hasMoreTokens) {
        this.conversations = conversations;
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    @Generated
    public List<ConversationMeta> getConversations() {
        return this.conversations;
    }

    @Generated
    public int getNextToken() {
        return this.nextToken;
    }
}

