/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobEntryCategory;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryBase
implements Cloneable,
VariableSpace,
CheckResultSourceInterface,
ResourceHolderInterface {
    private String name;
    private String description;
    private String pluginID = null;
    private String configId;
    private boolean changed;
    private JobEntryType type;
    private long id;
    protected VariableSpace variables = new Variables();
    public static final String[] category_order = new String[]{JobEntryCategory.GENERAL.getName(), JobEntryCategory.MAIL.getName(), JobEntryCategory.FILE_MANAGEMENT.getName(), JobEntryCategory.CONDITIONS.getName(), JobEntryCategory.SCRIPTING.getName(), JobEntryCategory.BULK_LOADING.getName(), JobEntryCategory.XML.getName(), JobEntryCategory.FILE_TRANSFER.getName(), JobEntryCategory.REPOSITORY.getName(), JobEntryCategory.EXPERIMENTAL.getName()};

    public JobEntryBase() {
        this.name = null;
        this.description = null;
        this.type = JobEntryType.NONE;
    }

    public JobEntryBase(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.setID(-1L);
        this.type = JobEntryType.NONE;
    }

    public JobEntryBase(JobEntryBase jeb) {
        this.setName(jeb.getName());
        this.setDescription(jeb.getDescription());
        this.setJobEntryType(jeb.getJobEntryType());
        this.setID(jeb.getID());
    }

    public void clear() {
        this.name = null;
        this.description = null;
        this.changed = false;
    }

    public void setID(long id) {
        this.id = id;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public void setJobEntryType(JobEntryType type) {
        this.type = type;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    @Override
    public String getTypeId() {
        return this.getTypeCode();
    }

    public JobEntryType getJobEntryType() {
        return this.type;
    }

    public String getTypeCode() {
        if (this.pluginID != null) {
            return this.pluginID;
        }
        return this.type.toString();
    }

    public static final String getTypeCode(JobEntryType type) {
        return type.toString();
    }

    public String getTypeDesc() {
        return this.type.getDescription();
    }

    public static final String getTypeDesc(JobEntryType type) {
        return type.getDescription();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPluginID(String pid) {
        this.pluginID = pid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String Description) {
        this.description = Description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean isStart() {
        return false;
    }

    public boolean isDummy() {
        return false;
    }

    public boolean isEvaluation() {
        return this.getJobEntryType() == JobEntryType.EVAL;
    }

    public boolean isJob() {
        return this.getJobEntryType() == JobEntryType.JOB;
    }

    public boolean isMail() {
        return this.getJobEntryType() == JobEntryType.MAIL;
    }

    public boolean isShell() {
        return this.getJobEntryType() == JobEntryType.MAIL;
    }

    public boolean isSpecial() {
        return this.getJobEntryType() == JobEntryType.SPECIAL;
    }

    public boolean isTransformation() {
        return this.getJobEntryType() == JobEntryType.TRANS;
    }

    public boolean isFTP() {
        return this.getJobEntryType() == JobEntryType.FTP;
    }

    public boolean isSFTP() {
        return this.getJobEntryType() == JobEntryType.SFTP;
    }

    public boolean isHTTP() {
        return this.getJobEntryType() == JobEntryType.HTTP;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"description", (String)this.getDescription()));
        if (this.type != JobEntryType.NONE) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)this.getTypeCode()));
        }
        if (this.pluginID != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)this.pluginID));
        }
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleXMLException {
        try {
            this.setName(XMLHandler.getTagValue((Node)entrynode, (String)"name"));
            this.setDescription(XMLHandler.getTagValue((Node)entrynode, (String)"description"));
            String stype = XMLHandler.getTagValue((Node)entrynode, (String)"type");
            this.setJobEntryType(JobEntryCopy.getType(stype));
            this.setDescription(XMLHandler.getTagValue((Node)entrynode, (String)"description"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load base info for job entry", (Throwable)e);
        }
    }

    public void parseRepositoryObjects(Repository rep) throws KettleException {
    }

    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            this.setID(rep.insertJobEntry(id_job, this));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry base information to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            RowMetaAndData r = rep.getJobEntry(id_jobentry);
            if (r != null) {
                this.setName(r.getString("NAME", null));
                this.setDescription(r.getString("DESCRIPTION", null));
                int id_jobentry_type = (int)r.getInteger("ID_JOBENTRY_TYPE", 0L);
                RowMetaAndData jetrow = rep.getJobEntryType(id_jobentry_type);
                if (jetrow != null) {
                    this.type = JobEntryCopy.getType(jetrow.getString("CODE", null));
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load base job entry information from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    public Object clone() {
        JobEntryBase je;
        try {
            je = (JobEntryBase)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        return je;
    }

    public String toString() {
        return this.name;
    }

    public boolean resetErrorsBeforeExecution() {
        return true;
    }

    public boolean evaluates() {
        return false;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<SQLStatement> getSQLStatements(Repository repository) throws KettleException {
        return this.getSQLStatements(repository, null);
    }

    public List<SQLStatement> getSQLStatements(Repository repository, VariableSpace space) throws KettleException {
        return new ArrayList<SQLStatement>();
    }

    public String getFilename() {
        return null;
    }

    public String getRealFilename() {
        return null;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
    }

    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        return new ArrayList<ResourceReference>(5);
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository) throws KettleException {
        return null;
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        className = className.replaceFirst("\\.di\\.", ".di.ui.");
        className = className + "Dialog";
        return className;
    }

    @Override
    public String getHolderType() {
        return "JOBENTRY";
    }

    protected VariableSpace getVariables() {
        return this.variables;
    }
}

