/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.documentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.xfire.service.OperationInfo;

public class DocumentationProvider {
    private String serviceDocumentation;
    private Map operationsDocumentation = new HashMap();

    public String getOperationDoc(OperationInfo operation) {
        MethodInfo info = this.findMethodInfo(operation);
        return info == null ? null : info.getDocumentation();
    }

    private MethodInfo findMethodInfo(OperationInfo operation) {
        List operations = (List)this.operationsDocumentation.get(operation.getName());
        int paramsNr = operation.getMethod().getParameterTypes().length;
        if (operations != null) {
            for (int i = 0; i < operations.size(); ++i) {
                MethodInfo info = (MethodInfo)operations.get(i);
                if (info.getParamsDocumentation().size() != paramsNr) continue;
                return info;
            }
        }
        return null;
    }

    public String getParamters(OperationInfo operation, int index) {
        MethodInfo info = this.findMethodInfo(operation);
        return info == null ? null : info.getParamsDocumentation().get(index);
    }

    public String getResultDocumentation(OperationInfo operation) {
        MethodInfo info = this.findMethodInfo(operation);
        return info == null ? null : info.getReturnDocumentation();
    }

    public String getExceptionDocumentation(OperationInfo operation, String className) {
        MethodInfo info = this.findMethodInfo(operation);
        return info == null ? null : info.getExceptions().get(className);
    }

    public String getServiceDoc() {
        return this.serviceDocumentation;
    }

    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    void addOperation(String methodName, String documentation, List parameters, String resultDoc, Map exceptions) {
        ArrayList<MethodInfo> operations = (ArrayList<MethodInfo>)this.operationsDocumentation.get(methodName);
        MethodInfo info = new MethodInfo(methodName, parameters);
        info.setDocumentation(documentation);
        info.setReturnDocumentation(resultDoc);
        info.setExceptions(exceptions);
        if (operations == null) {
            operations = new ArrayList<MethodInfo>();
            this.operationsDocumentation.put(methodName, operations);
        }
        operations.add(info);
    }

    private class MethodInfo {
        private List paramsDocumentation;
        private String documentation;
        private String returnDocumentation;
        private Map exceptions;

        public Map getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(Map exceptions) {
            this.exceptions = exceptions;
        }

        public MethodInfo(String operationDoc, List paramsDoc) {
            this.documentation = operationDoc;
            this.paramsDocumentation = paramsDoc;
        }

        public List getParamsDocumentation() {
            return this.paramsDocumentation;
        }

        public void setDocumentation(String operationDocumentation) {
            this.documentation = operationDocumentation;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public String getReturnDocumentation() {
            return this.returnDocumentation;
        }

        public void setReturnDocumentation(String returnDocumentation) {
            this.returnDocumentation = returnDocumentation;
        }
    }
}

