/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.calls.tower.InvokeResolvePriority;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroupKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0000H\u0002J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u000b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "", "code", "", "debugKinds", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "invokeResolvePriority", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;", "receiverGroup", "(J[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;)V", "InvokeExtension", "getInvokeExtension", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "Member", "getMember", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "ContextReceiverGroup", "depth", "", "Implicit", "InvokeReceiver", "InvokeResolvePriority", "Local", "NonLocal", "TopPrioritized", "compareTo", "other", "debugCompareTo", "equals", "", "", "hashCode", "kindOf", "kind", "toString", "", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nTowerGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerGroup.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,271:1\n26#2:272\n*S KotlinDebug\n*F\n+ 1 TowerGroup.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup\n*L\n88#1:272\n*E\n"})
public final class TowerGroup
implements Comparable<TowerGroup> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long code;
    @NotNull
    private final TowerGroupKind[] debugKinds;
    @NotNull
    private final InvokeResolvePriority invokeResolvePriority;
    @Nullable
    private final TowerGroup receiverGroup;
    private static final int KIND_SIZE_BITS = Integer.bitCount(15);
    private static final int DEPTH_SIZE_BITS = Integer.bitCount(65535);
    private static final int USABLE_BITS = Long.numberOfLeadingZeros(63L);
    @NotNull
    private static final TowerGroupKind[] EMPTY_KIND_ARRAY;
    @NotNull
    private static final TowerGroup EmptyRoot;
    @NotNull
    private static final TowerGroup Start;
    @NotNull
    private static final TowerGroup Qualifier;
    @NotNull
    private static final TowerGroup Classifier;
    @NotNull
    private static final TowerGroup QualifierValue;
    @NotNull
    private static final TowerGroup Member;
    @NotNull
    private static final TowerGroup Last;

    private TowerGroup(long code, TowerGroupKind[] debugKinds, InvokeResolvePriority invokeResolvePriority, TowerGroup receiverGroup) {
        this.code = code;
        this.debugKinds = debugKinds;
        this.invokeResolvePriority = invokeResolvePriority;
        this.receiverGroup = receiverGroup;
    }

    /* synthetic */ TowerGroup(long l, TowerGroupKind[] towerGroupKindArray, InvokeResolvePriority invokeResolvePriority, TowerGroup towerGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            invokeResolvePriority = InvokeResolvePriority.NONE;
        }
        if ((n & 8) != 0) {
            towerGroup = null;
        }
        this(l, towerGroupKindArray, invokeResolvePriority, towerGroup);
    }

    private final TowerGroup kindOf(TowerGroupKind kind) {
        return new TowerGroup(TowerGroup.Companion.subscript(this.code, kind), TowerGroup.Companion.appendDebugKind(this.debugKinds, kind), null, null, 12, null);
    }

    @NotNull
    public final TowerGroup getMember() {
        return this.kindOf(TowerGroupKind.Member.INSTANCE);
    }

    @NotNull
    public final TowerGroup Local(int depth) {
        return this.kindOf(new TowerGroupKind.Local(depth));
    }

    @NotNull
    public final TowerGroup Implicit(int depth) {
        return this.kindOf(TowerGroupKind.Companion.Implicit(depth));
    }

    @NotNull
    public final TowerGroup NonLocal(int depth) {
        return this.kindOf(TowerGroupKind.Companion.NonLocal(depth));
    }

    @NotNull
    public final TowerGroup ContextReceiverGroup(int depth) {
        return this.kindOf(new TowerGroupKind.ContextReceiverGroup(depth));
    }

    @NotNull
    public final TowerGroup getInvokeExtension() {
        return this.kindOf(TowerGroupKind.InvokeExtension.INSTANCE);
    }

    @NotNull
    public final TowerGroup TopPrioritized(int depth) {
        return this.kindOf(new TowerGroupKind.TopPrioritized(depth));
    }

    @NotNull
    public final TowerGroup InvokeReceiver(@NotNull TowerGroup receiverGroup) {
        Intrinsics.checkNotNullParameter((Object)receiverGroup, (String)"receiverGroup");
        return new TowerGroup(this.code, this.debugKinds, this.invokeResolvePriority, receiverGroup);
    }

    @NotNull
    public final TowerGroup InvokeResolvePriority(@NotNull InvokeResolvePriority invokeResolvePriority) {
        Intrinsics.checkNotNullParameter((Object)((Object)invokeResolvePriority), (String)"invokeResolvePriority");
        if (invokeResolvePriority == InvokeResolvePriority.NONE) {
            return this;
        }
        return new TowerGroup(this.code, this.debugKinds, invokeResolvePriority, null, 8, null);
    }

    @Override
    public int compareTo(@NotNull TowerGroup other) {
        int n;
        int actualResult;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        TowerGroup $this$compareTo_u24lambda_u240 = this;
        boolean bl = false;
        int result2 = Long.compareUnsigned($this$compareTo_u24lambda_u240.code, other.code);
        int n2 = result2 != 0 ? result2 : ((actualResult = $this$compareTo_u24lambda_u240.invokeResolvePriority.compareTo((Enum)other.invokeResolvePriority)) == 0 ? ($this$compareTo_u24lambda_u240.receiverGroup == null || other.receiverGroup == null ? 0 : $this$compareTo_u24lambda_u240.receiverGroup.compareTo(other.receiverGroup)) : actualResult);
        int it = n = n2;
        boolean bl2 = false;
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup");
        TowerGroup cfr_ignored_0 = (TowerGroup)other;
        if (this.code != ((TowerGroup)other).code) {
            return false;
        }
        if (this.invokeResolvePriority != ((TowerGroup)other).invokeResolvePriority) {
            return false;
        }
        return this.receiverGroup == null || ((TowerGroup)other).receiverGroup == null || Intrinsics.areEqual((Object)this.receiverGroup, (Object)((TowerGroup)other).receiverGroup);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder2 = new StringBuilder().append("TowerGroup(code=").append(Long.toBinaryString(this.code)).append(", debugKinds=");
        String string2 = Arrays.toString(this.debugKinds);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return stringBuilder2.append(string2).append(", invokeResolvePriority=").append((Object)this.invokeResolvePriority).append(')').toString();
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.code);
        result2 = 31 * result2 + this.invokeResolvePriority.hashCode();
        return result2;
    }

    static {
        boolean $i$f$emptyArray = false;
        EMPTY_KIND_ARRAY = new TowerGroupKind[0];
        EmptyRoot = new TowerGroup(0L, EMPTY_KIND_ARRAY, null, null, 12, null);
        Start = TowerGroup.Companion.kindOf(TowerGroupKind.Start.INSTANCE);
        Qualifier = TowerGroup.Companion.kindOf(TowerGroupKind.Qualifier.INSTANCE);
        Classifier = TowerGroup.Companion.kindOf(TowerGroupKind.Classifier.INSTANCE);
        QualifierValue = TowerGroup.Companion.kindOf(TowerGroupKind.QualifierValue.INSTANCE);
        Member = TowerGroup.Companion.kindOf(TowerGroupKind.Member.INSTANCE);
        Last = TowerGroup.Companion.kindOf(TowerGroupKind.Last.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\nJ\u000e\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\nJ)\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010+\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010+\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0018\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020!2\u0006\u0010+\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u000e\u0010\u001e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup$Companion;", "", "()V", "Classifier", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "getClassifier", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "DEBUG", "", "DEPTH_MASK", "", "DEPTH_SIZE_BITS", "EMPTY_KIND_ARRAY", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "EmptyRoot", "getEmptyRoot", "KIND_MASK", "KIND_SIZE_BITS", "Last", "getLast", "Member", "getMember", "Qualifier", "getQualifier", "QualifierValue", "getQualifierValue", "Start", "getStart", "TOTAL_BITS", "USABLE_BITS", "USED_BITS_MASK", "", "ContextReceiverGroup", "depth", "Implicit", "Local", "NonLocal", "TopPrioritized", "UnqualifiedEnum", "appendDebugKind", "kinds", "kind", "([Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "debugKindArrayOf", "(Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;)[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "kindOf", "subscript", "code", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        private final TowerGroupKind[] appendDebugKind(TowerGroupKind[] kinds2, TowerGroupKind kind) {
            return EMPTY_KIND_ARRAY;
        }

        private final TowerGroupKind[] debugKindArrayOf(TowerGroupKind kind) {
            return EMPTY_KIND_ARRAY;
        }

        private final long subscript(long code, TowerGroupKind kind) {
            long l;
            int usedBits = (int)(code & 0x3FL);
            if (kind instanceof TowerGroupKind.WithDepth) {
                int kindUsedBits = usedBits + KIND_SIZE_BITS;
                int depthUsedBits = kindUsedBits + DEPTH_SIZE_BITS;
                if (!(((TowerGroupKind.WithDepth)kind).getDepth() <= 65535)) {
                    boolean $i$a$-require-TowerGroup$Companion$subscript$32 = false;
                    String $i$a$-require-TowerGroup$Companion$subscript$32 = "Depth overflow: requested: " + ((TowerGroupKind.WithDepth)kind).getDepth() + ", allowed: 65535";
                    throw new IllegalArgumentException($i$a$-require-TowerGroup$Companion$subscript$32.toString());
                }
                if (!(depthUsedBits <= USABLE_BITS)) {
                    boolean bl = false;
                    String string2 = "BitGroup overflow: newUsedBits: " + depthUsedBits + ", original: " + Long.toBinaryString(code) + ", usedBits: " + usedBits;
                    throw new IllegalArgumentException(string2.toString());
                }
                l = code | (long)kind.getIndex() << 64 - kindUsedBits | (long)((TowerGroupKind.WithDepth)kind).getDepth() << 64 - depthUsedBits | (long)depthUsedBits;
            } else {
                int newUsedBits = usedBits + KIND_SIZE_BITS;
                if (!(newUsedBits <= USABLE_BITS)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                l = code | (long)kind.getIndex() << 64 - newUsedBits | (long)newUsedBits;
            }
            return l;
        }

        private final TowerGroup kindOf(TowerGroupKind kind) {
            return new TowerGroup(this.subscript(0L, kind), this.debugKindArrayOf(kind), null, null, 12, null);
        }

        @NotNull
        public final TowerGroup getEmptyRoot() {
            return EmptyRoot;
        }

        @NotNull
        public final TowerGroup getStart() {
            return Start;
        }

        @NotNull
        public final TowerGroup getQualifier() {
            return Qualifier;
        }

        @NotNull
        public final TowerGroup getClassifier() {
            return Classifier;
        }

        @NotNull
        public final TowerGroup getQualifierValue() {
            return QualifierValue;
        }

        @NotNull
        public final TowerGroup getMember() {
            return Member;
        }

        @NotNull
        public final TowerGroup UnqualifiedEnum(int depth) {
            return this.kindOf(new TowerGroupKind.UnqualifiedEnum(depth));
        }

        @NotNull
        public final TowerGroup Local(int depth) {
            return this.kindOf(new TowerGroupKind.Local(depth));
        }

        @NotNull
        public final TowerGroup Implicit(int depth) {
            return this.kindOf(TowerGroupKind.Companion.Implicit(depth));
        }

        @NotNull
        public final TowerGroup NonLocal(int depth) {
            return this.kindOf(TowerGroupKind.Companion.NonLocal(depth));
        }

        @NotNull
        public final TowerGroup ContextReceiverGroup(int depth) {
            return this.kindOf(new TowerGroupKind.ContextReceiverGroup(depth));
        }

        @NotNull
        public final TowerGroup TopPrioritized(int depth) {
            return this.kindOf(new TowerGroupKind.TopPrioritized(depth));
        }

        @NotNull
        public final TowerGroup getLast() {
            return Last;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

