/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.DefaultCacheCleanupStrategy;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheVersionMapping;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.classpath.ClasspathTransformerCacheFactory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class DefaultClasspathTransformerCacheFactory
implements ClasspathTransformerCacheFactory {
    private static final CacheVersionMapping CACHE_VERSION_MAPPING = CacheVersionMapping.introducedIn((String)"2.2").incrementedIn("3.2-rc-1").incrementedIn("3.5-rc-1").changedTo(8, "6.5-rc-1").incrementedIn("7.1").build();
    @VisibleForTesting
    static final String CACHE_NAME = "jars";
    @VisibleForTesting
    static final String CACHE_KEY = "jars-" + CACHE_VERSION_MAPPING.getLatestVersion();
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final UsedGradleVersions usedGradleVersions;
    private final CacheConfigurationsInternal cacheConfigurations;

    public DefaultClasspathTransformerCacheFactory(UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        this.usedGradleVersions = usedGradleVersions;
        this.cacheConfigurations = cacheConfigurations;
    }

    @Override
    public PersistentCache createCache(GlobalScopedCacheBuilderFactory cacheBuilderFactory, FileAccessTimeJournal fileAccessTimeJournal) {
        return cacheBuilderFactory.createCrossVersionCacheBuilder(CACHE_KEY).withDisplayName(CACHE_NAME).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).withCleanupStrategy(this.createCacheCleanupStrategy(fileAccessTimeJournal)).open();
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(FileAccessTimeJournal fileAccessTimeJournal) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)this.createCleanupAction(fileAccessTimeJournal), (Provider)this.cacheConfigurations.getCleanupFrequency());
    }

    private CompositeCleanupAction createCleanupAction(FileAccessTimeJournal fileAccessTimeJournal) {
        return CompositeCleanupAction.builder().add(new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CACHE_NAME, (CacheVersionMapping)CACHE_VERSION_MAPPING, (UsedGradleVersions)this.usedGradleVersions)}).add(new CleanupAction[]{new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), fileAccessTimeJournal, this.cacheConfigurations.getCreatedResources().getRemoveUnusedEntriesOlderThanAsSupplier())}).build();
    }

    @Override
    public FileAccessTracker createFileAccessTracker(PersistentCache persistentCache, FileAccessTimeJournal fileAccessTimeJournal) {
        return new SingleDepthFileAccessTracker(fileAccessTimeJournal, persistentCache.getBaseDir(), 1);
    }
}

