/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.serialization.codecs;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.configurationcache.serialization.codecs.AbstractVisitor;
import org.gradle.configurationcache.serialization.codecs.ResolutionBackedFileCollectionSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gradle/configurationcache/serialization/codecs/ResolutionContentsCollectingVisitor;", "Lorg/gradle/configurationcache/serialization/codecs/AbstractVisitor;", "resolutionHostDisplayName", "", "lenient", "", "(Ljava/lang/String;Z)V", "containsTransforms", "getContainsTransforms", "()Z", "setContainsTransforms", "(Z)V", "elements", "", "", "getElements", "()Ljava/util/Set;", "addElements", "", "target", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "visitCollection", "contents", "", "Ljava/io/File;", "configuration-cache"})
final class ResolutionContentsCollectingVisitor
extends AbstractVisitor {
    @NotNull
    private final String resolutionHostDisplayName;
    private final boolean lenient;
    private boolean containsTransforms;
    @NotNull
    private final Set<Object> elements;

    public ResolutionContentsCollectingVisitor(@NotNull String resolutionHostDisplayName, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)resolutionHostDisplayName, (String)"resolutionHostDisplayName");
        this.resolutionHostDisplayName = resolutionHostDisplayName;
        this.lenient = lenient;
        this.elements = new LinkedHashSet();
    }

    public final boolean getContainsTransforms() {
        return this.containsTransforms;
    }

    public final void setContainsTransforms(boolean bl) {
        this.containsTransforms = bl;
    }

    @NotNull
    public final Set<Object> getElements() {
        return this.elements;
    }

    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source instanceof TransformedArtifactSet ? FileCollectionStructureVisitor.VisitType.NoContents : FileCollectionStructureVisitor.VisitType.Visit;
    }

    public void visitCollection(@NotNull FileCollectionInternal.Source source, @NotNull Iterable<? extends File> contents) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        if (source instanceof TransformedArtifactSet) {
            this.containsTransforms = true;
            this.elements.add(source);
        } else {
            CollectionsKt.addAll((Collection)this.elements, contents);
        }
    }

    public final void addElements(@NotNull Set<Object> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        if (this.containsTransforms) {
            target.add(new ResolutionBackedFileCollectionSpec(this.resolutionHostDisplayName, this.lenient, CollectionsKt.toList((Iterable)this.elements)));
        } else {
            target.addAll((Collection<Object>)this.elements);
        }
    }
}

