/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.ServerTool;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.EndPointInfo;
import com.sun.corba.se.spi.activation.InvalidORBid;
import com.sun.corba.se.spi.activation.Locator;
import com.sun.corba.se.spi.activation.LocatorHelper;
import com.sun.corba.se.spi.activation.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class LocateServerForORB
implements CommandHandler {
    static final int illegalServerId = -1;

    LocateServerForORB() {
    }

    @Override
    public String getCommandName() {
        return "locateperorb";
    }

    @Override
    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.locateorb"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.locateorb1"));
        }
    }

    @Override
    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        String string = "";
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2;
                if ((string2 = stringArray[n2++]).equals("-serverid")) {
                    if (n2 < stringArray.length) {
                        n = Integer.valueOf(stringArray[n2++]);
                        continue;
                    }
                    return true;
                }
                if (string2.equals("-applicationName")) {
                    if (n2 < stringArray.length) {
                        n = ServerTool.getServerIdForAlias(oRB, stringArray[n2++]);
                        continue;
                    }
                    return true;
                }
                if (!string2.equals("-orbid") || n2 >= stringArray.length) continue;
                string = stringArray[n2++];
            }
            if (n == -1) {
                return true;
            }
            Locator locator = LocatorHelper.narrow(oRB.resolve_initial_references("ServerLocator"));
            ServerLocationPerORB serverLocationPerORB = locator.locateServerForORB(n, string);
            printStream.println(CorbaResourceUtil.getText("servertool.locateorb2", serverLocationPerORB.hostname));
            for (EndPointInfo endPointInfo : serverLocationPerORB.ports) {
                printStream.println("\t\t" + endPointInfo.port + "\t\t" + endPointInfo.endpointType + "\t\t" + string);
            }
        }
        catch (InvalidORBid invalidORBid) {
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchorb"));
        }
        catch (ServerHeldDown serverHeldDown) {
            printStream.println(CorbaResourceUtil.getText("servertool.helddown"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

