/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingleinfo;

import java.io.IOException;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.jingleinfo.JingleInfoQueryIQ;
import org.jitsi.xmpp.extensions.jingleinfo.RelayProvider;
import org.jitsi.xmpp.extensions.jingleinfo.ServerPacketExtension;
import org.jitsi.xmpp.extensions.jingleinfo.StunProvider;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class JingleInfoQueryIQProvider
extends IqProvider<JingleInfoQueryIQ> {
    private final StunProvider stunProvider = new StunProvider();
    private final RelayProvider relayProvider = new RelayProvider();

    public JingleInfoQueryIQProvider() {
        ProviderManager.addExtensionProvider("server", "google:jingleinfo", new DefaultPacketExtensionProvider<ServerPacketExtension>(ServerPacketExtension.class));
    }

    @Override
    public JingleInfoQueryIQ parse(XmlPullParser parser, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        JingleInfoQueryIQ iq = new JingleInfoQueryIQ();
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("stun")) {
                    iq.addExtension((ExtensionElement)this.stunProvider.parse(parser));
                } else if (elementName.equals("relay")) {
                    iq.addExtension((ExtensionElement)this.relayProvider.parse(parser));
                }
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("query")) continue;
            done = true;
        }
        return iq;
    }
}

